<?php
if (!defined('ABSPATH')) {
    exit();
}

// Widget areas
function milo_widgets_init() {
    register_widget('milo_social_media_widget');
    register_widget('milo_flickr_widget');
    register_widget('milo_instagram_widget');
    register_widget('milo_contact_widget');
    register_widget('milo_posts_widget');

    // creates the default sidebar
    register_sidebar(array(
        'name' => esc_html__('Default Sidebar', 'dakota-theme'),
        'id' => 'milo-default-sidebar',
        'description' => esc_html__('Default widget area', 'dakota-theme'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h6 class="widget_title">',
        'after_title' => '</h6>',
    ));

    // Generates the the top widget areas of the header
    for ($count = 1; $count <= 4; $count++) {
        register_sidebar(array(
            'name' => esc_html__('Header Widget Area ', 'dakota-theme') . $count,
            'id' => 'milo-top-sidebar-' . $count,
            'description' => esc_html__('Widget area', 'dakota-theme'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widget_title">',
            'after_title' => '</h6>',
        ));
    }

    // Generates the the top widget areas of the footer
    for ($count = 1; $count <= 4; $count++) {
        register_sidebar(array(
            'name' => esc_html__('Footer Widget Area ', 'dakota-theme') . $count,
            'id' => 'milo-footer-top-sidebar-' . $count,
            'description' => esc_html__('Widget area', 'dakota-theme'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widget_title">',
            'after_title' => '</h6>',
        ));
    }
    
    for ($count = 1; $count <= 4; $count++) {
        register_sidebar(array(
            'name' => esc_html__('Middle Footer Widget Area ', 'dakota-theme') . $count,
            'id' => 'milo-footer-mid-sidebar-' . $count,
            'description' => esc_html__('Widget area', 'dakota-theme'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widget_title">',
            'after_title' => '</h6>',
        ));
    }


    for ($count = 1; $count <= 4; $count++) {
        register_sidebar(array(
            'name' => esc_html__('Bottom Footer Widget Area ', 'dakota-theme') . $count,
            'id' => 'milo-footer-bottom-sidebar-' . $count,
            'description' => esc_html__('Widget area', 'dakota-theme'),
            'before_widget' => '<div id="%1$s" class="widget %2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h6 class="widget_title">',
            'after_title' => '</h6>',
        ));
    }

    $option_name = 'milo-sidebars-custom';
    if (get_option($option_name) != false) {

        $sidebars_array = get_option($option_name);
        if ($sidebars_array != null) {
            $count = count($sidebars_array);
            $j = 0;

            for ($i = 0; $i < $count; $i = $i + 2) {

                // Stores sidebars titles
                $sidebars_title[$j] = esc_html($sidebars_array[$i]);
                // Stores sidebars description
                $sidebars_description[$j] = esc_html($sidebars_array[$i + 1]);

                if (function_exists('register_sidebar')) {
                    // Registers each sidebar with title and description
                    register_sidebar(array(
                        'name' => $sidebars_title[$j],
                        'id' => sanitize_title_with_dashes($sidebars_title[$j]) . '-' . $j,
                        'description' => $sidebars_description[$j],
                        'before_widget' => '<div id="%1$s" class="widget %2$s">',
                        'after_widget' => '</div>',
                        'class' => 'milo-sidebars-custom',
                        'before_title' => '<h6 class="widget_title">',
                        'after_title' => '</h6>',
                    ));
                }
                $j++;
            }
        }
    }
}

add_action('widgets_init', 'milo_widgets_init');

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       Contact Widget
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class milo_contact_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                'milo_contact_widget', esc_html__('Dakota - Contact', 'dakota-theme'), array(
            'description' => esc_html__('contact widget', 'dakota-theme'),)
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $email = apply_filters('widget_email', $instance['email']);
        $address = apply_filters('widget_address', $instance['address']);
        $phone = apply_filters('widget_phone', $instance['phone']);
        $website = apply_filters('widget_website', $instance['website']);

        echo wp_kses_post($args['before_widget']);
        ?>
        <div class="widget widget-contact">

            <?php
            if (trim($title) != '') {
                echo wp_kses_post($args['before_title']);
                echo esc_html($title);
                echo wp_kses_post($args['after_title']);
            }
            ?>
            <ul>
                <?php if (trim($address) != ''): ?>
                    <li>
                        <i class="mt-icon-map-marker1"></i>
                        <?php
                        $address = esc_html($address);
                        $address_parts = preg_split("/\r\n|\n|\r/", $address);

                        foreach ($address_parts as $address_part) {
                            echo esc_html($address_part) . '<br>';
                        }
                        ?>
                    </li>
                    <?php
                endif;
                if (trim($phone) != ''):
                    ?>
                    <li>
                        <i class="mt-icon-telephone1"></i>
                        <a href="tel:<?php echo esc_attr($phone); ?>"><?php echo esc_html($phone); ?></a>
                    </li>
                    <?php
                endif;
                if (trim($email) != ''):
                    ?>
                    <li>
                        <i class="mt-icon-mail"></i>
                        <a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a>
                    </li>
                <?php
                endif;
                if (trim($website) != ''): ?>
                    <li>
                        <i class="mt-icon-earth"></i>
                        <a href="<?php echo esc_url($website); ?>"><?php echo esc_html($website); ?></a>
                    </li>
        <?php endif; ?>
            </ul>

        </div>

        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function form($instance) {
        if (isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('title')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($title); ?>" />
        </p>

        <?php
        if (isset($instance['address'])) {
            $address = $instance['address'];
        } else {
            $address = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'dakota-theme'); ?></label>
            <textarea class="widefat" 
                      id="<?php echo sanitize_html_class($this->get_field_id('address')); ?>" 
                      name="<?php echo esc_attr($this->get_field_name('address')); ?>" ><?php echo esc_textarea($address); ?> </textarea>
        </p>

        <?php
        if (isset($instance['phone'])) {
            $phone = $instance['phone'];
        } else {
            $phone = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('phone')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('phone')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($phone); ?>" />
        </p>

        <?php
        if (isset($instance['email'])) {
            $email = $instance['email'];
        } else {
            $email = '';
        }
        ?>

        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('email')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('email')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($email); ?>" />
        </p>

        <?php
        if (isset($instance['website'])) {
            $website = $instance['website'];
        } else {
            $website = '';
        }
        ?>

        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('website')); ?>"><?php esc_html_e('Website:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('website')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('website')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($website); ?>" />
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['email'] = (!empty($new_instance['email']) ) ? strip_tags($new_instance['email']) : '';
        $instance['address'] = (!empty($new_instance['address']) ) ? strip_tags($new_instance['address']) : '';
        $instance['phone'] = (!empty($new_instance['phone']) ) ? strip_tags($new_instance['phone']) : '';
        $instance['website'] = (!empty($new_instance['website']) ) ? strip_tags($new_instance['website']) : '';
        return $instance;
    }

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       Social Media Widget
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class milo_social_media_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                'milo_social_media_widget', esc_html__('Dakota - Social Media', 'dakota-theme'), array(
            'description' => esc_html__('Social Media widget', 'dakota-theme'),)
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $facebook = apply_filters('widget_facebook', $instance['facebook']);
        $googleplus = apply_filters('widget_googleplus', $instance['googleplus']);
        $twitter = apply_filters('widget_twitter', $instance['twitter']);
        $pinterest = apply_filters('widget_pinterest', $instance['pinterest']);
        $youtube = apply_filters('widget_youtube', $instance['youtube']);
        $linkedin = apply_filters('widget_linkedin', $instance['linkedin']);
        $instagram = apply_filters('widget_instagram', $instance['instagram']);

        echo wp_kses_post($args['before_widget']);
        ?>
        <div>

            <?php
            if (trim($title) != '') {
                echo wp_kses_post($args['before_title']);
                echo esc_html($title);
                echo wp_kses_post($args['after_title']);
            }
            ?>

        <?php if (trim($facebook)!=''): ?>
                <a href="<?php echo esc_url($facebook); ?>" class="facebook social-media" target="_blank">
                    <i class="mt-icon-facebook"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($twitter)!=''): ?>
                <a href="<?php echo esc_url($twitter); ?>" class="twitter social-media" target="_blank">
                    <i class="mt-icon-twitter"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($googleplus)!=''): ?>
                <a href="<?php echo esc_url($googleplus); ?>" class="google social-media" target="_blank">
                    <i class="mt-icon-google-plus"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($linkedin)!=''): ?>
                <a href="<?php echo esc_url($linkedin); ?>" class="linkedin social-media" target="_blank">
                    <i class="mt-icon-linkedin"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($youtube)!=''): ?>
                <a href="<?php echo esc_url($youtube); ?>" class="youtube social-media" target="_blank">
                    <i class="mt-icon-youtube-play"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($pinterest)!=''): ?>
                <a href="<?php echo esc_url($pinterest); ?>" class="pinterest social-media" target="_blank">
                    <i class="mt-icon-pinterest"></i>
                </a>
            <?php endif; ?>

        <?php if (trim($instagram)!=''): ?>
                <a href="<?php echo esc_url($instagram); ?>" class="instagram social-media" target="_blank">
                    <i class="mt-icon-instagram"></i>
                </a>
        <?php endif; ?>

        </div>

        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function form($instance) {
        if (isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('title')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($title); ?>" />
        </p>

        <?php
        if (isset($instance['facebook'])) {
            $facebook = $instance['facebook'];
        } else {
            $facebook = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('facebook')); ?>"><?php esc_html_e('Facebook link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('facebook')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('facebook')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($facebook); ?>" />
        </p>
        <?php
        if (isset($instance['twitter'])) {
            $twitter = $instance['twitter'];
        } else {
            $twitter = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('twitter')); ?>"><?php esc_html_e('Twitter link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('twitter')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($twitter); ?>" />
        </p>

        <?php
        if (isset($instance['googleplus'])) {
            $googleplus = $instance['googleplus'];
        } else {
            $googleplus = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('googleplus')); ?>"><?php esc_html_e('Googleplus link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('googleplus')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('googleplus')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($googleplus); ?>" />
        </p>
        <?php
        if (isset($instance['linkedin'])) {
            $linkedin = $instance['linkedin'];
        } else {
            $linkedin = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('linkedin')); ?>"><?php esc_html_e('LinkedIn link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('linkedin')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($linkedin); ?>" />
        </p>

        <?php
        if (isset($instance['youtube'])) {
            $youtube = $instance['youtube'];
        } else {
            $youtube = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('youtube')); ?>"><?php esc_html_e('Youtube link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('youtube')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('youtube')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($youtube); ?>" />
        </p>

        <?php
        if (isset($instance['pinterest'])) {
            $pinterest = $instance['pinterest'];
        } else {
            $pinterest = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('pinterest')); ?>"><?php esc_html_e('Pinterest link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('pinterest')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('pinterest')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($pinterest); ?>" />
        </p>

        <?php
        if (isset($instance['instagram'])) {
            $instagram = $instance['instagram'];
        } else {
            $instagram = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('instagram')); ?>"><?php esc_html_e('Instagram link:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('instagram')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('instagram')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($instagram); ?>" />
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['facebook'] = (!empty($new_instance['facebook']) ) ? strip_tags($new_instance['facebook']) : '';
        $instance['googleplus'] = (!empty($new_instance['googleplus']) ) ? strip_tags($new_instance['googleplus']) : '';
        $instance['twitter'] = (!empty($new_instance['twitter']) ) ? strip_tags($new_instance['twitter']) : '';
        $instance['pinterest'] = (!empty($new_instance['pinterest']) ) ? strip_tags($new_instance['pinterest']) : '';
        $instance['linkedin'] = (!empty($new_instance['linkedin']) ) ? strip_tags($new_instance['linkedin']) : '';
        $instance['youtube'] = (!empty($new_instance['youtube']) ) ? strip_tags($new_instance['youtube']) : '';
        $instance['instagram'] = (!empty($new_instance['instagram']) ) ? strip_tags($new_instance['instagram']) : '';
        return $instance;
    }

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       Flickr Widget 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class milo_flickr_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                'milo_flickr_widget', esc_html__('Dakota - Flickr', 'dakota-theme'), array(
            'description' => esc_html__('Flickr gallery widget', 'dakota-theme'),)
        );
    }

    public function widget($args, $instance) {
        $user = apply_filters('widget_user', $instance['user']);
        $title = apply_filters('widget_title', $instance['title']);
        $images = apply_filters('widget_images', $instance['images']);

        $images = absint($images);

        echo wp_kses_post($args['before_widget']);
        ?>
        <div class="widget-flickr">
            <?php
            if (trim($title) != '') {
                echo wp_kses_post($args['before_title']);
                echo esc_html($title);
                echo wp_kses_post($args['after_title']);
            }
            ?>
            <div class="flickr-photos">
                <?php if (trim($user) != ''): ?>                   
                    <script src="http://www.flickr.com/badge_code_v2.gne?count=<?php echo esc_attr($images); ?>&amp;display=latest&amp;size=s&amp;layout=x&amp;source=user_set&amp;set=<?php echo esc_attr($user); ?>"></script>
        <?php endif; ?>
            </div>
        </div>
        <br class="clear">
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function form($instance) {
        if (isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('title')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($title); ?>" />
        </p>

        <?php
        if (isset($instance['user'])) {
            $user = $instance['user'];
        } else {
            $user = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('user')); ?>"><?php esc_html_e('Flicker User ID:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('user')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('user')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($user); ?>" />
            <label><?php esc_html_e('Use ', 'dakota-theme'); ?><a href='http://idgettr.com/' target='_blank'>idgettr.com</a><?php esc_html_e(' to get the Flicker ID number.', 'dakota-theme'); ?></label>
        </p>

        <?php
        if (isset($instance['images'])) {
            $images = $instance['images'];
        } else {
            $images = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('images')); ?>"><?php esc_html_e('Number of images:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('images')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('images')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($images); ?>" />
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['user'] = (!empty($new_instance['user']) ) ? strip_tags($new_instance['user']) : '';
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['images'] = (!empty($new_instance['images']) ) ? strip_tags($new_instance['images']) : '';
        return $instance;
    }

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       Instagram Widget 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class milo_instagram_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                'milo_instagram_widget', esc_html__('Dakota - Instagram', 'dakota-theme'), array(
            'description' => esc_html__('Instagram gallery widget', 'dakota-theme'),)
        );
    }

    public function widget($args, $instance) {
        $user = apply_filters('widget_user', $instance['user']);
        $token = apply_filters('widget_token', $instance['token']);
        $images = apply_filters('widget_images', $instance['images']);
        $title = apply_filters('widget_title', $instance['title']);

        $images = absint($images);

        echo wp_kses_post($args['before_widget']);
        ?>
        <div class="widget-instagram">
            <?php
            if (trim($title) != '') {
                echo wp_kses_post($args['before_title']);
                echo esc_html($title);
                echo wp_kses_post($args['after_title']);
            }
            ?>
            <div id="instafeed" data-user="<?php echo esc_attr($user); ?>" data-number="<?php echo esc_attr($images); ?>" data-accesstoken="<?php echo esc_attr($token); ?>"></div>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function form($instance) {
        if (isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('title')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($title); ?>" />
        </p>

        <?php
        if (isset($instance['user'])) {
            $user = $instance['user'];
        } else {
            $user = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('user')); ?>"><?php esc_html_e('User Id number:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('user')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('user')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($user); ?>" />
            <label><?php esc_html_e('Use ', 'dakota-theme'); ?><a href='http://jelled.com/instagram/lookup-user-id' target='_blank'>jelled.com/instagram/lookup-user-id</a><?php esc_html_e(' to find your user id number.', 'dakota-theme'); ?></label>
        </p>

        <?php
        if (isset($instance['token'])) {
            $token = $instance['token'];
        } else {
            $token = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('token')); ?>"><?php esc_html_e('Access token:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('token')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('token')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($token); ?>" />
            <label><?php esc_html_e('Use ', 'dakota-theme'); ?><a href='http://instafeedjs.com/' target='_blank'>instafeedjs.com</a><?php esc_html_e(' to find your access token. You must log in on Instagram first.', 'dakota-theme'); ?></label>
        </p>

        <?php
        if (isset($instance['images'])) {
            $images = $instance['images'];
        } else {
            $images = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('images')); ?>"><?php esc_html_e('Number of images:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('images')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('images')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($images); ?>" />
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['user'] = (!empty($new_instance['user']) ) ? strip_tags($new_instance['user']) : '';
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['token'] = (!empty($new_instance['token']) ) ? strip_tags($new_instance['token']) : '';
        $instance['images'] = (!empty($new_instance['images']) ) ? strip_tags($new_instance['images']) : '';
        return $instance;
    }

}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       Posts Widget 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
class milo_posts_widget extends WP_Widget {

    function __construct() {
        parent::__construct(
                'milo_posts_widget', esc_html__('Dakota - Recent posts', 'dakota-theme'), array(
            'description' => esc_html__('Displays recent posts', 'dakota-theme'),)
        );
    }

    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $count = apply_filters('widget_count', $instance['count']);

        if (trim($count) != '') {
            if (preg_match("/[^0-9]/", $count)) {
                $count = 1;
            }
        } else {
            $count = 1;
        }

        echo wp_kses_post($args['before_widget']);
        ?>
        <div class="widget-recent-posts">
            <?php
            if (trim($title) != '') {
                echo wp_kses_post($args['before_title']);
                echo esc_html($title);
                echo wp_kses_post($args['after_title']);
            }
            ?>

            <ul>
                <?php
                $recent_posts = wp_get_recent_posts(array('numberposts' => $count, 'post_status' => 'publish'));
                foreach ($recent_posts as $recent):
                    ?>
                    <li>
                         <?php echo get_the_post_thumbnail($recent["ID"], 'milo_testimonial_size'); ?>
			<a class="post-title" href="<?php the_permalink($recent["ID"]); ?>"><?php echo esc_html($recent["post_title"]); ?></a><br>
			<a class="post-date" href="<?php the_permalink($recent["ID"]); ?>"><?php echo get_the_date('F j, Y', $recent["ID"]); ?></a><br>
			<a class="read-more" href="<?php the_permalink($recent["ID"]); ?>"><?php esc_html_e('Read more', 'dakota-theme'); ?></a>
                    </li>
                    <?php
                endforeach;
                ?>

            </ul>
        </div>

        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function form($instance) {
        if (isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = esc_html__('Latest posts', 'dakota-theme');
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('title')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($title); ?>" />
        </p>

        <?php
        if (isset($instance['count'])) {
            $count = $instance['count'];
        } else {
            $count = '';
        }
        ?>
        <p>
            <label for="<?php echo sanitize_html_class($this->get_field_id('count')); ?>"><?php esc_html_e('Number of posts:', 'dakota-theme'); ?></label>
            <input class="widefat" 
                   id="<?php echo sanitize_html_class($this->get_field_id('count')); ?>" 
                   name="<?php echo esc_attr($this->get_field_name('count')); ?>" 
                   type="text" 
                   value="<?php echo esc_attr($count); ?>" />
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title']) ) ? strip_tags($new_instance['title']) : '';
        $instance['count'] = (!empty($new_instance['count']) ) ? strip_tags($new_instance['count']) : '';
        return $instance;
    }

}
