<?php

$milo_metabox_header = array(
    'id' => 'milo-page-header',
    'title' => esc_html__('Page Header', 'dakota-theme'),
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
        array(
            'name' => esc_html__('Header Config', 'dakota-theme'),
            'id' => 'milo_header_toggle',
            'type' => 'toggle',
            'options' => array(
                array('name' => 'Enable', 'value' => 'Enable'),
                array('name' => 'Disable', 'value' => 'Disable')
            )
        ),
        array(
            'name' => esc_html__('Page header title', 'dakota-theme'),
            'id' => 'milo_header_title',
            'type' => 'text'
        ),
        array(
            'name' => esc_html__('Font color', 'dakota-theme'),
            'id' => 'milo_header_font_color',
            'type' => 'colorpicker',
            'default' => ''
        ),
        array(
            'name' => esc_html__('Background color', 'dakota-theme'),
            'id' => 'milo_header_background_color',
            'type' => 'colorpicker',
            'default' => ''
        ),
        array(
            'name' => esc_html__('Background image', 'dakota-theme'),
            'id' => 'milo_header_image',
            'type' => 'image'
        ),
        array(
            'name' => esc_html__('Show Breadcrumbs', 'dakota-theme'),
            'id' => 'milo_header_breadcrumbs',
            'description' => esc_html__('For breadcrumbs, please select a page parent on the right side under "Page Attributes"', 'dakota-theme'),
            'type' => 'checkbox'
        )
    )
);

add_action('admin_menu', 'milo_page_header_add_box');

// Add the meta box
function milo_page_header_add_box() {

    global $milo_metabox_header;
    add_meta_box($milo_metabox_header['id'], $milo_metabox_header['title'], 'milo_page_header_show_box', 'page', $milo_metabox_header['context'], $milo_metabox_header['priority']);
    if (defined('MILO_PORTFOLIO')) {
        add_meta_box($milo_metabox_header['id'], $milo_metabox_header['title'], 'milo_page_header_show_box', 'milo-portfolio', $milo_metabox_header['context'], $milo_metabox_header['priority']);
    }
}

// Callback function to show fields in meta box
function milo_page_header_show_box() {
    global $milo_metabox_header, $post;
    // Use nonce for verification
    echo '<input type="hidden" name="milo_page_header_meta_box_nonce" value="', wp_create_nonce(get_template_directory()), '" />';
    echo '<table id="milo_header_options_table" class="form-table">';

    foreach ($milo_metabox_header['fields'] as $field) {
        // Get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);

        echo '<tr';
        if ($field['id'] == 'milo_header_style') {
            echo ' id="milo_style_container"';
        }
        echo '><th><label for="', esc_attr($field['id']), '">', esc_html($field['name']), '</label></th><td>';
        switch ($field['type']) {
            case 'toggle':
                echo '<div>';
                foreach ($field['options'] as $option) {
                    // Prepare the default option
                    if ($meta == null && ($option['value'] == 'Enable' || $option['value'] == 'off')) {
                        $default_check = 'checked="checked"';
                    } else {
                        $default_check = '';
                    }
                    echo ' <input type="radio" id="toggle-' . sanitize_html_class($option['value']) . '" class="toggle toggle-' . sanitize_html_class($option['value']) . '" name="', esc_attr($field['id']), '" '
                    . 'value="', esc_attr($option['value']), '"', $meta == $option['value'] ? ' checked="checked"' : '', ' ' . esc_html($default_check) . ' ', $field['id'] == 'milo_style_toggle' ? 'onchange="milo_style_select()"' : 'onclick="milo_header_override()"', ' />'
                    . '<label for="toggle-' . esc_attr($option['value']) . '">' . esc_html($option['name']) . '</label>';
                }
                echo '</div>';
                break;
            case 'text':
                echo '<input type="text" name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '" value="' . esc_attr($meta) . '" size="30" /><br>';
                break;
            case 'colorpicker':
                echo '<div class="milo_color_preview" id="milo_color_preview_id" style="background-color:' . esc_attr($meta) . ';"></div><div id="milo_color_preview_container_id">';
                echo '<input type="text" name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '" value="' . esc_attr($meta) . '" class="custom_header_color" data-default-color="#fff" /></div>';
                break;
            case 'checkbox':
                if ($meta == 'breadcrumbs') {
                    $default_check = 'checked="checked"';
                } else {
                    $default_check = '';
                }
                echo '<input type="checkbox" name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '" value="breadcrumbs" ' . esc_attr($default_check) . ' />' . esc_html__('Enable', 'dakota-theme') . '<br>';
                echo '<br class="clear_milo"><p>' . esc_html($field['description']) . '</p>';
                break;
            case 'image':
                echo '<span class="custom_default_image" style="display:none"></span>';
                $image_none = get_template_directory_uri() . "/layouts/images/default/image_none.png";
                if ($meta) {
                    $image = wp_get_attachment_image_src($meta, 'medium');
                    $image = $image[0];
                } else {
                    $image = $image_none;
                }
                echo '<input name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '_upload_input" type="hidden" class="custom_upload_image" value="' . esc_attr($meta) . '" />
                <img src="' . esc_url($image) . '" class="custom_preview_image" id="' . esc_attr($field['id']) . '_preview_image" alt="" /><br />
                    <input id="' . esc_attr($field['id']) . '_trigger" class="custom_upload_image_button button milo_custom_image_upload_trigger" name="custom_upload_image_button" type="button" value="' . esc_html__('Choose Image', 'dakota-theme') . '" onclick="milo_upload_trigger(\'' . esc_attr($field['id']) . '\')"/>
                    <input id="' . esc_attr($field['id']) . '_upload_input_clear" class="button milo_clear_img custom_upload_image_button" value="' . esc_html__('Remove Image', 'dakota-theme') . '" type="button" onclick="milo_clear_image_trigger(\'' . esc_attr($field['id']) . '\',\'' . esc_attr($image_none) . '\')">';

                echo '<br class="clear_milo"><p>' . esc_html__('Select a background image', 'dakota-theme') . '</p>';

                break;
        }
        echo '</td><td>',
        '</td></tr>';
    }
    echo '</table>';
}

add_action('save_post', 'milo_save_page_header_data');

// Save data from meta box
function milo_save_page_header_data($post_id) {
    global $milo_metabox_header;
    if (isset($_POST['milo_page_header_meta_box_nonce'])) {
        // Verify nonce
        if (!wp_verify_nonce($_POST['milo_page_header_meta_box_nonce'], get_template_directory())) {
            return $post_id;
        }
        // Check autosave
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        // Check permissions
        if ('page' == $_POST['post_type']) {
            if (!current_user_can('edit_page', $post_id)) {
                return $post_id;
            }
        } elseif (!current_user_can('edit_post', $post_id)) {
            return $post_id;
        }
        // Populates the meta box fields with the appropriate data
        foreach ($milo_metabox_header['fields'] as $field) {
            $old = get_post_meta(absint($post_id), sanitize_text_field($field['id']), true);
            if (isset($_POST[$field['id']])) {
                $new = $_POST[$field['id']];
                if ($new && $new != $old) {
                    update_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($new));
                } elseif ('' == $new && $old) {
                    delete_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($old));
                }
            } else {
                delete_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($old));
            }
        }
    }
}

//Sidebars
$milo_metabox_sidebar = array(
    'id' => 'milo-page-sidebar',
    'title' => esc_html__('Sidebar Layout', 'dakota-theme'),
    'context' => 'normal',
    'priority' => 'high',
    'fields' => array(
        array(
            'name' => esc_html__('Blog Layout', 'dakota-theme'),
            'id' => 'milo_blog_layout',
            'type' => 'blog_layout'
        ),
        // Sidebar positioning options
        array(
            'name' => esc_html__('Page Layout', 'dakota-theme'),
            'id' => 'milo_sidebar_position',
            'type' => 'radio',
            'options' => array(
                array('name' => 'Left', 'value' => 'left'),
                array('name' => 'None', 'value' => 'none'),
                array('name' => 'Right', 'value' => 'right')
            )
        ),
        // Sidebars list
        array(
            'name' => esc_html__('Sidebar selection', 'dakota-theme'),
            'id' => 'milo_sidebar_source',
            'type' => 'select'
        ),
        array(
            'name' => esc_html__('Boxed page', 'dakota-theme'),
            'id' => 'milo_page_boxed',
            'description' => esc_html__('Boxed page', 'dakota-theme'),
            'type' => 'checkbox'
        ),
        array(
            'name' => esc_html__('Boxed background color', 'dakota-theme'),
            'id' => 'milo_boxed_bg_color',
            'type' => 'colorpicker',
            'default' => ''
        ),
        array(
            'name' => esc_html__('Boxed background image', 'dakota-theme'),
            'id' => 'milo_boxed_bg_image',
            'type' => 'image'
        )
    )
);

add_action('admin_menu', 'milo_sidebar_add_box');

// Add the meta box
function milo_sidebar_add_box() {
    global $milo_metabox_sidebar;
    add_meta_box($milo_metabox_sidebar['id'], $milo_metabox_sidebar['title'], 'milo_sidebar_show_box', 'page', $milo_metabox_sidebar['context'], $milo_metabox_sidebar['priority']);
    add_meta_box($milo_metabox_sidebar['id'], $milo_metabox_sidebar['title'], 'milo_sidebar_show_box', 'post', $milo_metabox_sidebar['context'], $milo_metabox_sidebar['priority']);
    if (defined('MILO_PORTFOLIO')) {
        add_meta_box($milo_metabox_sidebar['id'], $milo_metabox_sidebar['title'], 'milo_sidebar_show_box', 'milo-portfolio', $milo_metabox_sidebar['context'], $milo_metabox_sidebar['priority']);
    }
}

// Callback function to show fields in meta box
function milo_sidebar_show_box() {
    global $milo_metabox_sidebar, $post;
    // Use nonce for verification

    echo '<input type="hidden" name="milo_sidebar_meta_box_nonce" value="' . esc_attr(wp_create_nonce(get_template_directory())) . '" />';
    echo '<table id="milo_layout_options_table" class="form-table">';
    if (get_the_id() != get_option('page_for_posts')) {
        $skip_field1 = 'milo_blog_layout';
    } else {
        $skip_field1 = '';
    }

    foreach ($milo_metabox_sidebar['fields'] as $field) {
        // Get current post meta data
        $meta = get_post_meta($post->ID, $field['id'], true);
        
         if($field['id']=='milo_boxed_bg_color' || $field['id']=='milo_boxed_bg_image'){
        $field_class=' class="milo_boxed_options"';
    }else {
        $field_class='';
    }
        if ($field['id'] != $skip_field1) {
            echo '<tr',esc_html($field_class),'><th style="width:20%"><label for="', esc_attr($field['id']), '">', esc_html($field['name']), '</label></th><td>';
            switch ($field['type']) {
                case 'blog_layout':
                    echo '<div>';
                    echo '<select name="', esc_attr($field['id']), '" id="', esc_attr($field['id']), '">';

                    echo '<option ', $meta == '1' || $meta == null ? ' selected="selected"' : '', ' value="1">' . esc_html__('1 column', 'dakota-theme') . '</option>';
                    echo '<option ', $meta == '2' ? ' selected="selected"' : '', ' value="2">' . esc_html__('2 columns', 'dakota-theme') . '</option>';
                    echo '<option ', $meta == '3' ? ' selected="selected"' : '', ' value="3">' . esc_html__('3 columns', 'dakota-theme') . '</option>';
                    echo '<option ', $meta == '4' ? ' selected="selected"' : '', ' value="4">' . esc_html__('2 columns masonry', 'dakota-theme') . '</option>';
                    echo '<option ', $meta == '5' ? ' selected="selected"' : '', ' value="5">' . esc_html__('3 columns masonry', 'dakota-theme') . '</option>';

                    echo '</select>';
                    echo '</div>';
                    echo '<br class="clear_milo"><p>' . esc_html__('Select the blog layout', 'dakota-theme') . '</p>';
                    break;
                case 'radio':
                    echo '<div>';
                    foreach ($field['options'] as $option) {
                        echo '<div class="sidebar_icon_radio">';
                        $check_title = '';
                        switch ($option['value']) {
                            case 'left':
                                echo '<img title="' . esc_html__('Sidebar on the left', 'dakota-theme') . '" src="' . esc_url(get_template_directory_uri()) . '/inc/admin/images/icon-left-sidebar.png" alt="sidebar left">';
                                break;
                            case 'none':
                                echo '<img title="' . esc_html__('No Sidebar', 'dakota-theme') . '" src="' . esc_url(get_template_directory_uri()) . '/inc/admin/images/no-sidebar.png" alt="sidebar none">';
                                break;
                            case 'right':
                                echo '<img title="' . esc_html__('Sidebar on the right', 'dakota-theme') . '" src="' . esc_url(get_template_directory_uri()) . '/inc/admin/images/icon-right-sidebar.png" alt="sidebar right">';
                                break;
                        }
                        // Prepare the default option
                        if ($meta == null && $option['value'] == 'none') {
                            $default_check = 'checked="checked"';
                        } else {
                            $default_check = '';
                        }
                        echo '<br><div class="sidebar_position_option_style">'
                        . '<input type="radio" name="', $field['id'], '" '
                        . 'value="', esc_attr($option['value']), '"', $meta == $option['value'] ? ' checked="checked"' : '', ' ' . esc_attr($default_check) . ' /></div>';
                        echo '</div>';
                    }
                    echo '</div>';
                    echo '<br class="clear_milo"><br><p>' . esc_html__('Select if the page should have a sidebar and how it should be positioned', 'dakota-theme') . '</p>';
                    break;
                case 'colorpicker':
                    echo '<div class="milo_color_preview" id="milo_color_preview_id" style="background-color:' . esc_attr($meta) . ';"></div><div id="milo_color_preview_container_id">';
                    echo '<input type="text" name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '" value="' . esc_attr($meta) . '" class="custom_header_color" data-default-color="#fff" /></div>';
                    break;
                case 'checkbox':
                    if ($meta == 'boxed') {
                        $default_check = 'checked="checked"';
                    } else {
                        $default_check = '';
                    }
                    echo '<input type="checkbox" name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '" value="boxed" ' . esc_html($default_check) . ' onclick="milo_boxed_toggle()" />' . esc_html__('Enable', 'dakota-theme') . '<br>';
                    echo '<br class="clear_milo"><p>' . esc_html__('If enabled the page will be boxed instead of full-width', 'dakota-theme') . '</p>';
                    break;
                case 'select':
                    global $wp_registered_sidebars;
                    echo '<div>';
                    echo '<select name="', esc_attr($field['id']), '" id="', esc_attr($field['id']), '">';
                    foreach ($wp_registered_sidebars as $sidebar) {
                        $check_footer = explode('milo-footer-', $sidebar['id']);
                        $check_header = explode('milo-top-sidebar-', $sidebar['id']);
                        if (count($check_footer) == 1 && count($check_header) == 1) {
                            echo '<option ', $meta == $sidebar['id'] ? ' selected="selected"' : '', ' value="', esc_attr($sidebar['id']), '">', esc_html($sidebar['name']), '</option>';
                        }
                    }
                    echo '</select>';
                    echo '</div>';
                    echo '<br class="clear_milo"><p>' . esc_html__('Select the sidebar that should be used. You can create additional sidebars in the theme options panel', 'dakota-theme') . '</p>';
                    break;
                case 'image':
                    echo '<span class="custom_default_image" style="display:none"></span>';
                    $image_none = get_template_directory_uri() . "/layouts/images/default/image_none.png";
                    if ($meta) {
                        $image = wp_get_attachment_image_src($meta, 'medium');
                        $image = $image[0];
                    } else {
                        $image = $image_none;
                    }
                    echo '<input name="' . esc_attr($field['id']) . '" id="' . esc_attr($field['id']) . '_upload_input" type="hidden" class="custom_upload_image" value="' . esc_attr($meta) . '" />
                <img src="' . esc_url($image) . '" class="custom_preview_image" id="' . esc_attr($field['id']) . '_preview_image" alt="" /><br />
                    <input id="' . esc_attr($field['id']) . '_trigger" class="custom_upload_image_button button milo_custom_image_upload_trigger" name="custom_upload_image_button" type="button" value="' . esc_html__('Choose Image', 'dakota-theme') . '" onclick="milo_upload_trigger(\'' . esc_attr($field['id']) . '\')"/>
                    <input id="' . esc_attr($field['id']) . '_upload_input_clear" class="button milo_clear_img custom_upload_image_button" value="' . esc_html__('Remove Image', 'dakota-theme') . '" type="button" onclick="milo_clear_image_trigger(\'' . esc_attr($field['id']) . '\',\'' . esc_attr($image_none) . '\')">';

                    echo '<br class="clear_milo"><p>' . esc_html__('Select a boxed background image', 'dakota-theme') . '</p>';

                    break;
            }
            echo '</td><td>',
            '</td></tr>';
        }
    }
    echo '</table>';
}

add_action('save_post', 'milo_save_sidebar_data');

// Save data from meta box
function milo_save_sidebar_data($post_id) {
    global $milo_metabox_sidebar;
    if (isset($_POST['milo_sidebar_meta_box_nonce'])) {
        // Verify nonce
        if (!wp_verify_nonce($_POST['milo_sidebar_meta_box_nonce'], get_template_directory())) {
            return $post_id;
        }
        // Check autosave
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        // Check permissions
        if ('page' == $_POST['post_type']) {
            if (!current_user_can('edit_page', $post_id)) {
                return $post_id;
            }
        } elseif (!current_user_can('edit_post', $post_id)) {
            return $post_id;
        }
        // Populates the meta box fields with the appropriate data
        foreach ($milo_metabox_sidebar['fields'] as $field) {
            $old = get_post_meta(absint($post_id), sanitize_text_field($field['id']), true);
            if (isset($_POST[$field['id']])) {
                $new = $_POST[$field['id']];
                if ($new && $new != $old) {
                    update_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($new));
                } elseif ('' == $new && $old) {
                    delete_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($old));
                }
            } else {
                delete_post_meta(absint($post_id), sanitize_text_field($field['id']), sanitize_text_field($old));
            }
        }
    }
}

// Check autosave
if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
    return $post_id;
}