<?php

if (!defined('ABSPATH')) {
    exit();
}
/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $full_width
 * @var $full_height
 * @var $content_placement
 * @var $parallax
 * @var $parallax_image
 * @var $css
 * @var $el_id
 * @var $video_bg
 * @var $video_bg_url
 * @var $video_bg_parallax
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Row
 */
$output = $after_output = $stellar_class = $stellar_attr = $shadow_top = $shadow_bottom = $font_color_style = $half_image = $milo_anim_data = $milo_anim_class = $milo_half_enable = $milo_half_right = $milo_iteration = $milo_duration = $duration = $iteration = $overlay_enable = $pattern_enable = $pattern_image = '';
$milo_type = 'none';
$milo_delay = '0';
$overlay_opacity = '0.9';
$overlay_color = '#282e3a';

$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

wp_enqueue_script('wpb_composer_front_js');

$el_class = $this->getExtraClass($el_class);

$css_classes = array(
    'vc_row',
    'wpb_row', //deprecated
    'vc_row-fluid',
    $el_class,
    vc_shortcode_custom_css_class($css),
);
$wrapper_attributes = array();
// build attributes for wrapper
if (!empty($el_id)) {
    $wrapper_attributes[] = 'id="' . esc_attr($el_id) . '"';
}

if (!empty($full_height)) {
    $css_classes[] = ' vc_row-o-full-height';
    if (!empty($content_placement)) {
        $css_classes[] = ' vc_row-o-content-' . $content_placement;
    }
}

// use default video if user checked video, but didn't chose url
if (!empty($video_bg) && empty($video_bg_url)) {
    $video_bg_url = 'https://www.youtube.com/watch?v=lMJXxhRFO1k';
}

$has_video_bg = (!empty($video_bg) && !empty($video_bg_url) && vc_extract_youtube_id($video_bg_url) );

if ($has_video_bg) {
    $parallax = $video_bg_parallax;
    $parallax_image = $video_bg_url;
    $css_classes[] = ' vc_video-bg-container';
    wp_enqueue_script('vc_youtube_iframe_api_js');
}

if (!empty($parallax)) {
    if ($parallax == 'stellar') {
        $stellar_class = ' parallax';
        $stellar_attr = ' data-stellar-background-ratio="0.1"';
    } else {
        wp_enqueue_script('vc_jquery_skrollr_js');
        $wrapper_attributes[] = 'data-vc-parallax="1.5"'; // parallax speed
        $css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
        if (strpos($parallax, 'fade') !== false) {
            $css_classes[] = 'js-vc_parallax-o-fade';
            $wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
        } elseif (strpos($parallax, 'fixed') !== false) {
            $css_classes[] = 'js-vc_parallax-o-fixed';
        }
    }
}

if (!empty($parallax_image)) {
    if ($has_video_bg) {
        $parallax_image_src = $parallax_image;
    } else {
        $parallax_image_id = preg_replace('/[^\d]/', '', $parallax_image);
        $parallax_image_src = wp_get_attachment_image_src($parallax_image_id, 'full');
        if (!empty($parallax_image_src[0])) {
            $parallax_image_src = $parallax_image_src[0];
        }
    }
    if ($parallax == 'stellar') {
        $wrapper_attributes[] = ' style="background-image: url(' . esc_url($parallax_image_src) . ')"';
    } else {
        $wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr($parallax_image_src) . '"';
    }
}
if (!$parallax && $has_video_bg) {
    $wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr($video_bg_url) . '"';
}
$css_class = preg_replace('/\s+/', ' ', apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode(' ', array_filter($css_classes)), $this->settings['base'], $atts));

if (defined('DEX_MLP_VERSION')) {
    if ($milo_dex_class != '') {
        $css_class.=' ' . $milo_dex_class;
    }
}

if ($milo_shadow_top == '1') {
    $shadow_top = '<div class="full-section-shadow-top"></div>';
}
if ($milo_shadow_bottom == '1') {
    $shadow_bottom = '<div class="full-section-shadow-bottom"></div>';
}
if ($milo_font_color != '') {
    $font_color_style = ' style="color:' . esc_attr($milo_font_color) . '"';
}
if ($pattern_enable == '1') {
    if ($pattern_image != null) {
        $p_image_data = wp_get_attachment_image_src(absint($pattern_image), 'milo_aboutme_size');
        $p_image_url = esc_url($p_image_data[0]);
        $milo_pattern = "<div class='full-section-pattern' style='background:url({$p_image_url}) repeat top left;'></div>";
    } else {
        $milo_pattern = '<div class="full-section-pattern pattern-default"></div>';
    }
} else {
    $milo_pattern = '';
}
if ($overlay_enable == '1') {
    if ($overlay_color != '#282e3a' && trim($overlay_color) != '' && $overlay_opacity != '0.9') {
        $overlay_style = ' style="background-color:' . esc_attr($overlay_color) . ';opacity:' . $overlay_opacity . '"';
    } else if ($overlay_color != '#282e3a') {
        $overlay_style = ' style="background-color:' . esc_attr($overlay_color) . ';"';
    } else if ($overlay_opacity != '0.9') {
        $overlay_style = ' style="opacity:' . $overlay_opacity . '"';
    } else {
        $overlay_style = '';
    }
    $milo_overlay = "<div class='full-section-overlay-color'{$overlay_style}></div>";
} else {
    $milo_overlay = '';
}
if ($milo_half_enable == '1') {
    if ($milo_half_image != null) {

        $milo_image_data = wp_get_attachment_image_src($milo_half_image, 'full');
        $milo_image_url = esc_url($milo_image_data[0]);

        if ($milo_half_right == '1') {
            $class_half = 'half-image-right';
        } else {
            $class_half = 'half-image-left';
        }
        if ($milo_type != 'none') {
            if ($milo_duration != '') {
                $milo_duration = absint($milo_duration);
                $duration = " data-wow-duration='{$milo_duration}s'";
            }
            if ($milo_iteration != '') {
                $milo_iteration = esc_attr($milo_iteration);
                $iteration = " data-wow-iteration='{$milo_iteration}'";
            }
            $milo_anim_data = " data-wow-delay='{$milo_delay}' {$iteration}{$duration}";
            $milo_anim_class = " wow {$milo_type}";
        }
        $half_image = "<div class='half-image {$class_half}{$milo_anim_class}'{$milo_anim_data} style='background-image:url({$milo_image_url});'><img src='{$milo_image_url}' alt=''></div>";
    }
}

if ($font_color_style != '') {
    $output .= '<div class="row-font-color"' . $font_color_style . '>';
}

if ('stretch_row' === $full_width) {

    $wrapper_attributes[] = 'class="' . esc_attr(trim($css_class)) . $stellar_class . ' full-section"';

    $output .= '<div ' . implode(' ', $wrapper_attributes) . $stellar_attr . '>';
    $output .= $milo_overlay . $milo_pattern . $half_image . $shadow_top . $shadow_bottom.'<div class="container-inner"><div class="row">';
    $output .= wpb_js_remove_wpautop($content);
    $output .= '</div></div></div>';
} else if ('stretch_row_content' === $full_width) {

    $wrapper_attributes[] = 'class="' . esc_attr(trim($css_class)) . ' row container-fluid' . $stellar_class . '"';
    
    $output .= '<div ' . implode(' ', $wrapper_attributes) . $stellar_attr . '>';
    $output .= $milo_overlay . $milo_pattern . $half_image . $shadow_top . $shadow_bottom;
    $output .= wpb_js_remove_wpautop($content);
    $output .= '</div>';
    
} else {

    $wrapper_attributes[] = 'class="' . esc_attr(trim($css_class)) . ' row' . $stellar_class . '"';
    
    $output .= '<div class="container-inner">';
    $output .= '<div ' . implode(' ', $wrapper_attributes) . $stellar_attr . '>';
    $output .= $milo_overlay . $milo_pattern . $half_image . $shadow_top . $shadow_bottom;
    $output .= wpb_js_remove_wpautop($content);
    $output .= '</div></div>';
    
}

$output .= $after_output;
$output .= $this->endBlockComment($this->getShortcode());

if ($font_color_style != '') {
    $output .= '</div>';
}

print $output;
