<?php

if (!defined('ABSPATH')) {
    exit();
}

$font_attributes = array('type' => 'colorpicker',
    'heading' => esc_html__('Font color', 'dakota-theme'),
    'param_name' => 'milo_font_color',
    'description' => esc_html__('Select a font color for this row', 'dakota-theme')
);
vc_add_param('vc_row', $font_attributes);

$stretch_attributes = array('type' => 'dropdown',
    'heading' => esc_html__('Row stretch', 'dakota-theme'),
    'param_name' => 'full_width',
    'value' => array(
        esc_html__('Default', 'dakota-theme') => '',
        esc_html__('Stretch row', 'dakota-theme') => 'stretch_row',
        esc_html__('Stretch row and content', 'dakota-theme') => 'stretch_row_content',
    ),
    'description' => esc_html__('Select stretching options for row and content', 'dakota-theme')
);
vc_add_param('vc_row', $stretch_attributes);

$parallax_attributes = array(
    'type' => 'dropdown',
    'heading' => esc_html__('Parallax', 'dakota-theme'),
    'param_name' => 'parallax',
    'value' => array(
        esc_html__('None', 'dakota-theme') => '',
        esc_html__('Simple', 'dakota-theme') => 'content-moving',
        esc_html__('With fade', 'dakota-theme') => 'content-moving-fade',
        esc_html__('Stellar parallax', 'dakota-theme') => 'stellar'
    ),
    'description' => esc_html__('Add parallax type background for row (Note: If no image is specified, parallax will use background image from Design Options).', 'dakota-theme'),
    'dependency' => array(
        'element' => 'video_bg',
        'is_empty' => true,
    )
);
vc_add_param('vc_row', $parallax_attributes);

$overlay_enable = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Enable overlay', 'dakota-theme'),
    'param_name' => 'overlay_enable',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1'),
    'description' => esc_html__('Can add a semi-transparent overlay over the row background', 'dakota-theme'),
);
vc_add_param('vc_row', $overlay_enable);

$overlay_color = array(
    'type' => 'colorpicker',
    'heading' => esc_html__('Overlay Color', 'dakota-theme'),
    'param_name' => 'overlay_color',
    'value' => '#282e3a',
    'dependency' => array(
        'element' => 'overlay_enable',
        'value' => '1'
    )
);
vc_add_param('vc_row', $overlay_color);

$overlay_opacity = array(
    'type' => 'dropdown',
    'heading' => esc_html__('Overlay Opacity', 'dakota-theme'),
    'param_name' => 'overlay_opacity',
    'value' => array(
        '0.9' => '0.9',
        '0.8' => '0.8',
        '0.7' => '0.7',
        '0.6' => '0.6',
        '0.5' => '0.5',
        '0.4' => '0.4',
        '0.3' => '0.3',
        '0.2' => '0.2',
        '0.1' => '0.1'
    ),
    'description' => esc_html__('Select a transparency level for the overlay', 'dakota-theme'),
    'dependency' => array(
        'element' => 'overlay_enable',
        'value' => '1'
    )
);
vc_add_param('vc_row', $overlay_opacity);

$shadow_top = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Shadow top', 'dakota-theme'),
    'param_name' => 'milo_shadow_top',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1'),
    'description' => esc_html__('the upper side of the row will be shaded', 'dakota-theme'),
);
vc_add_param('vc_row', $shadow_top);
$shadow_bottom = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Shadow bottom', 'dakota-theme'),
    'param_name' => 'milo_shadow_bottom',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1'),
    'description' => esc_html__('the bottom side of the row will be shaded', 'dakota-theme'),
);
vc_add_param('vc_row', $shadow_bottom);

$pattern_enable = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Enable image pattern', 'dakota-theme'),
    'param_name' => 'pattern_enable',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1')
);
vc_add_param('vc_row', $pattern_enable);

$pattern_enable = array(
                        'type' => 'attach_image',
                        'heading' => esc_html__('Pattern image', 'dakota-theme'),
                        'param_name' => 'pattern_image',
                        'description' => esc_html__('Add an image as pattern (small images with transparency are recommended)', 'dakota-theme'),
    'dependency' => array(
        'element' => 'pattern_enable',
        'value' => '1'
    )
                    );
vc_add_param('vc_row', $pattern_enable);

if (defined('DEX_MLP_VERSION')) {
    $stretch_attributes = array('type' => 'dropdown',
        'heading' => esc_html__('Content vertical position on multi-layer parallax', 'dakota-theme'),
        'param_name' => 'milo_dex_class',
        'value' => array(
            esc_html__('50%', 'dakota-theme') => '',
            esc_html__('10%', 'dakota-theme') => 'milo-dex-10',
            esc_html__('20%', 'dakota-theme') => 'milo-dex-20',
            esc_html__('30%', 'dakota-theme') => 'milo-dex-30',
            esc_html__('40%', 'dakota-theme') => 'milo-dex-40',
            esc_html__('60%', 'dakota-theme') => 'milo-dex-60',
            esc_html__('70%', 'dakota-theme') => 'milo-dex-70',
            esc_html__('80%', 'dakota-theme') => 'milo-dex-80',
            esc_html__('90%', 'dakota-theme') => 'milo-dex-90',
        ),
        'description' => esc_html__('Select a vertical postion for row content in a Dex multi-layer parallax container', 'dakota-theme')
    );
    vc_add_param('vc_row', $stretch_attributes);
}

// Half image background options
$milo_half_enable = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Image over half of the background', 'dakota-theme'),
    'param_name' => 'milo_half_enable',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1'),
    'description' => esc_html__('Allows placing of an image over half of the row background', 'dakota-theme'),
);
vc_add_param('vc_row', $milo_half_enable);

$milo_half_image = array(
    'type' => 'attach_image',
    'heading' => esc_html__('Image', 'dakota-theme'),
    'param_name' => 'milo_half_image',
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'description' => esc_html__('Select an image', 'dakota-theme')
);
vc_add_param('vc_row', $milo_half_image);

$milo_half_right = array(
    'type' => 'checkbox',
    'heading' => esc_html__('Right side', 'dakota-theme'),
    'param_name' => 'milo_half_right',
    'value' => array(esc_html__('Enable', 'dakota-theme') => '1'),
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'description' => esc_html__('The image will be on the right side of the background', 'dakota-theme'),
);
vc_add_param('vc_row', $milo_half_right);

$milo_type = array(
    'type' => 'dropdown',
    'heading' => esc_html__('Image Animation Type', 'dakota-theme'),
    'param_name' => 'milo_type',
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'value' => array(
        esc_html__('none', 'dakota-theme') => 'none',
        esc_html__('bounce', 'dakota-theme') => 'bounce',
        esc_html__('flash', 'dakota-theme') => 'flash',
        esc_html__('pulse', 'dakota-theme') => 'pulse',
        esc_html__('rubberBand', 'dakota-theme') => 'rubberBand',
        esc_html__('shake', 'dakota-theme') => 'shake',
        esc_html__('swing', 'dakota-theme') => 'swing',
        esc_html__('tada', 'dakota-theme') => 'tada',
        esc_html__('wobble', 'dakota-theme') => 'wobble',
        esc_html__('bounceIn', 'dakota-theme') => 'bounceIn',
        esc_html__('bounceInDown', 'dakota-theme') => 'bounceInDown',
        esc_html__('bounceInLeft', 'dakota-theme') => 'bounceInLeft',
        esc_html__('bounceInRight', 'dakota-theme') => 'bounceInRight',
        esc_html__('bounceInUp', 'dakota-theme') => 'bounceInUp',
        esc_html__('bounceOut', 'dakota-theme') => 'bounceOut',
        esc_html__('bounceOutDown', 'dakota-theme') => 'bounceOutDown',
        esc_html__('bounceOutLeft', 'dakota-theme') => 'bounceOutLeft',
        esc_html__('bounceOutRight', 'dakota-theme') => 'bounceOutRight',
        esc_html__('bounceOutUp', 'dakota-theme') => 'bounceOutUp',
        esc_html__('fadeIn', 'dakota-theme') => 'fadeIn',
        esc_html__('fadeInDown', 'dakota-theme') => 'fadeInDown',
        esc_html__('fadeInDownBig', 'dakota-theme') => 'fadeInDownBig',
        esc_html__('fadeInLeft', 'dakota-theme') => 'fadeInLeft',
        esc_html__('fadeInLeftBig', 'dakota-theme') => 'fadeInLeftBig',
        esc_html__('fadeInRight', 'dakota-theme') => 'fadeInRight',
        esc_html__('fadeInRightBig', 'dakota-theme') => 'fadeInRightBig',
        esc_html__('fadeInUp', 'dakota-theme') => 'fadeInUp',
        esc_html__('fadeInUpBig', 'dakota-theme') => 'fadeInUpBig',
        esc_html__('fadeOut', 'dakota-theme') => 'fadeOut',
        esc_html__('fadeOutDown', 'dakota-theme') => 'fadeOutDown',
        esc_html__('fadeOutDownBig', 'dakota-theme') => 'fadeOutDownBig',
        esc_html__('fadeOutLeft', 'dakota-theme') => 'fadeOutLeft',
        esc_html__('fadeOutLeftBig', 'dakota-theme') => 'fadeOutLeftBig',
        esc_html__('fadeOutRight', 'dakota-theme') => 'fadeOutRight',
        esc_html__('fadeOutRightBig', 'dakota-theme') => 'fadeOutRightBig',
        esc_html__('fadeOutUp', 'dakota-theme') => 'fadeOutUp',
        esc_html__('fadeOutUpBig', 'dakota-theme') => 'fadeOutUpBig',
        esc_html__('flip', 'dakota-theme') => 'flip',
        esc_html__('flipInX', 'dakota-theme') => 'flipInX',
        esc_html__('flipInY', 'dakota-theme') => 'flipInY',
        esc_html__('flipOutX', 'dakota-theme') => 'flipOutX',
        esc_html__('flipOutY', 'dakota-theme') => 'flipOutY',
        esc_html__('lightSpeedIn', 'dakota-theme') => 'lightSpeedIn',
        esc_html__('lightSpeedOut', 'dakota-theme') => 'lightSpeedOut',
        esc_html__('rotateIn', 'dakota-theme') => 'rotateIn',
        esc_html__('rotateInDownLeft', 'dakota-theme') => 'rotateInDownLeft',
        esc_html__('rotateInDownRight', 'dakota-theme') => 'rotateInDownRight',
        esc_html__('rotateInUpLeft', 'dakota-theme') => 'rotateInUpLeft',
        esc_html__('rotateInUpRight', 'dakota-theme') => 'rotateInUpRight',
        esc_html__('rotateOut', 'dakota-theme') => 'rotateOut',
        esc_html__('rotateOutDownLeft', 'dakota-theme') => 'rotateOutDownLeft',
        esc_html__('rotateOutDownRight', 'dakota-theme') => 'rotateOutDownRight',
        esc_html__('rotateOutUpLeft', 'dakota-theme') => 'rotateOutUpLeft',
        esc_html__('rotateOutUpRight', 'dakota-theme') => 'rotateOutUpRight',
        esc_html__('hinge', 'dakota-theme') => 'hinge',
        esc_html__('rollIn', 'dakota-theme') => 'rollIn',
        esc_html__('rollOut', 'dakota-theme') => 'rollOut',
        esc_html__('zoomIn', 'dakota-theme') => 'zoomIn',
        esc_html__('zoomInDown', 'dakota-theme') => 'zoomInDown',
        esc_html__('zoomInLeft', 'dakota-theme') => 'zoomInLeft',
        esc_html__('zoomInRight', 'dakota-theme') => 'zoomInRight',
        esc_html__('zoomInUp', 'dakota-theme') => 'zoomInUp',
        esc_html__('zoomOut', 'dakota-theme') => 'zoomOut',
        esc_html__('zoomOutDown', 'dakota-theme') => 'zoomOutDown',
        esc_html__('zoomOutLeft', 'dakota-theme') => 'zoomOutLeft',
        esc_html__('zoomOutRight', 'dakota-theme') => 'zoomOutRight',
        esc_html__('zoomOutUp', 'dakota-theme') => 'zoomOutUp'
    ),
    'description' => esc_html__('Select an animation for the image', 'dakota-theme')
);
vc_add_param('vc_row', $milo_type);

$milo_delay = array(
    'type' => 'textfield',
    'heading' => esc_html__('Animation Delay', 'dakota-theme'),
    'param_name' => 'milo_delay',
    'value' => '0',
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'description' => esc_html__('Specify the delay amount', 'dakota-theme')
);
vc_add_param('vc_row', $milo_delay);

$milo_iteration = array(
    'type' => 'textfield',
    'heading' => esc_html__('Iteration', 'dakota-theme'),
    'param_name' => 'milo_iteration',
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'description' => esc_html__('Specify the iteration in numbers or infinite, example: 3; example: infinite', 'dakota-theme')
);
vc_add_param('vc_row', $milo_iteration);

$milo_duration = array(
    'type' => 'textfield',
    'heading' => esc_html__('Duration', 'dakota-theme'),
    'param_name' => 'milo_duration',
    'value' => 'default',
    'dependency' => array(
        'element' => 'milo_half_enable',
        'value' => '1'
    ),
    'description' => esc_html__('Specify the duration in numbers, example: 3', 'dakota-theme')
);
vc_add_param('vc_row', $milo_duration);