<?php

/**
 * ReduxFramework Config File
 */
if (!class_exists('Redux')) {
    return;
}


// This is your option name where all the Redux data is stored.
$opt_name = "milo_theme_options";


// If Redux is running as a plugin, this will remove the demo notice and links
add_action( 'redux/loaded', 'remove_demo' );

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'menu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Theme Options', 'dakota-theme'),
    'page_title' => esc_html__('Theme Options', 'dakota-theme'),
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    'admin_bar' => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-portfolio',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => false,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    // OPTIONAL -> Give you extra features
    'page_priority' => 57,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => get_template_directory_uri() . '/inc/admin/images/admin_theme_options.png',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.
    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'system_info' => false,
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => '',
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover',
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave',
            ),
        ),
    )
);

Redux::setArgs($opt_name, $args);

/*
 * ---> END ARGUMENTS
 */


/*
 * ---> START HELP TABS
 */

$tabs = array(
    array(
        'id' => 'redux-help-tab-1',
        'title' => esc_html__('Theme Information 1', 'dakota-theme'),
        'content' => esc_html__('This is the tab content, HTML is allowed.', 'dakota-theme')
    ),
    array(
        'id' => 'redux-help-tab-2',
        'title' => esc_html__('Theme Information 2', 'dakota-theme'),
        'content' => esc_html__('This is the tab content, HTML is allowed.', 'dakota-theme')
    )
);
Redux::setHelpTab($opt_name, $tabs);

// Set the help sidebar
$content = esc_html__('This is the sidebar content, HTML is allowed.', 'dakota-theme');
Redux::setHelpSidebar($opt_name, $content);


// -> START Basic Fields
$page_ids = get_all_page_ids();
$pages_array = array();
$pages_array['default'] = 'Default';
foreach ($page_ids as $page_id) {
    // do not include the Auto Draft pages
    if (get_the_title($page_id) != 'Auto Draft') {
        $pages_array[$page_id] = esc_html(get_the_title($page_id));
    }
}
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-cogs',
    'title' => esc_html__('General', 'dakota-theme'),
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'milo-color-android-theme',
            'type' => 'color',
            'title' => esc_html__('Android theme color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a color', 'dakota-theme'),
            'default' => '#fe5e3e',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-ms-color',
            'type' => 'color',
            'title' => esc_html__('MS theme color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a color', 'dakota-theme'),
            'default' => '#fe5e3e',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-backtotop-toggle',
            'type' => 'button_set',
            'title' => esc_html__('Back to top', 'dakota-theme'),
            'subtitle' => esc_html__('Show the back to top navigator', 'dakota-theme'),
            'desc' => esc_html__('Toggle On or Off', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-404-selection',
            'type' => 'select',
            'title' => esc_html__('404 Page Selection', 'dakota-theme'),
            'subtitle' => esc_html__('Can replace the page displayed when error 404 occurs', 'dakota-theme'),
            'desc' => esc_html__('Chose a page for 404 error', 'dakota-theme'),
            'options' => $pages_array,
            'default' => 'default',
        ),
        array(
            'id' => 'milo-portfolio-slug',
            'type' => 'text',
            'title' => esc_html__('Portfolio slug', 'dakota-theme'),
            'subtitle' => esc_html__('Only for Milo Portfolio plugin', 'dakota-theme'),
            'desc' => esc_html__('Leave blank for default ( milo-portfolio ) or specify a new slug name', 'dakota-theme')
        ),
        array(
            'id' => 'milo-custom-css',
            'type' => 'textarea',
            'title' => esc_html__('Custom CSS', 'dakota-theme'),
            'subtitle' => esc_html__('Only CSS code allowed', 'dakota-theme'),
            'desc' => esc_html__('This field is CSS validated.', 'dakota-theme'),
            'validate' => 'css',
        )
    )
));

Redux::setSection($opt_name, array(
    'icon' => 'el-icon-home',
    'title' => esc_html__('Header', 'dakota-theme'),
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'milo-header-logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Header Logo Selection', 'dakota-theme'),
            'desc' => esc_html__('Upload a new logo image', 'dakota-theme'),
            'subtitle' => esc_html__('Replace or remove the existing logo', 'dakota-theme'),
            'default' => array(
                'url' => get_template_directory_uri() . '/layouts/images/logo.png')
        ),
        array(
            'id' => 'milo-header-stickyheader-toggle',
            'type' => 'button_set',
            'title' => esc_html__('Sticky Header', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable the sticky header', 'dakota-theme'),
            'desc' => esc_html__('Toggle On or Off', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-header-search-toggle',
            'type' => 'button_set',
            'title' => esc_html__('Header Search', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable the header search', 'dakota-theme'),
            'desc' => esc_html__('Toggle On or Off', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '1'
        ),
    )
));
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-credit-card',
    'title' => esc_html__('Widget Areas', 'dakota-theme'),
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'milo-top-switch',
            'type' => 'button_set',
            'title' => esc_html__('Top Widget area', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable header widget area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable widget area', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-layout-top',
            'type' => 'milo_multi_slider',
            'required' => array('milo-footer-top-switch', 'equals', '1'),
            'title' => esc_html__('Adjust the top widget area layout', 'dakota-theme'),
            'desc' => esc_html__('Adjust header areas size/spread', 'dakota-theme')
        ),
        array(
            'id' => 'milo-footer-top-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer top', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable footer area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable footer area/spread', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-footer-layout-top',
            'type' => 'milo_multi_slider',
            'required' => array('milo-footer-top-switch', 'equals', '1'),
            'title' => esc_html__('Adjust the top footer layout', 'dakota-theme'),
            'subtitle' => esc_html__('Add/edit sidebars', 'dakota-theme'),
            'desc' => esc_html__('Adjust footer areas size/spread', 'dakota-theme')
        ),
        array(
            'id' => 'milo-footer-mid-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer middle', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable footer middle area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable footer area/spread', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-footer-layout-mid',
            'type' => 'milo_multi_slider',
            'required' => array('milo-footer-mid-switch', 'equals', '1'),
            'title' => esc_html__('Adjust the middle footer layout', 'dakota-theme'),
            'subtitle' => esc_html__('Add/edit sidebars', 'dakota-theme'),
            'desc' => esc_html__('Adjust footer areas size/spread', 'dakota-theme')
        ),
        array(
            'id' => 'milo-footer-bottom-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer bottom', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable footer bottom area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable footer bottom area/spread', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '1'
        ),
        array(
            'id' => 'milo-footer-layout-bottom',
            'type' => 'milo_multi_slider',
            'required' => array('milo-footer-bottom-switch', 'equals', '1'),
            'title' => esc_html__('Adjust the bottom footer layout', 'dakota-theme'),
            'subtitle' => esc_html__('Add/edit sidebars', 'dakota-theme'),
            'desc' => esc_html__('Adjust footer areas size/spread', 'dakota-theme')
        ),
        array(
            'id' => 'milo-sidebars-size',
            'type' => 'slider',
            'title' => esc_html__('Sidebar width', 'dakota-theme'),
            'subtitle' => esc_html__('Adjust the sidebar width', 'dakota-theme'),
            'desc' => esc_html__('Increasing the sidebar size will reduce the rest of the page content width', 'dakota-theme'),
            "default" => 4,
            "min" => 1,
            "step" => 1,
            "max" => 11,
            'display_value' => 'text'
        ),
    )
));
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-credit-card',
    'title' => esc_html__('Backgrounds', 'dakota-theme'),
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'milo-page-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Page background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable page background', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable page background', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-page-bg-background',
            'type' => 'background',
            'required' => array('milo-page-bg-switch', 'equals', '1'),
            'title' => esc_html__('Page background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-sidebar-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Sidebar background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable sidebar background', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable sidebar background', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-sidebar-bg-background',
            'type' => 'background',
            'required' => array('milo-sidebar-bg-switch', 'equals', '1'),
            'title' => esc_html__('Sidebar background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-header-nav-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Header menu background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for header menu', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for header menu', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-header-nav-background',
            'type' => 'background',
            'required' => array('milo-header-nav-bg-switch', 'equals', '1'),
            'title' => esc_html__('Header menu background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '#fff',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-header-mega-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Header megamenu background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for header megamenu', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for header menu', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-header-mega-background',
            'type' => 'background',
            'required' => array('milo-header-mega-bg-switch', 'equals', '1'),
            'title' => esc_html__('Header megamenu background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '#f0f0f0',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-header-area-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Header widget area background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for header widget area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for header widget area', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-header-area-background',
            'type' => 'background',
            'required' => array('milo-header-area-bg-switch', 'equals', '1'),
            'title' => esc_html__('Header widget area Background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-footer-top-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer top background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for footer top area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for footer top areaa', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '1'
        ),
        array('id' => 'milo-footer-top-background',
            'type' => 'background',
            'required' => array('milo-footer-top-bg-switch', 'equals', '1'),
            'title' => esc_html__('Footer Top Background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-image' => get_template_directory_uri() . '/layouts/images/footer-top.jpg',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-footer-top-parallax',
            'type' => 'button_set',
            'title' => esc_html__('Footer top parallax', 'dakota-theme'),
            'required' => array('milo-footer-top-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer top parallax', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-footer-top-shadow',
            'type' => 'button_set',
            'title' => esc_html__('Footer top shadow', 'dakota-theme'),
            'required' => array('milo-footer-top-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer top shadow', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-footer-mid-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer mid background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for footer middle area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for footer middle areaa', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-footer-mid-background',
            'type' => 'background',
            'required' => array('milo-footer-mid-bg-switch', 'equals', '1'),
            'title' => esc_html__('Footer Middle Background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '#060c17',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-footer-mid-parallax',
            'type' => 'button_set',
            'title' => esc_html__('Footer middle parallax', 'dakota-theme'),
            'required' => array('milo-footer-mid-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer middle parallax', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-footer-mid-shadow',
            'type' => 'button_set',
            'title' => esc_html__('Footer middle shadow', 'dakota-theme'),
            'required' => array('milo-footer-mid-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer middle shadow', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-footer-bottom-bg-switch',
            'type' => 'button_set',
            'title' => esc_html__('Footer Bottom background', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable background for footer bottom area', 'dakota-theme'),
            'desc' => esc_html__('Enable or disable background for footer bottom areaa', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array('id' => 'milo-footer-bottom-background',
            'type' => 'background',
            'required' => array('milo-footer-bottom-bg-switch', 'equals', '1'),
            'title' => esc_html__('Footer Bottom Background', 'dakota-theme'),
            'desc' => esc_html__('Select a color or image for the background', 'dakota-theme'),
            'transparent' => false,
            'preview_media' => true,
            'default' => array(
                'background-color' => '#040914',
                'background-repeat' => 'no-repeat',
                'background-position' => 'center center'
            )),
        array(
            'id' => 'milo-footer-bottom-parallax',
            'type' => 'button_set',
            'title' => esc_html__('Footer bottom parallax', 'dakota-theme'),
            'required' => array('milo-footer-bottom-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer bottom parallax', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-footer-bottom-shadow',
            'type' => 'button_set',
            'title' => esc_html__('Footer bottom shadow', 'dakota-theme'),
            'required' => array('milo-footer-bottom-bg-switch', 'equals', '1'),
            'desc' => esc_html__('Enable or disable the footer bottom shadow', 'dakota-theme'),
            'options' => array(
                '1' => 'On',
                '2' => 'Off'
            ),
            'default' => '2'
        )
    )
));
Redux::setSection($opt_name, array(
    'icon' => 'el-icon-list',
    'title' => esc_html__('Theme Colors', 'dakota-theme'),
    'subsection' => false,
    'fields' => array(
        array(
            'id' => 'milo-accent-colors-enable',
            'type' => 'button_set',
            'title' => esc_html__('Color scheme', 'dakota-theme'),
            'subtitle' => esc_html__('Enable or disable custom color scheme', 'dakota-theme'),
            'desc' => esc_html__('If it is disabled, then the default color scheme will be used.', 'dakota-theme'),
            'options' => array(
                '1' => 'Enable',
                '2' => 'Disable'
            ),
            'default' => '2'
        ),
        array(
            'id' => 'milo-color-scheme-accent1',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('First accent color ', 'dakota-theme'),
            'subtitle' => esc_html__('Pick an accent color', 'dakota-theme'),
            'default' => '#fe5e3e',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-accent2',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Second accent color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick an accent color', 'dakota-theme'),
            'default' => '#00d2ed',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-accent3',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Third accent color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick an accent color', 'dakota-theme'),
            'default' => '#00e095',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-accent4',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Fourth accent color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick an accent color', 'dakota-theme'),
            'default' => '#282e3a',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-body-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Body font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a font color', 'dakota-theme'),
            'default' => '#6e6e6e',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-headlines',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Headlines font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a headlines font color', 'dakota-theme'),
            'default' => '#282e3a',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-menu',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Menu font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a menu font color', 'dakota-theme'),
            'default' => '#282e3a',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-submenu',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Submenus font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a submenu font color', 'dakota-theme'),
            'default' => '#282e3a',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-scheme-submenu-bg',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Submenus background color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a submenu background color', 'dakota-theme'),
            'default' => '#f0f0f0',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-header-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Header widget area font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a header widget area font color', 'dakota-theme'),
            'default' => '#6e6e6e',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-footer-top-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Footer top font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a footer top font color', 'dakota-theme'),
            'default' => '#d1d1d1',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-footer-mid-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Footer middle font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a footer middle font color', 'dakota-theme'),
            'default' => '#d1d1d1',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-footer-bottom-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Footer bottom font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a footer bottom font color', 'dakota-theme'),
            'default' => '#d1d1d1',
            'transparent' => false,
            'validate' => 'color',
        ),
        array(
            'id' => 'milo-color-sidebar-font',
            'type' => 'color',
            'required' => array('milo-accent-colors-enable', 'equals', '1'),
            'title' => esc_html__('Sidebar font color', 'dakota-theme'),
            'subtitle' => esc_html__('Pick a sidebar font color', 'dakota-theme'),
            'default' => '#282e3a',
            'transparent' => false,
            'validate' => 'color',
        )
    )
));

/*
 * <--- END SECTIONS
 */

/**
 * This is a test function that will let you see when the compiler hook occurs.
 * It only runs if a field    set with compiler=>true is changed.
 * */
function compiler_action($options, $css, $changed_values) {
    echo "<pre>";
    print_r($changed_values); // Values that have changed since the last save
    echo "</pre>";
}

/**
 * Custom function for the callback validation referenced above
 * */
if (!function_exists('redux_validate_callback_function')) {

    function redux_validate_callback_function($field, $value, $existing_value) {
        $error = false;
        $warning = false;

        //do your validation
        if ($value == 1) {
            $error = true;
            $value = $existing_value;
        } elseif ($value == 2) {
            $warning = true;
            $value = $existing_value;
        }

        $return['value'] = $value;

        if ($error == true) {
            $return['error'] = $field;
            $field['msg'] = 'your custom error message';
        }

        if ($warning == true) {
            $return['warning'] = $field;
            $field['msg'] = 'your custom warning message';
        }

        return $return;
    }

}

/**
 * Custom function for the callback referenced above
 */
if (!function_exists('redux_my_custom_field')) {

    function redux_my_custom_field($field, $value) {
        print_r($field);
        echo '<br/>';
        print_r($value);
    }

}

/**
 * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
 * so you must use get_template_directory_uri() if you want to use any of the built in icons
 * */
function dynamic_section($sections) {
    //$sections = array();
    $sections[] = array(
        'title' => esc_html__('Section via hook', 'dakota-theme'),
        'desc' => esc_html__('This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.', 'dakota-theme'),
        'icon' => 'el el-paper-clip',
        // Leave this as a blank section, no options just some intro text set above.
        'fields' => array()
    );

    return $sections;
}

/**
 * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
 * */
function change_arguments($args) {
    //$args['dev_mode'] = true;

    return $args;
}

/**
 * Filter hook for filtering the default value of any given field. Very useful in development mode.
 * */
function change_defaults($defaults) {
    $defaults['str_replace'] = 'Testing filter hook!';

    return $defaults;
}

// Remove the demo link and the notice of integrated demo from the redux-framework plugin
function remove_demo() {

    // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
    if (class_exists('ReduxFrameworkPlugin')) {
        remove_filter('plugin_row_meta', array(
            ReduxFrameworkPlugin::instance(),
            'plugin_metalinks'
                ), null, 2);

        // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
        remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
    }
}

// Adds the custom CSS and the custom color schemes 
add_action('wp_head', 'milo_theme_options_styles');

function milo_theme_options_styles() {
    if (!is_admin()) {
        global $milo_theme_options;

        echo '<style type="text/css">';

        if (is_admin_bar_showing()) {
            echo '#header-sticky.header-sticky { padding-top: 35px; }';
        }

        $milo_accent_colors_enable = 0;

        if (isset($milo_theme_options['milo-accent-colors-enable'])) {
            $milo_accent_colors_enable = $milo_theme_options['milo-accent-colors-enable'];
        }

        if ($milo_accent_colors_enable == 1) {

            $color_accent1 = "#fe5e3e";
            if (isset($milo_theme_options['milo-color-scheme-accent1'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-accent1'])) {
                    $color_accent1 = $milo_theme_options['milo-color-scheme-accent1'];
                }
            }
            if ($color_accent1 != "#fe5e3e") {
                echo 'a,
                    a:hover,
                    a:focus,
                    .text-default,
                    .check-list.default li:before,
                    .process-steps .step > i,
                    .process-steps.default .step > i,
                    .pie-chart > i,
                    .pie-chart.default > i,
                    .comparison-bars .progress-bar-title-after i,
                    .comparison-bars .progress-bar-title-before i,
                    .comparison-bars.default .progress-bar-title-after i,
                    .comparison-bars.default .progress-bar-title-before i,
                    .counter > i,
                    .counter.default > i,
                    .countdown > div:after,
                    .testimonial > h6,
                    .widget_categories ul li a:hover,
                    .widget_archive ul li a:hover,
                    .widget_pages ul li a:hover,
                    .widget_meta ul li a:hover,
                    .widget_recent-posts ul li .post-title:hover,
                    .widget_contact ul li i,
                    .menu li a:hover, 
                    .menu li.active > a,
                    .menu li.current-menu-ancestor > a,
                    .menu li.current-menu-item > a,
                     #header .search a:hover,
                    #header .search a:active,
                    #header .search a:focus,
                    #footer a:hover,
                    #footer .widget-recent-posts ul li .post-date,
                    #footer-bottom a:hover,
                    #footer-bottom .widget-recent-posts ul li .post-date,
                    .service-box.style-1 > i,
                    .service-box.style-1.default > i,
                    .service-box.style-1.default .service-box-content h6 a:hover,
                    .service-box.style-2 > i,
                    .service-box.style-2.default > i,
                    .service-box.style-2.default .service-box-content h6 a:hover,
                    .service-box.style-3 > i,
                    .service-box.style-3.default > i,
                    .service-box.style-3.default h6 a:hover,
                    .service-box.style-4 i,
                    .service-box.style-4.default i,
                    .service-box.style-4.default .service-box-content h6 a:hover,
                    .blog-article-author h6
                    { color: ' . esc_attr($color_accent1) . '; }';

                echo '.theme-tab .vc_tta-tab.vc_active a,
                    .theme-tab .vc_tta-tab a:hover,
                    .theme-tab .vc_tta-tab a:focus,
                    .theme-tab2 .vc_tta-tab.vc_active a,
                    .theme-tab2 .vc_tta-tab a:hover,
                    .theme-tab2 .vc_tta-tab a:focus,
                    .theme-tab3 .vc_tta-tab.vc_active a,
                    .theme-tab3 .vc_tta-tab a:hover,
                    .theme-tab3 .vc_tta-tab a:focus,
                    a.social-media.color-default:hover
                    { color: ' . esc_attr($color_accent1) . ' !important; }';

                echo '.alert.alert-danger,
                    .arrow-list.default li:before,
                    .btn-default, 
                    .btn-default:hover, 
                    .btn-default:focus,
                    .btn-default:active,
                    .btn-default:active:focus,
                    .text-box.default,
                    .panel-title.default a,
                    .process-steps .step > i:after,
                    .process-steps .step:hover > i,
                    .process-steps.default .step > i:after,
                    .process-steps.default .step:hover > i,
                    .progress-bar,
                    .progress-bar.default,
                    .comparison-bars .progress-bar,
                    .comparison-bars.default .progress-bar,
                    .legend li:nth-child(1):before,
                    .price-plan-header,
                    .price-plan:hover,
                    .price-plan:hover ul li:nth-child(odd), 
                    .price-plan:hover .price-plan-footer,
                    .price-plan.default .price-plan-header, 
                    .price-plan.default:hover,
                    .price-plan.default:hover ul li:nth-child(odd), 
                    .price-plan.default:hover .price-plan-footer,
                    .testimonial:before,
                    .filter li a:before,
                    .filter li a:hover,
                    .filter li a.active,
                    .pagination li a:hover,
                    .pagination li.active a,
                    .pagination li.active a:hover,
                    #go-top:hover,
                    .tp-leftarrow.custom:hover,
                    .tp-rightarrow.custom:hover,
                    .owl-prev:hover,
                    .owl-next:hover,
                    .widget_categories ul li a:hover:before,
                    .widget_archive ul li a:hover:before,
                    .widget_pages ul li a:hover:before,
                    .widget_meta ul li a:hover:before,
                    .widget_tag_cloud a:before,
                    .widget_calendar table td#today,
                    .menu ul li > a:hover,
                    .menu ul li.sfHover > a,
                    #mobile-menu-button,
                    #mobile-menu,
                    #search-form-container a.search-form-close:hover,
                    #page-header,
                    .about-me .social-media,
                    .blog-article-date,
                    #commentform #submit
                    { background-color: ' . esc_attr($color_accent1) . '; }';

                echo '.panel-title a:hover,
                    .panel-title a[aria-expanded="true"],
                    .theme .vc_tta-panel-title a:hover,
                    .theme .vc_tta-panels-container .vc_tta-panels .vc_active .vc_tta-panel-heading .vc_tta-panel-title a,
                    .theme.default .vc_tta-panel-title a,
                    .theme.default .vc_tta-panel-title a:focus,
                    .theme .default .vc_tta-panel-title a,
                    .theme .default .vc_tta-panel-title a:focus,
                    .theme.default .vc_tta-panel-title a:hover,
                    .theme.default .vc_tta-panels-container .vc_tta-panels .vc_active .vc_tta-panel-heading .vc_tta-panel-title a,
                    .theme .default .vc_tta-panel-title a:hover,
                    .theme .vc_tta-panels-container .vc_tta-panels .default.vc_active .vc_tta-panel-heading .vc_tta-panel-title a
                    { background-color: ' . esc_attr($color_accent1) . ' !important; }';

                echo '.service-box.style-3:after,
                    .service-box.style-3.default:after
                    { border-bottom-color: ' . esc_attr($color_accent1) . '; }';

                echo '.hr.default,
                    .sf-arrows > li:hover > .sf-with-ul:after,
                    .service-box.style-3:after,
                    .service-box.style-3.default:after
                    { border-top-color: ' . esc_attr($color_accent1) . '; }';

                echo '.headline:after,
                    .check-list.default li:before,
                    .process-steps .step > i,
                    .process-steps.default .step > i,
                    .filter li a:hover,
                    .filter li a.active,
                    .pagination li a:hover,
                    .pagination li.active a,
                    .pagination li.active a:hover,
                    .widget_categories ul li a:before,
                    .widget_archive ul li a:before,
                    .widget_pages ul li a:before,
                    .widget_meta ul li a:before,
                    .widget_newsletter input[type="email"]:focus,
                    #search-form-container a.search-form-close:hover,
                    .sticky
                    { border-color: ' . esc_attr($color_accent1) . '; }';

                echo '.service-box.style-3:before,
                    .service-box.style-3.default:before
                    { border-right-color: ' . esc_attr($color_accent1) . '; }';

                echo '.service-box.style-3:before,
                    .service-box.style-3.default:before,
                    .blog-article-thumbnail,
                    .blog-article-date:before
                    { border-left-color: ' . esc_attr($color_accent1) . '; }';

                $color_accent1_rgba = milo_hex_to_rgba($color_accent1, 0.9);

                echo '.portfolio-item-hover
                    { background-color: ' . esc_attr($color_accent1_rgba) . '; }';
            }

            $color_accent2 = "#00d2ed";
            if (isset($milo_theme_options['milo-color-scheme-accent2'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-accent2'])) {
                    $color_accent2 = $milo_theme_options['milo-color-scheme-accent2'];
                }
            }

            if ($color_accent2 != "#00d2ed") {
                echo '.text-blue,
                    .check-list.blue li:before,
                    .process-steps.blue .step > i,
                    .pie-chart.blue > i,
                    .comparison-bars.blue .progress-bar-title-after i,
                    .comparison-bars.blue .progress-bar-title-before i,
                    .counter.blue > i,
                    .service-box.style-1.blue > i,
                    .service-box.style-1.blue .service-box-content h6 a:hover,
                    .service-box.style-2.blue > i,
                    .service-box.style-2.blue .service-box-content h6 a:hover,
                    .service-box.style-3.blue > i,
                    .service-box.style-3.blue h6 a:hover,
                    .service-box.style-4.blue i,
                    .service-box.style-4.blue .service-box-content h6 a:hover
                    { color: ' . esc_attr($color_accent2) . '; }';

                echo '.headline:before,
                    .check-list.blue li:before,
                    .process-steps.blue .step > i,
                    .tp-bullets.custom .tp-bullet,
                    .owl-page
                    { border-color: ' . esc_attr($color_accent2) . '; }';

                echo 'a.social-media.color-blue:hover
                    { color: ' . esc_attr($color_accent2) . ' !important; }';

                echo '.alert.alert-warning,
                    .arrow-list.blue li:before,
                    .btn-blue, 
                    .btn-blue:hover, 
                    .btn-blue:focus,
                    .btn-blue:active,
                    .btn-blue:active:focus,
                    .text-box.blue,
                    .panel-title.blue a,
                    .process-steps.blue .step > i:after,
                    .process-steps.blue .step:hover > i,
                    .progress-bar.blue,
                    .comparison-bars.blue .progress-bar,
                    .legend li:nth-child(2):before,
                    .price-plan.blue .price-plan-header, 
                    .price-plan.blue:hover,
                    .price-plan.blue:hover ul li:nth-child(odd), 
                    .price-plan.blue:hover .price-plan-footer,
                    .tp-bullets.custom .tp-bullet:hover,
                    .tp-bullets.custom .tp-bullet.selected,
                    .owl-page:hover,
                    .owl-page.active
                    { background-color: ' . esc_attr($color_accent2) . '; }';

                echo '.theme.blue .vc_tta-panel-title a,
                    .theme.blue .vc_tta-panel-title a:focus,
                    .theme .blue .vc_tta-panel-title a,
                    .theme .blue .vc_tta-panel-title a:focus,
                    .theme.blue .vc_tta-panel-title a:hover,
                    .theme.blue .vc_tta-panels-container .vc_tta-panels .vc_active .vc_tta-panel-heading .vc_tta-panel-title a,
                    .theme .blue .vc_tta-panel-title a:hover,
                    .theme .vc_tta-panels-container .vc_tta-panels .blue.vc_active .vc_tta-panel-heading .vc_tta-panel-title a
                    { background-color: ' . esc_attr($color_accent2) . ' !important; }';

                echo '.hr.blue,
                    .service-box.style-3.blue:after
                    { border-top-color: ' . esc_attr($color_accent2) . '; }';

                echo '.service-box.style-3.blue:before
                    { border-right-color: ' . esc_attr($color_accent2) . '; }';

                echo '.service-box.style-3.blue:before
                    { border-left-color: ' . esc_attr($color_accent2) . '; }';

                echo '.service-box.style-3.blue:after
                    { border-bottom-color: ' . esc_attr($color_accent2) . '; }';
            }

            $color_accent3 = "#00e095";
            if (isset($milo_theme_options['milo-color-scheme-accent3'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-accent3'])) {
                    $color_accent3 = $milo_theme_options['milo-color-scheme-accent3'];
                }
            }

            if ($color_accent3 != "#00e095") {
                echo '.text-green,
                    .check-list.green li:before,
                    .process-steps.green .step > i,
                    .pie-chart.green > i,
                    .comparison-bars.green .progress-bar-title-after i,
                    .comparison-bars.green .progress-bar-title-before i,
                    .counter.green > i,
                    .service-box.style-1.green > i,
                    .service-box.style-1.green .service-box-content h6 a:hover,
                    .service-box.style-2.green > i,
                    .service-box.style-2.green .service-box-content h6 a:hover,
                    .service-box.style-3.green > i,
                    .service-box.style-3.green h6 a:hover,
                    .service-box.style-4.green i,
                    .service-box.style-4.green .service-box-content h6 a:hover
                    { color: ' . esc_attr($color_accent3) . '; }';

                echo '.check-list.green li:before,
                    .process-steps.green .step > i
                    { border-color: ' . esc_attr($color_accent3) . '; }';

                echo 'a.social-media.color-green:hover
                    { color: ' . esc_attr($color_accent3) . ' !important; }';

                echo '.alert.alert-success,
                    .arrow-list.green li:before,
                    .btn-green, 
                    .btn-green:hover, 
                    .btn-green:focus,
                    .btn-green:active,
                    .btn-green:active:focus,
                    .text-box.green,
                    .panel-title.green a,
                    .process-steps.green .step > i:after,
                    .process-steps.green .step:hover > i,
                    .progress-bar.green,
                    .comparison-bars.green .progress-bar,
                    .legend li:nth-child(3):before,
                    .price-plan.green .price-plan-header, 
                    .price-plan.green:hover,
                    .price-plan.green:hover ul li:nth-child(odd), 
                    .price-plan.green:hover .price-plan-footer
                    { background-color: ' . esc_attr($color_accent3) . '; }';

                echo '.theme.green .vc_tta-panel-title a,
                    .theme.green .vc_tta-panel-title a:focus,
                    .theme .green .vc_tta-panel-title a,
                    .theme .green .vc_tta-panel-title a:focus,
                    .theme.green .vc_tta-panel-title a:hover,
                    .theme.green .vc_tta-panels-container .vc_tta-panels .vc_active .vc_tta-panel-heading .vc_tta-panel-title a,
                    .theme .green .vc_tta-panel-title a:hover,
                    .theme .vc_tta-panels-container .vc_tta-panels .green.vc_active .vc_tta-panel-heading .vc_tta-panel-title a
                    { background-color: ' . esc_attr($color_accent3) . ' !important; }';

                echo '.hr.green,
                    .service-box.style-3.green:after
                    { border-top-color: ' . esc_attr($color_accent3) . '; }';

                echo '.service-box.style-3.green:before
                    { border-right-color: ' . esc_attr($color_accent3) . '; }';

                echo '.service-box.style-3.green:before
                    { border-left-color: ' . esc_attr($color_accent3) . '; }';

                echo '.service-box.style-3.green:after
                    { border-bottom-color: ' . esc_attr($color_accent3) . '; }';
            }

            $color_accent4 = "#282e3a";
            if (isset($milo_theme_options['milo-color-scheme-accent4'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-accent4'])) {
                    $color_accent4 = $milo_theme_options['milo-color-scheme-accent4'];
                }
            }

            if ($color_accent4 != "#282e3a") {
                echo 'h1,
                    h2,
                    h3,
                    h4,
                    h5,
                    h6,
                    h1 a, 
                    h2 a, 
                    h3 a, 
                    h4 a, 
                    h5 a, 
                    h6 a,
                    .check-list li:before,
                    .btn-white,
                    .btn-white:focus, 
                    .btn-white:active,
                    .counter-value,
                    .countdown > div,
                    .tp-caption.title-big,
                    .widget_categories ul li a,
                    .widget_archive ul li a,
                    .widget_pages ul li a,
                    .widget_meta ul li a,
                    .widget_recent-posts ul li .post-title,
                    .menu li a,
                    #header .search a,
                    .about-me .social-media a:hover,
                    .blog-article-author h6 span,
                    .comment-author .fn,
                    .comment-metadata a
                    { color: ' . esc_attr($color_accent4) . '; }';

                echo '.check-list li:before,
                    .btn-white,
                    .btn-white:focus, 
                    .btn-white:active,
                    .slider-navigation span:hover,
                    .widget_newsletter input[type="email"]
                    { border-color: ' . esc_attr($color_accent4) . '; }';

                echo 'input[type="reset"]:hover,
                    input[type="submit"]:hover,
                    input[type="button"]:hover,
                    .alert.alert-info,
                    .arrow-list li:before,
                    .btn:before,
                    .btn-black, 
                    .btn-black:hover, 
                    .btn-black:focus,
                    .btn-black:active,
                    .btn-black:active:focus,
                    .text-box,
                    .theme .vc_tta-panel-title a,
                    .price-plan .price,
                    .full-section-overlay-color,
                    #go-top,
                    .tp-leftarrow.custom,
                    .tp-rightarrow.custom,
                    .owl-prev,
                    .owl-next,
                    .slider-navigation span:hover,
                    .widget_tag_cloud a,
                    #search-form-container,
                    #commentform #submit:active,
                    #commentform #submit:hover,
                    #commentform #submit:focus,
                    #commentform #submit:active:focus
                    { background-color: ' . esc_attr($color_accent4) . '; }';

                echo '.panel-title a,
                    .panel-title a:focus,
                    .theme .vc_tta-panel-title a,
                    .theme .vc_tta-panel-title a:focus
                    { background-color: ' . esc_attr($color_accent4) . ' !important; }';

                echo '.sf-arrows .sf-with-ul:after
                    { border-top-color: ' . esc_attr($color_accent4) . '; }';

                echo '.sf-arrows ul .sf-with-ul:after
                    { border-left-color: ' . esc_attr($color_accent4) . '; }';
            }

            $body_font = "#6e6e6e";
            if (isset($milo_theme_options['milo-color-body-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-body-font'])) {
                    $body_font = $milo_theme_options['milo-color-body-font'];
                }
            }

            if ($body_font != "#6e6e6e") {
                echo 'body { color: ' . esc_attr($body_font) . '; }';
            }

            $headlines_font = "#282e3a";

            if (isset($milo_theme_options['milo-color-scheme-headlines'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-headlines'])) {
                    $headlines_font = $milo_theme_options['milo-color-scheme-headlines'];
                }
            }

            if ($headlines_font != "#282e3a") {
                echo 'h1,
                    h2,
                    h3,
                    h4,
                    h5,
                    h6,
                    h1 a, 
                    h2 a, 
                    h3 a, 
                    h4 a, 
                    h5 a, 
                    h6 a
                { color: ' . esc_attr($headlines_font) . '; }';


                $color_headlines_rgba = milo_hex_to_rgba($headlines_font, 0.5);

                echo '.headline h6
                { color: ' . esc_attr($color_headlines_rgba) . '; }';
            }

            $submenu_font = "#282e3a";

            if (isset($milo_theme_options['milo-color-scheme-submenu'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-submenu'])) {
                    $submenu_font = $milo_theme_options['milo-color-scheme-submenu'];
                }
            }

            if ($submenu_font != "#282e3a") {
                echo '.menu li a { color: ' . esc_attr($submenu_font) . '; }';
            }

            $submenu_bg = "#f0f0f0";

            if (isset($milo_theme_options['milo-color-scheme-submenu-bg'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-submenu-bg'])) {
                    $submenu_bg = $milo_theme_options['milo-color-scheme-submenu-bg'];
                }
            }

            if ($submenu_bg != "#f0f0f0") {
                echo '.menu li.dropdown ul, .menu li.megamenu .megamenu-container { background-color: ' . esc_attr($submenu_bg) . '; }';
            }

            $menu_font = "#282e3a";

            if (isset($milo_theme_options['milo-color-scheme-menu'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-scheme-menu'])) {
                    $menu_font = $milo_theme_options['milo-color-scheme-menu'];
                }
            }

            if ($menu_font != "#282e3a") {
                echo '.menu > li > a { color: ' . esc_attr($menu_font) . '; }';
            }

            $header_font = "#6e6e6e";

            if (isset($milo_theme_options['milo-color-header-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-header-font'])) {
                    $header_font = $milo_theme_options['milo-color-header-font'];
                }
            }

            if ($header_font != "#6e6e6e") {
                echo '#header-top a,
                    #header-top h1,
                    #header-top h2,
                    #header-top h3,
                    #header-top h4,
                    #header-top h5,
                    #header-top h6,
                    #header-top .widget_milo_social_media_widget ul li i,
                    #header-top .widget_milo_contact_widget ul li i,
                    #header-top,
                    #header-top .widget-recent-posts ul li .post-date
                    { color: ' . esc_attr($header_font) . '; }';
            }

            $footer_top_font = "#6e6e6e";

            if (isset($milo_theme_options['milo-color-footer-top-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-footer-top-font'])) {
                    $footer_top_font = $milo_theme_options['milo-color-footer-top-font'];
                }
            }

            if ($footer_top_font != "#6e6e6e") {
                echo '#footer-top,
                    #footer-top a,
                    #footer-top h1,
                    #footer-top h2,
                    #footer-top h3,
                    #footer-top h4,
                    #footer-top h5,
                    #footer-top h6,
                    #footer-top .widget_milo_contact_widget ul li i,
                    #footer-top .widget-recent-posts ul li .post-date
                        { color: ' . esc_attr($footer_mid_font) . '; }';
            }

            $footer_mid_font = "#d1d1d1";

            if (isset($milo_theme_options['milo-color-footer-mid-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-footer-mid-font'])) {
                    $footer_mid_font = $milo_theme_options['milo-color-footer-mid-font'];
                }
            }

            if ($footer_mid_font != "#d1d1d1") {
                echo '#footer,
                    #footer a,
                    #footer h1,
                    #footer h2,
                    #footer h3,
                    #footer h4,
                    #footer h5,
                    #footer h6,
                    #footer .widget_milo_contact_widget ul li i,
                    #footer .widget-recent-posts ul li .post-date
                        { color: ' . esc_attr($footer_top_font) . '; }';
            }

            $footer_bottom_font = "#d1d1d1";

            if (isset($milo_theme_options['milo-color-footer-bottom-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-footer-bottom-font'])) {
                    $footer_bottom_font = $milo_theme_options['milo-color-footer-bottom-font'];
                }
            }

            if ($footer_bottom_font != "#d1d1d1") {
                echo '#footer-bottom,
                    #footer-bottom a,
                    #footer-bottom h1,
                    #footer-bottom h2,
                    #footer-bottom h3,
                    #footer-bottom h4,
                    #footer-bottom h5,
                    #footer-bottom h6,
                    #footer-bottom .widget_milo_contact_widget ul li i,
                    #footer-bottom .widget-recent-posts ul li .post-date
                        { color: ' . esc_attr($footer_bottom_font) . '; }';
            }

            $sidebar_font = "#282e3a";

            if (isset($milo_theme_options['milo-color-sidebar-font'])) {
                if (preg_match('/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i', $milo_theme_options['milo-color-sidebar-font'])) {
                    $sidebar_font = $milo_theme_options['milo-color-sidebar-font'];
                }
            }

            if ($sidebar_font != "#282e3a") {
                echo '#milo-sidebar,
                    #milo-sidebar a,
                    #milo-sidebar h1,
                    #milo-sidebar h2,
                    #milo-sidebar h3,
                    #milo-sidebar h4,
                    #milo-sidebar h5,
                    #milo-sidebar h6,
                    #milo-sidebar .widget_milo_contact_widget ul li i,
                    #milo-sidebar .widget-recent-posts ul li .post-date
                        { color: ' . esc_attr($sidebar_font) . ' !important; }';
            }
        }

        $milo_sidebar_bg_enable = 0;
        if (isset($milo_theme_options['milo-sidebar-bg-switch'])) {
            $milo_sidebar_bg_enable = $milo_theme_options['milo-sidebar-bg-switch'];
        }

        if ($milo_sidebar_bg_enable == 1) {
            $milo_sidebar_bg_color = $milo_sidebar_bg_image = $milo_sidebar_bg_repeat = $milo_sidebar_bg_position = $milo_sidebar_bg_size = $milo_sidebar_bg_attachment = '';

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-color'])) {
                $milo_sidebar_bg_color = $milo_theme_options['milo-sidebar-bg-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-image'])) {
                $milo_sidebar_bg_image = $milo_theme_options['milo-sidebar-bg-background']['background-image'];
            }

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-repeat'])) {
                $milo_sidebar_bg_repeat = $milo_theme_options['milo-sidebar-bg-background']['background-repeat'];
            }

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-position'])) {
                $milo_sidebar_bg_position = $milo_theme_options['milo-sidebar-bg-background']['background-position'];
            }

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-size'])) {
                $milo_sidebar_bg_size = $milo_theme_options['milo-sidebar-bg-background']['background-size'];
            }

            if (isset($milo_theme_options['milo-sidebar-bg-background']['background-attachment'])) {
                $milo_sidebar_bg_attachment = $milo_theme_options['milo-sidebar-bg-background'] ['background-attachment'];
            }

            if ($milo_sidebar_bg_color != null || $milo_sidebar_bg_image != null) {
                echo ' #milo-sidebar {';
                if ($milo_sidebar_bg_color != null) {
                    echo 'background-color: ' . esc_attr($milo_sidebar_bg_color) . ';';
                }

                // Background image.
                if ($milo_sidebar_bg_image != null) {
                    echo 'background-image: url(' . esc_url($milo_sidebar_bg_image) . ');';
                }

                // Background image options
                if ($milo_sidebar_bg_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_sidebar_bg_repeat) . ';';
                }
                if ($milo_sidebar_bg_position != null) {
                    echo 'background-position: ' . esc_attr($milo_sidebar_bg_position) . ';';
                }
                if ($milo_sidebar_bg_size != null) {
                    echo 'background-size: ' . esc_attr($milo_sidebar_bg_size) . ';';
                }
                if ($milo_sidebar_bg_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_sidebar_bg_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_page_bg_enable = 0;
        if (isset($milo_theme_options ['milo-page-bg-switch'])) {
            $milo_pager_bg_enable = $milo_theme_options['milo-page-bg-switch'];
        }

        if ($milo_page_bg_enable == 1) {

            $milo_page_bg_color = $milo_page_bg_image = $milo_page_bg_repeat = $milo_page_bg_position = $milo_page_bg_size = $milo_page_bg_attachment = '';

            if (isset($milo_theme_options['milo-page-bg-background']['background-color'])) {
                $milo_page_bg_color = $milo_theme_options['milo-page-bg-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-page-bg-background']['background-image'])) {
                $milo_page_bg_image = $milo_theme_options['milo-page-bg-background']['background-image'];
            }

            if (isset($milo_theme_options['milo-page-bg-background']['background-repeat'])) {
                $milo_page_bg_repeat = $milo_theme_options['milo-page-bg-background']['background-repeat'];
            }

            if (isset($milo_theme_options['milo-page-bg-background']['background-position'])) {
                $milo_page_bg_position = $milo_theme_options['milo-page-bg-background']['background-position'];
            }

            if (isset($milo_theme_options['milo-page-bg-background']['background-size'])) {
                $milo_page_bg_size = $milo_theme_options['milo-page-bg-background']['background-size'];
            }

            if (isset($milo_theme_options ['milo-page-bg-background'] ['background-attachment'])) {
                $milo_page_bg_attachment = $milo_theme_options['milo-page-bg-background'] ['background-attachment'];
            }

            if ($milo_page_bg_color != null || $milo_page_bg_image != null) {
                echo '#page-content {';
                if ($milo_page_bg_color != null) {
                    echo 'background-color: ' . esc_attr($milo_page_bg_color) . ';';
                }

                if ($milo_page_bg_image != null) {
                    echo 'background-image: url(' . esc_url($milo_page_bg_image) . ');';
                }

                if ($milo_page_bg_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_page_bg_repeat) . ';';
                }
                if ($milo_page_bg_position != null) {
                    echo 'background-position: ' . esc_attr($milo_page_bg_position) . ';';
                }
                if ($milo_page_bg_size != null) {
                    echo 'background-size: ' . esc_attr($milo_page_bg_size) . ';';
                }
                if ($milo_page_bg_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_page_bg_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_header_nav_enable = 0;
        if (isset($milo_theme_options['milo-header-nav-bg-switch'])) {
            $milo_header_nav_enable = $milo_theme_options['milo-header-nav-bg-switch'];
        }

        if ($milo_header_nav_enable == 1) {

            $milo_header_nav_color = $milo_header_nav_image = $milo_header_nav_repeat = $milo_header_nav_position = $milo_header_nav_size = $milo_header_nav_attachment = '';

            if (isset($milo_theme_options['milo-header-nav-background']['background-color'])) {
                $milo_header_nav_color = $milo_theme_options['milo-header-nav-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-header-nav-background']['background-image'])) {
                $milo_header_nav_image = $milo_theme_options['milo-header-nav-background']['background-image'];
            }

            if (isset($milo_theme_options['milo-header-nav-background']['background-repeat'])) {
                $milo_header_nav_repeat = $milo_theme_options['milo-header-nav-background']['background-repeat'];
            }

            if (isset($milo_theme_options['milo-header-nav-background']['background-position'])) {
                $milo_header_nav_position = $milo_theme_options['milo-header-nav-background']['background-position'];
            }

            if (isset($milo_theme_options['milo-header-nav-background']['background-size'])) {
                $milo_header_nav_size = $milo_theme_options['milo-header-nav-background']['background-size'];
            }

            if (isset($milo_theme_options['milo-header-nav-background'] ['background-attachment'])) {
                $milo_header_nav_attachment = $milo_theme_options['milo-header-nav-background'] ['background-attachment'];
            }

            if ($milo_header_nav_color != null || $milo_header_nav_image != null) {
                echo ' #header, #header-sticky {';
                if ($milo_header_nav_color != null) {
                    echo 'background-color: ' . esc_attr($milo_header_nav_color) . ';';
                }

                if ($milo_header_nav_image != null) {
                    echo 'background-image: url(' . esc_url($milo_header_nav_image) . ');';
                }

                if ($milo_header_nav_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_header_nav_repeat) . ';';
                }
                if ($milo_header_nav_position != null) {
                    echo 'background-position: ' . esc_attr($milo_header_nav_position) . ';';
                }
                if ($milo_header_nav_size != null) {
                    echo 'background-size: ' . esc_attr($milo_header_nav_size) . ';';
                }
                if ($milo_header_nav_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_header_nav_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_header_mega_enable = 0;
        if (isset($milo_theme_options['milo-header-mega-bg-switch'])) {
            $milo_header_mega_enable = $milo_theme_options['milo-header-mega-bg-switch'];
        }

        if ($milo_header_mega_enable == 1) {
            $milo_header_mega_color = $milo_header_mega_image = $milo_header_mega_repeat = $milo_header_mega_position = $milo_header_mega_size = $milo_header_mega_attachment = '';

            if (isset($milo_theme_options['milo-header-mega-background']['background-color'])) {
                $milo_header_mega_color = $milo_theme_options['milo-header-mega-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-header-mega-background']['background-image'])) {
                $milo_header_mega_image = $milo_theme_options['milo-header-mega-background']['background-image'];
            }

            if (isset($milo_theme_options['milo-header-mega-background']['background-repeat'])) {
                $milo_header_mega_repeat = $milo_theme_options['milo-header-mega-background']['background-repeat'];
            }

            if (isset($milo_theme_options['milo-header-mega-background']['background-position'])) {
                $milo_header_mega_position = $milo_theme_options ['milo-header-mega-background'] ['background-position'];
            }

            if (isset($milo_theme_options['milo-header-mega-background']['background-size'])) {
                $milo_header_mega_size = $milo_theme_options['milo-header-mega-background'] ['background-size'];
            }

            if (isset($milo_theme_options ['milo-header-mega-background']['background-attachment'])) {
                $milo_header_mega_attachment = $milo_theme_options['milo-header-mega-background']['background-attachment'];
            }

            if ($milo_header_mega_color != null || $milo_header_mega_image != null) {
                echo ' .menu li.megamenu .megamenu-container {';
                if ($milo_header_mega_color != null) {
                    echo 'background-color: ' . esc_attr($milo_header_mega_color) . ';';
                }

                if ($milo_header_mega_image != null) {
                    echo 'background-image: url(' . esc_url($milo_header_mega_image) . ');';
                }

                if ($milo_header_mega_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_header_mega_repeat) . ';';
                }
                if ($milo_header_mega_position != null) {
                    echo 'background-position: ' . esc_attr($milo_header_mega_position) . ';';
                }
                if ($milo_header_mega_size != null) {
                    echo 'background-size: ' . esc_attr($milo_header_mega_size) . ';';
                }
                if ($milo_header_mega_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_header_mega_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_header_area_bg_enable = 0;
        if (isset($milo_theme_options['milo-header-area-bg-switch'])) {
            $milo_header_area_bg_enable = $milo_theme_options['milo-header-area-bg-switch'];
        }

        if ($milo_header_area_bg_enable == 1) {
            $milo_header_area_color = $milo_header_area_image = $milo_header_area_repeat = $milo_header_area_position = $milo_header_area_size = $milo_header_area_attachment = '';

            if (isset($milo_theme_options['milo-header-area-background']['background-color'])) {
                $milo_header_area_color = $milo_theme_options['milo-header-area-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-header-area-background']['background-image'])) {
                $milo_header_area_image = $milo_theme_options ['milo-header-area-background']['background-image'];
            }

            if (isset($milo_theme_options ['milo-header-area-background'] ['background-repeat'])) {
                $milo_header_area_repeat = $milo_theme_options ['milo-header-area-background']['background-repeat'];
            }

            if (isset($milo_theme_options['milo-header-area-background']['background-position'])) {
                $milo_header_area_position = $milo_theme_options ['milo-header-area-background'] ['background-position'];
            }

            if (isset($milo_theme_options['milo-header-area-background'] ['background-size'])) {
                $milo_header_area_size = $milo_theme_options ['milo-header-area-background']['background-size'];
            }

            if (isset($milo_theme_options['milo-header-area-background'] ['background-attachment'])) {
                $milo_header_area_attachment = $milo_theme_options['milo-header-area-background'] ['background-attachment'];
            }

            if ($milo_header_area_color != null || $milo_header_area_image != null) {
                echo ' #header-top {';
                if ($milo_header_area_color != null) {
                    echo 'background-color: ' . esc_attr($milo_header_area_color) . ';';
                }

                if ($milo_header_area_image != null) {
                    echo 'background-image: url(' . esc_url($milo_header_area_image) . ');';
                }

                if ($milo_header_area_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_header_area_repeat) . ';';
                }
                if ($milo_header_area_position != null) {
                    echo 'background-position: ' . esc_attr($milo_header_area_position) . ';';
                }
                if ($milo_header_area_size != null) {
                    echo 'background-size: ' . esc_attr($milo_header_area_size) . ';';
                }
                if ($milo_header_area_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_header_area_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_footer_top_bg_enable = 0;
        if (isset($milo_theme_options['milo-footer-top-bg-switch'])) {
            $milo_footer_top_bg_enable = $milo_theme_options['milo-footer-top-bg-switch'];
        }

        if ($milo_footer_top_bg_enable == 1) {
            $milo_footer_top_color = $milo_footer_top_image = $milo_footer_top_repeat = $milo_footer_top_position = $milo_footer_top_size = $milo_footer_top_attachment = '';

            if (isset($milo_theme_options['milo-footer-top-background']['background-color'])) {
                $milo_footer_top_color = $milo_theme_options['milo-footer-top-background'] ['background-color'];
            }

            if (isset($milo_theme_options ['milo-footer-top-background']['background-image'])) {
                $milo_footer_top_image = $milo_theme_options ['milo-footer-top-background']['background-image'];
            }

            if (isset($milo_theme_options ['milo-footer-top-background']['background-repeat'])) {
                $milo_footer_top_repeat = $milo_theme_options['milo-footer-top-background'] ['background-repeat'];
            }

            if (isset($milo_theme_options ['milo-footer-top-background'] ['background-position'])) {
                $milo_footer_top_position = $milo_theme_options['milo-footer-top-background'] ['background-position'];
            }

            if (isset($milo_theme_options['milo-footer-top-background'] ['background-size'])) {
                $milo_footer_top_size = $milo_theme_options ['milo-footer-top-background'] ['background-size'];
            }

            if (isset($milo_theme_options ['milo-footer-top-background']['background-attachment'])) {
                $milo_footer_top_attachment = $milo_theme_options['milo-footer-top-background']['background-attachment'];
            }

            if ($milo_footer_top_color != null || $milo_footer_top_image != null) {
                echo ' #footer-top {';
                if ($milo_footer_top_color != null) {
                    echo 'background-color: ' . esc_attr($milo_footer_top_color) . ';';
                }

                if ($milo_footer_top_image != null) {
                    echo 'background-image: url(' . esc_url($milo_footer_top_image) . ');';
                }

                if ($milo_footer_top_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_footer_top_repeat) . ';';
                }
                if ($milo_footer_top_position != null) {
                    echo 'background-position: ' . esc_attr($milo_footer_top_position) . ';';
                }
                if ($milo_footer_top_size != null) {
                    echo 'background-size: ' . esc_attr($milo_footer_top_size) . ';';
                }
                if ($milo_footer_top_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_footer_top_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_footer_mid_bg_enable = 0;
        if (isset($milo_theme_options['milo-footer-mid-bg-switch'])) {
            $milo_footer_mid_bg_enable = $milo_theme_options['milo-footer-mid-bg-switch'];
        }

        if ($milo_footer_mid_bg_enable == 1) {
            $milo_footer_mid_color = $milo_footer_mid_image = $milo_footer_mid_repeat = $milo_footer_mid_position = $milo_footer_mid_size = $milo_footer_mid_attachment = '';

            if (isset($milo_theme_options['milo-footer-mid-background'] ['background-color'])) {
                $milo_footer_mid_color = $milo_theme_options ['milo-footer-mid-background']['background-color'];
            }

            if (isset($milo_theme_options ['milo-footer-mid-background']['background-image'])) {
                $milo_footer_mid_image = $milo_theme_options['milo-footer-mid-background'] ['background-image'];
            }

            if (isset($milo_theme_options['milo-footer-mid-background'] ['background-repeat'])) {
                $milo_footer_mid_repeat = $milo_theme_options ['milo-footer-mid-background'] ['background-repeat'];
            }

            if (isset($milo_theme_options['milo-footer-mid-background'] ['background-position'])) {
                $milo_footer_mid_position = $milo_theme_options['milo-footer-mid-background'] ['background-position'];
            }

            if (isset($milo_theme_options ['milo-footer-mid-background'] ['background-size'])) {
                $milo_footer_mid_size = $milo_theme_options['milo-footer-mid-background'] ['background-size'];
            }

            if (isset($milo_theme_options['milo-footer-mid-background'] ['background-attachment'])) {
                $milo_footer_mid_attachment = $milo_theme_options['milo-footer-mid-background'] ['background-attachment'];
            }

            if ($milo_footer_mid_color != null || $milo_footer_mid_image != null) {
                echo ' #footer {';
                if ($milo_footer_mid_color != null) {
                    echo 'background-color: ' . esc_attr($milo_footer_mid_color) . ';';
                }

                if ($milo_footer_mid_image != null) {
                    echo 'background-image: url(' . esc_url($milo_footer_mid_image) . ');';
                }

                if ($milo_footer_mid_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_footer_mid_repeat) . ';';
                }
                if ($milo_footer_mid_position != null) {
                    echo 'background-position: ' . esc_attr($milo_footer_mid_position) . ';';
                }
                if ($milo_footer_mid_size != null) {
                    echo 'background-size: ' . esc_attr($milo_footer_mid_size) . ';';
                }
                if ($milo_footer_mid_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_footer_mid_attachment) . ';';
                }

                echo '}';
            }
        }

        $milo_footer_bottom_bg_enable = 0;
        if (isset($milo_theme_options['milo-footer-bottom-bg-switch'])) {
            $milo_footer_bottom_bg_enable = $milo_theme_options['milo-footer-bottom-bg-switch'];
        }

        if ($milo_footer_bottom_bg_enable == 1) {
            $milo_footer_bottom_color = $milo_footer_bottom_image = $milo_footer_bottom_repeat = $milo_footer_bottom_position = $milo_footer_bottom_size = $milo_footer_bottom_attachment = '';

            if (isset($milo_theme_options ['milo-footer-bottom-background']['background-color'])) {
                $milo_footer_bottom_color = $milo_theme_options ['milo-footer-bottom-background']['background-color'];
            }

            if (isset($milo_theme_options['milo-footer-bottom-background']['background-image'])) {
                $milo_footer_bottom_image = $milo_theme_options['milo-footer-bottom-background'] ['background-image'];
            }

            if (isset($milo_theme_options['milo-footer-bottom-background'] ['background-repeat'])) {
                $milo_footer_bottom_repeat = $milo_theme_options['milo-footer-bottom-background'] ['background-repeat'];
            }

            if (isset($milo_theme_options ['milo-footer-bottom-background'] ['background-position'])) {
                $milo_footer_bottom_position = $milo_theme_options ['milo-footer-bottom-background'] ['background-position'];
            }

            if (isset($milo_theme_options ['milo-footer-bottom-background'] ['background-size'])) {
                $milo_footer_bottom_size = $milo_theme_options ['milo-footer-bottom-background'] ['background-size'];
            }

            if (isset($milo_theme_options ['milo-footer-bottom-background']['background-attachment'])) {
                $milo_footer_bottom_attachment = $milo_theme_options['milo-footer-bottom-background'] ['background-attachment'];
            }

            if ($milo_footer_bottom_color != null || $milo_footer_bottom_image != null) {
                echo ' #footer-bottom {';
                if ($milo_footer_bottom_color != null) {
                    echo 'background-color: ' . esc_attr($milo_footer_bottom_color) . ';';
                }

                // Background image.
                if ($milo_footer_bottom_image != null) {
                    echo 'background-image: url(' . esc_url($milo_footer_bottom_image) . ');';
                }

                // Background image options
                if ($milo_footer_bottom_repeat != null) {
                    echo 'background-repeat: ' . esc_attr($milo_footer_bottom_repeat) . ';';
                }
                if ($milo_footer_bottom_position != null) {
                    echo 'background-position: ' . esc_attr($milo_footer_bottom_position) . ';';
                }
                if ($milo_footer_bottom_size != null) {
                    echo 'background-size: ' . esc_attr($milo_footer_bottom_size) . ';';
                }
                if ($milo_footer_bottom_attachment != null) {
                    echo 'background-attachment: ' . esc_attr($milo_footer_bottom_attachment) . ';';
                }

                echo '}';
            }
        }

        /* Theme options custom css related field */
        $milo_custom_css = "";
        if (isset($milo_theme_options['milo-custom-css'])) {
            $milo_custom_css = $milo_theme_options['milo-custom-css'];
        }
        if (trim($milo_custom_css) != '') {
            print $milo_custom_css;
        }

        echo '</style>' . "\n";
    }
}