<?php
/**
 * Redux Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Redux Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Redux Framework. If not, see <http://www.gnu.org/licenses/>.
 *
 * @package     ReduxFramework
 * @author      Dovy Paukstys
 * @version     3.1.5
 */
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) )
    exit;

// Don't duplicate me!
if ( !class_exists( 'ReduxFramework_milo_multi_slider' ) ) {

    /**
     * Main ReduxFramework_milo_multi_slider class
     *
     * @since       1.0.0
     */
    class ReduxFramework_milo_multi_slider extends ReduxFramework {

        /**
         * Field Constructor.
         *
         * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        function __construct ( $field = array(), $value = array(3, 6, 9), $parent ) {


            $this->parent = $parent;
            $this->field = $field;
            $this->value = $value;
            // $this->value_title = $value_title;
            // $this->value_description = $value_description;

            if ( empty( $this->extension_dir ) ) {
                $this->extension_dir =  trailingslashit(get_template_directory()) . 'inc/admin/options-config/extensions/';
                $this->extension_url = site_url( str_replace( trailingslashit( str_replace( '\\', '/', ABSPATH ) ), '', $this->extension_dir ) );
            }

            // Set default args for this field to avoid bad indexes. Change this to anything you use.
            $defaults = array(
                'options' => array(),
                'stylesheet' => '',
                'output' => true,
                'enqueue' => true,
                'enqueue_frontend' => true
            );
            $this->field = wp_parse_args( $this->field, $defaults );
        }

        /**
         * Field Render Function.
         *
         * Takes the vars and outputs the HTML for the field in the settings
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function render () {
            $value = $this->value;
            if($value==''){
               $value[0]=3; 
               $value[1]=6;
               $value[2]=9;
            }
            ?>

            <div class="range <?php echo esc_attr( $this->field['class'] ); ?>" id="<?php echo esc_attr( $this->field['id'] ); ?>" data-min="1" data-max="12" data-step="1">
                <input type="hidden" name="<?php echo esc_attr( $this->field['name'] ) . '[0]'; ?>" value="<?php echo esc_attr( $value[0] ); ?>"/>

                <input type="hidden" name="<?php echo esc_attr( $this->field['name'] ) . '[1]'; ?>" value="<?php echo esc_attr( $value[1] ); ?>"/>

                <input type="hidden" name="<?php echo esc_attr( $this->field['name'] ) . '[2]'; ?>" value="<?php echo esc_attr( $value[2] ); ?>"/>

            </div>
<br>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <span class="milo_slide_range"></span>
            <ol  class="milo_slector_list">
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
                <li></li>
            </ol>
            <div id="log"></div>

            <?php
        }

        /**
         * Enqueue Function.
         *
         * If this field requires any scripts, or css define this function and register/enqueue the scripts/css
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function enqueue () {
            wp_enqueue_script( 'milo-multi-slider-js', get_template_directory_uri() . '/inc/admin/options-config/extensions/milo_multi_slider/milo_multi_slider.js' );
            wp_enqueue_style( 'milo-multi-slider-css', get_template_directory_uri() . '/inc/admin/options-config/extensions/milo_multi_slider/milo_multi_slider.css' );
        }

        /**
         * Output Function.
         *
         * Used to enqueue to the front-end
         *
         * @since       1.0.0
         * @access      public
         * @return      void
         */
        public function output () {

            if ( $this->field['enqueue_frontend'] ) {
                
            }
        }

    }

}