'use strict';

jQuery(document).ready(function () {

    jQuery(function (jQuery) {

         if (jQuery("#widgets-right").length > 0) {
            var target_area = document.getElementById('widgets-right');
            target_area.insertAdjacentHTML('afterend', '<div class="sidebars_form_container">\n\
<h3 class="sidebars_form_title">Create a new Sidebar</h3>\n\
<input id="milo_sidebar_title" name="milo_sidebar_title" type="text" placeholder="name" value=""><br/>\n\
<input id="milo_sidebar_description" name="milo_sidebar_description" placeholder="description" type="text" value=""><br/>\n\
<div class="button-primary" id="milo_create_trigger">Create Sidebar</div></div>');

            var sidebars = document.getElementsByClassName("sidebar-milo-sidebars-custom");
            var i;
            for (i = 0; i < sidebars.length; i++) {

                var sub = sidebars[i].getElementsByClassName('sidebar-name');
                var alt = sidebars[i].getElementsByClassName('widgets-sortables ui-sortable');

                sub[0].innerHTML = '<button class="milo_sidebar_remove button-primary" data-sidebar_id="' + alt[0].id + '">remove</button>' + sub[0].innerHTML;

            }
        }

        jQuery("#milo_create_trigger").click(function () {
            // Stores the relevant data from the fields in variables
            var title = document.getElementById('milo_sidebar_title').value;
            var description = document.getElementById('milo_sidebar_description').value;

            jQuery.ajax({
                type: "post",
                dataType: "json",
                url: milo_ajax.ajaxurl,
                data: {action: "milo_admin_custom_sidebars", title: title, description: description,milo_widget_form_nonce:milo_ajax.milo_widget_form_nonce},
                success: function (response) {
                    if (response == "created") {
                        window.location.reload();
                    } else {
                        alert(response);
                    }
                },
                error: function (response) {
                    alert('Sidebar could not be created');
                    console.log(response);
                }

            });

            return false;
        });

        jQuery(".milo_sidebar_remove").click(function () {
            var sidebar_id = jQuery(this).attr("data-sidebar_id");

            jQuery.ajax({
                type: "post",
                dataType: "json",
                url: milo_ajax.ajaxurl,
                data: {action: "milo_remove_sidebar", sidebar_id: sidebar_id, milo_widget_form_nonce:milo_ajax.milo_widget_form_nonce},
                success: function (response) {
                    if (response.sidebar_id != '') {
                        document.getElementById(sidebar_id).parentNode.style.display = 'none';
                    }
                },
                error: function (response) {
                    alert('Sidebar could not be removed');
                    console.log(response);
                }

            });

            return false;
        });

    });


});

