<?php
/**
 * The Header template for milo theme
 */
if (!defined('ABSPATH')) {
    exit();
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php echo esc_attr(bloginfo('charset')); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0"/> 

        <?php
        global $milo_theme_options;
        ?>

        <meta name="msapplication-TileColor" content="<?php
        if (isset($milo_theme_options['milo-color-android-theme'])) {
            echo esc_attr($milo_theme_options['milo-color-android-theme']);
        }else {
            echo '#fe5e3e';
        }
        ?>">
        <meta name="theme-color" content="<?php
        if (isset($milo_theme_options['milo-ms-color'])) {
            echo esc_attr($milo_theme_options['milo-ms-color']);
        }else {
            echo '#fe5e3e';
        }
        ?>">

        <?php
        wp_head();
        ?>
    </head>

    <?php
    if (defined('MILO_PORTFOLIO')) {
        $portfolio_slug = 'milo-portfolio';
    } else {
        $portfolio_slug = false;
    }

    if (is_page() ||  get_post_type() == $portfolio_slug && !is_search()) {
        $post_id = get_queried_object_id();
    } else {
        $post_id = get_option('page_for_posts');
    }

    $header_text = $image_header = $font_color = $breadcrumbs = $background_color = '';

    if (is_search()) {
        $page_header_toggle = 'Enable';
        $header_text =  esc_html__( 'Search Results for: ', 'dakota-theme' ). get_search_query();
        $image_header[0] = '';
    } else {
        $page_header_toggle = get_post_meta($post_id, 'milo_header_toggle', true);
        if ($page_header_toggle == 'Enable') {
            $header_text = get_post_meta($post_id, 'milo_header_title', true);
            $font_color = get_post_meta($post_id, 'milo_header_font_color', true);
            $background_color = get_post_meta($post_id, 'milo_header_background_color', true);
            $header_image_id = get_post_meta($post_id, 'milo_header_image', true);
            $image_header = wp_get_attachment_image_src($header_image_id, 'full');
            $breadcrumbs = get_post_meta($post_id, 'milo_header_breadcrumbs', true);
        }
    }
    ?>

    <body <?php
    $boxed = get_post_meta(get_queried_object_id(), 'milo_page_boxed', true);
    if ($boxed == 'boxed') {
        body_class('boxed');
        $image_bg[0] = '';
        $image_bg_id = get_post_meta(get_queried_object_id(), 'milo_boxed_bg_image', true);
        $image_bg = wp_get_attachment_image_src($image_bg_id, 'full');
        if (count($image_bg) > 1) {
            echo ' style="background:url(' . esc_url($image_bg[0]) . ') repeat top left;"';
        } else {
            $boxed_color = get_post_meta(get_queried_object_id(), 'milo_boxed_bg_color', true);
            if ($boxed_color != null) {
                echo ' style="background-color:' . esc_attr($boxed_color) . ';"';
            }
        }
    } else {
        body_class();
    }
    ?>>

        <noscript>
        <div class="alert warning">
            <i class="fa fa-times-circle"></i><?php esc_html_e('You seem to have Javascript disabled. This website needs javascript in order to function properly!', 'dakota-theme'); ?>
        </div>
        </noscript>

        <!--[if lte IE 8]>
         <div class="alert error"><?php esc_html_e('You are using an outdated browser. Please upgrade your browser to improve your experience.', 'dakota-theme'); ?></div>
    <![endif]-->
        <div id="page-wrapper">
            <header>

                <?php
                $milo_top_switch = $milo_layout_top = '';
                $milo_layout_top[0] = 3;
                $milo_layout_top[1] = 6;
                $milo_layout_top[2] = 9;
                if (isset($milo_theme_options['milo-top-switch'])) {
                    $milo_top_switch = $milo_theme_options['milo-top-switch'];
                }
                if (isset($milo_theme_options['milo-layout-top'])) {
                    $milo_layout_top = $milo_theme_options['milo-layout-top'];
                }

                if ($milo_top_switch == 1 && $milo_layout_top != ''):
                    ?>
                    <div id="header-top">

                        <div class="container">
                            <div class="row">

                                <?php
                                $top_layouts = array_unique($milo_layout_top);

                                asort($top_layouts);
                                $initial = 0;
                                $count = 1;
                                foreach ($top_layouts as $top_layout) {


                                    $top_layout - $initial;
                                    ?>
                                    <div class="col-sm-<?php echo esc_attr($top_layout - $initial); ?>" id="top-widget-area-<?php echo esc_attr($count); ?>">

                                        <?php
                                        if (function_exists('dynamic_sidebar')) {

                                            if (is_active_sidebar('milo-top-sidebar-' . $count)) {
                                                dynamic_sidebar('milo-top-sidebar-' . $count);
                                            }
                                        }
                                        ?>

                                    </div>
                                    <?php
                                    $initial = $top_layout;
                                    $count++;
                                }
                                if ($initial != 12) {
                                    ?>
                                    <div class="col-sm-<?php echo esc_attr(12 - $initial); ?>" id="top-widget-area-<?php echo esc_attr($count); ?>">

                                        <?php
                                        if (function_exists('dynamic_sidebar')) {

                                            if (is_active_sidebar('milo-top-sidebar-' . $count)) {
                                                dynamic_sidebar('milo-top-sidebar-' . $count);
                                            }
                                        }
                                        ?>

                                    </div>
                                    <?php
                                }
                                ?>

                            </div><!-- row -->
                        </div><!-- container -->

                    </div><!-- header-top -->

                <?php endif; ?>

                <div id="header">

                    <div class="container">
                        <div class="row">
                            <div class="col-sm-3">

                                <!-- LOGO -->
                                <div id="logo">
                                    <a href="<?php echo esc_url(home_url('/')); ?>">
                                        <img src="<?php
                                        if (isset($milo_theme_options['milo-header-logo'])) {
                                            echo esc_url($milo_theme_options['milo-header-logo']['url']);
                                        }
                                        ?>" alt="logo">
                                    </a>
                                </div>

                            </div><!-- col -->
                            <div class="col-sm-9">
                                <!-- MENU --> 
                                <nav>

                                    <a id="mobile-menu-button" href="#"><i class="mt-icons-menu"></i></a>
                                    <?php
                                    // WordPress navigation menu
                                    if (has_nav_menu('milo-header-nav-menu')) {
                                        wp_nav_menu(array(
                                            'theme_location' => 'milo-header-nav-menu',
                                            'container' => false,
                                            'fallback_cb' => false,
                                            'items_wrap' => '<ul id="menu" class="menu clearfix">%3$s</ul>',
                                            'walker' => new milo_Nav_Menu_Walker()
                                                )
                                        );
                                    } else {
                                        global $milo_theme_options;
                                        if ($milo_theme_options['milo-header-search-toggle'] == 1) {
                                            ?>
                                            <ul id="menu" class="menu clearfix">
                                                <li class="search">
                                                    <a id="search-trigger" class="hidden-xs hidden-sm" href="#"><i class="mt-icon-search"></i></a>
                                                    <div id="search-form-container"><form id="search-form" name="search-form" action="<?php echo esc_url(home_url('/')); ?>">
                                                            <input type="search"  name="s" id="search" placeholder="<?php esc_html_e('Enter keywords...', 'dakota-theme'); ?>">
                                                            <input id="search-submit" type="submit" value=""></form>
                                                    </div>
                                                </li>
                                            </ul>
                                            <?php
                                        }
                                    }
                                    ?> 
                                </nav>

                            </div><!-- col -->
                        </div><!-- row -->
                    </div><!-- container -->

                </div><!-- header -->

            </header><!-- HEADER -->


            <!-- CONTENT -->
            <div id="page-content">   
                <?php if ($page_header_toggle == 'Enable') : ?>
                    <div id="page-header" <?php
                    if (trim($image_header[0]) != '') {
                        echo 'style="background:url(' . esc_url($image_header[0]) . ') no-repeat center center;"';
                    } else if ($background_color != '') {
                        echo 'style="background-color:' . esc_attr($background_color) . ';"';
                    }
                    ?>>  
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-12">

                                    <h4 <?php
                                    if (trim($font_color) != '') {
                                        echo ' style="color:' . esc_attr($font_color) . ';"';
                                    }
                                    ?>><?php echo esc_html($header_text); ?></h4>

                                    <?php if ($breadcrumbs == 'breadcrumbs') { ?>
                                        <h4 <?php
                                        if (trim($font_color) != '') {
                                            echo ' style="color:' . esc_attr($font_color) . ';"';
                                        }
                                        ?>>
                                                <?php
                                                if (is_page()) {
                                                    $page_id = get_queried_object_id();
                                                } else {
                                                    $page_id = get_option('page_for_posts');
                                                }
                                                $parents = array_reverse(get_post_ancestors($page_id));
                                                if ($parents) {
                                                    ?>
                                                    <?php
                                                    foreach ($parents as $parent) {
                                                        echo '<a href="' . esc_url(get_permalink($parent)) . '">' . get_the_title($parent) . '</a> / ';
                                                    }
                                                    ?>
                                                    <?php echo get_the_title($post_id); ?>
                                                <?php } ?>
                                        </h4>
                                    <?php } ?>

                                </div><!-- col -->
                            </div><!-- row -->
                        </div><!-- container -->    
                    </div><!-- page-header -->          
                <?php endif; ?>
            
