<?php

if (!defined('ABSPATH')) {
    exit();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       ADMIN SCRIPTS AND STYLES
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function milo_admin_scripts_and_styles() {
    if (is_admin()) {
        wp_enqueue_media();
        global $typenow;
        global $pagenow;
        if (defined('MILO_PORTFOLIO')) {
            $portfolio_slug = 'milo-portfolio';
        } else {
            $portfolio_slug = false;
        }
        if (milo_is_edit_page() && $portfolio_slug == $typenow || milo_is_edit_page() || $pagenow == "nav-menus.php" || $pagenow == 'admin.php' || $pagenow == 'post.php') {

            wp_enqueue_style('wp-color-picker');
            wp_enqueue_script('wp-color-picker');

            wp_enqueue_script('milo-admin-functions', get_template_directory_uri() . '/inc/admin/js/functions.js');
            wp_enqueue_style('milo-css-mt-icons', get_template_directory_uri() . '/layouts/fonts/mt-icons/mt-icons.css');
            wp_enqueue_style('milo_css_bootstrap', get_template_directory_uri() . '/layouts/fonts/glyphicons.min.css');

            wp_enqueue_style('milo-admin-lists', get_template_directory_uri() . '/inc/admin/css/lists.css');
        }

        if ($pagenow == "widgets.php") {
            wp_enqueue_script('ajax-calls-script', get_template_directory_uri() . '/inc/admin/js/ajax.js', array('jquery'), false, true);
            wp_localize_script('ajax-calls-script', 'milo_ajax', array('milo_widget_form_nonce'=> wp_create_nonce('milo_widget_form_ajax'),'ajaxurl' => admin_url('admin-ajax.php')));
        }

        wp_enqueue_style('milo-admin-styles', get_template_directory_uri() . '/inc/admin/css/styles.css');

        wp_enqueue_script('wp-link');
    }
}

add_action('admin_enqueue_scripts', 'milo_admin_scripts_and_styles');

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       FRONT-END SCRIPTS AND STYLES
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function milo_front_enqueue() {

    wp_enqueue_script('milo-js_sensor_gmap', 'http://maps.google.com/maps/api/js?sensor=false&amp;language=en', array('jquery'), false, true);

    if (!defined('DEX_MLP_VERSION')) {
        wp_enqueue_script('milo-js_parallax', get_template_directory_uri() . '/layouts/assets/parallax/jquery.stellar.min.js', array('jquery'), false, true);
    }

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

    wp_enqueue_script('milo-js-scripts', get_template_directory_uri() . '/layouts/js/scripts.js', array('jquery'), false, true);
    wp_enqueue_style('milo-css-scripts', get_template_directory_uri() . '/layouts/css/scripts.css');

    wp_enqueue_script('milo-ajax-calls-script', get_template_directory_uri() . '/layouts/js/ajax_calls.js', array('jquery'), false, true);
    wp_localize_script('milo-ajax-calls-script', 'milo_ajax', array('milo_ajax_call_nonce'=> wp_create_nonce('milo_portfolio_ajax'),'ajaxurl' => admin_url('admin-ajax.php')));

    wp_enqueue_style('milo-css-bootstrap', get_template_directory_uri() . '/layouts/css/bootstrap.min.css');

    wp_enqueue_script('milo-js-bootstrap', get_template_directory_uri() . '/layouts/js/bootstrap.min.js', array('jquery'), false, true);

    wp_enqueue_style('milo-css-mt-icons', get_template_directory_uri() . '/layouts/fonts/mt-icons/mt-icons.css');

    wp_enqueue_script('milo-js-custom', get_template_directory_uri() . '/layouts/js/custom.js', array('jquery'), false, true);

    wp_enqueue_style('milo-css-style', get_template_directory_uri() . '/style.css');

    global $milo_theme_options;
    $milo_sticky = 'off';
    if (isset($milo_theme_options['milo-header-stickyheader-toggle'])) {
        if ($milo_theme_options['milo-header-stickyheader-toggle'] == 1) {
            $milo_sticky = 'on';
        }
    }

    wp_localize_script(
            'milo-js-custom', 'milo_sticky', $milo_sticky
    );
    wp_enqueue_style('milo-fonts', milo_fonts_url(), array(), null);
}

if (!is_admin()) {
    add_action('wp_enqueue_scripts', 'milo_front_enqueue');
}

function milo_custom_header_fonts() {
    wp_enqueue_style('milo-fonts', milo_fonts_url(), array(), null);
}

add_action('admin_print_styles-appearance_page_custom-header', 'milo_custom_header_fonts');

function milo_fonts_url() {
    $fonts_url = '';

    /* Translators: If there are characters in your language that are not
     * supported by Lora, translate this to 'off'. Do not translate
     * into your own language.
     */
    $roboto = esc_html_x('on', 'Roboto font: on or off', 'dakota-theme');

    /* Translators: If there are characters in your language that are not
     * supported by Open Sans, translate this to 'off'. Do not translate
     * into your own language.
     */
    if ('off' !== $roboto) {
        $font_families = array();

        $font_families[] = 'Roboto:400,400italic,300italic,300,500,500italic,700,700italic';


        $query_args = array(
            'family' => urlencode(implode('|', $font_families)),
            'subset' => urlencode('latin,latin-ext'),
        );

        $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
    }

    return esc_url_raw($fonts_url);
}

function milo_is_edit_page($new_edit = null) {
    global $pagenow;
    //make sure we are on the backend
    if (!is_admin()) {
        return false;
    }

    if ($new_edit == "edit") {
        return in_array($pagenow, array('post.php',));
    } else if ($new_edit == "new") {//check for new post page
        return in_array($pagenow, array('post-new.php'));
    } else {//check for either new or edit
        return in_array($pagenow, array('post.php', 'post-new.php'));
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       THEME SETUP AND FUNCTIONS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Set up the content width value based on the theme's design.
if (!isset($content_width)) {
    $content_width = 1170;
}

if (!function_exists('milo_setup')) {

    function milo_setup() {

        // translation file
        // Localization Support
        load_theme_textdomain('dakota-theme', get_template_directory() . '/languages');

        $locale = get_locale();
        $locale_file = get_template_directory() . "/languages/$locale.php";
        if (is_readable($locale_file)) {
            require_once($locale_file);
        }
        // Add RSS feed links to <head> for posts and comments.
        add_theme_support('automatic-feed-links');

        add_theme_support('title-tag');
        // Enable support for Post Thumbnails...
        add_theme_support('post-thumbnails');
        set_post_thumbnail_size(1140, 0);
        // Crops the uploaded images to certain sizes used for different components and elements
        if (function_exists('add_image_size')) {
            add_image_size('milo_blog3col_size', 355, 200, true);
            add_image_size('milo_blog2col_size', 550, 310, true);
            add_image_size('milo_blog1col_size', 745, 365, true);
            add_image_size('milo_aboutme_size', 360, 445, true);
            add_image_size('milo_testimonial_size', 90, 90, true);
            add_image_size('milo_blog_masonry_size', 480, 0, true);
            add_image_size('milo_portfolio_size_4', 480, 380, true);
            add_image_size('milo_portfolio_size_3', 480, 480, true);
        }

        add_theme_support('menus');
        register_nav_menu('milo-header-nav-menu', esc_html__('Milo Header Menu', 'dakota-theme'));

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
        ));

        // Allows to link a custom stylesheet file to the TinyMCE visual editor
        add_editor_style(get_template_directory_uri() . '/inc/admin/css/lists.css');

        // disables frontend editor of visual composer
        if (function_exists('vc_disable_frontend')) {
            vc_disable_frontend();
        }

        // Add support for featured content.
        add_theme_support('featured-content', array(
            'featured_content_filter' => 'milo_get_featured_content',
            'max_posts' => 6,
        ));

        add_theme_support('post-formats', array('video', 'audio'));
    }

}

add_action('after_setup_theme', 'milo_setup');

function milo_custom_wp_title($title, $sep) {
    global $paged, $page;

    if (is_feed()) {
        return $title;
    } // end if
    // Add the site name.
    $title = get_bloginfo('name');
    $sep = '-';
    // Add the site description for the home/front page.
    $site_description = get_bloginfo('description', 'display');
    if ($site_description && ( is_home() || is_front_page() )) {
        $title = "$title $sep $site_description";
    } else if (is_search()) {
        $title = esc_html__('Search', 'dakota-theme') . " $sep $title";
    } else if (is_tag()) {
        $title = esc_html__('Tag', 'dakota-theme') . " $sep $title";
    } else if (is_category()) {
        $title = esc_html__('Category', 'dakota-theme') . " $sep $title";
    } else if (is_tax()) {
        $title = esc_html__('Taxonomy', 'dakota-theme') . " $sep $title";
    } else if (is_archive()) {
        $title = esc_html__('Archive', 'dakota-theme') . " $sep $title";
    } else {
        $title = get_the_title() . " $sep $title";
    }
    // Add a page number if necessary.
    if ($paged >= 2 || $page >= 2) {
        $title = sprintf(esc_html__('Page %s', 'dakota-theme'), max($paged, $page)) . " $sep $title";
    } // end if

    return esc_html($title);
}

add_filter('wp_title', 'milo_custom_wp_title', 10, 2);

/*
 * conditional statement will show the featured content if at least there is one present
 * and while the page is not being paged (it is not in the second page onwards).
 */

function milo_get_featured_content($num = 1) {
    global $featured;
    $featured = apply_filters('milo_featured_content', array());

    if (is_array($featured) || $num >= count($featured))
        return true;

    return false;
}

// A helper conditional function that returns a boolean value.
function milo_has_featured_posts() {
    return !is_paged() && (bool) milo_get_featured_content();
}

// Pagination function
function milo_pagination($pages = '', $range = 3) {
    $showitems = ($range * 2) + 1;
    //$showitems = $range-1;

    global $paged;
    if (empty($paged))
        $paged = 1;

    if ($pages == '') {
        global $wp_query;
        $pages = $wp_query->max_num_pages;
        if (!$pages) {
            $pages = 1;
        }
    }

    if (1 != $pages) {
        echo "<ul class=\"pagination fixed\">";

        if ($paged > 2 && $paged > $range + 1 && $showitems < $pages) {
            echo "<li><a href='" . esc_url(get_pagenum_link(1)) . "' title='" . esc_html__('First page', 'dakota-theme') . "'>&lt;</a></li>";
        }

        for ($i = 1; $i <= $pages; $i++) {
            if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems )) {
                echo ($paged == $i) ? "<li class=\"active\"><a href='" . esc_url(get_pagenum_link($i)) . "'>" . esc_html($i) . "</a></li>" :
                        "<li><a href='" . esc_url(get_pagenum_link($i)) . "'>" . esc_html($i) . "</a></li>";
            }
        }

        if ($paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages) {
            echo "<li><a href='" . esc_url(get_pagenum_link($pages)) . "' title='" . esc_html__('Last page', 'dakota-theme') . "'>&gt;</a></li>";
        }

        echo "</ul>\n";
    }
}

function milo_hex_to_rgba($color, $opacity = false) {

    $default = 'rgb(0,0,0)';

    //Return default if no color provided
    if (empty($color))
        return $default;

    //Sanitize $color if "#" is provided 
    if ($color[0] == '#') {
        $color = substr($color, 1);
    }

    //Check if color has 6 or 3 characters and get values
    if (strlen($color) == 6) {
        $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
    } elseif (strlen($color) == 3) {
        $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
    } else {
        return $default;
    }

    //Convert hexadec to rgb
    $rgb = array_map('hexdec', $hex);

    //Check if opacity is set(rgba or rgb)
    if ($opacity) {
        if (abs($opacity) > 1)
            $opacity = 1.0;
        $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
    } else {
        $output = 'rgb(' . implode(",", $rgb) . ')';
    }

    //Return rgb(a) color string
    return $output;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       THEME CUSTOM LISTS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Add Formats Dropdown Menu To MCE
if (!function_exists('milo_style_select')) {

    function milo_style_select($buttons) {
        array_push($buttons, 'styleselect');
        return $buttons;
    }

}

add_filter('mce_buttons', 'milo_style_select');
// Add new styles to the TinyMCE "formats" menu dropdown
if (!function_exists('milo_styles_dropdown')) {

    function milo_styles_dropdown($settings) {

        // Create array of new styles
        $new_styles = array(
            array(
                'title' => esc_html__('List Styles', 'dakota-theme'),
                'items' => array(
                    array(
                        'title' => esc_html__('Check', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'check-list'
                    ),
                    array(
                        'title' => esc_html__('Check default', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'check-list default'
                    ),
                    array(
                        'title' => esc_html__('Check blue', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'check-list blue'
                    ),
                    array(
                        'title' => esc_html__('Check green', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'check-list green'
                    ),
                    array(
                        'title' => esc_html__('Arrow', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'arrow-list'
                    ),
                    array(
                        'title' => esc_html__('Arrow default', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'arrow-list default'
                    ),
                    array(
                        'title' => esc_html__('Arrow blue', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'arrow-list blue'
                    ),
                    array(
                        'title' => esc_html__('Arrow green', 'dakota-theme'),
                        'selector' => 'ul',
                        'classes' => 'arrow-list green'
                    )
                )
            )
        );

        // Merge old & new styles
        $settings['style_formats_merge'] = true;

        // Add new styles
        $settings['style_formats'] = json_encode($new_styles);

        // Return New Settings
        return $settings;
    }

}
add_filter('tiny_mce_before_init', 'milo_styles_dropdown');


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       THEME FILES INCLUDE
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Visual composer
if (defined('WPB_VC_VERSION')) {
    // Directs VC to the templates
    vc_set_shortcodes_templates_dir(trailingslashit(get_template_directory()) . '/inc/extensions/');

    add_action('vc_before_init', 'milo_vcSetAsTheme');

    function milo_vcSetAsTheme() {
        vc_set_as_theme($disable_updater = true);
    }

    include_once (trailingslashit(get_template_directory()) . 'inc/extensions/params.php');
}

// Widgets and sidebars
include_once (trailingslashit(get_template_directory()) . 'inc/widgets_sidebars.php');

// Metaboxes
include_once (trailingslashit(get_template_directory()) . 'inc/metaboxes.php');

// Tgm activation plugin
include_once trailingslashit(get_template_directory())  . 'inc/plugins/tgm-plugin-activation/class-tgm-plugin-activation.php';

// Ajax   
include_once (trailingslashit(get_template_directory()) . 'inc/ajax_functions.php');


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       THEME OPTIONS FRAMEWORK files and settings
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if (class_exists('ReduxFramework')) {
    // Initiates the configuration file
    include_once (trailingslashit(get_template_directory()) . 'inc/admin/options-config/milo-config.php');
    include_once (trailingslashit(get_template_directory()) . 'inc/admin/options-config/extensions/extension_milo_multi_slider.php');
    include_once (trailingslashit(get_template_directory()) . 'inc/admin/options-config/extensions/milo_multi_slider/field_milo_multi_slider.php');

// Removes the demo
    function milo_removeDemoModeLink() {
        if (class_exists('ReduxFrameworkPlugin')) {
            remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2);
        }
        if (class_exists('ReduxFrameworkPlugin')) {
            remove_action('admin_notices', array(ReduxFrameworkPlugin::get_instance(), 'admin_notices'));
        }
    }

    add_action('init', 'milo_removeDemoModeLink');
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       THEME NAV MENU WALKER
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Global valueS used to determine the first menu item
global $milo_mega_menu;
global $milo_mega_section;
$milo_mega_menu = 0;
$milo_mega_section = 0;

class milo_Nav_Menu_Walker extends Walker_Nav_Menu {

    function display_element($element, &$children_elements, $max_depth, $depth = 0, $args, &$output) {
        $this->child_count = ( isset($children_elements[$element->ID]) ) ? count($children_elements[$element->ID]) : 0;
        $this->ID = $element->ID;
        $this->depth = $depth;
        $this->have_current = true;
        $mega_count = 0;

        if ($this->child_count > 0) {

            foreach ($children_elements[$element->ID] as $child) {
                if (isset($child->classes)) {
                    foreach ($child->classes as $class) {
                        if ($class == 'megamenu') {
                            $mega_count++;
                        }
                    }
                }
            }
        }
        $element->classes[] = 'mega-section-count-' . $mega_count;
        parent::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
    }

    public function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
        $indent = ( $depth ) ? str_repeat("\t", $depth) : '';

        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $check = $check2 = 0;
        foreach ($classes as $class_single) {
            if (trim($class_single) == 'menu-item-has-children') {
                $check = 1;
            }
            if (trim($class_single) == 'megamenu') {
                $check2 = 1;
            }
        }
        $classes[] = 'menu-item-' . $item->ID;
        if ($check == 1 && $check2 == 0) {
            $classes[] = 'dropdown';
        }

        /**
         * Filter the CSS class(es) applied to a menu item's <li>.
         *
         * @since 3.0.0
         *
         * @see wp_nav_menu()
         *
         * @param array  $classes The CSS classes that are applied to the menu item's <li>.
         * @param object $item    The current menu item.
         * @param array  $args    An array of wp_nav_menu() arguments.
         */
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));

        $class_parts = explode(' ', $class_names);

        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

        $mega_count = 0;

        foreach ($class_parts as $class_part) {
            $mega_count_class = explode('mega-section-count-', $class_names);

            if (isset($mega_count_class[1])) {
                $mega_count = (int) $mega_count_class[1];
            }
        }

        /**
         * Filter the ID applied to a menu item's <li>.
         *
         * @since 3.0.1
         *
         * @see wp_nav_menu()
         *
         * @param string $menu_id The ID that is applied to the menu item's <li>.
         * @param object $item    The current menu item.
         * @param array  $args    An array of wp_nav_menu() arguments.
         */
        $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
        $id = $id ? ' id="' . esc_attr($id) . '"' : '';

        $milo_mega_menu_start = $milo_mega_section_start = '';
        global $milo_mega_section;
        global $milo_mega_menu;


        if ($depth == 0) {

            foreach ($classes as $class) {
                if (trim($class) == "megamenu") {
                    $mega_col = '';
                    if ($mega_count != 0) {
                        if ($mega_count >= 4) {
                            $mega_col = ' col-4';
                        } else {
                            $mega_col = ' col-' . $mega_count;
                        }
                    }

                    $milo_mega_menu_start = '<div class="megamenu-container' . $mega_col . '">';
                    $milo_mega_menu = 1;
                }
            }
        }

        if ($depth == 1) {
            foreach ($classes as $class) {
                if (trim($class) == "megamenu" && $milo_mega_menu == 1) {
                    if ($milo_mega_section == 1) {
                        $output .= '</ul></div>';
                    }
                    $milo_mega_section_start = '<div class="section"><ul>';
                    $milo_mega_section = 1;
                }
            }
        }

        if ($milo_mega_section_start != '') {
            $output .= $milo_mega_section_start;
        }
        $output .= $indent . '<li' . $id . $class_names . '>';

        $atts = array();
        $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
        $atts['target'] = !empty($item->target) ? $item->target : '';
        $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
        $atts['href'] = !empty($item->url) ? $item->url : '';

        /**
         * Filter the HTML attributes applied to a menu item's <a>.
         *
         * @since 3.6.0
         *
         * @see wp_nav_menu()
         *
         * @param array $atts {
         *     The HTML attributes applied to the menu item's <a>, empty strings are ignored.
         *
         *     @type string $title  Title attribute.
         *     @type string $target Target attribute.
         *     @type string $rel    The rel attribute.
         *     @type string $href   The href attribute.
         * }
         * @param object $item The current menu item.
         * @param array  $args An array of wp_nav_menu() arguments.
         */
        $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args);

        $attributes = '';
        foreach ($atts as $attr => $value) {
            if (!empty($value)) {
                $value = ( 'href' === $attr ) ? esc_url($value) : esc_attr($value);
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }

        $item_output = $args->before;
        $item_output .= '<a' . $attributes . '>';
        /** This filter is documented in wp-includes/post-template.php */
        $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
        $item_output .= '</a>';
        if ($milo_mega_menu_start != '') {
            $item_output .= $milo_mega_menu_start;
        }
        $item_output .= $args->after;

        /**
         * Filter a menu item's starting output.
         *
         * The menu item's starting output only includes $args->before, the opening <a>,
         * the menu item's title, the closing </a>, and $args->after. Currently, there is
         * no filter for modifying the opening and closing <li> for a menu item.
         *
         * @since 3.0.0
         *
         * @see wp_nav_menu()
         *
         * @param string $item_output The menu item's starting HTML output.
         * @param object $item        Menu item data object.
         * @param int    $depth       Depth of menu item. Used for padding.
         * @param array  $args        An array of wp_nav_menu() arguments.
         */
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }

    function end_lvl(&$output, $depth = 0, $args = array()) {
        $indent = str_repeat("\t", $depth);
        global $milo_mega_section;
        global $milo_mega_menu;
        if ($milo_mega_section == 1) {
            $output .= '</ul></div></div>';
            $milo_mega_section = 0;
            $output .= "$indent\n";
            $milo_mega_menu = 0;
        } else {
            $output .= "$indent</ul>\n";
        }
    }

    function start_lvl(&$output, $depth = 0, $args = array()) {
        $indent = str_repeat("\t", $depth);
        global $milo_mega_menu;
        if ($milo_mega_menu == 1) {
            $output .= "\n$indent\n";
        } else {
            $output .= "\n$indent<ul class=\"sub-menu\">\n";
        }
    }

}

add_filter('wp_nav_menu_items', 'milo_append_to_nav', 10, 2);

function milo_append_to_nav($items, $args) {
    if ($args->theme_location == 'milo-header-nav-menu') {
        global $milo_theme_options;
        if ($milo_theme_options['milo-header-search-toggle'] == 1) {
            $items.='<li class="search"><a id="search-trigger" class="hidden-xs hidden-sm" href="#"><i class="mt-icon-search"></i></a>
                    <div id="search-form-container"><form id="search-form" name="search-form" action="' . esc_url(home_url('/')) . '">
                    <input type="search"  name="s" id="search" placeholder="' . esc_html__('Enter keywords...', 'dakota-theme') . '">
                    <input id="search-submit" type="submit" value=""></form></div></li>';
        }
    }
    return $items;
}
