<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 */
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit();
}
if ( post_password_required() ) {
    return;
}
?>

<div id="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>

        <h6 class="commentlist-title"><?php esc_html_e( 'Comments', 'dakota-theme' ); ?></h6>
        <ul class="commentlist">
            <?php
            // Lists user comments
            wp_list_comments( array(
                'style' => 'ul',
                'short_ping' => false,
                'avatar_size' => 80,
            ) );
            ?>
        </ul>

        <?php
        // Comment navigation
        if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
            ?>
            <nav id="comment-nav-below" class="navigation" role="navigation">
                <h3 class="assistive-text section-heading"><?php esc_html_e( 'Comment navigation', 'dakota-theme' ); ?></h3>
                <div class="nav-previous"><?php previous_comments_link( '&larr;' . esc_html__( ' Older Comments', 'dakota-theme' ) ); ?></div>
                <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments ', 'dakota-theme' ) . '&rarr;' ); ?></div>
            </nav>
        <?php endif; ?>

        <?php if ( !comments_open() ) : ?>
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'dakota-theme' ); ?></p>
            <?php
        endif;
    endif;
    ?>

    <?php
    // Displays the comment form with customized html
    comment_form(
            array(
                'cancel_reply_link' => esc_html__( 'Cancel reply', 'dakota-theme' ),
                'label_submit' => esc_html__( 'Submit', 'dakota-theme' ),
                'title_reply' => '',
                'id_form' => 'commentform',
                'comment_notes_after' => '',
                'comment_notes_before' => '',
                'comment_field' =>
                '<p class="commentform-comment">
                    <textarea id="comment" class="col-xs-12" name="comment" rows="5" cols="25" placeholder="' . esc_html__( 'message', 'dakota-theme' ) . '"></textarea>
		</p>',
                'fields' => array(
                    'author' => 
                    '<p class="commentform-author">
			<input id="name" class="col-xs-12" type="text" name="author" placeholder="'. esc_html__( 'name', 'dakota-theme' ) .'">
                    </p>',
                    'email' => 
                    '<p class="commentform-email"> 
			<input id="email" class="col-xs-12" type="email" name="email" placeholder="' . esc_html__( 'e-mail', 'dakota-theme' ) . '">
                    </p>',
                    'url' =>
                    '<p class="commentform-url">
			<input id="url" class="col-xs-12" type="url" name="subject" placeholder="' . esc_html__( 'URL', 'dakota-theme' ) . '">
                    </p>',
                )
            )
    );
    ?>

</div>