<?php
/**
 * Template Name: 404
 * The template for displaying 404 pages (Not Found)
 */
if (!defined('ABSPATH')) {
    exit();
}

global $milo_theme_options;

$milo_404_selection = "";
if (isset($milo_theme_options['milo-404-selection'])) {
    $milo_404_selection = $milo_theme_options['milo-404-selection'];
}

// Verifies if a certain a custom page was selected to be displayed as the 404 page
if ($milo_404_selection == 'default' || $milo_404_selection == '' || get_permalink($milo_404_selection) == '') {
    // Display the default 404 page content
    get_header();
    ?>  
    <div class="container">
        <div class="row">
            <div class="col-sm-12 text-center">

                <header>
                    <h1><?php esc_html_e('Not Found', 'dakota-theme'); ?></h1>
                </header>

                <p><?php esc_html_e('Nothing was found at this location.', 'dakota-theme'); ?></p>

                <?php get_search_form(); ?>

            </div>
        </div>
    </div>
    <?php
    get_footer();
} else {
    wp_redirect(get_page_link($milo_404_selection));
}
   
    