<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://milothemes.com/
 * @since             1.0.0
 * @package           Portfolio Milo
 *
 * @wordpress-plugin
 * Plugin Name:       Portfolio Milo
 * Plugin URI:        http://milothemes.com/
 * Description:       A very simple plugin that creates the portfolio custom post type.
 * Version:           1.0.0
 * Author:            MiloThemes
 * Author URI:        http://milothemes.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       portfolio-milo
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'MILO_PORTFOLIO', 'milo-portfolio-plugin' );

//define( 'MILO_SLUG', 'milo-portfolio' );
/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-portfolio-milo-activator.php
 */
function activate_portfolio_milo() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-portfolio-milo-activator.php';
	Portfolio_Milo_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-portfolio-milo-deactivator.php
 */
function deactivate_portfolio_milo() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-portfolio-milo-deactivator.php';
	Portfolio_Milo_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_portfolio_milo' );
register_deactivation_hook( __FILE__, 'deactivate_portfolio_milo' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-portfolio-milo.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_portfolio_milo() {

	$plugin = new Portfolio_Milo();
	$plugin->run();

}
run_portfolio_milo();
