<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              http://milothemes.com/
 * @since             1.0.0
 * @package           Milo Shortcodes
 *
 * @wordpress-plugin
 * Plugin Name:       Milo Shortcodes
 * Plugin URI:        http://milothemes.com/
 * Description:       A very simple plugin that adds the Dakota theme shortcodes.
 * Version:           1.0.0
 * Author:            MiloThemes
 * Author URI:        http://milothemes.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       milo-shortcodes
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'MILO_SHORTCODES', 'milo-shortcodes-plugin' );

define( 'MILO_SHOTCODES_PATH', plugins_url( 'assets/', __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-milo-shortcodes-activator.php
 */
function activate_milo_shortcodes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-milo-shortcodes-activator.php';
	milo_shortcodes_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-milo-shortcodes-deactivator.php
 */
function deactivate_milo_shortcodes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-milo-shortcodes-deactivator.php';
	milo_shortcodes_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_milo_shortcodes' );
register_deactivation_hook( __FILE__, 'deactivate_milo_shortcodes' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-milo-shortcodes.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_milo_shortcodes() {

	$plugin = new milo_shortcodes();
	$plugin->run();

}
run_milo_shortcodes();
