<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://www.europadns.com/
 * @since      1.0.0
 *
 * @package    milo_shortcodes
 * @subpackage milo_shortcodes/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    milo_shortcodes
 * @subpackage milo_shortcodes/includes
 * @author     Europadns <nicolae@europadns.com>
 */
class milo_shortcodes {

    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      milo_shortcodes_Loader    $loader    Maintains and registers all hooks for the plugin.
     */
    protected $loader;

    /**
     * The unique identifier of this plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $plugin_name    The string used to uniquely identify this plugin.
     */
    protected $milo_shortcodes;

    /**
     * The current version of the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $version    The current version of the plugin.
     */
    protected $version;

    /**
     * Define the core functionality of the plugin.
     *
     * Set the plugin name and the plugin version that can be used throughout the plugin.
     * Load the dependencies, define the locale, and set the hooks for the admin area and
     * the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function __construct() {

        $this->milo_shortcodes = 'milo-shortcodes';
        $this->version = '1.0.0';

        $this->load_dependencies();
        $this->set_locale();
        $this->milo_shortcodes_initiate_shortcodes();
    }

    /**
     * Load the required dependencies for this plugin.
     *
     * Include the following files that make up the plugin:
     *
     * - milo_shortcodes_Loader. Orchestrates the hooks of the plugin.
     * - milo_shortcodes_i18n. Defines internationalization functionality.
     *
     * Create an instance of the loader which will be used to register the hooks
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function load_dependencies() {

        /**
         * The class responsible for orchestrating the actions and filters of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-milo-shortcodes-loader.php';

        /**
         * The class responsible for defining internationalization functionality
         * of the plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-milo-shortcodes-i18n.php';

        $this->loader = new milo_shortcodes_Loader();
    }

    /**
     * Define the locale for this plugin for internationalization.
     *
     * Uses the milo_shortcodes_i18n class in order to set the domain and to register the hook
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function set_locale() {

        $plugin_i18n = new milo_shortcodes_i18n();
        $plugin_i18n->set_domain($this->get_milo_shortcodes());

        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     *
     * @since    1.0.0
     */
    public function run() {
        $this->loader->run();
    }

    /**
     * The name of the plugin used to uniquely identify it within the context of
     * WordPress and to define internationalization functionality.
     *
     * @since     1.0.0
     * @return    string    The name of the plugin.
     */
    public function get_milo_shortcodes() {
        return $this->milo_shortcodes;
    }

    /**
     * The reference to the class that orchestrates the hooks with the plugin.
     *
     * @since     1.0.0
     * @return    milo_shortcodes_Loader    Orchestrates the hooks of the plugin.
     */
    public function get_loader() {
        return $this->loader;
    }

    /**
     * Retrieve the version number of the plugin.
     *
     * @since     1.0.0
     * @return    string    The version number of the plugin.
     */
    public function get_version() {
        return $this->version;
    }

    public function milo_shortcodes_initiate_shortcodes() {
        if (defined('WPB_VC_VERSION')) {

            // Generates the form inputs related to mt icons
            function milo_icons_param_settings_field($settings, $value) {
                // Gets the list of icons
                $mt_icons_list = array('mt-icon-adobe-reader', 'mt-icon-align-center', 'mt-icon-align-left', 'mt-icon-align-right', 'mt-icon-amazon', 'mt-icon-android',
                    'mt-icon-apple', 'mt-icon-arrow-down', 'mt-icon-arrow-down2', 'mt-icon-arrow-left', 'mt-icon-arrow-left2', 'mt-icon-arrow-right',
                    'mt-icon-arrow-right2', 'mt-icon-arrow-up', 'mt-icon-arrow-up2', 'mt-icon-at', 'mt-icon-at-sign', 'mt-icon-audio', 'mt-icon-badoo',
                    'mt-icon-bag1', 'mt-icon-bag2', 'mt-icon-batterystatus1', 'mt-icon-batterystatus2', 'mt-icon-batterystatus3', 'mt-icon-behance',
                    'mt-icon-bell', 'mt-icon-blogger', 'mt-icon-blueetooth', 'mt-icon-box', 'mt-icon-boxes', 'mt-icon-briefcase1', 'mt-icon-briefcase2',
                    'mt-icon-building', 'mt-icon-button', 'mt-icon-calculating', 'mt-icon-calculator', 'mt-icon-cam', 'mt-icon-camera', 'mt-icon-cameras',
                    'mt-icon-car', 'mt-icon-cd1', 'mt-icon-cd2', 'mt-icon-cd3', 'mt-icon-cellphone1', 'mt-icon-cellphones2', 'mt-icon-certificate',
                    'mt-icon-charge', 'mt-icon-chart', 'mt-icon-check', 'mt-icon-chrome', 'mt-icon-clip', 'mt-icon-clock', 'mt-icon-clocks', 'mt-icon-cloudstorage',
                    'mt-icon-cloud', 'mt-icon-clouds', 'mt-icon-cocktail', 'mt-icon-code', 'mt-icon-coffee', 'mt-icon-compass', 'mt-icon-computermouse1',
                    'mt-icon-computermouse2', 'mt-icon-computerscreen1', 'mt-icon-computerscreen2', 'mt-icon-computers', 'mt-icon-connection1',
                    'mt-icon-connection2', 'mt-icon-connector', 'mt-icon-controller1', 'mt-icon-controller2', 'mt-icon-credit-card', 'mt-icon-css',
                    'mt-icon-database', 'mt-icon-deezer', 'mt-icon-delicious', 'mt-icon-deviantart', 'mt-icon-device', 'mt-icon-diamond', 'mt-icon-digg',
                    'mt-icon-direction', 'mt-icon-diskette', 'mt-icon-document1', 'mt-icon-document2', 'mt-icon-document3', 'mt-icon-documents', 'mt-icon-dribble',
                    'mt-icon-drop', 'mt-icon-dropbox', 'mt-icon-dropper', 'mt-icon-drupal', 'mt-icon-earphone', 'mt-icon-earphones', 'mt-icon-earth',
                    'mt-icon-email1', 'mt-icon-email2', 'mt-icon-expand1', 'mt-icon-expand2', 'mt-icon-eye', 'mt-icon-facebook', 'mt-icon-favorite',
                    'mt-icon-file1', 'mt-icon-file2', 'mt-icon-filmstrip', 'mt-icon-film1', 'mt-icon-film2', 'mt-icon-films', 'mt-icon-firefox', 'mt-icon-flickr',
                    'mt-icon-folder1', 'mt-icon-folder2', 'mt-icon-football', 'mt-icon-gaming', 'mt-icon-garbage', 'mt-icon-gear', 'mt-icon-glasses',
                    'mt-icon-google-plus', 'mt-icon-gps', 'mt-icon-graduation', 'mt-icon-hands', 'mt-icon-hardware', 'mt-icon-headphones', 'mt-icon-headset',
                    'mt-icon-heart1', 'mt-icon-heart2', 'mt-icon-home', 'mt-icon-html', 'mt-icon-illumination1', 'mt-icon-information2', 'mt-icon-instagram',
                    'mt-icon-instrument', 'mt-icon-internet-explorer', 'mt-icon-ipod1', 'mt-icon-ipod2', 'mt-icon-itunes', 'mt-icon-java', 'mt-icon-joomla',
                    'mt-icon-joysticks', 'mt-icon-keyboard1', 'mt-icon-keyboard2', 'mt-icon-lamps', 'mt-icon-laptop1', 'mt-icon-laptop2', 'mt-icon-last-fm',
                    'mt-icon-lcd', 'mt-icon-letter', 'mt-icon-letters', 'mt-icon-levels', 'mt-icon-lightbulb', 'mt-icon-like', 'mt-icon-linegraphic', 'mt-icon-link',
                    'mt-icon-linkedin', 'mt-icon-linux', 'mt-icon-list', 'mt-icon-lock', 'mt-icon-locks', 'mt-icon-longplay', 'mt-icon-magnifyingglass',
                    'mt-icon-mail', 'mt-icon-mail1', 'mt-icon-mail2', 'mt-icon-map', 'mt-icon-map-marker1', 'mt-icon-map-marker2', 'mt-icon-medal',
                    'mt-icon-menu', 'mt-icon-messages', 'mt-icon-microphone', 'mt-icon-microphones1', 'mt-icon-microphones2', 'mt-icon-minussign', 'mt-icon-money',
                    'mt-icon-mouse', 'mt-icon-multimediaoption', 'mt-icon-musicplayer1', 'mt-icon-musicplayer2', 'mt-icon-music1', 'mt-icon-music2',
                    'mt-icon-music3', 'mt-icon-musical1', 'mt-icon-musical2', 'mt-icon-myspace', 'mt-icon-newspapers', 'mt-icon-nintendo', 'mt-icon-notepad',
                    'mt-icon-opera', 'mt-icon-outlook', 'mt-icon-paper', 'mt-icon-paypal', 'mt-icon-pencil1', 'mt-icon-pendrive', 'mt-icon-phone1', 'mt-icon-phone2',
                    'mt-icon-photocamera1', 'mt-icon-photocamera2', 'mt-icon-photography', 'mt-icon-picasa', 'mt-icon-picture', 'mt-icon-pictures',
                    'mt-icon-pinterest', 'mt-icon-playbutton1', 'mt-icon-playbutton2', 'mt-icon-playbutton3', 'mt-icon-playbutton4', 'mt-icon-plug',
                    'mt-icon-plussign', 'mt-icon-ports', 'mt-icon-powerbutton', 'mt-icon-power', 'mt-icon-price', 'mt-icon-print', 'mt-icon-projector',
                    'mt-icon-quote-left', 'mt-icon-quote-right', 'mt-icon-radio1', 'mt-icon-radio2', 'mt-icon-radios1', 'mt-icon-radios2', 'mt-icon-rammemory',
                    'mt-icon-reddit', 'mt-icon-router', 'mt-icon-rss', 'mt-icon-safari', 'mt-icon-satellitedish', 'mt-icon-screen1', 'mt-icon-screen2',
                    'mt-icon-screen3', 'mt-icon-search', 'mt-icon-securitysystem', 'mt-icon-share', 'mt-icon-shields', 'mt-icon-shoppingcart1',
                    'mt-icon-shoppingcart2', 'mt-icon-shoppingcart3', 'mt-icon-sign', 'mt-icon-sim', 'mt-icon-skype', 'mt-icon-smartphone1', 'mt-icon-smartphone2',
                    'mt-icon-smartphone3', 'mt-icon-smartphone4', 'mt-icon-smartphone5', 'mt-icon-smartphone6', 'mt-icon-smartphone7', 'mt-icon-smartphone8',
                    'mt-icon-smartphone9', 'mt-icon-smartphones', 'mt-icon-snow', 'mt-icon-sound1', 'mt-icon-soundcloud', 'mt-icon-speaker1', 'mt-icon-speaker2',
                    'mt-icon-speechbubble1', 'mt-icon-speechbubble2', 'mt-icon-spotify', 'mt-icon-squares', 'mt-icon-stars', 'mt-icon-statistics', 'mt-icon-steam',
                    'mt-icon-suitcase', 'mt-icon-tablet1', 'mt-icon-tablet2', 'mt-icon-tablets1', 'mt-icon-tablets2', 'mt-icon-tablets3', 'mt-icon-technology1',
                    'mt-icon-technology2', 'mt-icon-telephone1', 'mt-icon-telephone2', 'mt-icon-telephone3', 'mt-icon-telephone4', 'mt-icon-television',
                    'mt-icon-televisions', 'mt-icon-thermometer', 'mt-icon-timetable', 'mt-icon-tower', 'mt-icon-trash', 'mt-icon-trophy', 'mt-icon-tumblr',
                    'mt-icon-tvscreen', 'mt-icon-twitter', 'mt-icon-umbrella', 'mt-icon-upload', 'mt-icon-uploading', 'mt-icon-usb1', 'mt-icon-usb2',
                    'mt-icon-utorrent', 'mt-icon-vibrate', 'mt-icon-videocamera1', 'mt-icon-videocamera2', 'mt-icon-videocamera3', 'mt-icon-videoplayer',
                    'mt-icon-vimeo', 'mt-icon-vine', 'mt-icon-vk', 'mt-icon-volumeadjustment', 'mt-icon-wallclock', 'mt-icon-weather', 'mt-icon-weibo',
                    'mt-icon-weixin', 'mt-icon-whatsapp', 'mt-icon-wifi1', 'mt-icon-wifi2', 'mt-icon-wikipedia', 'mt-icon-windows', 'mt-icon-wireless1',
                    'mt-icon-wireless2', 'mt-icon-word', 'mt-icon-wordpress', 'mt-icon-wristwatch', 'mt-icon-writingtool', 'mt-icon-xerox', 'mt-icon-xing',
                    'mt-icon-yahoo', 'mt-icon-youtube', 'mt-icon-youtube-play', 'mt-icon-zoom', 'mt-icon-zoom-in', 'mt-icon-zoom-out');

                $gl_icons_list = array('glyphicon glyphicon-asterisk', 'glyphicon glyphicon-plus', 'glyphicon glyphicon-euro', 'glyphicon glyphicon-eur',
                    'glyphicon glyphicon-minus', 'glyphicon glyphicon-cloud', 'glyphicon glyphicon-envelope', 'glyphicon glyphicon-pencil',
                    'glyphicon glyphicon-glass', 'glyphicon glyphicon-music', 'glyphicon glyphicon-search', 'glyphicon glyphicon-heart',
                    'glyphicon glyphicon-star', 'glyphicon glyphicon-star-empty', 'glyphicon glyphicon-user', 'glyphicon glyphicon-film',
                    'glyphicon glyphicon-th-large', 'glyphicon glyphicon-th', 'glyphicon glyphicon-th-list', 'glyphicon glyphicon-ok',
                    'glyphicon glyphicon-remove', 'glyphicon glyphicon-zoom-in', 'glyphicon glyphicon-zoom-out', 'glyphicon glyphicon-off',
                    'glyphicon glyphicon-signal', 'glyphicon glyphicon-cog', 'glyphicon glyphicon-trash', 'glyphicon glyphicon-home',
                    'glyphicon glyphicon-file', 'glyphicon glyphicon-time', 'glyphicon glyphicon-road', 'glyphicon glyphicon-download-alt',
                    'glyphicon glyphicon-download', 'glyphicon glyphicon-upload', 'glyphicon glyphicon-inbox', 'glyphicon glyphicon-play-circle',
                    'glyphicon glyphicon-repeat', 'glyphicon glyphicon-refresh', 'glyphicon glyphicon-list-alt', 'glyphicon glyphicon-lock',
                    'glyphicon glyphicon-flag', 'glyphicon glyphicon-headphones', 'glyphicon glyphicon-volume-off', 'glyphicon glyphicon-volume-down',
                    'glyphicon glyphicon-volume-up', 'glyphicon glyphicon-qrcode', 'glyphicon glyphicon-barcode', 'glyphicon glyphicon-tag',
                    'glyphicon glyphicon-tags', 'glyphicon glyphicon-book', 'glyphicon glyphicon-bookmark', 'glyphicon glyphicon-print',
                    'glyphicon glyphicon-camera', 'glyphicon glyphicon-font', 'glyphicon glyphicon-bold', 'glyphicon glyphicon-italic',
                    'glyphicon glyphicon-text-height', 'glyphicon glyphicon-text-width', 'glyphicon glyphicon-align-left',
                    'glyphicon glyphicon-align-center', 'glyphicon glyphicon-align-right', 'glyphicon glyphicon-align-justify',
                    'glyphicon glyphicon-list', 'glyphicon glyphicon-indent-left', 'glyphicon glyphicon-indent-right',
                    'glyphicon glyphicon-facetime-video', 'glyphicon glyphicon-picture', 'glyphicon glyphicon-map-marker',
                    'glyphicon glyphicon-adjust', 'glyphicon glyphicon-tint', 'glyphicon glyphicon-edit', 'glyphicon glyphicon-share',
                    'glyphicon glyphicon-check', 'glyphicon glyphicon-move', 'glyphicon glyphicon-step-backward', 'glyphicon glyphicon-fast-backward',
                    'glyphicon glyphicon-backward', 'glyphicon glyphicon-play', 'glyphicon glyphicon-pause', 'glyphicon glyphicon-stop',
                    'glyphicon glyphicon-forward', 'glyphicon glyphicon-fast-forward', 'glyphicon glyphicon-step-forward', 'glyphicon glyphicon-eject',
                    'glyphicon glyphicon-chevron-left', 'glyphicon glyphicon-chevron-right', 'glyphicon glyphicon-plus-sign',
                    'glyphicon glyphicon-minus-sign', 'glyphicon glyphicon-remove-sign', 'glyphicon glyphicon-ok-sign',
                    'glyphicon glyphicon-question-sign', 'glyphicon glyphicon-info-sign', 'glyphicon glyphicon-screenshot',
                    'glyphicon glyphicon-remove-circle', 'glyphicon glyphicon-ok-circle', 'glyphicon glyphicon-ban-circle',
                    'glyphicon glyphicon-arrow-left', 'glyphicon glyphicon-arrow-right', 'glyphicon glyphicon-arrow-up',
                    'glyphicon glyphicon-arrow-down', 'glyphicon glyphicon-share-alt', 'glyphicon glyphicon-resize-full',
                    'glyphicon glyphicon-resize-small', 'glyphicon glyphicon-exclamation-sign', 'glyphicon glyphicon-gift', 'glyphicon glyphicon-leaf',
                    'glyphicon glyphicon-fire', 'glyphicon glyphicon-eye-open', 'glyphicon glyphicon-eye-close', 'glyphicon glyphicon-warning-sign',
                    'glyphicon glyphicon-plane', 'glyphicon glyphicon-calendar', 'glyphicon glyphicon-random', 'glyphicon glyphicon-comment',
                    'glyphicon glyphicon-magnet', 'glyphicon glyphicon-chevron-up', 'glyphicon glyphicon-chevron-down', 'glyphicon glyphicon-retweet',
                    'glyphicon glyphicon-shopping-cart', 'glyphicon glyphicon-folder-close', 'glyphicon glyphicon-folder-open',
                    'glyphicon glyphicon-resize-vertical', 'glyphicon glyphicon-resize-horizontal', 'glyphicon glyphicon-hdd',
                    'glyphicon glyphicon-bullhorn', 'glyphicon glyphicon-bell', 'glyphicon glyphicon-certificate', 'glyphicon glyphicon-thumbs-up',
                    'glyphicon glyphicon-thumbs-down', 'glyphicon glyphicon-hand-right', 'glyphicon glyphicon-hand-left', 'glyphicon glyphicon-hand-up',
                    'glyphicon glyphicon-hand-down', 'glyphicon glyphicon-circle-arrow-right', 'glyphicon glyphicon-circle-arrow-left',
                    'glyphicon glyphicon-circle-arrow-up', 'glyphicon glyphicon-circle-arrow-down', 'glyphicon glyphicon-globe',
                    'glyphicon glyphicon-wrench', 'glyphicon glyphicon-tasks', 'glyphicon glyphicon-filter', 'glyphicon glyphicon-briefcase',
                    'glyphicon glyphicon-fullscreen', 'glyphicon glyphicon-dashboard', 'glyphicon glyphicon-paperclip', 'glyphicon glyphicon-heart-empty',
                    'glyphicon glyphicon-link', 'glyphicon glyphicon-phone', 'glyphicon glyphicon-pushpin', 'glyphicon glyphicon-usd',
                    'glyphicon glyphicon-gbp', 'glyphicon glyphicon-sort', 'glyphicon glyphicon-sort-by-alphabet',
                    'glyphicon glyphicon-sort-by-alphabet-alt', 'glyphicon glyphicon-sort-by-order', 'glyphicon glyphicon-sort-by-order-alt',
                    'glyphicon glyphicon-sort-by-attributes', 'glyphicon glyphicon-sort-by-attributes-alt', 'glyphicon glyphicon-unchecked',
                    'glyphicon glyphicon-expand', 'glyphicon glyphicon-collapse-down', 'glyphicon glyphicon-collapse-up', 'glyphicon glyphicon-log-in',
                    'glyphicon glyphicon-flash', 'glyphicon glyphicon-log-out', 'glyphicon glyphicon-new-window', 'glyphicon glyphicon-record',
                    'glyphicon glyphicon-save', 'glyphicon glyphicon-open', 'glyphicon glyphicon-saved', 'glyphicon glyphicon-import',
                    'glyphicon glyphicon-export', 'glyphicon glyphicon-send', 'glyphicon glyphicon-floppy-disk', 'glyphicon glyphicon-floppy-saved',
                    'glyphicon glyphicon-floppy-remove', 'glyphicon glyphicon-floppy-save', 'glyphicon glyphicon-floppy-open',
                    'glyphicon glyphicon-credit-card', 'glyphicon glyphicon-transfer', 'glyphicon glyphicon-cutlery', 'glyphicon glyphicon-header',
                    'glyphicon glyphicon-compressed', 'glyphicon glyphicon-earphone', 'glyphicon glyphicon-phone-alt', 'glyphicon glyphicon-tower',
                    'glyphicon glyphicon-stats', 'glyphicon glyphicon-sd-video', 'glyphicon glyphicon-hd-video', 'glyphicon glyphicon-subtitles',
                    'glyphicon glyphicon-sound-stereo', 'glyphicon glyphicon-sound-dolby', 'glyphicon glyphicon-sound-5-1',
                    'glyphicon glyphicon-sound-6-1', 'glyphicon glyphicon-sound-7-1', 'glyphicon glyphicon-copyright-mark',
                    'glyphicon glyphicon-registration-mark', 'glyphicon glyphicon-cloud-download', 'glyphicon glyphicon-cloud-upload',
                    'glyphicon glyphicon-tree-conifer', 'glyphicon glyphicon-tree-deciduous', 'glyphicon glyphicon-cd', 'glyphicon glyphicon-save-file',
                    'glyphicon glyphicon-open-file', 'glyphicon glyphicon-level-up', 'glyphicon glyphicon-copy', 'glyphicon glyphicon-paste',
                    'glyphicon glyphicon-alert', 'glyphicon glyphicon-equalizer', 'glyphicon glyphicon-king', 'glyphicon glyphicon-queen',
                    'glyphicon glyphicon-pawn', 'glyphicon glyphicon-bishop', 'glyphicon glyphicon-knight', 'glyphicon glyphicon-baby-formula',
                    'glyphicon glyphicon-tent', 'glyphicon glyphicon-blackboard', 'glyphicon glyphicon-bed', 'glyphicon glyphicon-apple',
                    'glyphicon glyphicon-erase', 'glyphicon glyphicon-hourglass', 'glyphicon glyphicon-lamp', 'glyphicon glyphicon-duplicate',
                    'glyphicon glyphicon-piggy-bank', 'glyphicon glyphicon-scissors', 'glyphicon glyphicon-bitcoin', 'glyphicon glyphicon-btc',
                    'glyphicon glyphicon-xbt', 'glyphicon glyphicon-yen', 'glyphicon glyphicon-jpy', 'glyphicon glyphicon-ruble', 'glyphicon glyphicon-rub',
                    'glyphicon glyphicon-scale', 'glyphicon glyphicon-ice-lolly', 'glyphicon glyphicon-ice-lolly-tasted', 'glyphicon glyphicon-education',
                    'glyphicon glyphicon-option-horizontal', 'glyphicon glyphicon-option-vertical', 'glyphicon glyphicon-menu-hamburger',
                    'glyphicon glyphicon-modal-window', 'glyphicon glyphicon-oil', 'glyphicon glyphicon-grain', 'glyphicon glyphicon-sunglasses',
                    'glyphicon glyphicon-text-size', 'glyphicon glyphicon-text-color', 'glyphicon glyphicon-text-background',
                    'glyphicon glyphicon-object-align-top', 'glyphicon glyphicon-object-align-bottom', 'glyphicon glyphicon-object-align-horizontal',
                    'glyphicon glyphicon-object-align-left', 'glyphicon glyphicon-object-align-vertical', 'glyphicon glyphicon-object-align-right',
                    'glyphicon glyphicon-triangle-right', 'glyphicon glyphicon-triangle-left', 'glyphicon glyphicon-triangle-bottom',
                    'glyphicon glyphicon-triangle-top', 'glyphicon glyphicon-console', 'glyphicon glyphicon-superscript', 'glyphicon glyphicon-subscript',
                    'glyphicon glyphicon-menu-left', 'glyphicon glyphicon-menu-right', 'glyphicon glyphicon-menu-down', 'glyphicon glyphicon-menu-up');

                $output = '<div class="milo_mt_icons_param_block">
            <div class="milo_icon_container"><span class="' . sanitize_html_class($value) . '" id="milo_selected_icon"></span></div>
            <input id="milo_icon_input" name="' . esc_attr($settings ['param_name'])
                        . '" class="icon_input wpb_vc_param_value wpb-textinput '
                        . esc_attr($settings['param_name']) . ' ' . esc_attr($settings['type']) . '_field" type="text" value="'
                        . esc_attr($value) . '" onchange="milo_selected_icon_display()" />
            <button class="vc_btn vc_btn-primary" onclick="milo_icon_clear_selection()" >Clear</button>
            <br><div id="milo_icons_list">MT Icons<br>';

                foreach ($mt_icons_list as $icon_class) {
                    $output.='<span class="' . $icon_class . '" onclick="milo_icon_change(this)"></span>';
                }
                $output.='<br><br>Glyphicons<br>';
                foreach ($gl_icons_list as $icon_class) {
                    $output.='<span class="' . $icon_class . '" onclick="milo_icon_change(this)"></span>';
                }
                $output.='</div></div>';
                return $output;
            }

            vc_add_shortcode_param('milo_icons_param', 'milo_icons_param_settings_field');

            function milo_social_icons_param_settings_field($settings, $value) {
                $icons_list = array('mt-icon-facebook', 'mt-icon-like', 'mt-icon-twitter', 'mt-icon-google-plus', 'mt-icon-youtube', 'mt-icon-youtube-play',
                    'mt-icon-pinterest', 'mt-icon-linkedin', 'mt-icon-instagram', 'mt-icon-myspace', 'mt-icon-dribble', 'mt-icon-behance', 'mt-icon-flickr',
                    'mt-icon-tumblr', 'mt-icon-yahoo', 'mt-icon-badoo', 'mt-icon-blogger', 'mt-icon-delicious', 'mt-icon-deviantart', 'mt-icon-digg',
                    'mt-icon-picasa', 'mt-icon-reddit', 'mt-icon-vk', 'mt-icon-weibo', 'mt-icon-weixin', 'mt-icon-xing', 'mt-icon-rss', 'mt-icon-share',
                    'mt-icon-last-fm', 'mt-icon-deezer', 'mt-icon-soundcloud', 'mt-icon-spotify', 'mt-icon-vimeo', 'mt-icon-vine', 'mt-icon-itunes',
                    'mt-icon-dropbox', 'mt-icon-at-sign', 'mt-icon-android', 'mt-icon-apple', 'mt-icon-windows', 'mt-icon-linux', 'mt-icon-html',
                    'mt-icon-css', 'mt-icon-wordpress', 'mt-icon-drupal', 'mt-icon-joomla', 'mt-icon-java', 'mt-icon-firefox', 'mt-icon-chrome',
                    'mt-icon-safari', 'mt-icon-internet-explorer', 'mt-icon-opera', 'mt-icon-skype', 'mt-icon-whatsapp', 'mt-icon-outlook', 'mt-icon-amazon',
                    'mt-icon-paypal', 'mt-icon-steam', 'mt-icon-utorrent', 'mt-icon-blueetooth', 'mt-icon-adobe-reader', 'mt-icon-word', 'mt-icon-wikipedia');
                $output = '<div class="milo_fa_icons_param_block">
            <i class="' . sanitize_html_class($value) . '" id="milo_selected_icon"></i>
            <input id="milo_icon_input" name="' . esc_attr($settings ['param_name'])
                        . '" class="wpb_vc_param_value wpb-textinput '
                        . sanitize_html_class($settings['param_name']) . ' ' . sanitize_html_class($settings['type']) . '_field" type="text" value="'
                        . esc_attr($value) . '" size="10" />
            <br><div id="milo_icons_list_fa">';
                foreach ($icons_list as $icon_class) {
                    $output.='<i class="' . $icon_class . '" onclick="milo_icon_change(this)"></i>';
                }
                $output.='</div></div>';
                return $output;
            }

            vc_add_shortcode_param('milo_social_icons_param', 'milo_social_icons_param_settings_field');

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT ABOUTME
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_aboutme_func($atts) {
                extract(shortcode_atts(array(
                    'milo_name' => '',
                    'milo_job' => '',
                    'milo_link_a' => '',
                    'milo_link_b' => '',
                    'milo_image' => '',
                    'milo_pinteres' => '',
                    'milo_instagram' => '',
                    'milo_facebook' => '',
                    'milo_twitter' => '',
                    'milo_linkedin' => '',
                    'milo_youtube' => '',
                    'milo_google_plus' => ''
                                ), $atts));

                $milo_name = esc_html($milo_name);
                $milo_job = esc_html($milo_job);

                $facebook = $twitter = $googleplus = $linkedin = $youtube = $pinteres = $instagram = $link_a = $link_b = '';

                if ($milo_image == null) {
                    $image = '';
                } else {
                    $image_data = wp_get_attachment_image_src($milo_image, 'milo_aboutme_size');
                    $image_url = esc_url($image_data[0]);

                    $image = "<img src='{$image_url}' alt='{$milo_name}'>";
                }

                if (trim($milo_google_plus) != '') {
                    $milo_google_plus = esc_url($milo_google_plus);
                    $googleplus = "<a class='google' href='{$milo_google_plus}' target='_blank'>
                                <i class='mt-icon-google-plus'></i>
                            </a>";
                }

                if (trim($milo_instagram) != '') {
                    $milo_instagram = esc_url($milo_instagram);
                    $instagram = "<a class='instagram' href = '{$milo_instagram}' target='_blank'>
                            <i class='mt-icon-instagram'></i>
                        </a>";
                }

                if (trim($milo_pinteres) != '') {
                    $milo_pinteres = esc_url($milo_pinteres);
                    $pinteres = "<a class='pinterest' href = '{$milo_pinteres}' target='_blank'>
                            <i class='mt-icon-pinterest'></i>
                        </a>";
                }

                if (trim($milo_facebook) != '') {
                    $milo_facebook = esc_url($milo_facebook);
                    $facebook = "<a class='facebook' href = '{$milo_facebook}' target='_blank'>
                            <i class='mt-icon-facebook'></i>
                        </a>";
                }

                if (trim($milo_twitter) != '') {
                    $milo_twitter = esc_url($milo_twitter);
                    $twitter = "<a class='twitter' href = '{$milo_twitter}' target='_blank'>
                            <i class='mt-icon-twitter'></i>
                        </a>";
                }
                if (trim($milo_youtube) != '') {
                    $milo_youtube = esc_url($milo_youtube);
                    $youtube = "<a class='youtube' href = '{$milo_youtube}' target='_blank'>
                            <i class='mt-icon-youtube'></i>
                        </a>";
                }
                if (trim($milo_linkedin) != '') {
                    $milo_linkedin = esc_url($milo_linkedin);
                    $linkedin = "<a class='linkedin' href = '{$milo_linkedin}' target='_blank'>
                            <i class='mt-icon-linkedin'></i>
                        </a>";
                }

                $link_details_a = vc_build_link($milo_link_a);
                if (trim($link_details_a['title']) != '') {

                    if ($link_details_a['target'] !== '') {
                        $newtab_a = "target='{$link_details_a['target']}'";
                    } else {
                        $newtab_a = '';
                    }

                    $link_details_a['url'] = esc_url($link_details_a['url']);
                    $link_details_a['title'] = esc_html($link_details_a['title']);

                    $link_a = "<a href='{$link_details_a['url']}' {$newtab_a} title='{$link_details_a['title']}'>{$link_details_a['title']}</a>";
                }

                $link_details_b = vc_build_link($milo_link_b);
                if (trim($link_details_b['title']) != '') {

                    if ($link_details_b['target'] !== '') {
                        $newtab_b = "target='{$link_details_b['target']}'";
                    } else {
                        $newtab_b = '';
                    }

                    $link_details_b['url'] = esc_url($link_details_b['url']);
                    $link_details_b['title'] = esc_html($link_details_b['title']);

                    $link_b = "<a href='{$link_details_b['url']}' {$newtab_b} title='{$link_details_b['title']}'>{$link_details_b['title']}</a>";
                }

                return "<div class='about-me'><div class='about-me-image'>{$image}<div class='social-media'>
	{$facebook}{$instagram}{$twitter}{$googleplus}{$linkedin}{$youtube}{$pinteres}
	<br>{$link_a}{$link_b}</div></div><h6>{$milo_name}</h6><p>{$milo_job}</p></div>";
            }

            add_shortcode('milo_aboutme', 'milo_aboutme_func');
            add_action('init', 'milo_integrate_vc_aboutme');

            function milo_integrate_vc_aboutme() {
                vc_map(
                        array(
                            'name' => esc_html__('About Me', 'dakota-theme'),
                            'base' => 'milo_aboutme',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'attach_image',
                                    'heading' => esc_html__('Image', 'dakota-theme'),
                                    'param_name' => 'milo_image',
                                    'description' => esc_html__('Add the image of the team member', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Name', 'dakota-theme'),
                                    'param_name' => 'milo_name',
                                    'value' => esc_html__('Sample name', 'dakota-theme'),
                                    'description' => esc_html__('Specify the name of the member', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Job', 'dakota-theme'),
                                    'param_name' => 'milo_job',
                                    'value' => esc_html__('Job Title', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Link A', 'dakota-theme'),
                                    'param_name' => 'milo_link_a',
                                    'description' => esc_html__('Specify an optional link', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Link B', 'dakota-theme'),
                                    'param_name' => 'milo_link_b',
                                    'description' => esc_html__('Specify an optional link', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Facebook', 'dakota-theme'),
                                    'param_name' => 'milo_facebook',
                                    'description' => esc_html__('Add an optional link to Facebook profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Instagram', 'dakota-theme'),
                                    'param_name' => 'milo_instagram',
                                    'description' => esc_html__('Add an optional link to Instagram profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Twitter', 'dakota-theme'),
                                    'param_name' => 'milo_twitter',
                                    'description' => esc_html__('Add an optional link to Twitter profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Google Plus', 'dakota-theme'),
                                    'param_name' => 'milo_google_plus',
                                    'description' => esc_html__('Add an optional link to Google Plus profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Linkedin', 'dakota-theme'),
                                    'param_name' => 'milo_linkedin',
                                    'description' => esc_html__('Add an optional link to Linkedin profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Youtube', 'dakota-theme'),
                                    'param_name' => 'milo_youtube',
                                    'description' => esc_html__('Add an optional link to Youtube profile page, leave blank if not available', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Pinteres', 'dakota-theme'),
                                    'param_name' => 'milo_pinteres',
                                    'description' => esc_html__('Add an optional link to Pinteres profile page, leave blank if not available', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT ANIMATIONS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_animations_container_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_type' => 'bounce',
                    'milo_delay' => '0',
                    'milo_iteration' => '',
                    'milo_duration' => ''
                                ), $atts));

                $content = wpb_js_remove_wpautop($content, false);
                $duration = $iteration = '';
                $milo_type = esc_attr($milo_type);
                if ($milo_delay != '' && $milo_delay != '0') {
                    $milo_delay = esc_attr($milo_delay) . 's';
                }
                if ($milo_duration != '') {
                    $milo_duration = esc_attr($milo_duration);
                    $duration = " data-wow-duration='{$milo_duration}s'";
                }
                if ($milo_iteration != '') {
                    $milo_iteration = esc_attr($milo_iteration);
                    $iteration = " data-wow-iteration='{$milo_iteration}'";
                }

                return "<div class='wow {$milo_type}' data-wow-delay='{$milo_delay}' {$iteration}{$duration}>{$content}</div>";
            }

            add_shortcode('milo_animations_container', 'milo_animations_container_func');
            add_action('init', 'milo_integrate_vc_animations_container_component');

// integrates the custom element in the visual composer
            function milo_integrate_vc_animations_container_component() {
                vc_map(array(
                    'name' => esc_html__('Animations Container', 'dakota-theme'),
                    'base' => 'milo_animations_container',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'content_element' => true,
                    'as_parent' => array('except' => 'milo_animations_container'),
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'show_settings_on_create' => true,
                    'params' => array(
                        array(
                            'type' => 'dropdown',
                            'holder' => 'div',
                            'heading' => esc_html__('Animation Type', 'dakota-theme'),
                            'param_name' => 'milo_type',
                            'value' => array(
                                esc_html__('bounce', 'dakota-theme') => 'bounce',
                                esc_html__('flash', 'dakota-theme') => 'flash',
                                esc_html__('pulse', 'dakota-theme') => 'pulse',
                                esc_html__('rubberBand', 'dakota-theme') => 'rubberBand',
                                esc_html__('shake', 'dakota-theme') => 'shake',
                                esc_html__('swing', 'dakota-theme') => 'swing',
                                esc_html__('tada', 'dakota-theme') => 'tada',
                                esc_html__('wobble', 'dakota-theme') => 'wobble',
                                esc_html__('bounceIn', 'dakota-theme') => 'bounceIn',
                                esc_html__('bounceInDown', 'dakota-theme') => 'bounceInDown',
                                esc_html__('bounceInLeft', 'dakota-theme') => 'bounceInLeft',
                                esc_html__('bounceInRight', 'dakota-theme') => 'bounceInRight',
                                esc_html__('bounceInUp', 'dakota-theme') => 'bounceInUp',
                                esc_html__('bounceOut', 'dakota-theme') => 'bounceOut',
                                esc_html__('bounceOutDown', 'dakota-theme') => 'bounceOutDown',
                                esc_html__('bounceOutLeft', 'dakota-theme') => 'bounceOutLeft',
                                esc_html__('bounceOutRight', 'dakota-theme') => 'bounceOutRight',
                                esc_html__('bounceOutUp', 'dakota-theme') => 'bounceOutUp',
                                esc_html__('fadeIn', 'dakota-theme') => 'fadeIn',
                                esc_html__('fadeInDown', 'dakota-theme') => 'fadeInDown',
                                esc_html__('fadeInDownBig', 'dakota-theme') => 'fadeInDownBig',
                                esc_html__('fadeInLeft', 'dakota-theme') => 'fadeInLeft',
                                esc_html__('fadeInLeftBig', 'dakota-theme') => 'fadeInLeftBig',
                                esc_html__('fadeInRight', 'dakota-theme') => 'fadeInRight',
                                esc_html__('fadeInRightBig', 'dakota-theme') => 'fadeInRightBig',
                                esc_html__('fadeInUp', 'dakota-theme') => 'fadeInUp',
                                esc_html__('fadeInUpBig', 'dakota-theme') => 'fadeInUpBig',
                                esc_html__('fadeOut', 'dakota-theme') => 'fadeOut',
                                esc_html__('fadeOutDown', 'dakota-theme') => 'fadeOutDown',
                                esc_html__('fadeOutDownBig', 'dakota-theme') => 'fadeOutDownBig',
                                esc_html__('fadeOutLeft', 'dakota-theme') => 'fadeOutLeft',
                                esc_html__('fadeOutLeftBig', 'dakota-theme') => 'fadeOutLeftBig',
                                esc_html__('fadeOutRight', 'dakota-theme') => 'fadeOutRight',
                                esc_html__('fadeOutRightBig', 'dakota-theme') => 'fadeOutRightBig',
                                esc_html__('fadeOutUp', 'dakota-theme') => 'fadeOutUp',
                                esc_html__('fadeOutUpBig', 'dakota-theme') => 'fadeOutUpBig',
                                esc_html__('flip', 'dakota-theme') => 'flip',
                                esc_html__('flipInX', 'dakota-theme') => 'flipInX',
                                esc_html__('flipInY', 'dakota-theme') => 'flipInY',
                                esc_html__('flipOutX', 'dakota-theme') => 'flipOutX',
                                esc_html__('flipOutY', 'dakota-theme') => 'flipOutY',
                                esc_html__('lightSpeedIn', 'dakota-theme') => 'lightSpeedIn',
                                esc_html__('lightSpeedOut', 'dakota-theme') => 'lightSpeedOut',
                                esc_html__('rotateIn', 'dakota-theme') => 'rotateIn',
                                esc_html__('rotateInDownLeft', 'dakota-theme') => 'rotateInDownLeft',
                                esc_html__('rotateInDownRight', 'dakota-theme') => 'rotateInDownRight',
                                esc_html__('rotateInUpLeft', 'dakota-theme') => 'rotateInUpLeft',
                                esc_html__('rotateInUpRight', 'dakota-theme') => 'rotateInUpRight',
                                esc_html__('rotateOut', 'dakota-theme') => 'rotateOut',
                                esc_html__('rotateOutDownLeft', 'dakota-theme') => 'rotateOutDownLeft',
                                esc_html__('rotateOutDownRight', 'dakota-theme') => 'rotateOutDownRight',
                                esc_html__('rotateOutUpLeft', 'dakota-theme') => 'rotateOutUpLeft',
                                esc_html__('rotateOutUpRight', 'dakota-theme') => 'rotateOutUpRight',
                                esc_html__('hinge', 'dakota-theme') => 'hinge',
                                esc_html__('rollIn', 'dakota-theme') => 'rollIn',
                                esc_html__('rollOut', 'dakota-theme') => 'rollOut',
                                esc_html__('zoomIn', 'dakota-theme') => 'zoomIn',
                                esc_html__('zoomInDown', 'dakota-theme') => 'zoomInDown',
                                esc_html__('zoomInLeft', 'dakota-theme') => 'zoomInLeft',
                                esc_html__('zoomInRight', 'dakota-theme') => 'zoomInRight',
                                esc_html__('zoomInUp', 'dakota-theme') => 'zoomInUp',
                                esc_html__('zoomOut', 'dakota-theme') => 'zoomOut',
                                esc_html__('zoomOutDown', 'dakota-theme') => 'zoomOutDown',
                                esc_html__('zoomOutLeft', 'dakota-theme') => 'zoomOutLeft',
                                esc_html__('zoomOutRight', 'dakota-theme') => 'zoomOutRight',
                                esc_html__('zoomOutUp', 'dakota-theme') => 'zoomOutUp'
                            ),
                            'description' => esc_html__('Specify', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Animation Delay', 'dakota-theme'),
                            'param_name' => 'milo_delay',
                            'value' => '0',
                            'description' => esc_html__('Specify the delay amount', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Iteration', 'dakota-theme'),
                            'param_name' => 'milo_iteration',
                            'description' => esc_html__('Specify the iteration in numbers or infinite, example: 3; example: infinite', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Duration', 'dakota-theme'),
                            'param_name' => 'milo_duration',
                            'value' => 'default',
                            'description' => esc_html__('Specify the duration in numbers, example: 3', 'dakota-theme')
                        )
                    ),
                    'js_view' => 'VcColumnView'));
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT COUNTERS 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_comparison_func($atts) {
                extract(shortcode_atts(array(
                    'milo_value' => '50',
                    'milo_dvalue' => '+50',
                    'milo_color' => 'default',
                    'milo_side' => 'left',
                    'milo_lvalue' => '',
                    'milo_ltitle' => '',
                    'milo_licon' => '',
                    'milo_rvalue' => '',
                    'milo_rtitle' => '',
                    'milo_ricon' => '',
                                ), $atts));

                $milo_dvalue = esc_html($milo_dvalue);
                $milo_value = absint($milo_value);

                $milo_lvalue = esc_html($milo_lvalue);
                $milo_ltitle = esc_html($milo_ltitle);
                if ($milo_rvalue != '') {
                    $milo_rvalue = esc_html($milo_rvalue);
                } else {
                    $milo_rvalue = $milo_lvalue;
                }
                if ($milo_rtitle != '') {
                    $milo_rtitle = esc_html($milo_rtitle);
                } else {
                    $milo_rtitle = $milo_ltitle;
                }

                if (trim($milo_licon) != '') {
                    $milo_licon = esc_attr($milo_licon);
                    $licon = "<i class='{$milo_licon}'></i>";
                } else {
                    $licon = '';
                }
                if ($milo_ricon != '') {
                    $milo_ricon = esc_attr($milo_ricon);
                    $ricon = "<i class='{$milo_ricon}'></i>";
                } else {
                    $ricon = $licon;
                }

                return "<div class='comparison-bars {$milo_color}'><div class='progress-bar-title-before'>
	{$licon}<h3>{$milo_lvalue}<br><small>{$milo_ltitle}</small></h3>
	</div><div class='progress'><div class='progress-bar' data-width='{$milo_value}' data-direction='{$milo_side}'>
	<span>{$milo_dvalue}%</span></div></div>
	<div class='progress-bar-title-after'>{$ricon}<h3>{$milo_rvalue}<br><small>{$milo_rtitle}</small></h3></div></div>";
            }

            add_shortcode('milo_comparison', 'milo_comparison_func');

            add_action('init', 'milo_integrate_vc_comparison');

// integrates the custom element in the visual composer
            function milo_integrate_vc_comparison() {
                vc_map(
                        array(
                            'name' => esc_html__('Comparison bars', 'dakota-theme'),
                            'base' => 'milo_comparison',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Percentage', 'dakota-theme'),
                                    'value' => '50',
                                    'param_name' => 'milo_value',
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Percentage display value', 'dakota-theme'),
                                    'holder' => 'div',
                                    'value' => '+50',
                                    'param_name' => 'milo_dvalue',
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Direction', 'dakota-theme'),
                                    'param_name' => 'milo_side',
                                    'value' => array(
                                        esc_html__('left', 'dakota-theme') => 'left',
                                        esc_html__('right', 'dakota-theme') => 'right'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Color', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'default',
                                        esc_html__('blue', 'dakota-theme') => 'blue',
                                        esc_html__('green', 'dakota-theme') => 'green',
                                    )
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Left side title', 'dakota-theme'),
                                    'param_name' => 'milo_ltitle'
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Left side number', 'dakota-theme'),
                                    'param_name' => 'milo_lvalue',
                                ),
                                array(
                                    'type' => 'milo_icons_param',
                                    'heading' => esc_html__('Select left side icon', 'dakota-theme'),
                                    'param_name' => 'milo_licon'
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Right side title', 'dakota-theme'),
                                    'param_name' => 'milo_rtitle'
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Right side number', 'dakota-theme'),
                                    'param_name' => 'milo_rvalue',
                                ),
                                array(
                                    'type' => 'milo_icons_param',
                                    'heading' => esc_html__('Select right side icon', 'dakota-theme'),
                                    'param_name' => 'milo_ricon'
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT COUNTERS 
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_counters_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_value' => '1',
                    'milo_color' => 'default',
                    'milo_icon' => ''
                                ), $atts));

                $content = esc_html($content);

                $milo_value = absint($milo_value);

                if (trim($milo_icon) != '') {
                    $milo_icon = esc_attr($milo_icon);
                    $icon = "<i class='{$milo_icon}'></i>";
                } else {
                    $icon = '';
                }

                return "<div class='counter {$milo_color}'>{$icon}<div class='counter-value' data-value='{$milo_value}'></div><div class='counter-details'>{$content}</div></div>";
            }

            add_shortcode('milo_counters', 'milo_counters_func');

            add_action('init', 'milo_integrate_vc_counters');

// integrates the custom element in the visual composer
            function milo_integrate_vc_counters() {
                vc_map(
                        array(
                            'name' => esc_html__('Counter', 'dakota-theme'),
                            'base' => 'milo_counters',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Number', 'dakota-theme'),
                                    'param_name' => 'milo_value',
                                    'value' => '1',
                                    'description' => esc_html__('The final value will animate to, from 0 to the number provided by you', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Milestone Details', 'dakota-theme'),
                                    'param_name' => 'content'
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Icon color', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'default',
                                        esc_html__('blue', 'dakota-theme') => 'blue',
                                        esc_html__('green', 'dakota-theme') => 'green',
                                    )
                                ),
                                array(
                                    'type' => 'milo_icons_param',
                                    'heading' => esc_html__('Select icon', 'dakota-theme'),
                                    'param_name' => 'milo_icon',
                                    'description' => esc_html__('Select an icon', 'dakota-theme')
                                ),
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT DIVIDER
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_dividers_func($atts) {
                extract(shortcode_atts(array(
                    'milo_type' => ''
                                ), $atts));

                return "<div class='hr{$milo_type}'></div>";
            }

            add_shortcode('milo_dividers', 'milo_dividers_func');

            add_action('init', 'milo_integrate_vc_dividers');

// integrates the custom element in the visual composer
            function milo_integrate_vc_dividers() {
                vc_map(
                        array(
                            'name' => esc_html__('Dividers', 'dakota-theme'),
                            'base' => 'milo_dividers',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'dropdown',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Divider Type', 'dakota-theme'),
                                    'param_name' => 'milo_type',
                                    'value' => array(
                                        esc_html__('Grey', 'dakota-theme') => '',
                                        esc_html__('Default', 'dakota-theme') => ' default',
                                        esc_html__('Blue', 'dakota-theme') => ' blue',
                                        esc_html__('Green', 'dakota-theme') => ' green'
                                    ),
                                    'description' => esc_html__('Select a divider type', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT GOOGLE MAP
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_gmaps_func($atts) {
                extract(shortcode_atts(array(
                    'milo_gmaps_zoom' => '15',
                    'milo_gmaps_address' => '',
                    'milo_gmaps_details' => ''
                                ), $atts));

                // Numeric validation
                $milo_gmaps_zoom = absint($milo_gmaps_zoom);

                $milo_gmaps_address = esc_attr($milo_gmaps_address);
                $milo_gmaps_details = esc_attr($milo_gmaps_details);

                return "<div class='map'
                    	data-zoom='{$milo_gmaps_zoom}' 
                    	data-address='{$milo_gmaps_address}' 
                    	data-address-details='{$milo_gmaps_details}'>
                    </div>";
            }

            add_shortcode('milo_gmaps', 'milo_gmaps_func');

            add_action('init', 'milo_integrate_vc_gmaps');

// integrates the custom element in the visual composer
            function milo_integrate_vc_gmaps() {
                vc_map(
                        array(
                            'name' => esc_html__('Google Map', 'dakota-theme'),
                            'base' => 'milo_gmaps',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Address', 'dakota-theme'),
                                    'param_name' => 'milo_gmaps_address',
                                    'description' => esc_html__('The address where the map is centered', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Pinpoint details', 'dakota-theme'),
                                    'param_name' => 'milo_gmaps_details',
                                    'description' => esc_html__('Specify text that will appear when you click on the pin', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Zoom', 'dakota-theme'),
                                    'param_name' => 'milo_gmaps_zoom',
                                    'value' => '15',
                                    'description' => esc_html__('Specify a zoom value between 5 and 20', 'dakota-theme')
                                ),
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT HEADLINE
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_headlines_func($atts) {
                extract(shortcode_atts(array(
                    'milo_title' => 'Sample title',
                    'milo_subtitle' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem',
                    'milo_align' => '',
                    'milo_spacing' => ''
                                ), $atts));

                $spacing = $subtitle = '';

                if ($milo_subtitle != '') {
                    $subtitle_parts = explode('<br />', $milo_subtitle);
                    foreach ($subtitle_parts as $subtitle_part) {
                        $subtitle.= esc_html($subtitle_part) . '<br class="hidden-xs">';
                    }
                }

                $title = esc_html($milo_title);

                if ($milo_spacing != '') {
                    $milo_spacing = absint($milo_spacing);
                    $spacing = " style='margin-bottom:{$milo_spacing}px !important;'";
                }

                return "<div class='headline{$milo_align}'{$spacing}>
                            <h3>{$title}</h3>
                            <p>{$subtitle}</p></div>";
            }

            add_shortcode('milo_headlines', 'milo_headlines_func');
            add_action('init', 'milo_integrate_vc_headlines');

// integrates the custom element in the visual composer
            function milo_integrate_vc_headlines() {
                vc_map(
                        array(
                            'name' => esc_html__('HeadLine', 'dakota-theme'),
                            'base' => 'milo_headlines',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Title', 'dakota-theme'),
                                    'param_name' => 'milo_title',
                                    'value' => esc_html__('Sample title', 'dakota-theme'),
                                    'description' => esc_html__('Specify a title for the headline', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textarea',
                                    'heading' => esc_html__('Subtitle', 'dakota-theme'),
                                    'param_name' => 'milo_subtitle',
                                    'value' => esc_html__('Sed ut perspiciatis unde omnis iste natus error sit voluptatem', 'dakota-theme'),
                                    'description' => esc_html__('Specify the subtitle of the headline', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Horizontal align', 'dakota-theme'),
                                    'param_name' => 'milo_align',
                                    'value' => array(
                                        esc_html__('Center', 'dakota-theme') => '',
                                        esc_html__('Left', 'dakota-theme') => ' headline-left'
                                    ),
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Bottom Spacing', 'dakota-theme'),
                                    'param_name' => 'milo_spacing',
                                    'value' => esc_html__('default', 'dakota-theme'),
                                    'description' => esc_html__('Select the spacing amount beneath the headline in numbers, example:50', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT IMAGE BOX
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_image_box_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_image' => '',
                    'milo_link' => '',
                    'milo_size' => '',
                    'milo_color' => 'btn-default',
                    'milo_align' => ''
                                ), $atts));

                $image = $link = '';

                $content = wpb_js_remove_wpautop($content, true);
                $content = wp_kses_post($content);

                if ($milo_image == null) {
                    $image = '';
                } else {
                    $image_data = wp_get_attachment_image_src($milo_image, 'full');
                    $image_url = esc_url($image_data[0]);

                    $image = "<div class='image-box-thumbnail'><img class='box-img' src='{$image_url}' alt=''></div>";
                }
                $link_details = vc_build_link($milo_link);

                $center_before = $center_after = $newtab = $size = $class = '';

                if ($milo_size == 'small') {
                    $size = ' btn-xs';
                } else if ($milo_size == 'large') {
                    $size = ' btn-lg';
                }

                if ($milo_align != '') {
                    $center_before = "<div class='text-{$milo_align}'>";
                    $center_after = "</div>";
                }

                $link_details['target'] = esc_attr($link_details['target']);
                $link_details['url'] = esc_url($link_details['url']);
                $link_details['title'] = esc_html($link_details['title']);

                if ($link_details['target'] != '') {
                    $newtab = "target='{$link_details['target']}'";
                }
                if ($milo_color != 'none') {
                    $class = "class='btn{$size} {$milo_color}' ";
                }

                if ($link_details['url'] != '' || $link_details['title'] != '') {
                    $link = "{$center_before}<a {$class}href='{$link_details['url']}' {$newtab}>{$link_details['title']}</a>{$center_after}";
                }

                return "<div class='image-box'>{$image}{$content}{$link}</div>";
            }

            add_shortcode('milo_image_box', 'milo_image_box_func');
            add_action('init', 'milo_integrate_vc_image_box');

            function milo_integrate_vc_image_box() {
                vc_map(
                        array(
                            'name' => esc_html__('Image Box', 'dakota-theme'),
                            'base' => 'milo_image_box',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'attach_image',
                                    'heading' => esc_html__('Image', 'dakota-theme'),
                                    'param_name' => 'milo_image',
                                    'description' => esc_html__('Warning! For Image Box component, please do not use images larger than necessary', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textarea_html',
                                    'heading' => esc_html__('Content', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'description' => esc_html__('Add description text for the image box', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Button title and url', 'dakota-theme'),
                                    'param_name' => 'milo_link',
                                    'description' => esc_html__('Specify the link pointing to another page', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Size', 'dakota-theme'),
                                    'param_name' => 'milo_size',
                                    'value' => array(
                                        esc_html__('Normal', 'dakota-theme') => 'normal',
                                        esc_html__('Large', 'dakota-theme') => 'large',
                                        esc_html__('Small', 'dakota-theme') => 'small'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Align', 'dakota-theme'),
                                    'param_name' => 'milo_align',
                                    'value' => array(
                                        esc_html__('Left', 'dakota-theme') => '',
                                        esc_html__('Center', 'dakota-theme') => 'center',
                                        esc_html__('Right', 'dakota-theme') => 'right'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Color set', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'btn-default',
                                        esc_html__('blue', 'dakota-theme') => 'btn-blue',
                                        esc_html__('green', 'dakota-theme') => 'btn-green',
                                        esc_html__('black', 'dakota-theme') => 'btn-black',
                                        esc_html__('white', 'dakota-theme') => 'btn-white',
                                        esc_html__('none', 'dakota-theme') => 'none'
                                    )
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT MAILCHIMP
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_mailchimp_func($atts) {
                extract(shortcode_atts(array(
                    'milo_class' => '',
                                ), $atts));

                if (defined('MC4WP_VERSION') || defined('MC4WP_LITE_VERSION')) {
                    $milo_class = esc_attr($milo_class);
                    return "<div class='{$milo_class}'>" . do_shortcode('[mc4wp_form]') . "</div>";
                } else {
                    return esc_html__('MailChimp for WordPress plugin must be installed and activated!', 'dakota-theme');
                }
            }

            add_shortcode('milo_mailchimp', 'milo_mailchimp_func');

            add_action('init', 'milo_integrate_vc_mailchimp');

// integrates the custom element in the visual composer
            function milo_integrate_vc_mailchimp() {
                vc_map(
                        array(
                            'name' => esc_html__('MailChimp form', 'dakota-theme'),
                            'base' => 'milo_mailchimp',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Optional Class', 'dakota-theme'),
                                    'param_name' => 'milo_class',
                                    'holder' => 'div',
                                    'description' => esc_html__('MailChimp for WordPress plugin is required', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT MESSAGE
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_message_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_type' => 'info',
                                ), $atts));

                $content = esc_html($content);

                return "<div class='alert alert-{$milo_type}'>{$content}</div>";
            }

            add_shortcode('milo_message', 'milo_message_func');

            add_action('init', 'milo_integrate_vc_message');

// integrates the custom element in the visual composer
            function milo_integrate_vc_message() {
                vc_map(
                        array(
                            'name' => esc_html__('Message box', 'dakota-theme'),
                            'base' => 'milo_message',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Message Type', 'dakota-theme'),
                                    'param_name' => 'milo_type',
                                    'value' => array(
                                        esc_html__('Info', 'dakota-theme') => 'info',
                                        esc_html__('Success', 'dakota-theme') => 'success',
                                        esc_html__('Warning', 'dakota-theme') => 'warning',
                                        esc_html__('Error', 'dakota-theme') => 'danger',
                                    ),
                                    'description' => esc_html__('Specify', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Message', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'holder' => 'div',
                                    'description' => esc_html__('Specify the content of the message', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT PIE CHART
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_pie_chart_func($atts) {
                extract(shortcode_atts(array(
                    'milo_title' => '',
                    'milo_data_barcolor' => '#fe5e3e',
                    'milo_data_trackcolor' => '',
                    'milo_percent' => '50',
                    'milo_linewidth' => '4',
                    'milo_barsize' => '170',
                    'milo_icon' => '',
                    'milo_color' => 'default'
                                ), $atts));

                $milo_data_barcolor = esc_attr($milo_data_barcolor);
                $milo_data_trackcolor = esc_attr($milo_data_trackcolor);
                $icon = '';

                if (trim($milo_icon) != '') {
                    $milo_icon = esc_attr($milo_icon);
                    $icon = "<i class='{$milo_icon}'></i>";
                }

                $milo_percent = absint($milo_percent);
                $milo_linewidth = absint($milo_linewidth);
                $milo_barsize = absint($milo_barsize);
                $milo_title = esc_html($milo_title);

                if (trim($milo_data_barcolor) == '') {
                    $milo_data_barcolor = 'transparent';
                }
                if (trim($milo_data_trackcolor) == '') {
                    $milo_data_trackcolor = 'transparent';
                }

                return "<div class='pie-chart-container'><div class='pie-chart {$milo_color}' data-percent='{$milo_percent}' data-bar-color='{$milo_data_barcolor}' 
            data-track-color='{$milo_data_trackcolor}' data-line-width='{$milo_linewidth}' data-size='{$milo_barsize}'>
                        {$icon}<div class='pie-chart-details'><h1><span class='value'></span>%</h1>
				<h6>{$milo_title}</h6></div></div></div>";
            }

            add_shortcode('milo_pie_chart', 'milo_pie_chart_func');
            add_action('init', 'milo_integrate_vc_pie_chart');

// integrates the custom element in the visual composer
            function milo_integrate_vc_pie_chart() {
                vc_map(
                        array(
                            'name' => esc_html__('Pie Chart', 'dakota-theme'),
                            'base' => 'milo_pie_chart',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Chart title', 'dakota-theme'),
                                    'param_name' => 'milo_title'
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Chart percent', 'dakota-theme'),
                                    'param_name' => 'milo_percent',
                                    'value' => '50',
                                    'description' => esc_html__('Specify a value from 0 to 100', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Pie Chart Bar Thickness', 'dakota-theme'),
                                    'param_name' => 'milo_linewidth',
                                    'value' => '4',
                                    'description' => esc_html__('Numeric value between 5 and 15', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Bar Width', 'dakota-theme'),
                                    'param_name' => 'milo_barsize',
                                    'value' => '170',
                                    'description' => esc_html__('Specify bar width', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'colorpicker',
                                    'heading' => esc_html__('Bar Color', 'dakota-theme'),
                                    'param_name' => 'milo_data_barcolor',
                                    'value' => '#fe5e3e',
                                    'description' => esc_html__('Select Bar-Color', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'colorpicker',
                                    'heading' => esc_html__('Track Color', 'dakota-theme'),
                                    'param_name' => 'milo_data_trackcolor',
                                    'description' => esc_html__('Select Track-Color', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Icon color', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'default',
                                        esc_html__('blue', 'dakota-theme') => 'blue',
                                        esc_html__('green', 'dakota-theme') => 'green',
                                    )
                                ),
                                array(
                                    'type' => 'milo_icons_param',
                                    'heading' => esc_html__('Select icon', 'dakota-theme'),
                                    'param_name' => 'milo_icon',
                                    'description' => esc_html__('Select an icon', 'dakota-theme')
                                ),
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT PORTFOLIO GALLERY
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_porfolio_gallery_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_max_number' => '12',
                    'milo_navigation' => '1',
                    'milo_loadmore_text' => esc_html__('Load more projects', 'dakota-theme'),
                    'milo_load_number' => '3',
                    'milo_all_text' => esc_html__('All', 'dakota-theme'),
                    'milo_gutter' => '',
                    'milo_columns' => '3',
                    'milo_style' => '1',
                    'milo_visit' => esc_html__('View', 'dakota-theme'),
                    'milo_selection' => 'all',
                    'milo_align' => ' text-center',
                    'milo_filter_disable' => ''
                                ), $atts));

                $type = 'milo-portfolio';

                if ($milo_style == '3' || $milo_style == '4') {
                    $img_size = 'milo_blog_masonry_size';
                } else if ($milo_style == '5') {
                    $milo_columns = '1';
                    $img_size = 'milo_blog1col_size';
                } else if ($milo_columns == '4' || $milo_columns == '5') {
                    $img_size = 'milo_portfolio_size_4';
                } else {
                    $img_size = 'milo_portfolio_size_3';
                }

                $milo_max_number = absint($milo_max_number);
                $milo_load_number = absint($milo_load_number);

                if ($milo_selection != 'all') {
                    $args = array(
                        'post_type' => $type,
                        'post_status' => 'publish',
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'portfolio_categories',
                                'field' => 'id',
                                'terms' => array($milo_selection)
                            )
                        ),
                        'posts_per_page' => $milo_max_number,
                        'ignore_sticky_posts' => 1);
                } else {
                    $args = array(
                        'post_type' => $type,
                        'post_status' => 'publish',
                        'posts_per_page' => $milo_max_number,
                        'ignore_sticky_posts' => 1);
                }

                $loop = new WP_Query($args);
                $output = '';

                $category_name = array();
                $categories_index = array();

                $portfolio_container_id = uniqid();
                // Get portfolio categories array
                $terms = get_terms('portfolio_categories');
                $milo_loadmore_text = esc_html($milo_loadmore_text);

                // Composes the portfolio category selection list
                if ($milo_filter_disable != 'yes') {
                    $milo_all_text = esc_html($milo_all_text);
                    if ($milo_align == 'description') {
                        $content = wpb_js_remove_wpautop($content, true);
                        $content = wp_kses_post($content);
                        $output = "<div class='container-inner'><div class='row'><div class='col-md-5'>{$content}</div><div class='col-md-7'><div class='filter'><ul><li><a class='active' data-filter='*' href='#' >{$milo_all_text}</a></li>";
                    } else {
                        $output = "<div class='row'><div class='col-sm-12'><div class='filter {$milo_align}'><ul><li><a class='active' data-filter='*' href='#' >{$milo_all_text}</a></li>";
                    }

                    if ($terms && !is_wp_error($terms)) {
                        foreach ($terms as $term) {
                            $category_name = esc_html($term->name);
                            $categ_slug = esc_attr($term->slug);
                            $output.="<li><a href='#' data-filter='.categ-{$categ_slug}' >{$category_name}</a></li>";
                        }
                    }

                    if ($milo_align == 'description') {
                        $output.="</ul></div></div></div></div>";
                    } else {
                        $output.="</ul></div></div></div>";
                    }
                }
                if ($milo_style == '5' && $milo_columns == '1' && $milo_gutter != '') {
                    $para_class = ' p-classic-gutter';
                } else {
                    $para_class = '';
                }

                $output.= "<div id='{$portfolio_container_id}' class='isotope col-{$milo_columns} {$milo_gutter}{$para_class}'>";

                while ($loop->have_posts()) {

                    $terms_class = 'isotope-item';
                    $loop->the_post();
                    $post_id = get_the_ID();

                    $post_categories = get_the_terms($post_id, 'portfolio_categories');

                    if (has_post_thumbnail($post_id)) {
                        $thumbnail_id = get_post_thumbnail_id();

                        $image_data = wp_get_attachment_image_src($thumbnail_id, $img_size);

                        $image_url = esc_url($image_data[0]);

                        $image_data_full = wp_get_attachment_image_src($thumbnail_id, 'full');

                        $image_url_full = esc_url($image_data_full[0]);
                    } else {
                        $image_url = $image_url_full = MILO_SHOTCODES_PATH . 'images/testimonial_none.png';
                    }

                    $post_title = esc_html(get_the_title($post_id));

                    $post_link = esc_url(get_post_permalink($post_id));

                    $terms_list = '';
                    if ($milo_style == '5') {

                        if (!empty($post_categories)) {
                            foreach ($post_categories as $category) {
                                $terms_class.=" categ-" . esc_attr($category->slug);
                                $term_link = get_term_link($category->slug, 'portfolio_categories');
                                $terms_list.="<a href='{$term_link}'>{$category->name}</a> ";
                            }
                        }

                        $milo_visit = esc_html($milo_visit);
                        $post_excerpt = apply_filters('the_content', get_the_excerpt());

                        $output.="<div class='{$terms_class}'><div class='portfolio-item portfolio-classic'>
                    <div class='portfolio-item-thumbnail'><img src='{$image_url}' alt=''><div class='portfolio-item-hover'>
                    <a class='fancybox zoom-action' data-fancybox-group='portfolio' href='{$image_url_full}'><i class='mt-icon-expand2'></i></a>
                    </div></div><div class='portfolio-item-details'><h6><a href='{$post_link}'>{$post_title}</a></h6><p>{$terms_list}<p><p>{$post_excerpt}</p>
                    <a class='btn btn-default' href='{$post_link}'>{$milo_visit}</a></div></div></div>";
                    } else {

                        if (!empty($post_categories)) {
                            foreach ($post_categories as $category) {
                                $terms_class.=" categ-" . esc_attr($category->slug);
                            }
                        }

                        $output.= "<div class='{$terms_class}'><div class='portfolio-item'>
		<div class='portfolio-item-thumbnail'><img src='{$image_url}' alt=''><div class='portfolio-item-hover'>";
                        if ($milo_style == '1' || $milo_style == '3') {
                            $output.= "<a class='fancybox zoom-action' data-fancybox-group='portfolio' href='{$image_url_full}'><i class='mt-icon-expand2'></i></a>
                    </div></div></div></div>";
                        } else if ($milo_style == '2' || $milo_style == '4') {
                            $output.= "<a class='fancybox zoom-action' data-fancybox-group='portfolio' href='{$image_url_full}'><i class='mt-icon-expand2'></i></a>
                    </div></div><div class='portfolio-item-details'><h6><a href='{$post_link}'>{$post_title}</a></h6></div></div></div>";
                        }
                    }
                }

                wp_reset_postdata();
                $output.="</div>";

                if ($milo_navigation != '3') {

                    $published_porfolio = $loop->found_posts;
                    $nonce = wp_create_nonce("milo_custom_posts_isotope_nonce");

                    if ($milo_navigation == '1' && $milo_max_number < $published_porfolio) {
                        $loader_img = MILO_SHOTCODES_PATH . 'images/loader.gif';
                        $output.= "<img id='{$portfolio_container_id}loadmore-gif' class='milo_loader_gif' src='{$loader_img}' alt='" . esc_html__('Loading..', 'dakota-theme') . "'>";
                        // Prepares the load more button and the ajax link
                        $total_images_count = $milo_max_number + $milo_load_number;

                        $link = esc_url(admin_url('admin-ajax.php?action=milo_portfolio_gallery'
                                        . '&count_increment=' . $milo_load_number
                                        . '&count_total=' . $milo_max_number
                                        . '&custom_post_type=' . $type
                                        . '&style=' . $milo_style
                                        . '&visit=' . $milo_visit
                                        . '&selection=' . $milo_selection
                                        . '&img_size=' . $img_size
                                        . '&nonce=' . $nonce));

                        $output.= "<div class='row portfolio-nav'><div class='col-sm-12'><p class='text-center'>"
                                . "<a class='btn btn-default load-more milo_load_more_trigger' id='{$portfolio_container_id}loadmore' "
                                . "data-nonce='{$nonce}' "
                                . "data-count_increment='{$milo_load_number}' "
                                . "data-count_total='{$total_images_count}' "
                                . "data-custom_post_type='{$type}' "
                                . "data-style='{$milo_style}' "
                                . "data-visit='{$milo_visit}' "
                                . "data-img_size='{$img_size}' "
                                . "data-selection='{$milo_selection}' "
                                . "data-target_container='{$portfolio_container_id}' "
                                . "href='{$link}'>{$milo_loadmore_text}</a></p></div></div>";
                    } else if ($milo_navigation == '2') {

                        $loader_img = MILO_SHOTCODES_PATH . 'images/loader.gif';
                        $output.= "<img id='{$portfolio_container_id}loadmore-gif' class='milo_loader_gif' src='{$loader_img}' alt='" . esc_html__('Loading..', 'dakota-theme') . "'>";
                        // Determines the number of pages for classic portfolio
                        if ($published_porfolio % $milo_max_number != 0) {
                            $portfolio_pages = $published_porfolio / $milo_max_number + 1;
                        } else {
                            $portfolio_pages = $published_porfolio / $milo_max_number;
                        }

                        // Prepares the list and ajax links of each page index
                        $total_images_count = $milo_max_number + $milo_max_number;

                        $link = esc_url(admin_url('admin-ajax.php?action=milo_portfolio_gallery'
                                        . '&count_increment=' . $milo_max_number . ''
                                        . '&count_page=1'
                                        . '&custom_post_type=' . $type . ''
                                        . '&style=' . $milo_style
                                        . '&visit=' . $milo_visit
                                        . '&selection=' . $milo_selection
                                        . '&img_size=' . $img_size
                                        . '&nonce=' . $nonce));

                        $output.="<div class='row portfolio-nav'>
            	<div class='col-sm-12'>
                
                        <ul class='pagination text-center'>
                            <li id='{$portfolio_container_id}_current' class='active'>
                                <a class='milo_portfolio_page_trigger' "
                                . "data-nonce='{$nonce}' "
                                . "data-count_increment='{$milo_max_number}' "
                                . "data-count_page='1' "
                                . "data-custom_post_type='{$type}' "
                                . "data-style='{$milo_style}' "
                                . "data-visit='{$milo_visit}' "
                                . "data-img_size='{$img_size}' "
                                . "data-selection='{$milo_selection}' "
                                . "data-target_container='{$portfolio_container_id}' "
                                . "href='{$link}'>1</a>
                            </li>";

                        // Generates each page index                        
                        for ($i = 2; $i <= $portfolio_pages; $i++) {
                            $link = esc_url(admin_url('admin-ajax.php?action=milo_portfolio_gallery'
                                            . '&count_increment=' . $milo_max_number . ''
                                            . '&count_page=' . $i . ''
                                            . '&custom_post_type=' . $type . ''
                                            . '&style=' . $milo_style
                                            . '&visit=' . $milo_visit
                                            . '&selection=' . $milo_selection
                                            . '&img_size=' . $img_size
                                            . '&nonce=' . $nonce));

                            $output.="<li><a class='milo_portfolio_page_trigger' "
                                    . "data-nonce='{$nonce}' "
                                    . "data-count_increment='{$milo_max_number}' "
                                    . "data-count_page='{$i}' "
                                    . "data-custom_post_type='{$type}' "
                                    . "data-style='{$milo_style}' "
                                    . "data-selection='{$milo_selection}' "
                                    . "data-visit='{$milo_visit}' "
                                    . "data-img_size='{$img_size}' "
                                    . "data-target_container='{$portfolio_container_id}' "
                                    . "href='{$link}'>{$i}</a>
                </li>";
                        }

                        $output.="</ul></div></div>";
                    }
                }

                return $output;
            }

            add_shortcode('milo_porfolio_gallery', 'milo_porfolio_gallery_func');
            add_action('init', 'milo_integrate_vc_porfolio_gallery');

// integrates the custom element in the visual composer
            function milo_integrate_vc_porfolio_gallery() {
                if (defined('MILO_PORTFOLIO')) {
                    $portfolio_terms = get_terms('portfolio_categories');
                    $terms = array(esc_html__('All', 'dakota-theme') => 'all');
                    if (!empty($portfolio_terms)) {
                        foreach ($portfolio_terms as $term) {
                            $terms[$term->name] = $term->term_id;
                        }
                    }
                } else {
                    $terms = array();
                }
                vc_map(
                        array(
                            'name' => esc_html__('Portfolio Gallery', 'dakota-theme'),
                            'base' => 'milo_porfolio_gallery',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'params' => array(
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Portfolio items selection', 'dakota-theme'),
                                    'param_name' => 'milo_selection',
                                    'value' => $terms,
                                    'description' => esc_html__('Select a all items or only items from a certain category', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Initial number of projects', 'dakota-theme'),
                                    'param_name' => 'milo_max_number',
                                    'value' => '12',
                                    'description' => esc_html__('How many portfolio items to show, initially', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('All Projects caption', 'dakota-theme'),
                                    'param_name' => 'milo_all_text',
                                    'description' => esc_html__('Specify the All projects caption', 'dakota-theme'),
                                    'value' => esc_html__('All', 'dakota-theme'),
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Filters align', 'dakota-theme'),
                                    'param_name' => 'milo_align',
                                    'value' => array(
                                        esc_html__('Center', 'dakota-theme') => ' text-center',
                                        esc_html__('Left', 'dakota-theme') => '',
                                        esc_html__('Right', 'dakota-theme') => ' text-right',
                                        esc_html__('With description', 'dakota-theme') => 'description'
                                    ),
                                    'description' => esc_html__('Align portfolio category filters', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textarea_html',
                                    'heading' => esc_html__('Portfolio description', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'dependency' => array(
                                        'element' => 'milo_align',
                                        'value' => 'description'
                                    ),
                                    'description' => esc_html__('Add description text that will show next to the filters', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Portfolio items style', 'dakota-theme'),
                                    'param_name' => 'milo_style',
                                    'value' => array(
                                        esc_html__('Symmetric', 'dakota-theme') => '1',
                                        esc_html__('Symmetric, titles under images', 'dakota-theme') => '2',
                                        esc_html__('Masonry', 'dakota-theme') => '3',
                                        esc_html__('Masonry, titles under images', 'dakota-theme') => '4',
                                        esc_html__('Classic, details on right side', 'dakota-theme') => '5'),
                                    'description' => esc_html__('Select a style', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('View Project Details caption', 'dakota-theme'),
                                    'param_name' => 'milo_visit',
                                    'dependency' => array(
                                        'element' => 'milo_style',
                                        'value' => '5'
                                    ),
                                    'description' => esc_html__('Specify the View Project Details caption', 'dakota-theme'),
                                    'value' => esc_html__('View', 'dakota-theme'),
                                ),
                                array(
                                    'type' => 'checkbox',
                                    'heading' => esc_html__('Gutter', 'dakota-theme'),
                                    'param_name' => 'milo_gutter',
                                    'description' => esc_html__('If gutter is enabled, there will be spacing between elements', 'dakota-theme'),
                                    'value' => array(esc_html__('enable', 'dakota-theme') => 'gutter')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Columns', 'dakota-theme'),
                                    'param_name' => 'milo_columns',
                                    'value' => array(
                                        esc_html__('3 Columns', 'dakota-theme') => '3',
                                        esc_html__('4 Columns', 'dakota-theme') => '4',
                                        esc_html__('5 Columns', 'dakota-theme') => '5'
                                    ),
                                    'dependency' => array(
                                        'element' => 'milo_style',
                                        'value' => array('1', '2', '3', '4')
                                    ),
                                    'description' => esc_html__('Select the number of columns the elements will be divided into', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Navigation', 'dakota-theme'),
                                    'param_name' => 'milo_navigation',
                                    'value' => array(
                                        esc_html__('Load More', 'dakota-theme') => '1',
                                        esc_html__('Paginated', 'dakota-theme') => '2',
                                        esc_html__('None', 'dakota-theme') => '3'
                                    ),
                                    'description' => esc_html__('Select the navigation type', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Load More Button Caption', 'dakota-theme'),
                                    'param_name' => 'milo_loadmore_text',
                                    'dependency' => array(
                                        'element' => 'milo_navigation',
                                        'value' => '1'
                                    ),
                                    'description' => esc_html__('Specify the load more caption', 'dakota-theme'),
                                    'value' => esc_html__('Load more projects', 'dakota-theme'),
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Number of projects to load on Load More', 'dakota-theme'),
                                    'dependency' => array(
                                        'element' => 'milo_navigation',
                                        'value' => '1'
                                    ),
                                    'param_name' => 'milo_load_number',
                                    'value' => '3',
                                    'description' => esc_html__('How many extra portfolio items to show when Load More is pressed', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'checkbox',
                                    'heading' => esc_html__('Disable portfolio filter', 'dakota-theme'),
                                    'param_name' => 'milo_filter_disable',
                                    'value' => array(esc_html__('disable', 'dakota-theme') => 'yes'),
                                    'description' => esc_html__('If you disable portfolio filter, then you wont be able to filter portfolio by portfolio category', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT PRICE PLAN
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_price_plan_func($atts) {
                extract(shortcode_atts(array(
                    'milo_price' => '30',
                    'milo_type' => '$',
                    'milo_price_color' => 'default',
                    'milo_period' => esc_html__('Month', 'dakota-theme'),
                    'milo_title' => esc_html__('Basic', 'dakota-theme'),
                    'milo_link' => '',
                    'milo_size' => '',
                    'milo_color' => 'btn-default',
                    'milo_specifications' => ''
                                ), $atts));

                $specifications_elements = mb_split('<br />', $milo_specifications);
                $specifications_list = '';
                $milo_title = esc_html($milo_title);
                $milo_price = esc_html($milo_price);
                $milo_type = esc_html($milo_type);
                $milo_period = esc_html($milo_period);

                // Loops through each specifications row
                foreach ($specifications_elements as $element) {
                    $specifications_list.='<li>' . esc_html($element) . '</li>';
                }

                $link_details = vc_build_link($milo_link);

                $newtab = $size = $class = $price_link = '';

                if ($milo_size == 'small') {
                    $size = ' btn-xs';
                } else if ($milo_size == 'large') {
                    $size = ' btn-lg';
                }

                if (trim($link_details['url']) != '') {
                    $link_details['target'] = esc_attr($link_details['target']);
                    $link_details['url'] = esc_url($link_details['url']);
                    $link_details['title'] = esc_html($link_details['title']);

                    if ($link_details['target'] != '') {
                        $newtab = "target='{$link_details['target']}'";
                    }
                    if ($milo_color != 'none') {
                        $class = "class='btn{$size} {$milo_color}' ";
                    }

                    $price_link = "<a {$class}href='{$link_details['url']}' {$newtab}>{$link_details['title']}</a>";
                }

                return "<div class='price-plan {$milo_price_color}'><h3 class='price-plan-header'>{$milo_title}</h3>
	<h1 class='price'><sub>{$milo_type}</sub> {$milo_price} <small>/ {$milo_period}</small></h1>
        <ul>{$specifications_list}</ul><div class='price-plan-footer'>{$price_link}</div></div>";
            }

            add_shortcode('milo_price_plan', 'milo_price_plan_func');

            add_action('init', 'milo_integrate_vc_price_plan');

// integrates the custom element in the visual composer
            function milo_integrate_vc_price_plan() {
                vc_map(
                        array(
                            'name' => esc_html__('Price Plan', 'dakota-theme'),
                            'base' => 'milo_price_plan',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Plan title', 'dakota-theme'),
                                    'param_name' => 'milo_title',
                                    'value' => esc_html__('Basic', 'dakota-theme'),
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Cost', 'dakota-theme'),
                                    'param_name' => 'milo_price',
                                    'value' => '30',
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Cost type', 'dakota-theme'),
                                    'param_name' => 'milo_type',
                                    'value' => '$',
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Period', 'dakota-theme'),
                                    'param_name' => 'milo_period',
                                    'value' => esc_html__('Month', 'dakota-theme'),
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Price plan color', 'dakota-theme'),
                                    'param_name' => 'milo_price_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'default',
                                        esc_html__('blue', 'dakota-theme') => 'blue',
                                        esc_html__('green', 'dakota-theme') => 'green'
                                    )
                                ),
                                array(
                                    'type' => 'textarea',
                                    'heading' => esc_html__('Plan features (add one per line)', 'dakota-theme'),
                                    'param_name' => 'milo_specifications',
                                    'description' => esc_html__('Write the specifications', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Button title and url', 'dakota-theme'),
                                    'param_name' => 'milo_link',
                                    'description' => esc_html__('Specify the link pointing to another page', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Size', 'dakota-theme'),
                                    'param_name' => 'milo_size',
                                    'value' => array(
                                        esc_html__('Normal', 'dakota-theme') => 'normal',
                                        esc_html__('Large', 'dakota-theme') => 'large',
                                        esc_html__('Small', 'dakota-theme') => 'small'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Color set', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'btn-default',
                                        esc_html__('blue', 'dakota-theme') => 'btn-blue',
                                        esc_html__('green', 'dakota-theme') => 'btn-green',
                                        esc_html__('black', 'dakota-theme') => 'btn-black',
                                        esc_html__('white', 'dakota-theme') => 'btn-white',
                                        esc_html__('none', 'dakota-theme') => 'none'
                                    )
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT PROCESS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_process_container_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_color' => 'default'
                                ), $atts));

                $content = wpb_js_remove_wpautop($content, false);
                $content_elements = explode("<div class='step'>", $content);
                $count = count($content_elements) - 1;


                return "<div class='process-steps process-{$count}-steps {$milo_color}'>{$content}</div>";
            }

            add_shortcode('milo_process_container', 'milo_process_container_func');

            function milo_process_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_title' => '',
                    'milo_icon' => ''
                                ), $atts));

                if ($milo_icon != '') {
                    $icon = "<i class='{$milo_icon}'></i>";
                } else {
                    $icon = '';
                }

                $content = esc_html($content);

                $milo_title = esc_html($milo_title);

                return "<div class='step'>{$icon}<div class='step-details'><h6>{$milo_title}</h6><p>{$content}</p></div></div>";
            }

            add_shortcode('milo_process', 'milo_process_func');
            add_action('init', 'milo_integrate_vc_process_components');

            function milo_integrate_vc_process_components() {
                vc_map(array(
                    'name' => esc_html__('Process container', 'dakota-theme'),
                    'base' => 'milo_process_container',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'as_parent' => array('only' => 'milo_process'),
                    'content_element' => true,
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'show_settings_on_create' => true,
                    'params' => array(array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Color style', 'dakota-theme'),
                            'param_name' => 'milo_color',
                            'value' => array(
                                esc_html__('default', 'dakota-theme') => 'default',
                                esc_html__('blue', 'dakota-theme') => 'blue',
                                esc_html__('green', 'dakota-theme') => 'green',
                            )
                        ),),
                    'js_view' => 'VcColumnView'
                ));
                vc_map(array(
                    'name' => esc_html__('Process Step', 'dakota-theme'),
                    'base' => 'milo_process',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'content_element' => true,
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'as_child' => array('only' => 'milo_process_container'),
                    'params' => array(
                        array(
                            'type' => 'milo_icons_param',
                            'heading' => esc_html__('Select icon', 'dakota-theme'),
                            'param_name' => 'milo_icon'
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Title', 'dakota-theme'),
                            'param_name' => 'milo_title',
                            'holder' => 'div',
                            'description' => esc_html__('Specify the tile of the process', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textarea',
                            'heading' => esc_html__('Details', 'dakota-theme'),
                            'param_name' => 'content',
                            'description' => esc_html__('Specify the details of the process step', 'dakota-theme')
                        )
                    )
                ));
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT PROGRESS BAR
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_progress_bar_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_progress_bar_width' => '50',
                    'milo_color' => ''
                                ), $atts));

                $content = esc_html($content);

                $milo_progress_bar_width = absint($milo_progress_bar_width);

                return "<div class='progress-bar-title'>{$content}</div><div class='progress'>  
                <div class='progress-bar{$milo_color}' data-width='{$milo_progress_bar_width}'> 
                    <span>{$milo_progress_bar_width}%</span></div></div>";
            }

            add_shortcode('milo_progress_bar', 'milo_progress_bar_func');

            add_action('init', 'milo_integrate_vc_progress_bar');

            function milo_integrate_vc_progress_bar() {
                vc_map(
                        array(
                            'name' => esc_html__('Progress Bar', 'dakota-theme'),
                            'base' => 'milo_progress_bar',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Title', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'value' => esc_html__('title', 'dakota-theme'),
                                    'description' => esc_html__('The title of the progress bar', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Value', 'dakota-theme'),
                                    'param_name' => 'milo_progress_bar_width',
                                    'value' => '50',
                                    'description' => esc_html__('Specify a value between 1 and 100, it represents the loaded percentage', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Icon color', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => '',
                                        esc_html__('blue', 'dakota-theme') => ' blue',
                                        esc_html__('green', 'dakota-theme') => ' green',
                                    )
                                ),
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT RECENT POSTS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            function milo_recent_posts_func($atts) {
                extract(shortcode_atts(array(
                    'milo_count' => '3',
                    'milo_title' => esc_html__('Read more', 'dakota-theme')
                                ), $atts));

                $args = array(
                    'post_type' => 'post',
                    'post_status' => 'publish',
                    'posts_per_page' => absint($milo_count),
                    'ignore_sticky_posts' => 1);

                $loop = new WP_Query($args);

                $output = '<div>';

                while ($loop->have_posts()) {
                    $post_media = '';
                    $loop->the_post();
                    $post_id = get_the_ID();

                    $embeds = '';

                    if (has_post_format('video') || has_post_format('audio')) {
                        $content = do_shortcode(apply_filters('the_content', get_the_content()));
                        $embeds = get_media_embedded_in_content($content);
                    }

                    if (has_post_thumbnail() || $embeds != null) {
                        $post_media = "<div class='blog-article-thumbnail'>";
                        if ($embeds != null) {
                            if (has_post_format('video')) {
                                $post_media.= "<div class='embed-responsive embed-responsive-16by9'>" . $embeds[0] . "</div></div>";
                            } else {
                                $post_media.= "<div>" . $embeds[0] . "</div></div>";
                            }
                        } else {
                            $image_data = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), 'milo_blog2col_size');
                            $image_url = esc_url($image_data[0]);
                            $post_media.= "<img src='{$image_url}' alt=''></div>";
                        }
                    }

                    $post_title = esc_html(get_the_title());
                    $post_link = esc_url(get_permalink());
                    $post_date = get_the_date('d M, Y');
                    $post_author = esc_html(get_the_author());
                    $post_categories = get_the_category_list(', ');
                    $post_comments = '<a href="' . get_comments_link() . '">' . get_comments_number() . esc_html__(' Comments', 'dakota-theme') . '</a>';

                    $by_text = esc_html__('By ', 'dakota-theme');

                    if ($milo_title != '') {
                        $milo_title = esc_html($milo_title);
                        $read_more = "<a class='btn btn-white' href='{$post_link}'>{$milo_title}</a>";
                    } else {
                        $read_more = '';
                    }

                    $post_excerpt = apply_filters("the_content", get_the_excerpt());

                    $output.="<div class='col-sm-6'><div class='blog-article'>{$post_media}<div class='blog-article-date'>{$post_date}</div>
                <div class='blog-article-details text-center'><h5><a href='{$post_link}'>{$post_title}</a></h5>
                <p>{$by_text} {$post_author} | {$post_categories} | {$post_comments}</p>
                <p>{$post_excerpt}</p>{$read_more}</div></div></div>";
                }
                wp_reset_postdata();
                $output.= '</div>';
                return $output;
            }

            add_shortcode('milo_recent_posts', 'milo_recent_posts_func');
            add_action('init', 'milo_integrate_vc_recent_posts_components');

            function milo_integrate_vc_recent_posts_components() {
                vc_map(array(
                    'name' => esc_html__('Recent Posts', 'dakota-theme'),
                    'base' => 'milo_recent_posts',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'content_element' => true,
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'params' => array(
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Number of recent posts', 'dakota-theme'),
                            'param_name' => 'milo_count',
                            'value' => '3',
                            'holder' => 'div',
                            'description' => esc_html__('Specify how many recent posts to show', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Read more button title', 'dakota-theme'),
                            'param_name' => 'milo_title',
                            'value' => esc_html__('Read more', 'dakota-theme')
                        )
                    )
                ));
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT SERVICE BOX
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_service_box_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_icon' => '',
                    'milo_link' => '',
                    'milo_title' => '',
                    'milo_align' => ' icon-left',
                    'milo_short' => '',
                    'milo_style' => '1',
                    'milo_color' => 'default'
                                ), $atts));

                $newtab = $read_more = $link_before = $link_after = $icon = $content_p = $align = '';

                if (trim($milo_icon) != '') {
                    $milo_icon = esc_attr($milo_icon);
                    $icon = "<i class='{$milo_icon}'></i>";
                }

                if (trim($content) != '') {
                    $content = esc_html($content);
                    $content_p = "<p>{$content}</p>";
                }

                $link_details = vc_build_link($milo_link);

                $milo_title = esc_html($milo_title);

                if (trim($link_details['url']) != '') {
                    $link_details['url'] = esc_url($link_details['url']);

                    if ($link_details['target'] !== '') {
                        $newtab = "target='{$link_details['target']}'";
                    }

                    $link_before = "<a href='{$link_details['url']}' {$newtab}>";
                    $link_after = "</a>";

                    if (trim($link_details['title']) != '') {
                        $link_details['title'] = esc_html($link_details['title']);
                        $read_more = "<a href='{$link_details['url']}' {$newtab}><em>{$link_details['title']}</em></a>";
                    }
                }

                if ($milo_style != '3') {

                    if ($milo_style != '2') {
                        $milo_align = '';
                    }
                    if ($milo_style != '4') {
                        $milo_short = '';
                    }

                    return "<div class='service-box style-{$milo_style} {$milo_color}{$milo_short}{$milo_align}'>
                                {$icon}
                                <div class='service-box-content'>
                                    <h6>{$link_before}{$milo_title}{$link_after}</h6>
                                    {$content_p}
                                    {$read_more}
                                </div></div>";
                } else {
                    return "<div class='service-box style-3 {$milo_color}'>
                                {$icon}
                                    <h6>{$link_before}{$milo_title}{$link_after}</h6>
                                <div class='service-box-content'>
                                    {$content_p}
                                    {$read_more}
                                </div></div>";
                }
            }

            add_shortcode('milo_service_box', 'milo_service_box_func');
            add_action('init', 'milo_integrate_vc_service_box');

// integrates the custom element in the visual composer
            function milo_integrate_vc_service_box() {
                vc_map(
                        array(
                            'name' => esc_html__('Service Box', 'dakota-theme'),
                            'base' => 'milo_service_box',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Service Title', 'dakota-theme'),
                                    'param_name' => 'milo_title'
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Style Type', 'dakota-theme'),
                                    'param_name' => 'milo_style',
                                    'value' => array(
                                        esc_html__('Style 1', 'dakota-theme') => '1',
                                        esc_html__('Style 2', 'dakota-theme') => '2',
                                        esc_html__('Style 3', 'dakota-theme') => '3',
                                        esc_html__('Style 4', 'dakota-theme') => '4'
                                    ),
                                    'description' => esc_html__('Specify', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'checkbox',
                                    'heading' => esc_html__('Align right', 'dakota-theme'),
                                    'dependency' => array(
                                        'element' => 'milo_style',
                                        'value' => array('2')
                                    ),
                                    'param_name' => 'milo_align',
                                    'value' => array(esc_html__('Enable', 'dakota-theme') => ' icon-right')
                                ),
                                array(
                                    'type' => 'checkbox',
                                    'heading' => esc_html__('Shorter top bar', 'dakota-theme'),
                                    'dependency' => array(
                                        'element' => 'milo_style',
                                        'value' => array('4')
                                    ),
                                    'param_name' => 'milo_short',
                                    'value' => array(esc_html__('Enable', 'dakota-theme') => ' short-bar')
                                ),
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Read more link', 'dakota-theme'),
                                    'param_name' => 'milo_link',
                                    'description' => esc_html__('Specify an optional link pointing to a details page', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'milo_icons_param',
                                    'heading' => esc_html__('Select icon', 'dakota-theme'),
                                    'param_name' => 'milo_icon',
                                    'description' => esc_html__('Select an icon', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Color style', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'default',
                                        esc_html__('blue', 'dakota-theme') => 'blue',
                                        esc_html__('green', 'dakota-theme') => 'green',
                                    )
                                ),
                                array(
                                    'type' => 'textarea',
                                    'heading' => esc_html__('Content', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'description' => esc_html__('Add description text for the service', 'dakota-theme')
                                )
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT SIMPLE SLIDER
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_simple_slider_container_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_type' => '1',
                    'milo_style' => '',
                    'milo_text' => ''
                                ), $atts));

                $content = wpb_js_remove_wpautop($content, false);


                if ($milo_type == '1') {

                    $carousel_id = uniqid();
                    $nav_id = $carousel_id . 'nav';

                    return "<div id='{$carousel_id}' class='owl-carousel logos-slider'>{$content}</div>
    <div id='{$nav_id}' class='slider-navigation text-center'><span class='prev'><i class='mt-icon-arrow-left'></i></span>
    <span class='next'><i class='mt-icon-arrow-right2'></i></span></div>";
                } else if ($milo_type == '2') {

                    $carousel_id = uniqid();
                    $nav_id = $carousel_id . 'nav';
                    $milo_text = esc_html($milo_text);

                    return "<div class='row'><div class='col-sm-7'><p>{$milo_text}</p></div><div class='col-sm-5'><div id='{$nav_id}' class='slider-navigation text-right'>
	<span class='prev'><i class='mt-icon-arrow-left'></i></span><span class='next'><i class='mt-icon-arrow-right2'></i></span></div>
	</div></div><div id='{$carousel_id}' class='owl-carousel logos-slider'>{$content}</div>";
                } else if ($milo_type == '3') {

                    return "<div class='owl-carousel images-slider'>{$content}</div>";
                } else if ($milo_type == '4') {

                    $carousel_id = uniqid();
                    $nav_id = $carousel_id . 'nav';

                    return "<div id='{$carousel_id}' class='owl-carousel branding-slider'>{$content}</div>
        <div id='{$nav_id}' class='slider-navigation text-center'><span class='prev'><i class='mt-icon-arrow-left'></i></span>
    <span class='next'><i class='mt-icon-arrow-right2'></i></span></div>";
                } else {

                    $carousel_id = uniqid();
                    $nav_id = $carousel_id . 'nav';
                    $milo_text = esc_html($milo_text);

                    return "<div class='row'><div class='col-sm-7'><p>{$milo_text}</p></div><div class='col-sm-5'><div id='{$nav_id}' class='slider-navigation text-right'>
	<span class='prev'><i class='mt-icon-arrow-left'></i></span><span class='next'><i class='mt-icon-arrow-right2'></i></span></div>
	</div></div><div id='{$carousel_id}' class='owl-carousel branding-slider'>{$content}</div>";
                }
            }

            add_shortcode('milo_simple_slider_container', 'milo_simple_slider_container_func');

            add_action('init', 'milo_integrate_vc_simple_slider_components');

            function milo_integrate_vc_simple_slider_components() {
                vc_map(array(
                    'name' => esc_html__('Simple Slider container', 'dakota-theme'),
                    'base' => 'milo_simple_slider_container',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'as_parent' => array('except' => 'milo_simple_slider_container'),
                    'content_element' => true,
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'show_settings_on_create' => true,
                    'params' => array(
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Button Color set', 'dakota-theme'),
                            'param_name' => 'milo_type',
                            'value' => array(
                                esc_html__('Logos slider', 'dakota-theme') => '1',
                                esc_html__('Logos slider with description', 'dakota-theme') => '2',
                                esc_html__('Images with navigation dots', 'dakota-theme') => '3',
                                esc_html__('Large with arrows', 'dakota-theme') => '4',
                                esc_html__('Large with arrows and description', 'dakota-theme') => '5'
                            )
                        ),
                        array(
                            'type' => 'textarea',
                            'heading' => esc_html__('Description', 'dakota-theme'),
                            'param_name' => 'milo_text',
                            'dependency' => array(
                                'element' => 'milo_type',
                                'value' => array('2', '5')
                            ),
                            'description' => esc_html__('Specify a short description for this slider', 'dakota-theme')
                        )
                    ),
                    'js_view' => 'VcColumnView'
                ));
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT SOCIAL MEDIA ELEMENTS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_social_media_func($atts) {
                extract(shortcode_atts(array(
                    'milo_social_icon' => '',
                    'milo_color' => '',
                    'milo_social_link' => ''
                                ), $atts));

                $output = '';

                $icon_parts = explode('mt-icon-', $milo_social_icon);

                if ($icon_parts[1] == 'youtube-play') {
                    $icon_parts[1] = 'youtube';
                } else if ($icon_parts[1] == 'google-plus') {
                    $icon_parts[1] = 'google';
                } else if ($icon_parts[1] == 'at-sign') {
                    $icon_parts[1] = 'email';
                }

                $milo_social_link = esc_url($milo_social_link);

                $output.= "<a href='{$milo_social_link}' class='social-media {$icon_parts[1]}{$milo_color}' target='_blank'><i class='{$milo_social_icon}'></i></a>";

                return $output;
            }

            add_shortcode('milo_social_media', 'milo_social_media_func');
            add_action('init', 'milo_integrate_vc_social_media');

// integrates the custom element in the visual composer
            function milo_integrate_vc_social_media() {
                vc_map(array(
                    'name' => esc_html__('Social Media', 'dakota-theme'),
                    'base' => 'milo_social_media',
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'params' => array(
                        array(
                            'type' => 'milo_social_icons_param',
                            'heading' => esc_html__('Social icon', 'dakota-theme'),
                            'param_name' => 'milo_social_icon',
                            'holder' => 'div',
                            'description' => esc_html__('Select social icon', 'dakota-theme')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Social link', 'dakota-theme'),
                            'param_name' => 'milo_social_link',
                            'value' => '',
                            'description' => esc_html__('Specify social link', 'dakota-theme')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Hover color', 'dakota-theme'),
                            'param_name' => 'milo_color',
                            'value' => array(
                                esc_html__('brand', 'dakota-theme') => '',
                                esc_html__('default', 'dakota-theme') => ' color-default',
                                esc_html__('blue', 'dakota-theme') => ' color-blue',
                                esc_html__('green', 'dakota-theme') => ' color-green',
                            )
                        ),
                    )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT TESTIMONIAL
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_testimonial_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_name' => '',
                    'milo_image' => '',
                    'milo_occupation' => '',
                                ), $atts));

                $milo_name = esc_html($milo_name);
                $milo_occupation = esc_html($milo_occupation);

                $specifications_elements = mb_split('<br />', $content);
                $specifications_list = $image = '';
                // Loops through each specifications row
                foreach ($specifications_elements as $element) {
                    $specifications_list.= esc_html($element) . '<br />';
                }

                if ($milo_image != '') {
                    $image_data = wp_get_attachment_image_src($milo_image, 'milo_testimonial_size');
                    $image_url = esc_url($image_data[0]);
                    $image = "<img src='{$image_url}' alt=''>";
                }
                return "<div><div class='testimonial'><blockquote><p>{$specifications_list}</p></blockquote>		
                       <h6>{$milo_name} <small>{$milo_occupation}</small></h6>{$image}</div></div>";
            }

            add_shortcode('milo_testimonial', 'milo_testimonial_func');

            add_action('init', 'milo_integrate_vc_testimonial');

// integrates the custom element in the visual composer
            function milo_integrate_vc_testimonial() {
                vc_map(
                        array(
                            'name' => esc_html__('Testimonial', 'dakota-theme'),
                            'base' => 'milo_testimonial',
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'params' => array(
                                array(
                                    'type' => 'textfield',
                                    'holder' => 'div',
                                    'heading' => esc_html__('Name', 'dakota-theme'),
                                    'param_name' => 'milo_name',
                                    'value' => esc_html__('Sample name', 'dakota-theme'),
                                    'description' => esc_html__('Specify the name of the testimonial author', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textfield',
                                    'heading' => esc_html__('Occupation', 'dakota-theme'),
                                    'param_name' => 'milo_occupation',
                                    'description' => esc_html__('Specify the occupation of the testimonial author', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'textarea',
                                    'heading' => esc_html__('Testimonial quote', 'dakota-theme'),
                                    'param_name' => 'content',
                                    'description' => esc_html__('Specify the text of the testimonial', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'attach_image',
                                    'heading' => esc_html__('Image', 'dakota-theme'),
                                    'param_name' => 'milo_image',
                                    'description' => esc_html__('Add an image for the testimonial', 'dakota-theme')
                                ),
                            )
                        )
                );
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT TESTIMONIAL SLIDER
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_testimonial_slider_container_func($atts, $content = null) {
                extract(shortcode_atts(array(
                    'milo_class' => ''
                                ), $atts));

                $content = wpb_js_remove_wpautop($content, false);

                $milo_class = esc_attr($milo_class);

                return '<div class="owl-carousel testimonials-slider ' . $milo_class . '">' . $content . '</div>';
            }

            add_shortcode('milo_testimonial_slider_container', 'milo_testimonial_slider_container_func');

            add_action('init', 'milo_integrate_vc_testimonial_slider_components');

// integrates the custom element in the visual composer
            function milo_integrate_vc_testimonial_slider_components() {
                vc_map(array(
                    'name' => esc_html__('Testimonial Slider Container', 'dakota-theme'),
                    'base' => 'milo_testimonial_slider_container',
                    'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                    'as_parent' => array('only' => 'milo_testimonial'),
                    'content_element' => true,
                    'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                    'show_settings_on_create' => false,
                    'params' => array(array(
                            'type' => 'textfield',
                            'holder' => 'div',
                            'heading' => esc_html__('Extra Class', 'dakota-theme'),
                            'param_name' => 'milo_class',
                            'value' => '',
                            'description' => esc_html__('Specify an optional extra class', 'dakota-theme')
                        )),
                    'js_view' => 'VcColumnView'
                ));
            }

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//                       MILO VC COMPONENT BUTTONS
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            function milo_button_formats_func($atts) {
                extract(shortcode_atts(array(
                    'milo_link' => '',
                    'milo_size' => '',
                    'milo_color' => 'btn-default',
                    'milo_align' => ''
                                ), $atts));

                $link_details = vc_build_link($milo_link);

                $center_before = $center_after = $newtab = $size = $class = '';

                if ($milo_size == 'small') {
                    $size = ' btn-xs';
                } else if ($milo_size == 'large') {
                    $size = ' btn-lg';
                }

                if ($milo_align != '') {
                    $center_before = "<div class='text-{$milo_align}'>";
                    $center_after = "</div>";
                }

                $link_details['target'] = esc_attr($link_details['target']);
                $link_details['url'] = esc_url($link_details['url']);
                $link_details['title'] = esc_html($link_details['title']);

                if ($link_details['target'] != '') {
                    $newtab = "target='{$link_details['target']}'";
                }
                if ($milo_color != 'none') {
                    $class = "class='btn{$size} {$milo_color}' ";
                }

                return "{$center_before}<a {$class}href='{$link_details['url']}' {$newtab}>{$link_details['title']}</a>{$center_after}";
            }

            add_shortcode('milo_button_formats', 'milo_button_formats_func');
            add_action('init', 'milo_integrate_vc_button_formats');

// integrates the custom element in the visual composer
            function milo_integrate_vc_button_formats() {
                vc_map(
                        array(
                            'name' => esc_html__('Theme Buttons', 'dakota-theme'),
                            'base' => 'milo_button_formats',
                            'category' => esc_html__('Dakota Elements', 'dakota-theme'),
                            'icon' => MILO_SHOTCODES_PATH . 'images/admin_vc_icon.png',
                            'params' => array(
                                array(
                                    'type' => 'vc_link',
                                    'heading' => esc_html__('Button title and url', 'dakota-theme'),
                                    'param_name' => 'milo_link',
                                    'description' => esc_html__('Specify the link pointing to another page', 'dakota-theme')
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Size', 'dakota-theme'),
                                    'param_name' => 'milo_size',
                                    'value' => array(
                                        esc_html__('Normal', 'dakota-theme') => 'normal',
                                        esc_html__('Large', 'dakota-theme') => 'large',
                                        esc_html__('Small', 'dakota-theme') => 'small'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Align', 'dakota-theme'),
                                    'param_name' => 'milo_align',
                                    'value' => array(
                                        esc_html__('Left', 'dakota-theme') => '',
                                        esc_html__('Center', 'dakota-theme') => 'center',
                                        esc_html__('Right', 'dakota-theme') => 'right'
                                    )
                                ),
                                array(
                                    'type' => 'dropdown',
                                    'heading' => esc_html__('Button Color set', 'dakota-theme'),
                                    'param_name' => 'milo_color',
                                    'value' => array(
                                        esc_html__('default', 'dakota-theme') => 'btn-default',
                                        esc_html__('blue', 'dakota-theme') => 'btn-blue',
                                        esc_html__('green', 'dakota-theme') => 'btn-green',
                                        esc_html__('black', 'dakota-theme') => 'btn-black',
                                        esc_html__('white', 'dakota-theme') => 'btn-white',
                                        esc_html__('none', 'dakota-theme') => 'none'
                                    )
                                )
                            )
                        )
                );
            }

        }
    }

}

if (class_exists('WPBakeryShortCodesContainer')) {

    class WPBakeryShortCode_Milo_Animations_Container extends WPBakeryShortCodesContainer {
        
    }

}

if (class_exists('WPBakeryShortCodesContainer')) {

    class WPBakeryShortCode_milo_testimonial_slider_container extends WPBakeryShortCodesContainer {
        
    }

}

if (class_exists('WPBakeryShortCodesContainer')) {

    class WPBakeryShortCode_milo_simple_slider_container extends WPBakeryShortCodesContainer {
        
    }

}

if (class_exists('WPBakeryShortCodesContainer')) {

    class WPBakeryShortCode_milo_process_container extends WPBakeryShortCodesContainer {
        
    }

}

if (class_exists('WPBakeryShortCode')) {

    class WPBakeryShortCode_milo_process extends WPBakeryShortCode {
        
    }

}