<?php
/**
 * The Template for displaying all archive products.
 *
 * Override this template by copying it to yourtheme/tp-event/templates/archive-event.php
 *
 * @author        ThimPress
 * @package       tp-event/template
 * @version       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
get_header();

/**
 * thim_wrapper_loop_start hook
 *
 * @hooked thim_wrapper_loop_end - 1
 * @hooked thim_wapper_page_title - 5
 * @hooked thim_wrapper_loop_start - 30
 */

do_action( 'thim_wrapper_loop_start' );



global $wp_query;
$_wp_query = $wp_query;
?>

<?php
/**
 * tp_event_before_main_content hook
 *
 * @hooked tp_event_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked tp_event_breadcrumb - 20
 */
do_action( 'tp_event_before_main_content' );
?>

<?php
/**
 * tp_event_archive_description hook
 *
 * @hooked tp_event_taxonomy_archive_description - 10
 * @hooked tp_event_room_archive_description - 10
 */
do_action( 'tp_event_archive_description' );
?>	<?php if( get_theme_mod( 'thim_event_layout_filter', 'select' ) == 'select' ) :?>
		<span class="icon-archive-event"><i class="fa fa-bars" aria-hidden="true"></i></span>
		<select class="thim-archive-event-select">
			<option selected value=""><?php esc_html_e( 'Event Type', 'coaching' ); ?></option>
			<option value="happening"><?php esc_html_e( 'Happening', 'coaching' ); ?></option>
			<option value="upcoming"><?php esc_html_e( 'Upcoming', 'coaching' ); ?></option>
			<option value="expired"><?php esc_html_e( 'Expired', 'coaching' ); ?></option>
		</select>
	<?php else : ?>
		<ul class="nav thim-archive-event-tabs">
		<?php
			$default_tab_title = array(
				'happening' => esc_html__( 'Happening', 'eduma' ),
				'upcoming'  => esc_html__( 'Upcoming', 'eduma' ),
				'expired'   => esc_html__( 'Expired', 'eduma' )
			);
			$first_tab = true;
			foreach ( $default_tab_title as $k => $v ) :
				if ( $first_tab ) {
					$first_tab = false;
					echo '<li class="active ' . ( $k ) . '"><a href="#tab-' . ( $k ) . '" data-toggle="tab">' . ( $v ) . '</a></li>';
				} else {
					echo '<li class="' . ( $k ) . '"><a href="#tab-' . ( $k ) . '" data-toggle="tab">' . ( $v ) . '</a></li>';
				}
			endforeach ; ?>
		</ul>
	<?php endif; ?>
	<div class="archive-event thim-list-event">
		<?php
		foreach ( array( 'happening', 'upcoming', 'expired' ) as $type ):
			get_template_part( "wp-events-manager/archive-event", $type );
		endforeach;
		?>
	</div>

<?php
/**
 * tp_event_after_main_content hook
 *
 * @hooked tp_event_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'tp_event_after_main_content' );
?>

<?php
/**
 * tp_event_sidebar hook
 *
 * @hooked tp_event_get_sidebar - 10
 */
do_action( 'tp_event_sidebar' );
?>


<?php

/**
 * thim_wrapper_loop_end hook
 *
 * @hooked thim_wrapper_loop_end - 10
 * @hooked thim_wrapper_div_close - 30
 */
do_action( 'thim_wrapper_loop_end' );

get_footer(); ?>
