<?php
/**
 * Template for displaying tab nav of single course.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/single-course/tabs/tabs.php.
 *
 * @author  ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

//$course = LearnPress::instance()->global['course'];
$course = learn_press_get_course();
$user   = learn_press_get_current_user();
if ( ! $course || ! $user ) {
	return;
}
?>

<?php $tabs = learn_press_get_course_tabs(); ?>

<?php
if ( empty( $tabs ) ) {
	return;
}

?>

<div class="thim-course-menu-landing">
	<div class="container">
		<ul class="thim-course-landing-tab">
			<?php foreach ( $tabs as $key => $tab ) { ?>
				<?php
				$classes = array( 'course-nav-tab-' . esc_attr( $key ) );
				if ( ! empty( $tab['current'] ) && $tab['current'] ) {
					$classes[] = 'active';
				}
				?>
				<li role="presentation" class="<?php echo join( ' ', $classes ); ?>">
					<a href="#<?php echo esc_attr( $tab['id'] ); ?>"><?php echo $tab['title']; ?></a>
				</li>
			<?php } ?>
		</ul>
		<?php
		$thim_single_course_payment = true;
		if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
			$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
			if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
				$thim_single_course_payment = false;
			}
		}
		if ( $thim_single_course_payment ) {
			?>
		<div class="thim-course-landing-button">
			<?php do_action( 'thim_single_course_payment' ); ?>
		</div>
		<?php } ?>
	</div>
</div>
