<?php
/**
 * Template for displaying curriculum tab of single course.
 *
 * @author   ThimPress
 * @package  Learnpress/Templates
 * @version  4.0.3
 */

defined( 'ABSPATH' ) || exit();

if ( empty( $args ) ) {
	return;
}

if ( isset( $args['section'] ) ) {
	$section   = $args['section'];
	$course_id = $args['course_id'];
} else {
	return;
}

$filters             = new LP_Section_Items_Filter();
$filters->section_id = $section['section_id'];
$section_items       = LP_Section_DB::getInstance()->get_section_items_by_section_id( $filters );
$count_items         = $section_items['total'];
$user                = learn_press_get_current_user();
?>

<li id="section-<?php echo esc_attr( $section['section_id'] ); ?>" class="section"
	data-section-id="<?php echo esc_attr( $section['section_id'] ); ?>">

	<div class="section-header">
		<div class="section-left">
			<span class="section-toggle collapse"></span>
			<h4 class="section-title">
				<?php echo ! empty( $section['section_name'] ) ? esc_html( $section['section_name'] ) : _x( 'Untitled', 'template title empty', 'learnpress' ); ?>
			</h4>
			<span class="meta">
			<?php
			if ( $user->has_enrolled_or_finished( $course_id ) ) {
				$user_course = $user->get_course_data( $course_id );
				?>
				<span
					class="step"><?php printf( '%d/%d', $user_course->get_completed_items( '', false, $section['section_id'] ), $count_items ); ?></span>
			<?php } else { ?>
				<span class="step"><?php printf( '%d', $count_items ); ?></span>
			<?php } ?>
				</span>

		</div>
	</div>
	<?php if ( ! empty( $section['section_description'] ) ) : ?>
		<p class="section-desc"><?php echo wp_kses_post( $section['section_description'] ); ?></p>
	<?php endif; ?>

	<?php
	$controller = new LP_REST_Lazy_Load_Controller();
	$request    = new WP_REST_Request();
	$request->set_param( 'sectionId', $section['section_id'] );
	$response    = $controller->course_curriculum_items( $request );
	$object_data = $response->get_data();
	?>
	<div class="section-item" data-section-id="<?php echo esc_attr( $section['section_id'] ); ?>">
		<ul class="section-content">
			<?php echo wp_kses_post( $object_data->data->content ?? $object_data->data ?? $object_data ? $object_data->data->content : '' ); ?>
		</ul>

		<?php if ( isset( $object_data ) && ! empty( $object_data->data->pages ) && $object_data->data->pages > 1 ) : ?>
			<div class="section-item__loadmore" data-page="1">
				<button><?php esc_html_e( 'Show more items', 'learnpress' ); ?></button>
			</div>
		<?php endif; ?>
	</div>

</li>
