<?php
/**
 * Template for displaying content of course without header and footer
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

defined( 'ABSPATH' ) || exit();

/**
 * If course has set password
 */
if ( post_password_required() ) {
	echo get_the_password_form();

	return;
}

/**
 * LP Hook
 */
do_action( 'learn-press/before-single-course' );
?>

<div id="learn-press-course" class="course-summary learn-press">

    <?php the_title( '<h1 class="entry-title" itemprop="name">', '</h1>' ); ?>

    <div class="course-meta">

        <?php
			$show_price_cms             = false;
			$thim_single_course_payment = $thim_show_metadata = true;
			if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
				$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
				if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
					$thim_single_course_payment = false;
					if ( 'yes' == get_post_meta( get_the_ID(), '_lp_coming_soon_metadata', true ) ) {
						$show_price_cms = true;
					}
				}
				if ( $instance_addon->is_coming_soon( get_the_ID() ) && 'no' == get_post_meta( get_the_ID(), '_lp_coming_soon_metadata', true ) ) {
					$thim_show_metadata = false;
				}
			}
			if ( $thim_show_metadata ) {
				do_action( 'thim_single_course_meta' );
			}
			?>
    </div>
    <?php
		if ( $show_price_cms ) {
			echo '<div class="course-payment">';
			do_action( 'thim_single_course_meta_cms_price' );
			echo '</div>';
		}
		if ( $thim_single_course_payment ) {
			?>
    <div class="course-payment">
        <?php do_action( 'thim_single_course_payment' ); ?>
    </div>
    <?php } ?>

    <div class="clear"></div>
    <div class="course-summary">
        <?php

			do_action( 'prerequisites_enroll_notice' );

			/**
			 * @since 3.0.0
			 *
			 *
			 * @see   learn_press_single_course_summary()
			 */
			do_action( 'learn-press/single-course-summary' );
			?>
    </div>
    <?php thim_related_courses(); ?>
</div>

<?php

/**
 * LP Hook
 */
do_action( 'learn-press/after-single-course' );