<?php
/**
 * Template for displaying course content within the loop.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$user = LP_Global::user();

$theme_options_data = get_theme_mods();
$class              = isset( $theme_options_data['thim_learnpress_cate_grid_column'] ) && $theme_options_data['thim_learnpress_cate_grid_column'] ? 'course-grid-' . $theme_options_data['thim_learnpress_cate_grid_column'] : 'course-grid-3';
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$class .= ' lpr_course';
?>

<div id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>

	<?php
	$loop_item = get_theme_mod( 'loop_course_item', '' );
	if ( class_exists( '\Thim_EL_Kit\Functions' ) && $loop_item ) {
		\Thim_EL_Kit\Utilities\Elementor::instance()->render_loop_item_content( $loop_item );
	} else {
		// @deprecated
		do_action( 'learn_press_before_courses_loop_item' );
		?>

	<div class="course-item">

		<?php
		// @since 3.0.0
		//do_action( 'learn-press/before-courses-loop-item' );
		?>

		<?php
		// @thim
		do_action( 'thim_courses_loop_item_thumb' );
		?>

		<div class="thim-course-content">
			<?php //learn_press_courses_loop_item_instructor(); ?>
			<?php
			//thim_courses_loop_item_author();
			//do_action( 'learn_press_before_the_title' );
			the_title( sprintf( '<h2 class="course-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			do_action( 'learn_press_after_the_title' );
			// edit by tuanta
			$message               = '';
			$thim_show_course_meta = true;
			if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
				$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
				if ( $instance_addon->is_coming_soon( get_the_ID() ) ) {
					$thim_show_course_meta = false;
					$message               = get_post_meta( get_the_ID(), '_lp_coming_soon_msg', true );
				}
			}
			if ( $thim_show_course_meta ) {
				?>
				<div class="middle">
					<?php learn_press_course_instructor(); ?>
					<?php learn_press_get_template( 'loop/course/students.php' ); ?>
				</div>
				<div class="course-description">
					<?php
					do_action( 'learn_press_before_course_content' );
					echo thim_excerpt( 25 );
					do_action( 'learn_press_after_course_content' );
					?>
				</div>

				<div class="course-meta">
					<?php learn_press_courses_loop_item_instructor(); ?>
					<?php thim_course_ratings(); ?>
					<?php learn_press_get_template( 'loop/course/students.php' ); ?>
					<?php LearnPress::instance()->template( 'course' )->courses_loop_item_price(); ?>
				</div>
				
				<?php
			} else {
				echo '<div class="message message-warning coming-soon-message">' . $message . '</div>';
			}
			?>
		</div>

		<?php
		// @since 3.0.0
		//do_action( 'learn-press/after-courses-loop-item' );
		?>

	</div>

		<?php
		// @deprecated
		do_action( 'learn_press_after_courses_loop_item' );
	}
	?>

</div>
