<?php
/**
 * Template for displaying archive course content.
 *
 * This template can be overridden by copying it to yourtheme/learnpress/content-archive-course.php
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.2
 */
get_header();
/**
 * thim_wrapper_loop_start hook
 *
 * @hooked thim_wrapper_loop_end - 1
 * @hooked thim_wapper_page_title - 5
 * @hooked thim_wrapper_loop_start - 30
 */

do_action( 'thim_wrapper_loop_start' );
/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

global $post, $wp_query, $lp_tax_query, $wp_query;

$show_description = get_theme_mod( 'thim_learnpress_cate_show_description' );
$show_desc        = ! empty( $show_description ) ? $show_description : '';
$cat_desc         = term_description();

$total = $wp_query->found_posts;

if ( $total == 0 ) {
	$message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'coaching' ) . '</p>';
	$index   = esc_html__( 'There are no available courses!', 'coaching' );
} elseif ( $total == 1 ) {
	$index = esc_html__( 'Showing only one result', 'coaching' );
} else {
	$courses_per_page = absint( LearnPress::instance()->settings->get( 'archive_course_limit' ) );
	$paged            = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;

	$from = 1 + ( $paged - 1 ) * $courses_per_page;
	$to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

	if ( $from == $to ) {
		$index = sprintf(
			esc_html__( 'Showing last course of %s results', 'coaching' ),
			$total
		);
	} else {
		$index = sprintf(
            esc_html__( 'Showing %s-%s of %s results', 'coaching' ),
			$from,
			$to,
			$total
		);
	}
}

$cookie_name = 'course_switch';
$layout      = ( ! empty( $_COOKIE[ $cookie_name ] ) ) ? $_COOKIE[ $cookie_name ] : 'grid-layout';

/**
 * @deprecated
 */
do_action( 'learn_press_before_main_content' );

/**
 * @since 3.0.0
 */
do_action( 'learn-press/before-main-content' );

/**
 * @deprecated
 */
do_action( 'learn_press_archive_description' );

/**
 * @since 3.0.0
 */
do_action( 'learn-press/archive-description' );

do_action( 'lp/template/archive-course/description' );

?>
<div class="thim-course-top switch-layout-container
<?php
if ( $show_desc && $cat_desc ) {
	echo 'has_desc';}
?>
">
    <div class="thim-course-switch-layout switch-layout">
        <a href="#" class="list switchToGrid<?php echo ( $layout == 'grid-layout' ) ? ' switch-active' : ''; ?>"><i
                class="fa fa-th-large"></i></a>
        <a href="#" class="grid switchToList<?php echo ( $layout == 'list-layout' ) ? ' switch-active' : ''; ?>"><i
                class="fa fa-list-ul"></i></a>
    </div>
    <div class="course-index">
        <span><?php echo( $index ); ?></span>
    </div>
    <div class="courses-searching">
        <form class="" method="get" action="<?php echo esc_url( get_post_type_archive_link( 'lp_course' ) ); ?>">
            <input type="text" value="" name="c_search"
                placeholder="<?php esc_attr_e( 'Search our courses', 'coaching' ); ?>"
                class="form-control course-search-filter" autocomplete="off" />
            <input type="hidden" value="course" name="ref" />
            <input type="hidden" name="post_type" value="lp_course">
            <input type="hidden" name="taxonomy"
                value="<?php echo esc_attr( get_queried_object()->taxonomy ?? $_GET['taxonomy'] ?? '' ); ?>">
            <input type="hidden" name="term_id"
                value="<?php echo esc_attr( get_queried_object()->term_id ?? $_GET['term_id'] ?? '' ); ?>">
            <input type="hidden" name="term"
                value="<?php echo esc_attr( get_queried_object()->slug ?? $_GET['term'] ?? '' ); ?>">
            <button type="submit"><i class="fa fa-search"></i></button>
            <span class="widget-search-close"></span>
        </form>
    </div>
</div>


<?php if ( $show_desc && $cat_desc ) { ?>
<div class="desc_cat">
    <?php echo $cat_desc; ?>
</div>
<?php } ?>


<div id="thim-course-archive"
    class="learn-press-courses <?php echo ( $layout == 'list-layout' ) ? 'thim-course-list' : 'thim-course-grid'; ?> "
    data-cookie="grid-layout">
    <?php
	/**
	 * LP Hook
	 */
	do_action( 'learn-press/before-courses-loop' );
	LearnPress::instance()->template( 'course' )->begin_courses_loop();

	if ( LP_Settings_Courses::is_ajax_load_courses() && ! LP_Settings_Courses::is_no_load_ajax_first_courses() ) {
		echo '<div class="lp-archive-course-skeleton" style="width:100%">';
		echo '</div>';
	} else {
		if ( have_posts() ) {
			while ( have_posts() ) :
				the_post();

				learn_press_get_template_part( 'content', 'course' );

			endwhile;
		} else {
			LearnPress::instance()->template( 'course' )->no_courses_found();
		}

		if ( LP_Settings_Courses::is_ajax_load_courses() ) {
			echo '<div class="lp-archive-course-skeleton no-first-load-ajax" style="width:100%; display: none">';
			echo '</div>';
		}
	}

	LearnPress::instance()->template( 'course' )->end_courses_loop();
	// do_action( 'learn-press/after-courses-loop' );
	?>

</div>


<?php

/**
 * @since 3.0.0
 */
do_action( 'learn-press/after-main-content' );

/**
 * thim_wrapper_loop_end hook
 *
 * @hooked thim_wrapper_loop_end - 10
 * @hooked thim_wrapper_div_close - 30
 */
do_action( 'thim_wrapper_loop_end' );

get_footer();
