<?php
/**
 * Thim_Builder Video config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Video' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Video extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Video constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'video';
			self::$name = esc_html__( 'Thim: Video', 'eduma' );
			self::$desc = esc_html__( 'Display video youtube or vimeo.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-video';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Width video', 'coaching' ),
					'param_name'  => 'video_width',
					'value'       => '',
					'description' => esc_html__( 'Enter width of video. Example 100% or 600. ', 'coaching' )
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Height video', 'coaching' ),
					'param_name'  => 'video_height',
					'value'       => '',
					'description' => esc_html__( 'Enter height of video. Example 100% or 600.', 'coaching' )
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Vimeo Video ID', 'coaching' ),
					'param_name'  => 'external_video',
					'description' => esc_html__( 'Enter vimeo video ID . Example if link video https://player.vimeo.com/video/61389324 then video ID is 61389324 ', 'coaching' ),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
