<?php
/**
 * Thim_Builder Progress Step config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Timeline_Slider' ) ) {
	/**
	 * Class Thim_Builder_Config_Timeline_Slider
	 */
	class Thim_Builder_Config_Timeline_Slider extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Timeline_Slider constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'timeline-slider';
			self::$name = esc_html__( 'Thim: Timeline Slider', 'eduma' );
			self::$desc = esc_html__( 'Display Timeline Slider.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-timetable';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'item',
					'params'      => array(
						array(
							'type'       => 'textfield',
							'admin_label' => false,
							'heading'    => esc_html__( 'Title', 'coaching' ),
							'std'        => esc_html__( 'Title', 'coaching' ),
							'param_name' => 'title',
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Description', 'coaching' ),
							'param_name'  => 'description',
							'std'         => esc_html__( 'Write a short description, that will describe the title or something informational and useful.', 'coaching' ),
						),
						array(
							'type'       => 'textfield',
							'admin_label' => false,
							'heading'    => esc_html__( 'Date time', 'coaching' ),
							'param_name' => 'timeline',
						),
					)
				),
				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Visible Item', 'coaching' ),
					'param_name'  => 'number',
					'std'         => 4,
				),
			);
		}
		public function get_template_name() {
			return 'base';
		}
	}
}
