<?php
/**
 * Thim_Builder Testimonials config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Testimonials' ) ) {
	/**
	 * Class Thim_Builder_Config_Testimonials
	 */
	class Thim_Builder_Config_Testimonials extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Testimonials constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'testimonials';
			self::$name = esc_html__( 'Thim: Testimonials', 'eduma' );
			self::$desc = esc_html__( 'Display testimonials.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-testimonials';

			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Layout', 'coaching' ),
					'param_name'  => 'layout',
					'value'       => array(
						esc_html__( 'Default', 'coaching' )              => 'base',
						esc_html__( 'Testimonial Layout 1', 'coaching' ) => 'layout_1',
						esc_html__( 'Testimonial Layout 2', 'coaching' ) => 'layout_2',
						esc_html__( 'Testimonial Layout 3', 'coaching' ) => 'layout_3',
						esc_html__( 'Layout Business', 'coaching' )      => 'layout_business',
						esc_html__( 'Before After Image', 'coaching' )   => 'before_after',
						esc_html__( 'Layout Home 5', 'coaching' )        => 'layout_home5',
					),
					'std'         => $this->value_options_default()['layout'],
				),

				array(
					'type'        => 'checkbox',
					'admin_label' => true,
					'heading'     => esc_html__( 'Show Full Description', 'coaching' ),
					'param_name'  => 'full_description',
					'std'         => $this->value_options_default()['full_description'],
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Limit Posts', 'coaching' ),
					'param_name'  => 'limit',
					'std'         => $this->value_options_default()['limit'],
				),

				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Items visible', 'coaching' ),
					'param_name'  => 'item_visible',
					'std'         => $this->value_options_default()['item_visible'],
				),

				array(
					'type'        => 'checkbox',
					'admin_label' => true,
					'heading'     => esc_html__( 'Auto play', 'coaching' ),
					'param_name'  => 'autoplay',
					'std'         => $this->value_options_default()['autoplay'],
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Timeout', 'coaching' ),
					'param_name'  => 'timeout',
					'description' => esc_html__( 'Set 0 to disable auto play.', 'coaching' ),
					'std'         => $this->value_options_default()['carousel_autoplay'],
				),

			);
		}

		public function value_options_default() {
			// options
			return array(
				'layout'            => 'base',
				'limit'             => '7',
				'item_visible'      => '5',
				'autoplay'          => false,
				'full_description'  => false,
				'mousewheel'        => false,
				'show_pagination'   => false,
				'show_navigation'   => true,
				'carousel_autoplay' => '0',
				'link_to_single'    => false,
			);
		}

	}
}
