<?php
/**
 * Thim_Builder Tab config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Tab' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Tab extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Tab constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'tab';
			self::$name = esc_html__( 'Thim: Tab', 'eduma' );
			self::$desc = esc_html__( 'Display Tab.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-timetable';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Tab Items', 'coaching' ),
					'param_name'  => 'tab',
					'params'      => array(
						array(
							'type'       => 'textfield',
							'admin_label' => false,
							'heading'    => esc_html__( 'Title', 'coaching' ),
							'std'        => esc_html__( 'Title', 'coaching' ),
							'param_name' => 'title',
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Content', 'coaching' ),
							'param_name'  => 'content',
							'std'         => esc_html__( 'Write a short description, that will describe the title or something informational and useful.', 'coaching' ),
						),

					)
				),
			);
		}
		public function get_template_name() {
			return 'base';
		}
	}
}
