<?php
/**
 * Thim_Builder Progress config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Progress' ) ) {
	/**
	 * Class Thim_Builder_Config_Progress
	 */
	class Thim_Builder_Config_Progress extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Progress constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'progress';
			self::$name = esc_html__( 'Thim: Progress', 'eduma' );
			self::$desc = esc_html__( 'Add progress', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-icon-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'number',
					'admin_label' => false,
					'heading'     => esc_html__( 'Input percent', 'coaching' ),
					'param_name'  => 'panel',
					'min'         => 0,
					'max'         => 100,
					'std'         => 0,
				),
				array(
					'type'        => 'number',
					'admin_label' => false,
					'heading'     => esc_html__( 'Set height', 'coaching' ),
					'param_name'  => 'height',
					'std'         => 5,
				),
				array(
					'type'        => 'colorpicker',
					'admin_label' => false,
					'heading'     => esc_html__( 'Color', 'coaching' ),
					'param_name'  => 'color',
					'value'       => '#2e8ece',
					'description' => esc_html__( 'Select the color.', 'coaching' ),
				),
				array(
					'type'        => 'colorpicker',
					'admin_label' => false,
					'heading'     => esc_html__( 'Background Color', 'coaching' ),
					'param_name'  => 'bg_color',
					'value'       => '#eaeaea',
					'description' => esc_html__( 'Select the background color.', 'coaching' ),
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
