<?php
/**
 * Thim_Builder Progress Step config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Progress_Step' ) ) {
	/**
	 * Class Thim_Builder_Config_Progress_Step
	 */
	class Thim_Builder_Config_Progress_Step extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Progress_Step constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'progress-step';
			self::$name = esc_html__( 'Thim: Progress Step', 'eduma' );
			self::$desc = esc_html__( 'Add progress step', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-our-team';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'textarea',
					'admin_label' => false,
					'heading'     => esc_html__( 'Title Description', 'coaching' ),
					'param_name'  => 'title_description',
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'panel',
					'params'      => array(
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title', 'coaching' ),
							'param_name'  => 'panel_title',
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Panel Body', 'coaching' ),
							'param_name'  => 'panel_body',
						),
					)
				),
				array(
					'type'        => 'checkbox',
					'admin_label' => false,
					'heading'     => esc_html__( 'Autoplay', 'coaching' ),
					'param_name'  => 'autoplay',
					'std'         => false,
				),
				array(
					'type'        => 'checkbox',
					'admin_label' => false,
					'heading'     => esc_html__( 'Navigation', 'coaching' ),
					'param_name'  => 'navigation',
					'std'         => false,
				),
				array(
					'type'        => 'checkbox',
					'admin_label' => false,
					'heading'     => esc_html__( 'Pagination', 'coaching' ),
					'param_name'  => 'pagination',
					'std'         => false,
				),
				array(
					'type'        => 'number',
					'admin_label' => false,
					'heading'     => esc_html__( 'Autoplay Timeout', 'coaching' ),
					'param_name'  => 'autoplayTimeout',
					'std'         => 6000,
				),
			);
		}
		public function get_template_name() {
			return 'base';
		}
	}
}
