<?php
/**
 * Thim_Builder Plan config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Plan' ) ) {
	/**
	 * Class Thim_Builder_Config_Plan
	 */
	class Thim_Builder_Config_Plan extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Plan constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'plan';
			self::$name = esc_html__( 'Thim: Plan', 'eduma' );
			self::$desc = esc_html__( 'Add Plan text.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-plan';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'panel',
					'params'      => array(
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title', 'coaching' ),
							'param_name'  => 'panel_title',
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Panel Body', 'coaching' ),
							'param_name'  => 'panel_body',
						),
					)
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
