<?php
/**
 * Thim_Builder Google Map config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Google_Map' ) ) {
	/**
	 * Class Thim_Builder_Config_Google_Map
	 */
	class Thim_Builder_Config_Google_Map extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Google_Map constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'google-map';
			self::$name = esc_html__( 'Thim: Google Map', 'eduma' );
			self::$desc = esc_html__( 'Display Google Map.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-google-map';

			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Type Maps', 'coaching' ),
					'param_name'  => 'type_map',
					'value'       => array(
						esc_html__( 'Default', 'coaching' )       => '',
						esc_html__( 'Multi Address', 'coaching' ) => 'multi_address',
						esc_html__( 'Layout 1', 'coaching' )      => 'layout-1',
					),
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Get Map By', 'coaching' ),
					'param_name'  => 'display_by',
					'value'       => array(
						esc_html__( 'Select', 'coaching' )      => '',
						esc_html__( 'Address', 'coaching' )     => 'address',
						esc_html__( 'Coordinates', 'coaching' ) => 'location',
					),
				),

				array(
					'type'          => 'textfield',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Lat', 'coaching' ),
					'param_name'    => 'location_lat',
					'param_name_so' => 'lat',
					'std'           => '41.868626',
					'dependency'    => array(
						'element' => 'display_by',
						'value'   => 'location',
					),
					'group'         => esc_html__( 'Coordinates Settings', 'coaching' ),
					'group_id'      => 'location',
				),

				array(
					'type'          => 'textfield',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Lng', 'coaching' ),
					'param_name'    => 'location_lng',
					'param_name_so' => 'lng',
					'std'           => '-74.104301',
					'dependency'    => array(
						'element' => 'display_by',
						'value'   => 'location',
					),
					'group'         => esc_html__( 'Coordinates Settings', 'coaching' ),
					'group_id'      => 'location',
				),

				array(
					'type'        => 'textarea',
					'admin_label' => true,
					'heading'     => esc_attr__( 'Map center', 'coaching' ),
					'description' => esc_attr__( 'The name of a place, town, city, or even a country. Can be an exact address too.', 'coaching' ),
					'param_name'  => 'map_center',
					'dependency'  => array(
						'element' => 'display_by',
						'value'   => 'address',
					),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Google Map API Key', 'coaching' ),
					'param_name'  => 'api_key',
					'description' => esc_html__( 'Enter your Google Map API Key. Refer on https://developers.google.com/maps/documentation/javascript/get-api-key#get-an-api-key', 'coaching' )
				),

				array(
					'type'          => 'textfield',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Height', 'coaching' ),
					'param_name'    => 'settings_height',
					'param_name_so' => 'height',
					'std'           => '480',
					'group'         => esc_html__( 'Maps Settings', 'coaching' ),
					'group_id'      => 'settings',
				),

				array(
					'type'          => 'number',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Zoom', 'coaching' ),
					'param_name'    => 'settings_zoom',
					'param_name_so' => 'zoom',
					'std'           => '12',
					'min'           => '0',
					'max'           => '21',
					'group'         => esc_html__( 'Maps Settings', 'coaching' ),
					'group_id'      => 'settings',
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Scroll to zoom', 'coaching' ),
					'description'   => esc_html__( 'Allow scrolling over the map to zoom in or out.', 'coaching' ),
					'param_name'    => 'settings_scroll_zoom',
					'param_name_so' => 'scroll_zoom',
					'std'           => true,
					'group'         => esc_html__( 'Maps Settings', 'coaching' ),
					'group_id'      => 'settings',
				),

				array(
					'type'          => 'checkbox',
					'admin_label'   => true,
					'heading'       => esc_html__( 'Draggable', 'coaching' ),
					'description'   => esc_html__( 'Allow dragging the map to move it around.', 'coaching' ),
					'param_name'    => 'settings_draggable',
					'param_name_so' => 'draggable',
					'std'           => true,
					'group'         => esc_html__( 'Maps Settings', 'coaching' ),
					'group_id'      => 'settings',
				),

				array(
					'type'        => 'checkbox',
					'admin_label' => true,
					'heading'     => esc_html__( 'Show marker at map center', 'coaching' ),
					'param_name'  => 'marker_at_center',
					'std'         => true,
					'group'       => esc_html__( 'Marker Settings', 'coaching' ),
					'group_id'    => 'markers',
				),

				array(
					'type'        => 'attach_image',
					'admin_label' => true,
					'heading'     => esc_html__( 'Marker Icon', 'coaching' ),
					'param_name'  => 'marker_icon',
					'group'       => esc_html__( 'Marker Settings', 'coaching' ),
					'group_id'    => 'markers',
				),

				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Marker positions', 'coaching' ),
					'param_name'  => 'marker_positions',
					'params'      => array(
						array(
							'type'          => 'textarea',
							'admin_label'   => false,
							'heading'       => esc_attr__( 'Place', 'coaching' ),
							'param_name'    => 'map_center',
							'param_name_so' => 'place',
						),
						array(
							'type'        => 'textfield',
							'admin_label' => true,
							'heading'     => esc_html__( 'Title Place', 'coaching' ),
							'param_name'  => 'title_place',
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_attr__( 'Content Place', 'coaching' ),
							'param_name'  => 'content_place',
						),
					),
					'dependency'  => array(
						'element' => 'type_map',
						'value'   => array( 'multi_address', 'layout-1' ),
					),
					'group'       => esc_html__( 'Marker Settings', 'coaching' ),
					'group_id'    => 'markers',
				),
			);
		}
	}
}
