<?php
/**
 * Thim_Builder Gallery Videos config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Gallery_Videos' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Gallery_Videos extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Gallery_Videos constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'gallery-videos';
			self::$name = esc_html__( 'Thim: Gallery Videos', 'eduma' );
			self::$desc = esc_html__( 'Display Gallery Videos.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-gallery-Videos';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {
 			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'value'       => '',
				),

				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Select Category', 'coaching' ),
					'param_name' => 'cad_id',
					'value'      => thim_get_cat_taxonomy( 'category', array( esc_html__( 'All', 'coaching' ) => 'all' ), true ),
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Order by', 'coaching' ),
					'param_name'  => 'orderby',
					'value'       => array(
						esc_html__( 'Popular', 'coaching' ) => 'popular',
						esc_html__( 'Recent', 'coaching' )  => 'recent',
						esc_html__( 'Title', 'coaching' )   => 'title',
						esc_html__( 'Random', 'coaching' )  => 'random',
					),
				),

				array(
					'type'        => 'dropdown',
					'admin_label' => false,
					'heading'     => esc_html__( 'Style', 'coaching' ),
					'param_name'  => 'style',
					'value'       => array(
						esc_html__( 'Normal', 'coaching' ) => '',
						esc_html__( 'Slider', 'coaching' ) => 'slider',
					),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => false,
					'heading'     => esc_html__( 'Link All Posts', 'coaching' ),
					'param_name'  => 'link',
					'value'       => '#',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => false,
					'heading'     => esc_html__( 'Text All Posts', 'coaching' ),
					'param_name'  => 'text_link',
					'value'       => 'View All',
				),

				array(
					'type'        => 'number',
					'admin_label' => false,
					'heading'     => esc_html__( 'Number Posts', 'coaching' ),
					'param_name'  => 'number_posts',
					'std'         => '8',
				),
			);
		}


	}
}
