<?php
/**
 * Thim_Builder Carousel Categories config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Course-Categories' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Daily_Support extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Daily_Support constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'daily-support';
			self::$name = esc_html__( 'Thim: Daily Support', 'eduma' );
			self::$desc = esc_html__( 'Add Daily Support box', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-icon-box';
			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this box.', 'coaching' ),
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'daily-support',
					'params'      => array(
						array(
							'type'        => 'dropdown',
							'admin_label' => false,
							'heading'     => esc_html__( 'Position', 'coaching' ),
							'param_name'  => 'position_support',
							'value'       => array(
								esc_html__( 'Left', 'coaching' ) => 'left',
								esc_html__( 'Right', 'coaching' ) => 'right',
							),
						),
						array(
							'type'        => 'attach_image',
							'admin_label' => false,
							'heading'     => esc_html__( 'Image Of Support', 'coaching' ),
							'param_name'  => 'image_support',
							'description' => esc_html__( 'Select image from media library.', 'coaching' ),
						),
						array(
							'type'        => 'textfield',
							'admin_label' => true,
							'heading'     => esc_html__( 'Support Body', 'coaching' ),
							'param_name'  => 'body_support',
						),
					)
				),

			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
