<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

class Thim_Elementor_Extend {
	private static $instance = null;

	public function __construct() {
//		add_action( 'elementor/frontend/before_enqueue_styles', array( $this, 'font_setup' ) );
		add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'font_setup' ) );
		add_action('elementor/preview/enqueue_scripts',array( $this,'thim_add_library_edit_elementor'));
		add_action('elementor/editor/before_enqueue_scripts',array( $this,'thim_add_library_edit_elementor'));
		// add widget categories
		add_action( 'elementor/elements/categories_registered', array( $this, 'register_categories' ) );

		add_action( 'elementor/widgets/register', array( $this, 'thim_register_widgets' ), 200 );

		// register font for vc
		add_action( 'vc_backend_editor_enqueue_js_css', array( $this, 'thim_vc_iconpicker_editor_jscss' ) );
		add_action( 'vc_frontend_editor_enqueue_js_css', array( $this, 'thim_vc_iconpicker_editor_jscss' ) );

		// add custom font for VC and SO and EL
		$list_icons = array( 'ionicons', 'flat_icon', 'stroke_icon' );
		foreach ( $list_icons as $list_icon ) {
 			add_filter(
				'vc_iconpicker-type-' . $list_icon,
				function () use ( $list_icon ) {
					$custom_icon = $this->thim_load_font_icon();

					return $custom_icon[$list_icon];
				}
			);

			add_filter(
				'thim-builder-so-' . $list_icon . '-icon',
				function () use ( $list_icon ) {
					$arr           = $this->thim_load_font_icon();
					$list_new_icon = array();
					if ( ! empty( $arr ) ) {
						foreach ( $arr[$list_icon] as $icons ) {
							foreach ( $icons as $key => $label ) {
								$list_new_icon[] = str_replace( array( 'pe-7s-', 'flaticon-' ), '', $key );
							}
						}
					}

					return $list_new_icon;
				}
			);
		}

		// change HTML thim_ekit_footer_header
		$this->theme_ekit_footer_header();

	}

	public function font_setup() {
 		wp_enqueue_style( 'thim-font-icon', THIM_URI . 'assets/css/thim-icons.css' );
		wp_enqueue_style( 'flaticon', THIM_URI . 'assets/css/flaticon.css' );
		wp_enqueue_style( 'font-pe-icon-7', THIM_URI . 'assets/css/font-pe-icon-7.css' );
		wp_enqueue_style( 'ionicons', THIM_URI . 'assets/css/ionicons.min.css' );
	}
	function thim_add_library_edit_elementor(){
		wp_enqueue_script( 'thim-slick', THIM_URI . 'assets/js/libs/slick.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
		wp_enqueue_script( 'owl-carousel', THIM_URI . 'assets/js/libs/owl.carousel.min.js', array( 'jquery' ), THIM_THEME_VERSION, true );
	}
	function theme_ekit_footer_header() {
		// Thim Elementor Kit
 		add_action( 'thim_ekit/header_footer/template/before_header', 'thim_print_preload', 5 );

		add_action( 'thim_ekit/header_footer/template/after_footer', function () {
			echo '</div>';
		}, 1 );
		add_action( 'thim_ekit/header_footer/template/after_footer', 'thim_footer_bottom', 5 );
		add_action( 'thim_ekit/header_footer/template/after_footer', function () {
			echo '</div></div>';
		}, 10 );

		add_action( 'thim_ekit/header_footer/template/before_header', function () {
			echo '<div id="wrapper-container" class="wrapper-container"><div class="content-pusher">';
		}, 10 );
		add_action( 'thim_ekit/header_footer/template/after_header', function () {
			echo '<div id="main-content">';
		}, 5 );
	}

	public function register_categories() {
		\Elementor\Plugin::instance()->elements_manager->add_category(
			'thim_ekit',
			array(
				'title' => esc_html__( 'Thim Basic', 'thim-elementor-kit' ),
				'icon'  => 'fa fa-plug',
			)
		);
	}

	public function thim_register_widgets( $widgets_manager ) {

		$widgets_all = apply_filters( 'thim_register_shortcode', array() );
		if ( ! empty( $widgets_all ) ) {
			foreach ( $widgets_all as $base => $widgets ) {

				if ( $base == 'general' || ( $base != 'general' && class_exists( $base ) ) ) {
					foreach ( $widgets as $widget ) {
						// unregister thim wp-widget
						$widgets_manager->unregister( 'wp-widget-' . $widget );
						// register widget for EL
						$file = THIM_DIR . "elementor-addons/$widget/$widget.php";

						if ( file_exists( $file ) ) {
							require_once $file;
							$class = ucwords( str_replace( '-', ' ', $widget ) );
							$class = str_replace( ' ', '_', $class );
							$class = sprintf( '\Elementor\Thim_%s_El', $class );

							if ( class_exists( $class ) ) {
								$widgets_manager->register( new $class() );
							}
						}
					}
				}
			}
		}
	}

	public static function get_instance() {
		if ( self::$instance == null ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	function thim_vc_iconpicker_editor_jscss() {
		wp_enqueue_style( 'thim-admin-ionicons' );
		wp_enqueue_style( 'thim-admin-font-flaticon' );
	}

	public function thim_load_font_icon() {
		$icon_widgets = file_get_contents( THIM_URI . '/assets/fonts/icons.json' );
		$icon         = json_decode( $icon_widgets, true );

		return $icon;
	}
 }

Thim_Elementor_Extend::get_instance();

if ( ! function_exists( 'thim_get_widget_template' ) ) {
	function thim_get_widget_template( $widget_base, $args = array(), $template_name = 'base' ) {
		if ( is_array( $args ) && isset( $args ) ) {
			extract( $args );
		}

		if ( false === strpos( $template_name, '.php' ) ) {
			$template_name .= '.php';
		}

		$parent_path = get_template_directory() . '/inc/widgets/' . $widget_base . '/tpl/' . $template_name;
		$child_path  = get_stylesheet_directory() . '/inc/widgets/' . $widget_base . '/' . $template_name;

		if ( file_exists( $child_path ) ) {
			$template_path = $child_path;
		} elseif ( file_exists( $parent_path ) ) {
			$template_path = $parent_path;
		} else {
			_doing_it_wrong( __FUNCTION__, sprintf( '<code>%s</code> does not exist.', $template_name ), '1.0.0' );

			return;
		}

		require $template_path;
	}
}
