<?php
/**
 * Thim_Builder Button config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Carousel_Post' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Carousel_Post extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Carousel_Post constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'carousel-post';
			self::$name = esc_html__( 'Thim: Carousel Posts', 'eduma' );
			self::$desc = esc_html__( 'Display posts with carousel.', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-carousel-posts';

			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Button Text', 'coaching' ),
					'param_name'  => 'title',
				),
				//Select Category
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Select Category', 'coaching' ),
					'param_name' => 'cat_id',
					'std'        => 'all',
					'value'      => thim_get_cat_taxonomy( 'category', array( esc_html__( 'All', 'coaching' ) => 'all' ), true ),
				),
				//Posts visible
				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Posts visible', 'coaching' ),
					'param_name'  => 'visible_post',
					'std'         => '3',
				),
				//Number posts
				array(
					'type'        => 'number',
					'admin_label' => true,
					'heading'     => esc_html__( 'Number posts', 'coaching' ),
					'param_name'  => 'number_posts',
					'std'         => '6',
				),
				//Show Navigation
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Show Navigation', 'coaching' ),
					'param_name'  => 'show_nav',
					'value'       => array(
						esc_html__( 'Select', 'coaching' ) => '',
						esc_html__( 'Yes', 'coaching' )    => 'yes',
						esc_html__( 'No', 'coaching' )     => 'no',
					),
					'group'       => esc_html__( 'Slider Settings', 'coaching' ),
				),
				//Show Pagination
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Show Pagination', 'coaching' ),
					'param_name'  => 'show_pagination',
					'value'       => array(
						esc_html__( 'Select', 'coaching' ) => '',
						esc_html__( 'Yes', 'coaching' )    => 'yes',
						esc_html__( 'No', 'coaching' )     => 'no',
					),
					'group'       => esc_html__( 'Slider Settings', 'coaching' ),
				),
				//Order by
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Order by', 'coaching' ),
					'param_name'  => 'orderby',
					'value'       => array(
						esc_html__( 'Select', 'coaching' )  => '',
						esc_html__( 'Popular', 'coaching' ) => 'popular',
						esc_html__( 'Recent', 'coaching' )  => 'recent',
						esc_html__( 'Title', 'coaching' )   => 'title',
						esc_html__( 'Random', 'coaching' )  => 'random',
					),
				),
				//Order
				array(
					'type'        => 'dropdown',
					'admin_label' => true,
					'heading'     => esc_html__( 'Order', 'coaching' ),
					'param_name'  => 'order',
					'value'       => array(
						esc_html__( 'Select', 'coaching' ) => '',
						esc_html__( 'ASC', 'coaching' )    => 'asc',
						esc_html__( 'DESC', 'coaching' )   => 'desc',
					),
				),
				// Extra class
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
