<?php
/**
 * Thim_Builder Visual Composer Button shortcode
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_VC_Button' ) ) {
	/**
	 * Class Thim_Builder_VC_Button
	 */
	class Thim_Builder_VC_Button extends Thim_Builder_VC_Shortcode {

		/**
		 * Thim_Builder_VC_Button constructor.
		 */
		public function __construct() {
			// set config class
			$this->config_class = 'Thim_Builder_Config_Button';

			parent::__construct();
		}

		function thim_convert_setting( $settings ) {
			$settings['style_options']['font_size']          = $settings['font_size'];
			$settings['style_options']['font_weight']        = $settings['font_weight'];
			$settings['style_options']['border_width']       = $settings['border_width'];
			$settings['style_options']['color']              = $settings['color'];
			$settings['style_options']['border_color']       = $settings['border_color'];
			$settings['style_options']['bg_color']           = $settings['bg_color'];
			$settings['style_options']['hover_color']        = $settings['hover_color'];
			$settings['style_options']['hover_border_color'] = $settings['hover_border_color'];
			$settings['style_options']['hover_bg_color']     = $settings['hover_bg_color'];

 			$new_icon                          = str_replace( 'fa fa-', '', $settings['icon'] );
 			$settings['icon']                  = array();
			$settings['icon']['icon']          = $new_icon;
			$settings['icon']['icon_size']     = $settings['icon_size'];
			$settings['icon']['icon_position'] = $settings['icon_position'];

			$settings['layout']['button_size'] = $settings['button_size'];
			$settings['layout']['rounding']    = $settings['rounding'];

			return $settings;
		}
	}
}

new Thim_Builder_VC_Button();
