<?php
/**
 * Thim_Builder Accordion config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_Accordion' ) ) {
	/**
	 * Class Thim_Builder_Config_Accordion
	 */
	class Thim_Builder_Config_Accordion extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_Accordion constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'accordion';
			self::$name = esc_html__( 'Thim: Accordion', 'eduma' );
			self::$desc = esc_html__( 'Add Accordion', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-timetable';

			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'description' => esc_html__( 'Provide the title for this Accordion.', 'coaching' ),
				),
				array(
					'type'        => 'param_group',
					'admin_label' => false,
					'heading'     => esc_html__( 'Items', 'coaching' ),
					'param_name'  => 'panel',
					'params'      => array(
						array(
							'type'        => 'textfield',
							'admin_label' => false,
							'heading'     => esc_html__( 'Title', 'coaching' ),
							'param_name'  => 'panel_title',
							'description' => esc_html__( 'Title of the panel', 'coaching' ),
						),
						array(
							'type'        => 'textarea',
							'admin_label' => false,
							'heading'     => esc_html__( 'Panel Body', 'coaching' ),
							'param_name'  => 'panel_body',
							'std'         => esc_html__( 'Put content', 'coaching' ),
						),
					)
				),
				array(
					'type'        => 'checkbox',
					'admin_label' => false,
					'heading'     => esc_html__( 'Show First Panel', 'coaching' ),
					'param_name'  => 'show_first_panel',
					'std'         => false,
				),
			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
