<?php
/**
 * Thim_Builder About_Me config class
 *
 * @version     1.0.0
 * @author      ThimPress
 * @package     Thim_Builder/Classes
 * @category    Classes
 * @author      Thimpress, tuanta
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Thim_Builder_Config_About_Me' ) ) {
	/**
	 * Class Thim_Builder_Config_About_Me
	 */
	class Thim_Builder_Config_About_Me extends Thim_Builder_Abstract_Config {

		/**
		 * Thim_Builder_Config_About_Me constructor.
		 */
		public function __construct() {
			// info
			self::$base = 'about_me';
			self::$name = esc_html__( 'Thim: About Me', 'eduma' );
			self::$desc = esc_html__( 'Display About Me', 'eduma' );
			self::$icon = 'thim-widget-icon thim-widget-icon-counters-box';

			parent::__construct();
		}

		/**
		 * @return array
		 */
		public function get_options() {

			// options
			return array(
				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Title', 'coaching' ),
					'param_name'  => 'title',
					'std'         => '',
				),

				array(
					'type'        => 'textarea',
					'admin_label' => true,
					'heading'     => esc_html__( 'Biographical Info', 'coaching' ),
					'param_name'  => 'info_me',
					'std'         => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Phone Number', 'coaching' ),
					'param_name'  => 'phone',
					'std'         => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Email', 'coaching' ),
					'param_name'  => 'email',
					'std'         => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Address', 'coaching' ),
					'param_name'  => 'address',
					'std'         => '',
				),

				array(
					'type'        => 'attach_image',
					'admin_label' => false,
					'heading'     => esc_html__( 'Upload Avatar Image', 'coaching' ),
					'param_name'  => 'avt_img',
					'description' => esc_html__( 'Select Upload Avatar Image.', 'coaching' ),
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Link', 'coaching' ),
					'param_name'  => 'link',
					'std'         => '',
				),

				array(
					'type'        => 'textfield',
					'admin_label' => true,
					'heading'     => esc_html__( 'Text Link', 'coaching' ),
					'param_name'  => 'text_link',
					'std'         => '',
				),

			);
		}

		public function get_template_name() {
			return 'base';
		}
	}
}
