<?php
/**
 * Custom functions for LearnPress 4.x
 *
 * @package thim
 */
add_filter( 'learn-press/override-templates', '__return_true' );
add_filter( 'lp/template-course/course_curriculum/skeleton', '__return_true' );

if ( ! function_exists( 'thim_remove_learnpress_hooks' ) ) {
	function thim_remove_learnpress_hooks() {

		add_action( 'thim_single_course_payment', LearnPress::instance()->template( 'course' )->func( 'course_pricing' ), 5 );
		add_action( 'thim_single_course_payment', LearnPress::instance()->template( 'course' )->func( 'course_buttons' ), 10 );

		if ( class_exists( 'LP_WC_Hooks' ) && thim_is_version_addons_woo_payment( '4.0.3' ) ) {
			$lp_woo_hoocks    = LP_WC_Hooks::instance();
			$buy_with_product = get_option( 'learn_press_woo-payment_buy_course_via_product' );
			if ( $buy_with_product == 'yes' ) {
				add_action( 'thim-lp-course-button-read-more', 'thim_button_read_more_course' );
			} else {
				add_action( 'thim-lp-course-button-read-more', array( $lp_woo_hoocks, 'btn_add_to_cart' ) );
				// add button remove for course free
				add_action( 'learnpress/woo-payment/course-free/btn_add_to_cart_before', 'thim_button_read_more_course' );
			}
		} else {
			add_action( 'thim-lp-course-button-read-more', 'thim_button_read_more_course' );
		}

		LearnPress::instance()->template( 'course' )->remove( 'learn-press/single-button-toggle-sidebar', array( '<input type="checkbox" id="sidebar-toggle" />', 'single-button-toggle-sidebar' ), 5 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->callback( 'single-course/instructor' ), 5 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->callback( 'single-course/meta/category' ), 15 );
		add_action( 'thim_single_course_meta', 'thim_course_forum_link', 20 );
		add_action( 'thim_single_course_meta', 'thim_course_ratings', 25 );
		add_action( 'thim_single_course_meta', LearnPress::instance()->template( 'course' )->func( 'user_progress' ), 30 );
		add_action( 'thim_single_course_meta_cms_price', LearnPress::instance()->template( 'course' )->func( 'course_pricing' ), 5 );

		// add_action('prerequisites_enroll_notice', function() {
		//     if (class_exists('LP_Addon_Prerequisites_Courses')) {
		//         return LP_Addon_Prerequisites_Courses::instance()->enroll_notice();
		//     }
		// });

		add_action(
			'init', function () {
			if ( class_exists( 'LP_Addon_Wishlist' ) && is_user_logged_in() && thim_is_version_addons_wishlist( '3' ) ) {
				$instance_addon = LP_Addon_Wishlist::instance();
				remove_action( 'learn-press/after-course-buttons', array( $instance_addon, 'wishlist_button' ), 100 );
				add_action( 'thim_inner_thumbnail_course', array( $instance_addon, 'wishlist_button' ), 10 );
			}
			if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
				$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
				remove_action( 'learn-press/course-content-summary', array( $instance_addon, 'coming_soon_countdown' ), 10 );
				add_action( 'learn-press/single-course-summary', array( $instance_addon, 'coming_soon_countdown' ), 5 );
			}
			if ( class_exists( 'LP_Addon_Prerequisites_Courses' ) ) {
				$instance_addon = LP_Addon_Prerequisites_Courses::instance();
				remove_action( 'learn-press/course-buttons', array( $instance_addon, 'enroll_notice' ), 34 );
				add_action( 'learn-press/single-course-summary', array( $instance_addon, 'enroll_notice' ), 1 );
			}
		}, 99
		);

		/**
		 *   Profile
		 */
		remove_action( 'learn-press/after-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'account_logged_in' ), 20 );
		remove_action( 'learn-press/after-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'order_comment' ), 60 );
		add_action( 'learn-press/before-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'account_logged_in' ), 9 );
		add_action( 'learn-press/before-checkout-form', LearnPress::instance()->template( 'checkout' )->func( 'order_comment' ), 11 );
		//		remove_action( 'learn-press/user-profile-account', LearnPress::instance()->template( 'profile' )->func( 'socials' ), 10 );
		//		add_action( 'learn-press/user-profile-info-after', LearnPress::instance()->template( 'profile' )->func( 'socials' ), 10 );

		//		remove_action( 'learn-press/before-user-profile', LearnPress::instance()->template( 'profile' )->func( 'header' ), 10 );
		//		remove_action( 'learn-press/profile/before-dashboard', LearnPress::instance()->template( 'profile' )->func( 'dashboard_statistic' ), 10 );
		remove_action( 'learn-press/profile/dashboard-summary', LearnPress::instance()->template( 'profile' )->func( 'dashboard_featured_courses' ), 20 );
		/*
		 * Page check out
		 */
		add_action( 'learnpress/template/pages/profile/before-content', 'thim_wapper_page_title', 5 );
		add_action( 'learnpress/template/pages/profile/before-content', 'thim_wrapper_loop_start', 10 );
		add_action( 'learnpress/template/pages/profile/after-content', 'thim_wrapper_loop_end', 10 );

		add_action( 'learnpress/template/pages/checkout/before-content', 'thim_wapper_page_title', 5 );
		add_action( 'learnpress/template/pages/checkout/before-content', 'thim_wrapper_loop_start', 10 );
		add_action( 'learnpress/template/pages/checkout/after-content', 'thim_wrapper_loop_end', 10 );

		/**
		 * @see LP_Template_Course::popup_footer_nav()
		 */
		// remove html in begin loop and end loop
		add_filter( 'learn_press_course_loop_begin', function () {
			return '';
		} );
		add_filter(
			'learn_press_course_loop_end', function () {
			return '';
		}
		);
		remove_action( 'learn-press/user-item-progress', 'lp_assignments_add_item_user_progress', 10, 3 );

	}
}

// add div for thumb image when us coming soon
function thim_class_before_thumb_image() {
	$course = learn_press_get_course();
	if ( ! $course ) {
		echo '<div>';
	}
	$no_thumbnail = ' no-thumbnail';
	if ( has_post_thumbnail() ) {
		$no_thumbnail = '';
	}
	if ( class_exists( 'LP_Addon_Coming_Soon_Courses' ) ) {
		$instance_addon = LP_Addon_Coming_Soon_Courses::instance();
		if ( $instance_addon->is_coming_soon( $course->get_id() ) ) {
			echo '<div class="thim-top-course' . $no_thumbnail . '">';
		} else {
			echo '<div>';
		}
	} else {
		echo '<div>';
	}

}

function thim_class_after_thumb_image() {
	echo '</div>';
}

add_action( 'learn-press/single-course-summary', 'thim_class_before_thumb_image', 1 );
add_action( 'learn-press/single-course-summary', 'thim_class_after_thumb_image', 6 );
add_action( 'after_setup_theme', 'thim_remove_learnpress_hooks', 15 );

add_filter( 'lp_item_course_class', 'thim_item_course_class_custom' );
function thim_item_course_class_custom( $class ) {
	$class[] = 'thim-course-grid';

	return $class;
}

/**
 * Remove Archive Course
 */
remove_action( 'learn-press/before-courses-loop', LearnPress::instance()->template( 'course' )->func( 'courses_top_bar' ) );
remove_action( 'learn-press/before-main-content', LearnPress::instance()->template( 'general' )->func( 'breadcrumb' ) );
// add div for button buy now

// add_action('learn-press/before-enroll-form','thim_before_purchase_form',1);
// add_action('learn-press/before-purchase-form','thim_before_purchase_form',1);
// function thim_before_purchase_form(){
// 	echo '<div class="lp-course-buttons">';
// 	echo '<input type="hidden" name="redirect_to" value="">';
// }
// add_action('learn-press/after-enroll-form','thim_after_purchase_form',100);
// add_action('learn-press/after-purchase-form','thim_after_purchase_form',100);
// function thim_after_purchase_form(){
// 	echo '</div>';
// }
/**
 * Remove Single Course
 */
remove_all_actions( 'learn-press/course-content-summary', 10 );
remove_all_actions( 'learn-press/course-content-summary', 15 );
remove_all_actions( 'learn-press/course-content-summary', 85 );

add_action( 'widget-grid-middle-content', LearnPress::instance()->template( 'course' )->callback( 'single-course/instructor' ), 5 );
add_action( 'widget-grid-middle-content', LearnPress::instance()->template( 'course' )->callback( 'loop/course/students' ), 10 );

function coaching_add_video_lesson() {
	lp_meta_box_textarea_field(
		array(
			'id'      => '_lp_lesson_video_intro',
			'label'   => esc_html__( 'Media intro', 'learnpress' ),
			'default' => '',
		)
	);
}

add_action( 'learnpress/lesson-settings/after', 'coaching_add_video_lesson' );

add_action(
	'learnpress_save_lp_lesson_metabox', function ( $post_id ) {
	$video = ! empty( $_POST['_lp_lesson_video_intro'] ) ? $_POST['_lp_lesson_video_intro'] : '';

	update_post_meta( $post_id, '_lp_lesson_video_intro', $video );
}
);

// add cusom field for course
function coaching_add_custom_field_course() {
	lp_meta_box_text_input_field(
		array(
			'id'          => 'thim_course_duration',
			'label'       => esc_html__( 'Duration Info', 'coaching' ),
			'description' => esc_html__( 'Display duration info', 'coaching' ),
			'default'     => esc_html__( '50 hours', 'coaching' )
		)
	);
	lp_meta_box_text_input_field(
		array(
			'id'          => 'thim_course_language',
			'label'       => esc_html__( 'Languages', 'coaching' ),
			'description' => esc_html__( 'Language\'s used for studying', 'coaching' ),
			'default'     => esc_html__( 'English', 'coaching' )
		)
	);

	lp_meta_box_textarea_field(
		array(
			'id'          => 'thim_course_media_intro',
			'label'       => esc_html__( 'Media Intro', 'coaching' ),
			'description' => esc_html__( 'Enter media intro', 'coaching' ),
			'default'     => '',
		)
	);
}

add_action( 'learnpress/course-settings/after-general', 'coaching_add_custom_field_course' );

add_action(
	'learnpress_save_lp_course_metabox', function ( $post_id ) {
	$video         = ! empty( $_POST['thim_course_media_intro'] ) ? $_POST['thim_course_media_intro'] : '';
	$language      = ! empty( $_POST['thim_course_language'] ) ? $_POST['thim_course_language'] : '';
	$duration_info = ! empty( $_POST['thim_course_duration'] ) ? $_POST['thim_course_duration'] : '';

	update_post_meta( $post_id, 'thim_course_media_intro', $video );
	update_post_meta( $post_id, 'thim_course_language', $language );
	update_post_meta( $post_id, 'thim_course_duration', $duration_info );
}
);


/**
 * @param Remaining time
 */
function thim_get_remaining_time() {

	$user   = LP_Global::user();
	$course = learn_press_get_course();

	if ( ! $course ) {
		return false;
	}

	if ( ! $user ) {
		return false;
	}

	if ( ! $user->has_enrolled_course( $course->get_id() ) ) {
		return false;
	}

	if ( $user->has_finished_course( $course->get_id() ) ) {
		return false;
	}

	$remaining_time = thim_timestamp_remaining_duration( $course );

	if ( false === $remaining_time ) {
		return false;
	}

	$time = '';
	$time .= '<div class="course-remaining-time message message-warning learn-press-message">';
	$time .= '<p>';
	$time .= sprintf( __( 'You have %s remaining for the course', 'coaching' ), $remaining_time );
	$time .= '</p>';
	$time .= '</div>';
	echo $time;
}

add_action( 'learn-press-course-curriculum', 'thim_get_remaining_time', 5 );

/**
 * custom remaning by UTC
 *
 * @param Remaining time
 */
function thim_timestamp_remaining_duration( LP_Course $course ) {

	$timestamp_remaining = - 1;
	$user                = learn_press_get_user( get_current_user_id() );

	if ( 0 === absint( $course->get_data( 'duration' ) ) ) {
		return $timestamp_remaining;
	}

	if ( $user instanceof LP_User_Guest ) {
		return $timestamp_remaining;
	}

	$course_item_data = $user->get_course_data( $course->get_id() );

	if ( ! $course_item_data ) {
		return $timestamp_remaining;
	}

	$course_start_time   = $course_item_data->get_start_time()->get_raw_date();
	$duration            = $course->get_data( 'duration' );
	$timestamp_expire    = strtotime( $course_start_time . ' +' . $duration );
	$timestamp_current   = strtotime( current_time( 'mysql' ) );
	$timestamp_remaining = $timestamp_expire - $timestamp_current;

	if ( $timestamp_remaining < 0 ) {
		$timestamp_remaining = 0;
	}

	$diff = learn_press_seconds_to_weeks( $timestamp_remaining );

	return $diff;
}


LearnPress::instance()->template( 'course' )->remove( 'learn-press/single-course-summary', array( 'single-course/content', array() ), 10 );
function single_course_content() {
	?>
<div id="course-landing" class="course-content course-summary-content">
    <?php do_action( 'learn-press/course-content-summary' ); ?>

    <?php thim_landing_tabs(); ?>
</div>
<?php
}

add_action( 'learn-press/single-course-summary', 'single_course_content', 10 );

// add class fix style use don't description in page profile
add_filter( 'learn-press/profile/class', 'thim_class_has_description_user' );
function thim_class_has_description_user( $classes ) {
	$profile = LP_Profile::instance();
	$user    = $profile->get_user();
	if ( ! isset( $user ) ) {
		return;
	}
	$bio = $user->get_description();
	if ( ! $bio ) {
		$classes[] = 'no-bio-user';
	}

	return $classes;
}

/**
 * Display thumbnail course
 */

if ( ! function_exists( 'thim_courses_loop_item_thumbnail' ) ) {
	function thim_courses_loop_item_thumbnail( $course = null ) {
		$course                      = learn_press_get_course();
		$course_thumbnail_dimensions = learn_press_get_course_thumbnail_dimensions();
		$with_thumbnail              = $course_thumbnail_dimensions['width'];
		$height_thumbnail            = $course_thumbnail_dimensions['height'];
		if ( ! $course ) {
			return;
		}
		echo '<div class="course-thumbnail">';
		echo '<a class="thumb" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '" >';
		echo thim_get_feature_image( get_post_thumbnail_id( $course->get_id() ), 'full', apply_filters( 'thim_course_thumbnail_width', $with_thumbnail ), apply_filters( 'thim_course_thumbnail_height', $height_thumbnail ), $course->get_title() );
		echo '</a>';
		thim_course_wishlist_button( $course->get_id() );
		do_action( 'thim-lp-course-button-read-more' );
		echo '</div>';
	}
}
add_action( 'thim_courses_loop_item_thumb', 'thim_courses_loop_item_thumbnail' );


if ( ! function_exists( 'thim_lp_social_user' ) ) {
	function thim_lp_social_user( $user_id = '' ) {
		global $post;
		if ( ! $user_id ) {
			$user    = learn_press_get_user( $post->post_author );
			$socials = $user->get_profile_socials( $user->get_id() );
		} else {
			$user_instructor = learn_press_get_user( $user_id );
			$socials         = $user_instructor->get_profile_socials( $user_id );
		}
		?>
<ul class="thim-author-social">
    <?php foreach ( $socials as $value ) : ?>
    <li><?php echo $value; ?></li>
    <?php endforeach; ?>
</ul>
<?php
	}
}

if ( ! function_exists( 'thim_print_rating' ) ) {
	function thim_print_rating( $rate ) {
		if ( version_compare( LP_ADDON_COURSE_REVIEW_VER, '4.0.6', '>=' ) ) {
			LP_Addon_Course_Review_Preload::$addon->get_template(
				'rating-stars.php',
				[ 'rated' => $rate ]
			);

			return;
		}

		wp_enqueue_style( 'course-review' );
		if ( ! thim_plugin_active( 'learnpress-course-review/learnpress-course-review.php' ) ) {
			return;
		}
		// learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $rate ) );
		?>
<div class="review-stars-rated">
    <ul class="review-stars">
        <li><span class="fa fa-star-o"></span></li>
        <li><span class="fa fa-star-o"></span></li>
        <li><span class="fa fa-star-o"></span></li>
        <li><span class="fa fa-star-o"></span></li>
        <li><span class="fa fa-star-o"></span></li>
    </ul>
    <ul class="review-stars filled" style="<?php echo esc_attr( 'width: ' . ( $rate * 20 ) . '%' ) ?>">
        <li><span class="fa fa-star"></span></li>
        <li><span class="fa fa-star"></span></li>
        <li><span class="fa fa-star"></span></li>
        <li><span class="fa fa-star"></span></li>
        <li><span class="fa fa-star"></span></li>
    </ul>
</div>
<?php

	}
}
function thim_redirect_to_buy_course_mobile() {
	echo '<input type="hidden" name="redirect_to" value="">';
}

add_action( 'learn-press/after-purchase-button', 'thim_redirect_to_buy_course_mobile', 5 );
add_action( 'learn-press/after-enroll-button', 'thim_redirect_to_buy_course_mobile', 5 );

// filter for package
add_filter( 'lp/upsell/archive-package/wrapper', 'lp_upsell_archive_package_wrapper_page_title' );
add_filter( 'lp/upsell/single-package/wrapper', 'lp_upsell_single_package_wrapper_page_title' );
function lp_upsell_archive_package_wrapper_page_title() {
	return array(
		thim_wapper_page_title()                                            => '',
		'<div class="learnpress-packages__wrapper site-content container">' => '</div>'
	);
}

function lp_upsell_single_package_wrapper_page_title() {
	return array(
		thim_wapper_page_title()                                            => '',
		'<div class="learnpress-packages__wrapper site-content container">' => '</div>',
		'<div class="single-package-wrapper">'                              => '</div>',
	);
}

add_filter( 'lp/upsell/archive-package/sections', function ( $section ) {
	unset( $section['header'] );

	return $section;
} );

// Overwrite support ajax course lp theme Coaching
function custom_learnpress_support_theme_no_ajax( $themes ) {

	$index = array_search( 'Coaching', $themes );
	if ( $index !== false ) {
		unset( $themes[$index] );
	}

	return $themes;
}

add_filter( 'lp/page/courses/themes/no_load_ajax', 'custom_learnpress_support_theme_no_ajax' );

// Support meta key language for thim-elementor-kit
add_filter('thim-ekit-course-key-language', function (){
	return 'thim_course_language';
});
