<?php
/**
 * Custom functions for LearnPress
 *
 * @package thim
 */

/**
 * Display course ratings
 */
if ( ! function_exists( 'thim_course_ratings' ) ) {
	function thim_course_ratings() {

		if ( ! thim_plugin_active( 'learnpress-course-review/learnpress-course-review.php' ) ) {
			return;
		}

		$course_id   = get_the_ID();
		$course_rate = learn_press_get_course_rate( $course_id );
		$ratings     = learn_press_get_course_rate_total( $course_id );
		?>
		<div class="course-review">
			<label><?php esc_html_e( 'Review', 'coaching' ); ?></label>

			<div class="value">
				<?php thim_print_rating( $course_rate ); ?>
			</div>
		</div>
		<?php
	}
}


/**
 * Display ratings count
 */

if ( ! function_exists( 'thim_course_ratings_count' ) ) {
	function thim_course_ratings_count( $course_id = null ) {
		if ( ! thim_plugin_active( 'learnpress-course-review/learnpress-course-review.php' ) || ! thim_is_version_addons_wishlist( '3' ) ) {
			return;
		}
		if ( ! $course_id ) {
			$course_id = get_the_ID();
		}
		$ratings = learn_press_get_course_rate_total( $course_id ) ? learn_press_get_course_rate_total( $course_id ) : 0;
		echo '<div class="course-comments-count">';
		echo '<div class="value"><i class="fa fa-comment"></i>';
		echo esc_html( $ratings );
		echo '</div>';
		echo '</div>';
	}
}

if ( ! function_exists( 'thim_course_wishlist_button' ) ) {
	function thim_course_wishlist_button( $course_id = null ) {
		if ( ! class_exists( 'LP_Addon_Wishlist' ) ) {
			return;
		}
		LP_Addon_Wishlist::instance()->wishlist_button( $course_id );

	}
}

if ( ! function_exists( 'thim_learnpress_page_title' ) ) {
	function thim_learnpress_page_title( $echo = true ) {
		$title = '';
		if ( get_post_type() == 'lp_course' && ! is_404() && ! is_search() || learn_press_is_courses() || learn_press_is_course_taxonomy() ) {
			if ( learn_press_is_course_taxonomy() ) {
				$title = learn_press_single_term_title( '', false );
			} else {
				$title                = esc_html__( 'All Courses', 'coaching' );
				$using_custom_heading = get_post_meta( get_the_ID(), 'thim_mtb_using_custom_heading', true );
				if ( $using_custom_heading ) {
					$thim_custom_heading = get_post_meta( get_the_ID(), 'thim_mtb_custom_title', true );
					if ( $thim_custom_heading ) {
						$title = $thim_custom_heading;
					}
				}
			}
		}
		if ( get_post_type() == 'lp_quiz' && ! is_404() && ! is_search() ) {
			if ( is_tax() ) {
				$title = learn_press_single_term_title( '', false );
			} else {
				$title = esc_html__( 'Quiz', 'coaching' );
			}
		}
		if ( $echo ) {
			echo $title;
		} else {
			return $title;
		}
	}
}


/**
 * Display related courses
 */
if ( ! function_exists( 'thim_related_courses' ) ) {
	function thim_related_courses() {
		$related_courses    = thim_lp_get_related_courses( 5 );
		$theme_options_data = get_theme_mods();
		wp_enqueue_script( 'owl-carousel' );
		if ( $related_courses->have_posts() ) {
			$layout_grid = get_theme_mod( 'thim_learnpress_cate_layout_grid', '' );
			$cls_layout  = ( $layout_grid != '' && $layout_grid != ' layout_courses_1' ) ? ' cls_courses_2' : ' ';
			?>
			<div class="thim-ralated-course<?php echo esc_attr( $cls_layout ); ?>">

				<h3 class="related-title">
					<?php esc_html_e( 'You May Like', 'coaching' ); ?>
				</h3>

				<div class="thim-course-grid">
					<div class="thim-carousel-wrapper" data-visible="3" data-itemtablet="2" data-itemmobile="1"
						 data-pagination="1">
						<?php while ( $related_courses->have_posts() ) {
							$related_courses->the_post(); ?>
							<?php
							learn_press_get_template_part( 'content', 'course' );

						} ?>
					</div>
				</div>
			</div>
			<?php
		}
	}
}

if ( ! function_exists( 'thim_lp_get_related_courses' ) ) {
	function thim_lp_get_related_courses( $limit ) {
		if ( ! $limit ) {
			$limit = 3;
		}
		$course_id = get_the_ID();

		$tag_ids = array();
		$tags    = get_the_terms( $course_id, 'course_tag' );

		if ( $tags ) {
			foreach ( $tags as $individual_tag ) {
				$tag_ids[] = $individual_tag->term_id;
			}
		}

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $course_id ),
			'post_type'           => 'lp_course'
		);

		if ( $tag_ids ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_tag',
					'field'    => 'term_id',
					'terms'    => $tag_ids
				)
			);
		}

		$query = new WP_Query( $args );

		return $query;
	}
}
if ( ! function_exists( 'thim_get_related_courses' ) ) {
	function thim_get_related_courses( $limit ) {
		if ( ! $limit ) {
			$limit = 3;
		}
		$course_id = get_the_ID();

		$tag_ids = array();
		$tags    = get_the_terms( $course_id, 'course_tag' );

		if ( $tags ) {
			foreach ( $tags as $individual_tag ) {
				$tag_ids[] = $individual_tag->slug;
			}
		}

		$args = array(
			'posts_per_page'      => $limit,
			'paged'               => 1,
			'ignore_sticky_posts' => 1,
			'post__not_in'        => array( $course_id ),
			'post_type'           => 'lp_course'
		);

		if ( $tag_ids ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => 'course_tag',
					'field'    => 'slug',
					'terms'    => $tag_ids
				)
			);
		}
		$related = array();
		if ( $posts = new WP_Query( $args ) ) {
			global $post;
			while ( $posts->have_posts() ) {
				$posts->the_post();
				$related[] = $post;
			}
		}
		wp_reset_query();

		return $related;
	}
}

/**
 * Display the link to course forum
 */
if ( ! function_exists( 'thim_course_forum_link' ) ) {
	function thim_course_forum_link() {

		if ( thim_plugin_active( 'bbpress/bbpress.php' ) && thim_plugin_active( 'learnpress-bbpress/learnpress-bbpress.php' ) && thim_is_version_addons_bbpress( '3' ) ) {
			LP_Addon_bbPress::instance()->forum_link();
		}
	}
}

if ( ! function_exists( 'thim_landing_tabs' ) ) {
	function thim_landing_tabs() {
		learn_press_get_template( 'single-course/tabs/tabs-landing.php' );
	}
}
if ( ! function_exists( 'thim_get_post_translated_duration' ) ) {
	function thim_get_post_translated_duration( $course_duration, $default = '' ) {
		$duration_arr = isset( $course_duration ) ? explode( ' ', $course_duration ) : '';
		$duration_str = '';
		if ( count( $duration_arr ) > 1 ) {
			$duration_number = $duration_arr[0];
			$duration_text   = $duration_arr[1];
			switch ( strtolower( $duration_text ) ) {
				case 'minute':
					$duration_str = sprintf( _n( '%s minute', '%s minutes', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'hour':
					$duration_str = sprintf( _n( '%s hour', '%s hours', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'day':
					$duration_str = sprintf( _n( '%s day', '%s days', $duration_number, 'learnpress' ), $duration_number );
					break;
				case 'week':
					$duration_str = sprintf( _n( '%s week', '%s weeks', $duration_number, 'learnpress' ), $duration_number );
					break;
				default:
					$duration_str = $course_duration;
			}
		}

		return empty( absint( $course_duration ) ) ? $default : $duration_str;
	}
}
/**
 * Display course info
 */
if ( ! function_exists( 'thim_course_info' ) ) {
	function thim_course_info() {
		$course = learn_press_get_course();
		if ( ! $course ) {
			return;
		}
		$course_id = $course->get_id();
		if ( thim_is_new_learnpress( '4.0' ) ) {
			$course_skill_level = get_post_meta( $course_id, '_lp_level', true );
			switch ( $course_skill_level ) {
				case 'beginner':
					$course_skill_level = esc_html__( 'Beginner', 'learnpress' );
					break;
				case 'intermediate':
					$course_skill_level = esc_html__( 'Intermediate', 'learnpress' );
					break;
				case 'expert':
					$course_skill_level = esc_html__( 'Expert', 'learnpress' );
					break;
				default:
					$course_skill_level = esc_html__( 'All levels', 'learnpress' );
			}
			$course_duration = get_post_meta( $course_id, 'thim_course_duration', true ) ? get_post_meta( $course_id, 'thim_course_duration', true ) : get_post_meta( $course_id, '_lp_duration', true );
		} else {
			$course_skill_level = get_post_meta( $course_id, 'thim_course_skill_level', true );
			$course_duration    = get_post_meta( $course_id, 'thim_course_duration', true );
		}

		$course_language = get_post_meta( $course_id, 'thim_course_language', true );

		?>
		<div class="thim-course-info">
			<h3 class="title"><?php esc_html_e( 'Course Features', 'coaching' ); ?></h3>
			<ul>
				<li class="lectures-feature">
					<i class="fa fa-files-o"></i>
					<span class="label"><?php esc_html_e( 'Lectures', 'coaching' ); ?></span>
					<span class="value"><?php
						// check with lp 4.1.4
						if ( thim_is_new_learnpress( '4.1.4' ) ) {
							echo $course->count_items( LP_LESSON_CPT );
						} else {
							echo count( $course->count_items( 'lp_lesson' ) );
						}
						?></span>
				</li>
				<li class="quizzes-feature">
					<i class="fa fa-puzzle-piece"></i>
					<span class="label"><?php esc_html_e( 'Quizzes', 'coaching' ); ?></span>
					<span class="value"><?php
						// check with lp 4.1.4
						if ( thim_is_new_learnpress( '4.1.4' ) ) {
							echo $course->count_items( LP_QUIZ_CPT );
						} else {
							echo count( $course->count_items( 'lp_quiz' ) );
						}
						?></span>
				</li>
				<?php if ( ! empty( $course_duration ) ): ?>
					<li class="duration-feature">
						<i class="fa fa-clock-o"></i>
						<span class="label"><?php esc_html_e( 'Duration', 'coaching' ); ?></span>
						<span
							class="value"><?php echo thim_get_post_translated_duration( $course_duration, esc_html__( 'Lifetime access', 'learnpress' ) ); ?></span>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $course_skill_level ) ): ?>
					<li class="skill-feature">
						<i class="fa fa-level-up"></i>
						<span class="label"><?php esc_html_e( 'Skill level', 'coaching' ); ?></span>
						<span class="value"><?php echo esc_html( $course_skill_level ); ?></span>
					</li>
				<?php endif; ?>
				<?php if ( ! empty( $course_language ) ): ?>
					<li class="language-feature">
						<i class="fa fa-language"></i>
						<span class="label"><?php esc_html_e( 'Language', 'coaching' ); ?></span>
						<span class="value"><?php echo esc_html( $course_language ); ?></span>
					</li>
				<?php endif; ?>
				<li class="students-feature">
					<i class="fa fa-users"></i>
					<span class="label"><?php esc_html_e( 'Students', 'coaching' ); ?></span>
					<?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
					<span class="value"><?php echo esc_html( $user_count ); ?></span>
				</li>
				<?php thim_course_certificate( $course_id ); ?>
				<li class="assessments-feature">
					<i class="fa fa-check-square-o"></i>
					<span class="label"><?php esc_html_e( 'Assessments', 'coaching' ); ?></span>
					<span
						class="value"><?php echo ( get_post_meta( $course_id, '_lp_course_result', true ) == 'evaluate_lesson' ) ? esc_html__( 'Yes', 'coaching' ) : esc_html__( 'Self', 'coaching' ); ?></span>
				</li>
			</ul>
			<?php thim_course_wishlist_button(); ?>
		</div>
		<?php
	}
}

/**
 * Display feature certificate
 *
 * @param $course_id
 */
function thim_course_certificate( $course_id ) {

	if ( thim_plugin_active( 'learnpress-certificates/learnpress-certificates.php' ) && thim_is_version_addons_certificates( '3' ) ) {
		?>
		<li class="cert-feature">
			<i class="fa fa-rebel"></i>
			<span class="label"><?php esc_html_e( 'Certificate', 'coaching' ); ?></span>
			<span
				class="value"><?php echo ( get_post_meta( $course_id, '_lp_cert', true ) ) ? esc_html__( 'Yes', 'coaching' ) : esc_html__( 'No', 'coaching' ); ?></span>
		</li>
		<?php
	}
}

/**
 * Display co instructors
 *
 * @param $course_id
 */
if ( ! function_exists( 'thim_co_instructors' ) ) {
	function thim_co_instructors( $course_id, $author_id ) {
		if ( ! $course_id ) {
			return;
		}

		if ( thim_plugin_active( 'learnpress-co-instructor/learnpress-co-instructor.php' ) ) {
			$instructors = get_post_meta( $course_id, '_lp_co_teacher' );
			$instructors = array_diff( $instructors, array( $author_id ) );
			if ( $instructors ) {
				foreach ( $instructors as $instructor ) {
					//Check if instructor not exist
					$user = get_userdata( $instructor );
					if ( $user === false ) {
						break;
					}
					$lp_info = get_the_author_meta( '_lp_extra_info', $instructor );
					$link    = learn_press_user_profile_link( $instructor );
					?>
					<div class="thim-about-author thim-co-instructor" itemprop="contributor" itemscope
						 itemtype="http://schema.org/Person">
						<div class="author-wrapper">
							<div class="author-avatar">
								<?php echo get_avatar( $instructor, 110 ); ?>
							</div>
							<div class="author-bio">
								<div class="author-top">
									<a itemprop="url" class="name" href="<?php echo esc_url( $link ); ?>">
										<span
											itemprop="name"><?php echo get_the_author_meta( 'display_name', $instructor ); ?></span>
									</a>
									<?php if ( isset( $lp_info['major'] ) && $lp_info['major'] ) : ?>
										<p class="job"
										   itemprop="jobTitle"><?php echo esc_html( $lp_info['major'] ); ?></p>
									<?php endif; ?>
								</div>
								<?php if ( function_exists( 'thim_lp_social_user' ) ) {
									thim_lp_social_user( $instructor );
								} ?>

								<div class="author-description" itemprop="description">
									<?php echo get_the_author_meta( 'description', $instructor ); ?>
								</div>
							</div>
						</div>
					</div>
					<?php
				}
			}
		}
	}
}

/**
 * Add format icon before curriculum items
 *
 * @param $lesson_or_quiz
 * @param $enrolled
 */
if ( ! function_exists( 'thim_add_format_icon' ) ) {
	function thim_add_format_icon( $item ) {
		$format = get_post_format( $item->get_id() );
		if ( get_post_type( $item->get_id() ) == 'lp_quiz' ) {
			echo '<span class="course-format-icon"><i class="fa fa-puzzle-piece"></i></span>';
		} elseif ( $format == 'video' ) {
			echo '<span class="course-format-icon"><i class="fa fa-play-circle"></i></span>';
		} else {
			echo '<span class="course-format-icon"><i class="fa fa-file-o"></i></span>';
		}
	}
}

add_action( 'learn_press_before_section_item_title', 'thim_add_format_icon', 10, 1 );


/** 
 * Show thumbnail single course
 */
if ( ! function_exists( 'thim_course_thumbnail_item' ) ) {
	function thim_course_thumbnail_item() {
		learn_press_get_template( 'single-course/thumbnail.php' );
	}
}
add_action( 'learn-press/single-course-summary', 'thim_course_thumbnail_item', 2 );

/**
 * Display table detailed rating
 *
 * @param $course_id
 * @param $total
 */
if ( ! function_exists( 'thim_detailed_rating' ) ) {
	function thim_detailed_rating( $course_id, $total ) {
		global $wpdb;
		$query = $wpdb->get_results(
			$wpdb->prepare(
				"
		SELECT cm2.meta_value AS rating, COUNT(*) AS quantity FROM $wpdb->posts AS p
		INNER JOIN $wpdb->comments AS c ON p.ID = c.comment_post_ID
		INNER JOIN $wpdb->users AS u ON u.ID = c.user_id
		INNER JOIN $wpdb->commentmeta AS cm1 ON cm1.comment_id = c.comment_ID AND cm1.meta_key=%s
		INNER JOIN $wpdb->commentmeta AS cm2 ON cm2.comment_id = c.comment_ID AND cm2.meta_key=%s
		WHERE p.ID=%d AND c.comment_type=%s AND c.comment_approved=%s
		GROUP BY cm2.meta_value",
				'_lpr_review_title',
				'_lpr_rating',
				$course_id,
				'review',
				'1'
			), OBJECT_K
		);
		?>
		<div class="detailed-rating">
			<?php for ( $i = 5; $i >= 1; $i -- ) : ?>
				<div class="stars">
					<div class="key">
						<?php ( $i === 1 ) ? printf( esc_html__( '%s star', 'coaching' ), $i ) : printf( esc_html__( '%s stars', 'coaching' ), $i ); ?>
					</div>
					<div class="bar">
						<div class="full_bar">
							<div
								style="<?php echo ( $total && ! empty( $query[$i]->quantity ) ) ? esc_attr( 'width: ' . ( $query[$i]->quantity / $total * 100 ) . '%' ) : 'width: 0%'; ?>">
							</div>
						</div>
					</div>
					<div
						class="value"><?php echo empty( $query[$i]->quantity ) ? '0' : esc_html( $query[$i]->quantity ); ?></div>
				</div>
			<?php endfor; ?>
		</div>
		<?php
	}
}

/*
 * Add media for lesson
 */
if ( ! function_exists( 'thim_content_item_lesson_media' ) ) {
	function thim_content_item_lesson_media() {
		$can_view_item = '';
		$user          = learn_press_get_current_user();
		$course_item   = LP_Global::course_item();
		$course        = learn_press_get_course();
		if ( $course || $user ) {
			$can_view_item = $user->can_view_item( $course_item->get_id(), $course->get_id() );
		}

		$media_intro = get_post_meta( $course_item->get_id(), '_lp_lesson_video_intro', true );
		if ( ! empty( $media_intro ) && $can_view_item ) {
			?>
			<div class="learn-press-video-intro">
				<div class="video-content">
					<?php
					echo str_replace(
						array( "<iframe", "</iframe>" ), array(
						'<div class="responsive-iframe"><iframe',
						"</iframe></div>"
					), apply_filters( 'the_content', $media_intro )
					);
					?>
				</div>
			</div>
			<?php
		}
	}
}
add_action( 'learn-press/before-course-item-content', 'thim_content_item_lesson_media', 5 );

if ( ! function_exists( 'thim_course_tabs_content' ) ) {
	function thim_course_tabs_content( $defaults ) {
		$group_tab = get_theme_mod( 'group_tabs_course', array(
			'description',
			'curriculum',
			'instructor',
			'announcements',
			'students-list',
			'package',
			'faqs',
			'review',
			'materials',
		) );
		$group_tab = str_replace( array( 'description', 'review' ), array( 'overview', 'reviews' ), $group_tab );

		foreach ( $defaults as $k => $v ) {

			switch ( $k ) {
				case 'overview':
					$v['icon'] = 'fa-bookmark';

					break;
				case 'reviews':
					$v['icon'] = 'fa-comments';
					break;
				case 'curriculum':
					$v['icon'] = 'fa-bars';
					break;
				case 'instructor':
					$v['icon'] = 'fa-user';
					break;
				case 'announcements':
					$v['icon'] = 'fa-envelope';
					break;
				case 'students-list':
					$v['icon'] = 'fa-list';
					break;
				case 'faqs':
					$v['icon'] = 'fa-question-circle';
					break;
				case 'package':
					$v['icon'] = 'fa-cube';
					break;
				case 'materials':
					$v['icon'] = 'fa-dropbox';
					break;
			}
			$defaults[$k] = $v;

			$new_prioty = array_keys( $group_tab, $k );
			if ( $new_prioty ) {
				$defaults[$k]['priority'] = $new_prioty[0];
			} else {
				unset( $defaults[$k] );
			}
		}
		$tab                      = get_theme_mod( 'default_tab_course', 'description' );
		$tab                      = str_replace( array( 'description', 'review' ), array( 'overview', 'reviews' ), $tab );
		$defaults[$tab]['active'] = true;

		return $defaults;
	}
}
add_filter( 'learn-press/course-tabs', 'thim_course_tabs_content', 9999 );


/*
 * Hide ads Learnpress
 */
if ( get_theme_mod( 'thim_learnpress_hidden_ads', false ) ) {
	remove_action( 'admin_footer', 'learn_press_footer_advertisement', - 10 );
}


/*
 * Hide LP collections excerpt
 */
if ( class_exists( 'LP_Addon_Collections' ) ) {
	remove_action( 'learn_press_collections_after_loop_item', 'learn_press_collections_after_loop_item', 5 );
}

/**
 * Check new version of addons LearnPress Woo Payment
 *
 * @return mixed
 */
function thim_is_version_addons_woo_payment( $version ) {
	if ( defined( 'LP_ADDON_WOO_PAYMENT_VER' ) ) {
		return ( version_compare( LP_ADDON_WOO_PAYMENT_VER, $version, '>=' ) );
	}

	return false;
}

/*
 * add button read more action thim-lp-course-button-read-more
 * Fix for add-on LP Woo Payment has button add-to-cart
 */
if ( ! function_exists( 'thim_button_read_more_course' ) ) {
	function thim_button_read_more_course() {
		$course = learn_press_get_course();
		if ( $course ) {
			echo '<a class="course-readmore" href="' . esc_url( get_the_permalink( $course->get_id() ) ) . '">' . esc_html__( 'Read More', 'coaching' ) . '</a>';
		}
	}
}
