<?php 
thim_customizer()->add_section(
	array(
		'id'       => 'top_heading_options',
		'panel'    => 'general',
		'title'    => esc_html__( 'Page Title Layout', 'coaching' ),
		'priority' => 20,
	)
);

// Select All Page Layout
thim_customizer()->add_field(
	array(
		'type'     => 'radio-image',
		'id'       => 'thim_top_heading',
		'label'    => esc_html__( 'Layout', 'coaching' ),
		'default'  => 'normal',
		'section'  => 'top_heading_options',
		'priority' => 75, 
		'choices'  => array(
			'normal' => THIM_URI . 'images/top-heading/top-heading-default.png',
			'style_2'   => THIM_URI . 'images/top-heading/top-heading-2.png',
			'style_3'   => THIM_URI . 'images/top-heading/top-heading-3.png',
 		),
	)
);
thim_customizer()->add_field(
	array(
		'type'     => 'select',
		'id'       => 'thim_top_heading_title_align',
		'label'    => esc_html__( 'Text Align Title', 'coaching' ),
		'default'  => 'left',
		'section'  => 'top_heading_options',
		'priority' => 75, 
		'choices'  => array(
			'left' 	=> esc_html__( 'Left', 'coaching' ) ,
			'center' 	=> esc_html__( 'Center', 'coaching' ) 
		),
		'active_callback' => array(
			array(
			'setting'  => 'thim_top_heading',
			'operator' => '===',
			'value'    => 'normal',
			)
		),
		'js_vars'   => array(
			array(
				'function' => 'css',
				'element'  => '.top_site_main .page-title-wrapper',
				'property' => 'text-align',
			)
		)
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_top_heading_line_title',
		'type'     => 'switch',
		'label'    => esc_html__( 'Line Title', 'coaching' ),
 		'section'  => 'top_heading_options',
		'default'  => true,
		'priority' => 75,
		'choices'  => array(
			true  => esc_html__( 'Yes', 'coaching' ),
			false => esc_html__( 'No', 'coaching' ),
		),
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '===',
			'value'    => 'normal',
		)),
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_image_offset_bottom',
		'type'     => 'slider',
		'label'    => esc_html__( 'Image Vertical Orientation (px)', 'coaching' ),
 		'default'  => - 270,
		'section'  => 'top_heading_options',
		'choices'  => array(
			'min'  => '-500',
			'max'  => '0',
			'step' => '1',
		), 
		'priority' => 80,
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '===',
			'value'    => 'style_3',
		)),
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_padding_top_content',
		'type'     => 'slider',
		'label'    => esc_html__( 'Padding Top Content', 'coaching' ),
 		'section'  => 'top_heading_options',
		'default'  => '0',
		'priority' => 80,
		'choices'  => array(
			'min'  => '0',
			'max'  => '200',
			'step' => '1',
		), 
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '===',
			'value'    => 'style_3',
		)),
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_top_bg_gradient',
		'type'     => 'switch',
		'label'    => esc_html__( 'Background gradient', 'coaching' ),
 		'section'  => 'top_heading_options',
		'default'  => true,
		'priority' => 80,
		'choices'  => array(
			true  => esc_html__( 'Yes', 'coaching' ),
			false => esc_html__( 'No', 'coaching' ),
		),
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '===',
			'value'    => 'style_3',
		)),
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_top_heading_padding',
		'type'     => 'dimensions',
		'label'    => esc_html__( 'Padding' ),
 		'section'  => 'top_heading_options' ,
 		'priority' => 80,
		'default'     => [
			'top'  => '90px',
 			'bottom' => '90px',
			'top-mobile'  => '50px',
 			'bottom-mobile' => '50px',
		],
		'choices'     => [
			'labels' => [
				'top'  => esc_html__( 'Top Desktop', 'coaching' ),
 				'bottom' 	=> esc_html__( 'Bottom Desktop', 'coaching' ) ,
				'top-mobile'  => esc_html__( 'Top Mobile', 'coaching' ),
 				'bottom-mobile' => esc_html__( 'Bottom Mobile', 'coaching' ),
			],
		],
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_top_heading_title_font',
		'type'     => 'dimensions',
		'label'    => esc_html__( 'Title Font Size', 'coaching' ),
 		'section'  => 'top_heading_options',
		'description' => esc_html__( 'Text Transform you can use "none, uppercase, capitalize, lowercase ..." ---
									Font Weight you can use "normal, bold, 600 ..."', 'coaching' ),
 		'priority' => 80,
		'default'     => [
			'size-desktop'  => '48px',
 			'size-mobile' => '35px',
			'text-transform' => 'uppercase' , 
			'weight' => 'bold' ,
		],
		'choices'     => [
			'labels' => [
				'size-desktop'  => esc_html__( 'Desktop', 'coaching' ),
 				'size-mobile' 	=> esc_html__( 'Mobile', 'coaching' ) ,
				'text-transform' => esc_html__( 'Text Transform', 'coaching' ) , 
				'weight' => esc_html__( 'Font Weight', 'coaching' ),
			],
		],
	)
);

thim_customizer()->add_field(
	array(
		'id'       => 'thim_breacrumb_font_size',
		'type'     => 'dimension',
		'label'    => esc_html__( 'Breacrumb Font Size', 'coaching' ),
 		'section'  => 'top_heading_options', 
		'description' => esc_html__( 'input font size breacrumb ex: 13px, 100%, 1em, 1rem', 'kirki' ),
 		'priority' => 80,
		'default'=> '1em', 
	)
);
thim_customizer()->add_field(
	array(
		'id'        => 'thim_breacrumb_bg_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Breacrumb Background Color', 'coaching' ),
 		'section'   => 'top_heading_options',
		'priority'  => 80,
		'choices' => array ('alpha'     => true),
 		'transport' => 'postMessage',
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '==',
			'value'    => 'normal',
		)),
 	)
); 
thim_customizer()->add_field(
	array(
		'id'        => 'thim_breacrumb_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Breacrumb Color', 'coaching' ),
 		'section'   => 'top_heading_options',
		'priority'  => 80,
		'choices' => array ('alpha'     => true),
		'default'   => '#666',
		'transport' => 'postMessage',
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '!=',
			'value'    => 'style_3',
		)),
 	)
); 

thim_customizer()->add_field(
	array(
		'id'        => 'thim_breacrumb_border_color',
		'type'      => 'color',
		'label'     => esc_html__( 'Breacrumb Border Color', 'coaching' ),
 		'section'   => 'top_heading_options',
		'priority'  => 80,
		'choices' => array ('alpha'     => true),
 		'transport' => 'postMessage',
		'active_callback' => array(array(
			'setting'  => 'thim_top_heading',
			'operator' => '!=',
			'value'    => 'style_3',
		)),
 	)
); 