<?php

namespace Elementor; 

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Testimonials_El extends Widget_Base {

	public function get_name() {
		return 'thim-testimonials';
	}

	public function get_title() {
		return esc_html__( 'Thim: Testimonials', 'coaching' );
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-testimonials';
	}
	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-testimonials';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content',
			[
				'label' => __( 'Testimonials', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Heading Text', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => false
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'base'            => esc_html__( 'Default', 'coaching' ),
					'layout_1'        => esc_html__( 'Testimonial Layout 1', 'coaching' ),
					'layout_2'        => esc_html__( 'Testimonial Layout 2', 'coaching' ),
					'layout_3'        => esc_html__( 'Testimonial Layout 3', 'coaching' ),
					'layout_business' => esc_html__( 'Layout Business', 'coaching' ),
					'before_after'    => esc_html__( 'Before After Image', 'coaching' ),
					'layout_home5'    => esc_html__( 'Layout Home 5', 'coaching' ),
				],
				'default' => 'base'
			]
		);

		$this->add_control(
			'limit',
			[
				'label'   => esc_html__( 'Limit Posts', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 7,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control( 
			'item_visible',
			[
				'label'   => esc_html__( 'Item Visible', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 5,
				'min'     => 1,
				'step'    => 1
			]
		);
		$this->add_control( 
			'item_visible_tablet',
			[
				'label'   => esc_html__( 'Item Visible Tablet', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 1,
				'min'     => 1,
				'step'    => 1,
				'condition' => array(
					'layout' => ['base','layout_1','layout_home5'], 
				),
			]
		);

		$this->add_control(
			'timeout',
			[
				'label'   => esc_html__( 'Timeout', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6000,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'   => esc_html__( 'Auto play?', 'coaching' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => false,
			]
		);

		$this->add_control(
			'full_description',
			[
				'label' => esc_html__( 'Show Full Description', 'coaching' ),
				'type'  => Controls_Manager::SWITCHER,
			]
		);


		$this->end_controls_section();
		$this->testimonial_tabs_style_sc();
	}
	protected function testimonial_tabs_style_sc(){
		$this->start_controls_section(
			'testimonials_section',
			array(
				'label'     => esc_html__( 'Headding', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
        $this->add_control(
			'testimonials_headding_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .testimonial-headding .widget-title' => 'color: {{VALUE}}!important;',
				],
			]
		); 
		$this->add_group_control( 
			Group_Control_Typography::get_type(), 
			[
				'name'     => 'testimonials_headding_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .testimonial-headding .widget-title',
			]
		);
		$this->add_responsive_control(
			'testimonials_headding_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ), 
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .testimonial-headding .widget-title' => 'text-align: {{VALUE}};', 
                ],
			]
		);
		$this->add_responsive_control( 
			'testimonials_headding_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .testimonial-headding .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}}; position: static !important;'
				],
			]
		);
        $this->end_controls_section();
		$this->start_controls_section(
			'testimonial_item_layout_title',
			array(
				'label'     => esc_html__( 'Item', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'testimonial_item_style_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['base','layout_1','layout_2','before_after'],
				),
			]
		);
		$this->add_control(
			'testimonial_item_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .title a' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .slides-content .slide-content .title,{{WRAPPER}} .testimonial-item .title:before' => 'color: {{VALUE}}!important;',
 
				],
				'condition' => array(
					'layout' => ['base','layout_1','layout_2','before_after'],
				),
			]
		);
		$this->add_group_control(  
			Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_item_title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .title a',
				'condition' => array(
					'layout' => ['base','layout_1','layout_2','before_after'],
				),
			]
		);
		$this->add_responsive_control( 
			'testimonials_title_space_top',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),   
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .testimonial-item .testimonial-content .title ,{{WRAPPER}} .slides-content .slide-content .title,{{WRAPPER}} .title' => 'margin-top: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['base','layout_1','layout_2','before_after'],
				),
				
			]
		);
		$this->add_responsive_control( 
			'testimonials_title_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .testimonial-item .testimonial-content .title ,{{WRAPPER}} .slides-content .slide-content .title,{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['base','layout_1','layout_2','before_after'],
				),
			]
		);
		$this->add_control(
			'testimonial_item_style_des',
			[
				'label' => esc_html__( 'Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'testimonial_item_des_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .testimonial-item .testimonial-content .description .thim-excerpt' => 'color: {{VALUE}};',
					'{{WRAPPER}} .slides-content .slide-content .description .thim-excerpt' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-testimonial-home5 .item .left-testimonials .description .thim-excerpt' => 'color: {{VALUE}};',
					'{{WRAPPER}} .testimonial-item .testimonial-content .description.full_content' => 'color: {{VALUE}};',
					'{{WRAPPER}} .slides-content .slide-content .description.full_content' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-testimonial-home5 .item .left-testimonials .description.full_content' => 'color: {{VALUE}};',
				],
			]
		); 
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_item_des_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .testimonial-item .testimonial-content .description .thim-excerpt,{{WRAPPER}} .description .thim-excerpt',
			]
		);
		$this->add_responsive_control( 
			'testimonials_des_space_top',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),  
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -100,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-testimonial-home5 .item .left-testimonials .description' => 'margin-top: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['layout_home5'],
				),
			]
		);
		$this->add_responsive_control( 
			'testimonials_des_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .testimonial-item .testimonial-content .description .thim-excerpt,{{WRAPPER}} .description' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				
			]
		);
		$this->add_control( 
			'testimonial_item_style_author',
			[
				'label' => esc_html__( 'Author', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'testimonial_item_author_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .testimonial-item .author' => 'color: {{VALUE}};',
					'{{WRAPPER}} .slides-content .slide-content .author,{{WRAPPER}} .layout_business .author a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-testimonial-home5 .item .left-testimonials .content .content-info .author a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_item_author_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .testimonial-item .author,{{WRAPPER}} .testimonial-thumbnail .author,{{WRAPPER}} .thim-round-testimonial.layout_business .author a',
			]
		);
		$this->add_control(
			'testimonial_item_style_job',
			[
				'label' => esc_html__( 'Job', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'testimonial_item_job_color',  
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .regency' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .slides-content .slide-content .regency' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-testimonial-home5 .item .left-testimonials.regency' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .thim-round-testimonial.layout-3  .regency,{{WRAPPER}} .thim-round-testimonial.layout-3  .content .author' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(), 
			[
				'name'     => 'testimonial_item_job_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-testimonial-carousel .testimonial-item  .regency,{{WRAPPER}} .thim-widget-testimonials .thim-testimonial-carousel.layout-1 .testimonial-thumbnail .regency,{{WRAPPER}} .thim-round-testimonial.layout-3  .content .author .regency,{{WRAPPER}} .thim-round-testimonial.layout_business .regency',
			]
		);
		$this->add_control(
			'testimonial_item_style_bgcolor',
			[
				'label' => esc_html__( 'Background', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['layout_1'],
				),
			]
		);
		$this->add_responsive_control( 
			'testimonials_job_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-round-testimonial.layout_business .regency' => 'margin-bottom: {{SIZE}}{{UNIT}}; position: static !important;'
				],
				'condition' => array(
					'layout' => ['layout_business'],
				),
			]
		);
		$this->add_control(
			'testimonial_item_bgcolor', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .testimonial-item .testimonial-content .wrap-box' => 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .testimonial-item .testimonial-content .wrap-box:before' => 'border-right-color: {{VALUE}}!important;',
					
				],
				'condition' => array(
					'layout' => ['layout_1'],
				),
			]
		);
		$this->end_controls_section();
	}
	protected function render() {

		$settings = $this->get_settings_for_display();

		$args                 = array();
		$args['before_title'] = '<div class="testimonial-headding"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings,
			'args'     => $args
		), $settings['layout'] );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Testimonials_El() );
