<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Tab_El extends Widget_Base { 

	public function get_name() { 
		return 'thim-tab';
	}

	public function get_title() {
		return esc_html__( 'Thim: Tab', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-tab';
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-tab';
	}
	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() { 
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Tab', 'coaching' )
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                "label"   => esc_html__( "Tab Title", 'coaching' ),
                "default" => esc_html__("Tab Title", 'coaching'),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'content',
            [
                "label" => esc_html__( "Content", 'coaching' ),
                'type'        => Controls_Manager::TEXTAREA,
            ]
        );


        $this->add_control(
            'tab',
            [
                'label'       => esc_html__( 'List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ title }}}',
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();
		$this->start_controls_section(
			'thim_tab_settings',
			[
				'label'     => esc_html__( 'Tabs Settings', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'auto_width',
			[
				'label' => esc_html__( 'Auto Width', 'coaching' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'coaching' ),
				'label_off' => esc_html__( 'No', 'coaching' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		$this->add_responsive_control( 
			'text_tab_padding',
			[
				'label'      => esc_html__( 'Padding item', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'tab_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}}.thim-widget-tab .nav-tabs li a'
			]
		);
		$this->start_controls_tabs( 'tabs_tab_item' );
		$this->start_controls_tab(
			'tabs_normal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_control(
			'tabs_item_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'bg_tabs_item_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li a' => 'background-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'border_tabs_item_color',
			[
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li a,{{WRAPPER}}.thim-widget-tab .nav-tabs,{{WRAPPER}}.thim-widget-tab .tab-content' => 'border-color: {{VALUE}};'
				]
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tabs_item_active',
			[
				'label' => esc_html__( 'Active', 'coaching' ),
			]
		);
		$this->add_control(
			'text_items_color_active',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li.active a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'bg_text_items_color_active',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li.active a' => 'background-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'border_text_items_color_active',
			[
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}}.thim-widget-tab .nav-tabs li.active:before' => 'background-color: {{VALUE}};',
				]
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
			'content_tab_settings',
			[
				'label' => esc_html__( 'Content Tabs Settings', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'tabs_content_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tab-content .tab-pane,{{WRAPPER}} .thim-widget-step .tab-content-step .tab-pane' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'bg_tabs_content_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tab-content,{{WRAPPER}} .thim-widget-step .tab-content-step .tab-pane' => 'background-color: {{VALUE}};'
				],
			]
		);

		$this->add_responsive_control(
			'text_content_tab_padding',
			[
				'label'      => esc_html__( 'Padding item', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}}.thim-widget-tab .tab-content .tab-pane' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'content_tab_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}}.thim-widget-tab .tab-content,{{WRAPPER}} .thim-widget-step .tab-content-step .tab-pane'
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

        thim_get_widget_template( $this->get_base(), array(
            'instance' => $settings
        ) );
	}

} 

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Tab_El() );
