<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Progress_Step_El extends Widget_Base { 

	public function get_name() {
		return 'thim-progress-step';
	}

	public function get_title() {
		return esc_html__( 'Thim: Progress Step', 'coaching' );
	}

	protected function get_html_wrapper_class() {
		return 'thim-widget-progress-step';
	}
	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-progress-step';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Progress Step', 'coaching' )
			]
		);

        $this->add_control(
            'title',
            [
                'label'               =>  esc_html__( 'Title', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title_description',
            [
                'label' => esc_html__('Title Description', 'coaching'),
                'type'        => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'panel_title',
            [
                'label' => esc_html__('Panel Title', 'coaching'),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'panel_body',
            [
                'label' => esc_html__('Panel Body', 'coaching'),
                'type'        => Controls_Manager::TEXTAREA,
            ]
        );

        $this->add_control(
            'panel',
            [
                'label'       => esc_html__( 'List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ panel_title }}}',
                'separator'   => 'before'
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'type'    => Controls_Manager::SWITCHER,
                'label' => esc_html__('Autoplay', 'coaching'),
                'default' => false
            ]
        );

        $this->add_control(
            'navigation',
            [
                'type'    => Controls_Manager::SWITCHER,
                'label' => esc_html__('Navigation', 'coaching'),
                'default' => false
            ]
        );

        $this->add_control(
            'pagination',
            [
                'type'    => Controls_Manager::SWITCHER,
                'label' => esc_html__('Pagination', 'coaching'),
                'default' => false
            ]
        );

        $this->add_control(
            'autoplayTimeout',
            [
                'type'    => Controls_Manager::NUMBER,
                'label' => esc_html__('Autoplay Timeout', 'coaching'),
                'description' => esc_html__( 'Set time out for slide auto play (millisecond).', 'coaching' ),
            ]
        );

		$this->end_controls_section();
        $this->start_controls_section(
			'process_step_style',
			[
				'label'     => esc_html__( 'Title', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				
			] 
		);
      
		$this->add_control(
			'process_step_style_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-progress-step  .widget-title' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'process_step_style_title_typography',
				'selector' => '{{WRAPPER}} .thim-progress-step  .widget-title',
			]
		);
		
		$this->end_controls_section();
		$this->progress_step_tabs_Style_sc();
		$this->progress_step_tabs_nav_Style_sc();
	}
	protected function progress_step_tabs_Style_sc(){
		$this->start_controls_section(
			'section_proces_step_list',
			[
				'label' => esc_html__( 'List', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'progcess_stpe_hading_numbr',
			[
				'label' => esc_html__( ' Number', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'process_step_style_number_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .circle-inner' => 'color: {{VALUE}} !important;',
				],
			]
		);
        $this->add_control(
			'process_step_style_number_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .circle-border'=> 'background: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'text_content_process_border_radius',
			array(
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .circle-border'=> 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
 				),
			)
		);
		$this->add_control(
			'progcess_stpe_hading_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'process_step_style_list_title_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .panel-title' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'process_step_style_list_title_typography',
				'selector' => '{{WRAPPER}} .panel-title',
			]
		);
		$this->add_control(
			'progcess_stpe_hading_content',
			[
				'label' => esc_html__( 'Content', 'coaching' ), 
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
			'process_step_style_list_content_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .panel-body' => 'color: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'process_step_style_list_content_typography',
				'selector' => '{{WRAPPER}} .panel-body',
			]
		);
        $this->end_controls_section();
	}

	protected function progress_step_tabs_nav_Style_sc(){
		$this->start_controls_section(
			'carousel_post__nav_style_tab',
			[
				'label'     => esc_html__( 'Nav', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'navigation' => 'yes',
				]
			]
		);
		$this->add_control(
			'carousel_post__nav_offset_position_v',
			array(
				'label'       => esc_html__( 'Vertical Position', 'coaching' ),
				'type'        => Controls_Manager::CHOOSE,
				'toggle'      => false,
				'default'     => '50',
				'options'     => array(
					'0'   => array(
						'title' => esc_html__( 'Top', 'coaching' ),
						'icon'  => 'eicon-v-align-top',
					),
					'50'  => array(
						'title' => esc_html__( 'Middle', 'coaching' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'100' => array(
						'title' => esc_html__( 'Bottom', 'coaching' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'render_type' => 'ui',
				'selectors'   => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => 'top:{{VALUE}}%;',
				],
			)
		);
		$this->add_responsive_control(
			'carousel_post__nav_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical align', 'coaching' ),
				'type'        => Controls_Manager::NUMBER,
				'label_block' => false,
				'min'         => - 500,
				'max'         => 500,
				'step'        => 1,
				'selectors'   => array(
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => '-webkit-transform: translateY({{VALUE}}px); -ms-transform: translateY({{SIZE}}px); transform: translateY({{SIZE}}px);',
				),
			)
		);

		$this->add_responsive_control(
			'carousel_post__nav_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 14,
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->start_controls_tabs(
			'carousel_post__nav_hover_normal_tabs'
		);

		$this->start_controls_tab(
			'carousel_post__nav_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_color_normal',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div i' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_normal',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_normal',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'carousel_post__nav_border_normal',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-progress-step-carousel .owl-nav > div',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_section();
	}
	protected function render() { 
		$settings = $this->get_settings_for_display();

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		));
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Progress_Step_El() );
