<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Program_El extends Widget_Base {

	public function get_name() {
		return 'thim-program';
	}

	public function get_title() {
		return esc_html__( 'Thim: Program', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-program';
	}
	protected function get_html_wrapper_class() {
		return 'thim-widget-program';
	}
	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Program', 'coaching' )
			]
		);

        $this->add_control(
            'title',
            [
                'label'               =>  esc_html__( 'Title', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'text_align',
            [
                "label"   => esc_html__( "Text Align", 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    "text-center" 	=> esc_html__( "Text Center", 'coaching' ),
                    "text-left" 	=> esc_html__( "Text Left", 'coaching' ),
                    "text-right" 	=> esc_html__( "Text Right", 'coaching' ),
                ],
                "default" => "text-center",
            ]
        );

        $this->add_control(
            'style',
            [
                "label"   => esc_html__( "Style", 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    "base"					=> esc_html__( "Normal", 'coaching' ),
                    "slider" 	=> esc_html__( "Slider", 'coaching' ),
                ],
                 "default" => "base",
            ]
        );
        $this->add_control(
			'item_to_show',
			[
				'label'   => esc_html__( 'Item to show', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
                'max'     => 10,
				'step'    => 1,
                'condition' => array(
                    'style' => [ 'slider' ],
                )
			]
		);
        $this->add_control(
            'columns',
            [
                "label"   => esc_html__( "Columns", 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    "2"                  => esc_html__( "2 Columns", 'coaching' ),
                    "3"                  => esc_html__( "3 Columns", 'coaching' ),
                    "4"                  => esc_html__( "4 Columns", 'coaching' ),
                    "6"                  => esc_html__( "6 Columns", 'coaching' ),

                ],
                "default" => "3",
                'condition' => array(
                    'style' => [ 'base' ]
                )
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'program_title',
            [
                'label'       =>  esc_html__( 'Title Of Program', 'coaching' ),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'program_link',
            [
                'label'       =>  esc_html__( 'Link Of Program', 'coaching' ),
                'type'        => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'program_image',
            [
                'label'       =>  esc_html__( 'Image Of Program', 'coaching' ),
                'type'        => Controls_Manager::MEDIA,
            ]
        );

        $this->add_control(
            'program',
            [
                'label'       => esc_html__( 'List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ program_title }}}',
                'separator'   => 'before'
            ]
        );
		$this->end_controls_section();
        $this->program_tabs_style_sc();

	}
    protected function program_tabs_style_sc(){
        $this->start_controls_section(
			'program_style_section',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'program_title_color',
            [
                'label' => esc_html__( 'Title Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim_program  .widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'program_title_typography',
				'selector' => '{{WRAPPER}} .thim_program  .widget-title',
			]
		);
        $this->add_responsive_control(
			'program__space_between',
			[
				'type' => \Elementor\Controls_Manager::SLIDER,
				'label' => esc_html__( 'Spacing', 'textdomain' ),
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .thim_program  .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'program_item_style_section',
			[
				'label' => esc_html__( 'Item', 'coaching' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);


        $this->add_control(
            'program_item_title_color',
            [
                'label' => esc_html__( 'Title Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-program a' => 'color: {{VALUE}}  !important;',
                ],

            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'program_item_title_typography',
				'selector' => '{{WRAPPER}} .thim_program_container .thim_program .item-program .image-program .title-program a',
			]
		);
        $this->add_control(
            'program_item_hover_bg_color',
            [
                'label' => esc_html__( 'Hover Background Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-program' => 'background: linear-gradient(transparent,{{VALUE}})  !important;',
                ],

            ]
        );
        $this->add_responsive_control(
			'program_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .title-program' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',

  				],
			]
		);
        $this->end_controls_section();
    }

	protected function render() {
		$settings = $this->get_settings_for_display();
		// Map variables between Elementor and SiteOrigin
//		$settings['program']['program_image'] = isset($settings['program']['program_image']) ? $settings['program']['program_image']['id'] : '';
 		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		), $settings['style'] );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Program_El() );
