<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) { 
	exit;
}

class Thim_Our_Team_El extends Widget_Base {

	public function get_name() {
		return 'thim-our-team';
	}

	public function get_title() {
		return esc_html__( 'Thim: Our Team', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-our-team';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Our Team', 'coaching' )
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'base'   => esc_html__( 'Default', 'coaching' ),
                    'layout-business' => esc_html__( 'Layout Business', 'coaching' ),
				],
				'default' => 'base'
			]
		);

		$this->add_control(
			'cat_id',
			[
				'label'   => esc_html__( 'Select Category', 'coaching' ),
				'type'    => Controls_Manager::SELECT2,
				'options' =>  thim_get_cat_taxonomy( 'our_team_category', array( 'all' => esc_html__( 'All', 'coaching' ) )  ),
				'default' => 'all'
			]
		);

		$this->add_control(
			'number_post',
			[
				'label'   => esc_html__( 'Number Posts', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 5,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control(
			'columns',
			[
				'label'       => esc_html__( 'Columns', 'coaching' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => false,
				'options'     => [
					'1' => esc_html__( '1', 'coaching' ),
					'2' => esc_html__( '2', 'coaching' ),
					'3' => esc_html__( '3', 'coaching' ),
					'4' => esc_html__( '4', 'coaching' )
				],
				'default'     => '4'
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label'     => esc_html__( 'Show Pagination?', 'coaching' ),
				'type'      => Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'condition' => array(
					'layout' => [ 'slider' ]
				)
			]
		);

		$this->add_control(
			'link_member',
			[
				'label'   => esc_html__( 'Enable Link To Member?', 'coaching' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => '',
			]
		);

		$this->add_control(
			'text_link',
			[
				'label'       => esc_html__( 'CTA Button Text', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'link',
			[
				'label'         => esc_html__( 'CTA Button Link', 'coaching' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'coaching' ),
				'show_external' => false,
				'default'       => [
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				],
			]
		);


		$this->end_controls_section();
		$this->start_controls_section(
			'our_team_layout_image',
			array(
				'label'     => esc_html__( 'Image', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => ['base'],
				),
			)
		);
		$this->add_responsive_control(
			'our_team_width',
			[
				'label' => esc_html__( 'Width', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .our-team-item .our-team-image img' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .our-team-item .our-team-image:before' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->add_control(
			'our_team_overlay', 
			[
				'label'     => esc_html__( 'Overlay Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .our-team-item .our-team-image:before' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'our_team_layout_title',
			array(
				'label'     => esc_html__( 'Content', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'cour_team_style_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'our_team_social_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .content-team .title,{{WRAPPER}} .list_team_business .title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .list_team_business .slide-content .title:after'=>  'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'our_team_social_title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .content-team .title,{{WRAPPER}} .list_team_business .title',
			]
		);
		$this->add_responsive_control(
			'our_team_social_title_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .content-team .title,{{WRAPPER}} .list_team_business .title'=> 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_control(
			'cour_team_style_regency',
			[
				'label' => esc_html__( 'Regency', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->add_control(
			'our_team_social_regency_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .content-team .regency' => 'color: {{VALUE}};',
 
				],
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'our_team_social_regency_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .content-team .regency',
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->add_responsive_control(
			'our_team_social_regency_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .content-team .regency' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['base'],
				),
			]
		);
		$this->add_control(
			'cour_team_style_des',
			[
				'label' => esc_html__( 'Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['layout-business'],
				),
			]
		);
		$this->add_control(
			'our_team_social_des_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .list_team_business .slide-content .content-team' => 'color: {{VALUE}};',
 
				],
				'condition' => array(
					'layout' => ['layout-business'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'our_team_social_des_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .list_team_business .slide-content .content-team',
				'condition' => array(
					'layout' => ['layout-business'],
				),
			]
		);
		$this->add_responsive_control(
			'our_team_social_des_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .list_team_business .slide-content .content-team' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
				'condition' => array(
					'layout' => ['layout-business'],
				),
			]
		);
		$this->add_control(
			'our_team_social', 
			[
				'label' => esc_html__( 'Social', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'our_team_social_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .social-team a' => 'color: {{VALUE}};',
 
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'our_team_social_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .social-team a',
			]
		);
		$this->end_controls_section();
		$this->our_team_button();
	}
	protected function our_team_button(){
		$this->start_controls_section(
			'our_team_header_section',
			array(
				'label'     => esc_html__( 'Button', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => ['base'],
				),
			)
		);
		// start tab for item
		$this->start_controls_tabs(
			'our_team_bt__tabs',
		);

		// start normal tab
		$this->start_controls_tab(
			'our_team_bt_style_normal2',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_control(
			'our_team_bt__color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'our_team_bt__bgcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'our_team_bt__typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'bt_all_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .wrapper-lists-our-team a.join-our-team',
			]
		);
		$this->add_responsive_control(
			'our_team_bt_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'bt_all_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' =>'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'our_team_bt__style_hover2',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'our_team_bt__color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'our_team_bt__bgcolor_hover', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .wrapper-lists-our-team a.join-our-team:hover' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'bt__box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .wrapper-lists-our-team a.join-our-team:hover',
			]
		);
		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$settings['link'] = isset($settings['link']) ? $settings['link']['url'] : ''; 
		$settings['css_animation'] = '';

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		), $settings['layout'] );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Our_Team_El() );
