<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Navigation_Menu_El extends Widget_Base {

	public function get_name() {
		return 'thim-navigation-menu';
	}

	public function get_title() {
		return esc_html__( 'Thim: Navigation Menu', 'coaching' );
	}

    public function get_icon() {
        return 'thim-widget-icon thim-widget-icon-navigation-menu';
    }

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	public function get_navigation_menu() {
		$menus        = wp_get_nav_menus();
		$options      = array();
		$options['0'] = esc_html__( '&mdash; Select &mdash;', 'coaching' );

		foreach ( $menus as $menu ) {
			$options[ $menu->term_id ] = $menu->name;
		}

		return $options;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Navigation Menu', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'menu',
			[
				'label'   => esc_html__( 'Select Menu', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => $this->get_navigation_menu(),
				'default' => '0'
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'title_settings',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .widget-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .widget-title',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .widget-title' => 'color: {{VALUE}};'
				],
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'list_settings',
			[
				'label' => esc_html__( 'List', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'view',
			[
				'label'       => esc_html__( 'Layout', 'coaching' ),
				'type'        => Controls_Manager::CHOOSE,
				'default'     => 'block',
				'options'     => [
					'block'  => [
						'title' => esc_html__( 'Default', 'coaching' ),
						'icon'  => 'eicon-editor-list-ul',
					],
					'inline' => [
						'title' => esc_html__( 'Inline', 'coaching' ),
						'icon'  => 'eicon-ellipsis-h',
					],
				],
				'label_block' => false,
				'selectors'   => [
					'{{WRAPPER}} .widget_nav_menu .menu .menu-item' => 'display: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'list_column',
			[
				'label'     => esc_html__( 'Coumn', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .widget_nav_menu .menu' => 'column-count: {{SIZE}};',
				],
				'condition' => [
					'view' => 'block'
				],
			]
		);

		$this->add_responsive_control(
			'list_margin',
			[
				'label'      => esc_html__( 'Margin (px)', 'elementskit-lite' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .widget_nav_menu .menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'text_settings',
			[
				'label' => esc_html__( 'Text', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'item_padding',
			[
				'label'      => esc_html__( 'Padding (px)', 'elementskit-lite' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .widget_nav_menu .menu a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .widget_nav_menu .menu a',
			]
		);
		$this->start_controls_tabs( 'tabs_item' );

		$this->start_controls_tab(
			'item_tabnormal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_control(
			'item_color',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .widget_nav_menu .menu a' => 'color: {{VALUE}};'
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'tabs_item_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'item_color_hover',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .widget_nav_menu .menu a:hover' => 'color: {{VALUE}};'
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
		$this->start_controls_section(
			'separator_settings',
			[
				'label'     => esc_html__( 'Separator', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'line' => 'yes'
				],
			]
		);
		$this->add_control(
			'w_separator',
			[
				'label'     => esc_html__( 'Width (px)', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .widget-title .line' => 'width: {{SIZE}}px;',
				],
			]
		);
		$this->add_control(
			'h_separator',
			[
				'label'     => esc_html__( 'Height (px)', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .widget-title .line' => 'height: {{SIZE}}px;',
				],
			]
		);
		$this->add_control(
			'bg_line',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .widget-title .line' => 'background-color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'margin_top_separator',
			[
				'label'     => esc_html__( 'Spacing Top (px)', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'selectors' => [
					'{{WRAPPER}} .widget-title .line' => 'margin-top: {{SIZE}}px;',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$nav_menu = ! empty( $settings['menu'] ) ? wp_get_nav_menu_object( $settings['menu'] ) : false;

		if ( ! $nav_menu ) {
			return;
		}

		$title = ! empty( $settings['title'] ) ? $settings['title'] : '';

		echo '<div class="widget widget_nav_menu">';

		if ( $title ) {
			echo '<h4 class="widget-title">' . $title . '</h4>';
		}

		$nav_menu_args = array(
			'fallback_cb' => '',
			'menu'        => $nav_menu
		);

		wp_nav_menu($nav_menu_args);

		echo '</div>';
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Navigation_Menu_El() );
