<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Login_Popup_El extends Widget_Base {

	public function get_name() {
		return 'thim-login-popup';
	}

	public function get_title() {
		return esc_html__( 'Thim: Login Popup', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-login-popup';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Login Popup', 'coaching' )
			]
		);

        $this->add_control(
            'show_register',
            [
                'label'   => esc_html__( 'Show Register Link', 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    '' => esc_html__( 'No', 'coaching' ),
                    '1' => esc_html__( 'Yes', 'coaching' )
                ],
            ]
        );

        $this->add_control(
            'style',
            [
                "label"   => esc_html__( "Style", 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    "base"					=> esc_html__( "Normal", 'coaching' ),
                    "layout_2" 	=> esc_html__( "Effective Style", 'coaching' ),
                ],
            ]
        );

		$this->add_control(
			'text_login',
			[
                'label'   => esc_html__( 'Text Login', 'coaching' ),
                'default' => esc_html__('Login', 'coaching'),
				'type'    => Controls_Manager::TEXT,
			]
		);

        $this->add_control(
            'text_register',
            [
                'label'   => esc_html__( 'Text for Register', 'coaching' ),
                'default' => esc_html__('Register', 'coaching'),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'text_logout',
            [
                'label'   => esc_html__( 'Text Logout', 'coaching' ),
                'default' => esc_html__('Logout', 'coaching'),
                'type'    => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'shortcode',
            [
                'label'       => esc_html__( 'Shortcode', 'coaching' ),
                'description' => esc_html__( 'Enter shortcode to show in form Login', 'coaching' ),
                'type'    => Controls_Manager::TEXT,
            ]
        );


		$this->end_controls_section();
        $this->register_style_setting_label_register( esc_html__( 'Login Label', 'coaching' ), 'login' );
		$this->register_style_setting_label_register( esc_html__( 'Logout Label', 'coaching' ), 'logout' );
		$this->register_style_setting_label_register( esc_html__( 'Profile Label', 'coaching' ), 'profile' );
        
	}
	protected function register_style_setting_label() {

		$this->start_controls_section(
			'settings_style_tabs',
			[
				'label' => esc_html__( 'Settings ', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'text_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-link-login a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'.site-header .navbar-nav>li.menu-right {{WRAPPER}} .thim-link-login a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'text_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-link-login a'             => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-link-login a:last-child'  => 'margin-right: 0;',
					'{{WRAPPER}} .thim-link-login a:first-child' => 'margin-left: 0;',
				],
			]
		);
		$this->add_responsive_control(
			'icon_space_right',
			[
				'label'      => esc_html__( 'Space icon', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-link-login a i'      => 'margin-right: {{SIZE}}{{UNIT}};',
					'.rtl {{WRAPPER}} .thim-link-login a i' => 'margin-right: 0; margin-left: {{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'layout!' => 'base'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'settings_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}}  .thim-link-login a',
			]
		);

		$this->end_controls_section();

	}

	protected function register_style_setting_label_register( $label, $class ) {

		$this->start_controls_section(
			$class . '_settings_style_tabs',
			[
				'label' => $label,
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			$class . '_settings_border',
			[
				'label'     => esc_html_x( 'Border Type', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'none'   => esc_html__( 'None', 'coaching' ),
					'solid'  => esc_html_x( 'Solid', 'Border Control', 'coaching' ),
					'double' => esc_html_x( 'Double', 'Border Control', 'coaching' ),
					'dotted' => esc_html_x( 'Dotted', 'Border Control', 'coaching' ),
					'dashed' => esc_html_x( 'Dashed', 'Border Control', 'coaching' ),
					'groove' => esc_html_x( 'Groove', 'Border Control', 'coaching' ),
				],
				'default'   => 'none',
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'border-style: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			$class . '_border_dimensions',
			[
				'label'     => esc_html_x( 'Width', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'condition' => [
					$class . '_settings_border!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( $class . '_tabs_color_settings_style' );
		$this->start_controls_tab(
			$class . '_tab_color_link_normal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_control(
			$class . '_text_color',
			[
				'label'     => __( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			$class . '_border_text',
			[
				'label'     => __( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'condition' => [
					$class . '_settings_border!' => 'none'
				],
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			$class . '_bg_text',
			[
				'label'     => __( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			$class . '_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-link-login .' . $class => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			$class . '_tab_color_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			$class . '_text_color_hover',
			[
				'label'     => __( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class . ':hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			$class . '_border_text_hover',
			[
				'label'     => __( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class . ':hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					$class . '_settings_border!' => 'none'
				],
			]
		);
		$this->add_control(
			$class . '_bg_text_hover',
			[
				'label'     => __( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .thim-link-login .' . $class . ':hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			$class . '_border_radius_h',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-link-login .' . $class . ':hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display();
 
		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		), $settings['style'] );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Login_Popup_El() );
