<?php
namespace Elementor;

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

class Thim_List_Video_El extends Widget_Base {
    public function get_name()
    {
        return 'thim-list-video';
    }

    public function get_title()
    {
        return esc_html__('List Video', 'coaching');
    }

    public function get_icon()
    {
        return 'thim-eicon eicon-gallery-grid';
    }

    public function get_categories() {
		return [ 'thim_ekit' ];
	}
    
    protected function register_controls() {
        $this->_register_content_video();
        $this->_style_content_category();
        
    }

    protected function _register_content_video() 
    {
        $this->start_controls_section(
            'content_video',
            array(
                'label' => esc_html__('Video', 'coaching'),
            )
        );

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			array(
				'name'         => 'thumbnail_size',
				'default'      => 'full',
				'prefix_class' => 'list-video-item-image-size-',
			)
		);

        $repeater_video = new \Elementor\Repeater();

        $repeater_video->add_control(
            'image_video',
            array(
                'label'   => esc_html__('Choose A Video Image', 'coaching'),
                'type'    => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                    'id'  => -1,
                ),
            )
        );

        $repeater_video->add_control(
            'title_video',
            array(
                'label'       => esc_html__('Title Video', 'coaching'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Video', 'coaching'),
            )
        );

        $repeater_video->add_control(
            'link_video',
            array(
                'label'         => esc_html__('Video Link', 'coaching'),
                'type'          => Controls_Manager::URL,
                'placeholder'   => esc_html__('https://youtube.com', 'coaching'),
                'show_external' => false,
                'default'       => array(
                    'url'         => '',
                    'is_external' => true,
                    'nofollow'    => true,
                ),
            )
        );
		$repeater_video->start_popover();

		$repeater_video->end_popover();

        $this->add_control(
            'data_video',
            array(
                'label'       => esc_html__('Video', 'coaching'),
                'type'        => Controls_Manager::REPEATER,
                'default'     => array(
                    array('title_video' => esc_html__('Video', 'coaching')),
                ),

                'fields'      => $repeater_video->get_controls(),
                'title_field' => '{{{ title_video }}}',
            )
        );
        $this->end_controls_section();
    }

    protected function _style_content_category() {
        $this->start_controls_section(
			'video_popup_style',
			array(
				'label' => esc_html__( 'Style', 'coaching' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->start_controls_tabs( 'tabs_category_btn_style' );
		$this->start_controls_tab(
			'tab_category_btn_normal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'font_category_btn',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .list-video .list-play__title',
			]
		);

        $this->add_control(
			'text_color_list_video',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .list-video .list-play__title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_category_btn_active',
			[
				'label' => esc_html__( 'Active', 'coaching' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'font_category_btn_active',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .list-video .list-play__item.active .list-play__title',
			]
		);

        $this->add_control(
			'text_color_list_video_active',
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .list-video .list-play__item.active .list-play__title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
			'background_color_list_video',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .list-video .list-video__wapper__right' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'border_style_list_video',
			[
				'label'     => esc_html_x( 'Border Type', 'Border Control', 'coaching' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'none'   => esc_html__( 'None', 'coaching' ),
					'solid'  => esc_html_x( 'Solid', 'Border Control', 'coaching' ),
					'double' => esc_html_x( 'Double', 'Border Control', 'coaching' ),
					'dotted' => esc_html_x( 'Dotted', 'Border Control', 'coaching' ),
					'dashed' => esc_html_x( 'Dashed', 'Border Control', 'coaching' ),
					'groove' => esc_html_x( 'Groove', 'Border Control', 'coaching' ),
				],
				'default'   => 'none',
				'selectors' => [
					'{{WRAPPER}} .list-video .list-play__item' => 'border-bottom: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'border_width_list_video',
			[
				'label'     => esc_html_x( 'Width', 'Border Control', 'coaching' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
                'min'       => 0,
				'max'       => 100,
				'step'      => 1,
				'selectors' => [
					'{{WRAPPER}} .list-video .list-play__item' => 'border-width: {{VALUE}}px;',
				],
			]
		);

		$this->add_control(
			'border_color_list_video',
			[
				'label'     => esc_html__( 'Border Color:', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .list-video .list-play__item' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'margin_list_video',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .list-video .list-play__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'padding_list_video',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .list-video .list-play__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
            'style_demo_gap',
            array(
                'label' => esc_html__('Scroll', 'coaching'),
                'tab'   => Controls_Manager::TAB_STYLE,
            )
        );
		$this->add_control(
			'scroll_width_video',
			[
				'label'     => esc_html__( 'Width Scroll Video', 'coaching' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => array('px'),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 10,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .list-video__wapper__right::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
				),
			]
		);

		$this->add_responsive_control(
			'height_list_video',
			array(
				'label'      => esc_html__('Height Scroll Video', 'coaching'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array('px'),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 700,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .list-video .list-video__wapper__right' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'scroll_color_video',
			[
				'label'     => esc_html__( 'Color Scroll Video', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .list-video__wapper__right::-webkit-scrollbar-thumb' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'height_iframe_video',
			array(
				'label'      => esc_html__('Height iframe', 'coaching'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array('px'),
				'range'      => array(
					'px' => array(
						'min'  => 0,
						'max'  => 700,
						'step' => 1,
					),
				),
				'selectors'  => array(
					'{{WRAPPER}} .list-video .list-video__wapper__left iframe' => 'height: {{SIZE}}{{UNIT}};',
				),
			)
		);
		$this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display(); 
        $slug_category = '';
        ?>

		<div class="list-video">
			<div class="list-video__wapper">
				<div class="list-video__wapper__left">
					<?php if ($settings['data_video']) : $i = 1; ?>    
						<?php foreach ($settings['data_video'] as $key => $item) : 
						$class      = ( $i == 1 ) ? ' active' : '';
						$url_youtube = $item['link_video']['url'];
						preg_match("/^(?:http(?:s)?:\/\/)?(?:www\.)?(?:m\.)?(?:youtu\.be\/|youtube\.com\/(?:(?:watch)?\?(?:.*&)?v(?:i)?=|(?:embed|v|vi|user|shorts)\/))([^\?&\"'>]+)/", $url_youtube, $matches_id);
						?>
						<?php
						if(empty($matches_id[1])) {
							$matches_id[1] = '';
						}
							echo '<div class="list-play__video'.esc_attr($class).'" data-list="list-vid-'.($key).'" ><iframe  src="https://www.youtube.com/embed/' . $matches_id[1] . '" allowfullscreen style="border: 0;"></iframe></div>';
						?>
						<?php $i ++; endforeach; ?>
					<?php endif; ?>   
				</div>

				<div class="list-video__wapper__right">
					<ul class="list-play">
						<?php if ($settings['data_video']) : $i = 1; ?>    
							<?php foreach ($settings['data_video'] as $key => $item) : 
							$class      = ( $i == 1 ) ? ' active' : '';
							$url_youtube = $item['link_video']['url'];?>
							<li class="list-play__item<?php echo esc_attr( $class ); ?>" data-list="list-tt-<?php echo $key ?>">
								<div class="list-play__image" src='<?php echo esc_url( $url_youtube ); ?>'>
									<?php
									$settings['thumbnail_id'] = $item['image_video'];
									$thumbnail_html           = Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail_size', 'thumbnail_id' );
									echo wp_kses_post( $thumbnail_html );
									?>
								</div>
								<p class="list-play__title"><?php echo esc_html__($item['title_video'],'coaching') ?></p>
							</li>
							<?php $i ++; endforeach; ?>
						<?php endif; ?>   
					</ul>
				</div>
			</div>         
		</div>
	<?php 
    }
}
