<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) { 
	exit;
}

class Thim_List_Event_El extends Widget_Base {

	public function get_name() { 
		return 'thim-list-event';
	}

	public function get_title() {
		return esc_html__( 'Thim: List Events', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-list-event';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}
	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'List Events', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Heading', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' )
			]
		);

		$this->add_control(
			'layout',
			[
				'label'   => esc_html__( 'Layout', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'base'             => esc_html__( 'Default', 'coaching' ),
					'layout-business'  => esc_html__( 'Layout Business', 'coaching' ),
					'layout-2'         => esc_html__( 'Layout 2', 'coaching' ),
					'layout-effective' => esc_html__( 'Layout Effective', 'coaching' ),
					'layout-3' 		   => esc_html__( 'Layout Grid', 'coaching' ),
				],
				'default' => 'base'
			]
		);

		$this->add_control(
			'cat_id',
			[
				'label'   => esc_html__( 'Select Category', 'coaching' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => thim_get_cat_taxonomy( 'tp_event_category', array( esc_html__( 'All', 'coaching' ) => 'all' ) ),
				'default' => 'all'
			]
		);

		$this->add_control(
			'status',
			[
				'label'       => esc_html__( 'Select Status', 'coaching' ),
				'type'        => Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => false,
				'options'     => array(
					'upcoming'  => esc_html__( 'Upcoming', 'coaching' ),
					'happening' => esc_html__( 'Happening', 'coaching' ),
					'expired'   => esc_html__( 'Expired', 'coaching' ),
				)
			]
		);

		$this->add_control(
			'number_posts',
			[
				'label'   => esc_html__( 'Number Posts', 'coaching' ),
				'type'    => Controls_Manager::NUMBER, 
				'default' => 3,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control( 
			'feature_items',
			[
				'label'   => esc_html__( 'Feature Items', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 1,
			]
		);

		$this->add_responsive_control(
			'columns',
			array(
				'label'          => esc_html__( 'Columns', 'eduma' ),
				'type'           => Controls_Manager::SELECT,
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'options'        => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				),
				'selectors'      => array(
					'{{WRAPPER}}' => '--thim-event-columns: repeat({{VALUE}}, 1fr)',
				),
				'condition'      => [
					'layout'         => 'layout-3',
				],
			)
		);

		$this->add_control(
			'text_link',
			[
				'label'   => esc_html__( 'Text Link All', 'coaching' ),
				'type'    => Controls_Manager::TEXT,
				'default' => esc_html__( 'View All', 'coaching' )
			]
		);

		$this->add_control(
			'url_link',
			[
				'label'         => __( 'URL', 'coaching' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => __( 'https://your-link.com', 'coaching' ),
				'show_external' => true,
				'default'       => [
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				],
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_design_layout',
			array(
				'label'     => esc_html__( 'Header', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_control(
			'list_event_header_title_color', 
			[
				'label'     => esc_html__( 'Text Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-header .widget-title' => 'color: {{VALUE}};',
 
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_title_header_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event-header .widget-title',
			]
		);
		$this->add_responsive_control(
			'list_event_item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-list-event-header' => 'text-align: {{VALUE}};', 
                ],
			]
		);
		$this->add_responsive_control( 
			'list_event_widget_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event-header .widget-title' => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();
		$this->list_event_tabs_style();
		$this->effective_slider_style();
		$this->effective_slider_nav_sc();
		$this->list_event_view_all_style();
	}
	protected function list_event_tabs_style(){
		$this->start_controls_section(
			'section_list_event_style',
			array(
				'label'     => esc_html__( 'List item', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'column_gap',
			array(
				'label'     => esc_html__( 'Columns Gap', 'eduma' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 30,
				),
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'condition' => [
					'layout' => 'layout-3'
				],
				'selectors' => array(
					'{{WRAPPER}}' => '--thim-event-column-gap: {{SIZE}}{{UNIT}}',
				),
			)
		);

		$this->add_responsive_control(
			'row_gap',
			array(
				'label'     => esc_html__( 'Rows Gap', 'eduma' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 30,
				),
				'range'     => array(
					'px' => array(
						'min' => 0,
						'max' => 100,
					),
				),
				'condition' => [
					'layout' => 'layout-3'
				],
				'selectors' => array(
					'{{WRAPPER}}' => '--thim-event-row-gap: {{SIZE}}{{UNIT}}',
				),
			)
		);
		$this->add_control(
			'list_event_bg_color', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .thim-list-event .item-event' => 'background: {{VALUE}}',
				),
				'condition' => [
					'layout' => 'layout-3'
				],
			]
		);
		$this->add_control(
			'list_event_bg_color_hover', 
			[
				'label'     => esc_html__( 'Background Color Hover', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .thim-list-event .item-event:hover .thumnail-event::after' => 'background-color: {{VALUE}}',
				),
				'condition' => [
					'layout' => 'layout-3'
				],
			]
		);
		$this->add_control(
			'list_event_color_hover_content', 
			[
				'label'     => esc_html__( 'Color Content Hover', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => array(
					'{{WRAPPER}} .thim-list-event .item-event:hover .title a, {{WRAPPER}} .thim-list-event .item-event:hover .time, {{WRAPPER}} .thim-list-event .item-event:hover .thim-excerpt ' => 'color: {{VALUE}}',
				),
				'condition' => [
					'layout' => 'layout-3'
				],
			]
		);
		$this->add_responsive_control(
			'list_event_item',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .item-event' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => array(
					'layout' => 'layout-3',
				),
			]
		); 
		$this->add_control(
			'list_event_style_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_item_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'litem_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_control(
			'list_event_style_title_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading a' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .title_event a' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event .title a' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .item-event .info-event .title-event a' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_title1_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .top-heading a,{{WRAPPER}} .thim-list-event .top-heading a,{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .item-event .title-event a',
			]
		);

		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'list_event_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'list_event_style_title_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading a:hover' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .thim-list-event .title a:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .title_event a:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .item-event .info-event .title-event a:hover' => 'color: {{VALUE}}!important;',
				],
				
			]
		);
		$this->end_controls_tab();
		// end hover tab
		
		$this->end_controls_tabs();
		$this->add_responsive_control(
			'list_event_style_title_item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left', 
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-list-event .top-heading' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event .title' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-business .title_event' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-effective .title-event' => 'text-align: {{VALUE}};',
                ],
			]
		);
		$this->add_responsive_control(
			'list_event_title_space_bottom',
			[
				'label'      => esc_html__( 'Space Bottom', 'coaching' ), 
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => -10,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .top-heading,{{WRAPPER}} .thim-list-event .title,
					{{WRAPPER}} .thim-list-event-business .title_event,{{WRAPPER}} .thim-list-event-effective .title-event' => 'margin-bottom: {{SIZE}}{{UNIT}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_style_des',
			[
				'label' => esc_html__( ' Description', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['base','layout-business','layout-effective','layout-3'],
				),
			]
		);
		$this->add_control(
			'list_event_style_des_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .description' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event .thim-excerpt' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-business .content_event .thim-excerpt' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .content_event .thim-excerpt' => 'color: {{VALUE}};',
				],
				'condition' => array(
					'layout' => ['base','layout-business','layout-effective','layout-3'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_des1_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .description,{{WRAPPER}} .thim-list-event-business .thim-excerpt,{{WRAPPER}} .thim-list-event .thim-excerpt',
				'condition' => array(
					'layout' => ['base','layout-business','layout-effective','layout-3'],
				),
			]
		);
		$this->add_responsive_control(
			'list_event_style_des_item_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-list-event .thim-excerpt' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-business .thim-excerpt' => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .thim-list-event-effective .thim-excerpt' => 'text-align: {{VALUE}};',
					
                ],
				'condition' => array(
					'layout' => ['base','layout-business','layout-effective'],
				),
			]
		);
		$this->add_responsive_control(
			'list_event_des_margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .description,{{WRAPPER}} .thim-list-event-business .thim-excerpt,
					{{WRAPPER}} .thim-list-event-effective .thim-excerpt , {{WRAPPER}} .thim-list-event .thim-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		); 
		$this->add_control(
			'list_event_style_date',
			[
				'label' => esc_html__( ' Date', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_style_date_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .time-from' => 'color: {{VALUE}}!important; margin-right: 14px;',
					'{{WRAPPER}} .thim-list-event-business .date_event' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .date_event h4' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .item-event .date-event' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_responsive_control(
			'list_event_style_date_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .time-from' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
				'condition' => array(
					'layout' => 'layout-3',
				),
			]
		); 
		$this->add_control(
			'list_event_style_date_background', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .time-from' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => 'layout-3',
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_date_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event-business  .item-event .date_event h4,{{WRAPPER}} .thim-list-event-business .item-event .date_event,{{WRAPPER}}  .thim-list-event-effective .date-event span',
				'condition' => array(
					'layout' => ['base','layout-business','layout-effective'],
				),
			]
		);
		$this->add_control(
			'list_event_style_time',
			[
				'label' => esc_html__( 'Time', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_style_time_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading .time' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event .time' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .meta_event span:first-child' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .meta_event span:first-child' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event.layout-2 .event-wrapper .meta .time' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_style_time_color_icon', 
			[
				'label'     => esc_html__( 'Color Icon', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading .time i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .meta_event span:first-child i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-normal .meta_event span:first-child i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event.layout-2 .event-wrapper .meta .time i' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_time_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .top-heading .time,
				{{WRAPPER}} .thim-list-event-business .meta_event span:first-child,
				{{WRAPPER}} .thim-list-event.layout-2 .event-wrapper .meta .time,
				{{WRAPPER}} .thim-list-event.layout-3 .time',
			]
		);
		$this->add_control(
			'list_event_style_location',
			[
				'label' => esc_html__( 'Location', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_style_location_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading .location' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event-business .meta_event span:last-child' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event-effective .layout-effective-normal .meta_event span:last-child' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event.layout-2 .event-wrapper .meta .location' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_style_location_color_icon', 
			[
				'label'     => esc_html__( 'Color icon', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .top-heading .location i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event-business .meta_event span:last-child i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event-effective .layout-effective-normal .meta_event span:last-child i' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event.layout-2 .event-wrapper .meta .location i' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_location_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .top-heading .location,
				{{WRAPPER}}  .thim-list-event-business .meta_event span:last-child,
				{{WRAPPER}}  .thim-list-event-effective .layout-effective-normal .meta_event span:last-child,
				{{WRAPPER}}  .thim-list-event.layout-2 .event-wrapper .meta .location', 
			]
		);
		$this->add_control(
			'list_event_style_button',
			[
				'label' => esc_html__( 'Button', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_item_tabs2',
        );

        // start normal tab
        $this->start_controls_tab(
            'litem_style_normal2',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
				
            ]
        );
		$this->add_control(
			'list_event_style_bt_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button' => 'color: {{VALUE}}!important;overflow: hidden; height: unset !important;',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_control(
			'list_event_style_bt_bgcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .view_detail .thim-button' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_bt_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button',
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .event-wrapper .thim-button,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button',
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_responsive_control(
			'bt_item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event  .thim-button,{{WRAPPER}} .thim-list-event-business .thim-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button',
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_responsive_control(
			'bt_item__margin',
			[
				'label'      => esc_html__( 'Margin', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
			]
		); 
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'litem_style_hover2',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_control(
			'list_event_style_bt_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .view_detail .thim-button:hover' => 'color: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_control(
			'list_event_style_bt_bgcolor_hover', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button:hover' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}}  .thim-list-event-business .view_detail .thim-button:hover' => 'background: {{VALUE}}!important;',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name' => 'item_border1_hover',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .event-wrapper .thim-button:hover,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button:hover',
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->add_responsive_control(
			'bt_item_border_radius_hover',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '',
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button:hover,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		 
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'item_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .event-wrapper .thim-button:hover,{{WRAPPER}} .thim-list-event-business .view_detail .thim-button:hover',
				'condition' => array(
					'layout' => ['base','layout-business'], 
				),
			]
		);

		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
		$this->add_responsive_control( 
			'item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .event-wrapper .thim-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; display: inline-block;',
					'{{WRAPPER}} .thim-list-event-business .view_detail .thim-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; display: inline-block;',
  				],
				'condition' => array(
					'layout' => ['base','layout-business'],
				),
			]
		);
		$this->end_controls_section();
	}
	protected function list_event_view_all_style(){
		$this->start_controls_section(
			'section_design_viewall_layout',
			array(
				'label'     => esc_html__( 'View ALL', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			)
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_viewall_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'viewall_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_control(
			'list_event_style_bt_viewall_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .view-all-link,{{WRAPPER}} .thim-list-event-business .view-all-link,{{WRAPPER}} .thim-list-event.layout-2 .view-all,{{WRAPPER}} .thim-list-event-effective .view-all-link' => 'color: {{VALUE}}!important;overflow: hidden;
					height: unset;',
				],
			]
		);
		$this->add_control(
			'list_event_style_bt_viewall_bgcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .view-all-link' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .view-all-link' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .view-all-link' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event.layout-2 .view-all' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_bt_viewall_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selector' =>'{{WRAPPER}} .thim-list-event .view-all-link',
			]
		);
		$this->add_responsive_control(
			'bt_viewall_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .view-all-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-event-business .view-all-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-event-effective .view-all-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .thim-list-event.layout-2 .view-all' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name' => 'bt_viewall_item_border',
				'label' => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .view-all-link,{{WRAPPER}} .thim-list-event-business .view-all-link,{{WRAPPER}} .thim-list-event-effective .view-all-link,{{WRAPPER}} .thim-list-event.layout-2 .view-all',
				
			]
		);
		$this->add_responsive_control(
			'bt_viewall_item_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'default'    => [
					'top'    => '',
					'right'  => '',
					'bottom' => '', 
					'left'   => '',
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .view-all-link,{{WRAPPER}} .thim-list-event-business .view-all-link,{{WRAPPER}} .thim-list-event-effective .view-all-link,{{WRAPPER}} .thim-list-event.layout-2 .view-all' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'bt_viewall_item_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .view-all-link,{{WRAPPER}} .thim-list-event-business .view-all-link,{{WRAPPER}} .thim-list-event-effective .view-all-link,{{WRAPPER}} .thim-list-event.layout-2 .view-all',
			]
		);
		$this->end_controls_tab();
		// end normal 
		// start hover tab
		$this->start_controls_tab(
			'viewall_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'list_event_style_bt_viewall_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .view-all-link:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .view-all-link:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .view-all-link:hover' => 'color: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event.layout-2 .view-all:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_style_bt_viewall_bgcolor_hover', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event .view-all-link:hover' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-business .view-all-link:hover' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event-effective .view-all-link:hover' => 'background: {{VALUE}}!important;',
					'{{WRAPPER}} .thim-list-event.layout-2 .view-all:hover' => 'background: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_style_border_hover', 
			[
				'label'     => esc_html__( 'Border color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [ 
					'{{WRAPPER}} .thim-list-event .view-all-link:hover,{{WRAPPER}} .thim-list-event-business .view-all-link:hover,{{WRAPPER}} .thim-list-event-effective .view-all-link:hover,{{WRAPPER}} .thim-list-event.layout-2 .view-all:hover' => 'border-color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'bt_viewall_item_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-list-event .view-all-link:hover,{{WRAPPER}} .thim-list-event-business .view-all-link:hover,{{WRAPPER}} .thim-list-event-effective .view-all-link:hover,{{WRAPPER}} .thim-list-event.layout-2 .view-all:hover',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		$this->end_controls_tab();
		$this->add_responsive_control( 
			'list_event_viewall_space',
			[
				'label'      => esc_html__( 'Space Top', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-list-event .view-all,{{WRAPPER}} .thim-list-event-business .view-all,{{WRAPPER}} .thim-list-event.layout-2 .view-all,{{WRAPPER}} .thim-list-event-effective .view-all' => 'margin-top: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();
	}
	protected function effective_slider_style(){
		$this->start_controls_section(
			'section_effective_slider_layout',
			array(
				'label'     => esc_html__( 'Silder', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => ['layout-effective'],
				),
			)
		);
		$this->add_control(
			'list_event_slider_background', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					' {{WRAPPER}} .thim-list-event-effective .layout-effective-slider .event-item' => 'background-color: {{VALUE}} !important;',
				],
				
			]
		);
		$this->add_control(
			'list_event_slider_style_title',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		// start tab for item
		$this->start_controls_tabs(
            'style_item_slider_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'litem_style_slider_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_control(
			'list_event_slider_style_title_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .title-event a' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_group_control( 
			Group_Control_Typography::get_type(),
			[
				'name'     => 'list_event_style_slider_title_typography',
				'label'    => esc_html__( 'Typography', 'coaching' ),
				'selectors' => 	'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .title-event a ',
			]
		);

		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'list_event_slider_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_control(
			'list_event_slider_style_title_color_hover', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .title-event a:hover' => 'color: {{VALUE}} !important;',
				],
				
			]
		);
		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();

		$this->add_control(
			'list_event_slider_style_date',
			[
				'label' => esc_html__( ' Date', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_slider_style_date_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .date-event' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'list_event_slider_style_content',
			[
				'label' => esc_html__( 'List content', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_slider_style_content_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider  .meta-event span' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_slider_style_content_icon_color', 
			[
				'label'     => esc_html__( 'Icon Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .event-item .meta-event span i' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_slider_style_countdown',
			[
				'label' => esc_html__( 'Countdown', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'list_event_slider_style_countdown_BGcolor', 
			[
				'label'     => esc_html__( 'Background', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .countdown-amount' => 'background-color: {{VALUE}}!important;',
				],
			]
		);
		$this->add_control(
			'list_event_slider_style_countdown_color', 
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-list-event-effective .layout-effective-slider .countdown-period' => 'color: {{VALUE}}!important;',
				],
			]
		);
		$this->end_controls_section();
	}
	protected function effective_slider_nav_sc(){
		$this->start_controls_section(
			'list_event_slider_style_nav',
			array(
				'label'     => esc_html__( 'Nav', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => array(
					'layout' => ['layout-effective'],
				),
			)
		);
		
		$this->start_controls_tabs( '
		list_event_tabs_item2' 
		);
		$this->start_controls_tab(
			'list_event_tabs_normal',
			[
				'label' => esc_html__( 'Normal', 'coaching' ),
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical align', 'coaching' ),
				'type'        => Controls_Manager::NUMBER,
				'label_block' => false,
				'min'         => - 500,
				'max'         => 500,
				'step'        => 1,
				'selectors'   => array(
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div' => '-webkit-transform: translateY({{VALUE}}px); -ms-transform: translateY({{SIZE}}px); transform: translateY({{SIZE}}px);',
				),
			)
		);
		$this->add_responsive_control(
			'carousel_post__nav_color_normal',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div i' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_normal',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		

		$this->add_responsive_control(
			'carousel_post__nav_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100, 
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_normal',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .layout-effective-slider .owl-nav > div',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name'     => 'carousel_post__nav_border_normal',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .layout-effective-slider .owl-nav > div',
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'list_event_tab_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ),
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_color_hover',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div i:hover' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_hover',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div:hover' => 'background-color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_boder_color_hover',
			[
				'label'     => esc_html__( 'Border Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .layout-effective-slider .owl-nav > div:hover' => 'border-color: {{VALUE}}'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .layout-effective-slider .owl-nav > div:hover',
			]
		);
		$this->end_controls_tab();
		// end normal tab
		$this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		// Map variables between Elementor and SiteOrigin
		$settings['url_link'] = isset($settings['url_link']) ? $settings['url_link']['url'] : '';
		
		$args                 = array();
		$args['before_title'] = '<div class="thim-list-event-header"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings,
			'args'     => $args
		), $settings['layout'] );
	}

} 

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_List_Event_El() );
