<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Daily_Support_El extends Widget_Base {

	public function get_name() {
		return 'thim-daily-support';
	}

	public function get_title() {
		return esc_html__( 'Thim: Daily Support', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-daily-support';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'Daily Support', 'coaching' )
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'position_support',
			[
                'label'         => esc_html__( 'Position', 'coaching' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'left'              => esc_html__( 'Left', 'coaching' ),
                    'right' => esc_html__( 'Right', 'coaching' ),
                ],
			]
		);

		$repeater->add_control(
			'image_support',
            [
                'label'         => esc_html__( 'Upload Image', 'coaching' ),
                'type'        => Controls_Manager::MEDIA,
            ]
		);

        $repeater->add_control(
            'body_support',
            [
                'label' => esc_html__('Support Body', 'coaching'),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'daily-support',
            [
                'label'       => esc_html__( 'Support List', 'coaching' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ position_support }}}',
                'separator'   => 'before'
            ]
        );

		$this->end_controls_section();
		$this->daily_sup_tabs_style_sc();

	}
	protected function daily_sup_tabs_style_sc(){
		$this->start_controls_section(
			'daily_content_section',
			[
				'label' => esc_html__( 'Style', 'coaching' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'daily_content_typography',
				'selector' => '{{WRAPPER}} .thim_item_support.left .thim_content_support,{{WRAPPER}} .thim_item_support.right .thim_content_support',
			]
		);
		$this->add_responsive_control(
			'daily_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim_item_support.left .thim_content_support,{{WRAPPER}} .thim_item_support.right .thim_content_support' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

  				],
			]
		);

		// start tab for item
		$this->start_controls_tabs(
            'daily_content__tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'daily_content__left',
            [
                'label' => esc_html__( 'LEFT', 'coaching' ),
            ]
        );
		$this->add_control(
            'daily_content_left_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim_daily_support .thim_item_support.left .thim_content_support' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_control(
            'daily_bg_left',
            [
                'label' => esc_html__( 'Background', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim_daily_support .thim_item_support.left .thim_content_support' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .thim_daily_support .thim_item_support.left .thim_content_support:before' => 'border-right: 10px solid {{VALUE}};',

                ],
            ]
        );
		$this->end_controls_tab();
		 // start normal tab
		 $this->start_controls_tab(
            'daily_content__right',
            [
                'label' => esc_html__( 'RIGHT', 'coaching' ),
            ]
        );
		$this->add_control(
            'daily_content_right_color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim_daily_support .thim_item_support.right .thim_content_support' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_control(
            'daily_bg_right',
            [
                'label' => esc_html__( 'Background', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim_daily_support .thim_item_support.right .thim_content_support' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .thim_daily_support .thim_item_support.right .thim_content_support:before' => 'border-left: 10px solid {{VALUE}};',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tab();

        $this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();


		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		) );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Daily_Support_El() );
