<?php

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_Carousel_Post_El extends Widget_Base {

	public function get_name() {
		return 'thim-carousel-post';
	}

	public function get_title() {
		return esc_html__( 'Thim: Carousel Posts', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-carousel-posts';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	//Get list post categories
	function thim_get_post_categories() {
        $args         = array(
            'orderby' => 'id',
            'parent'  => 0
        );
        $items        = array();
        $items['all'] = 'All';
        $categories   = get_categories( $args );
        if ( isset( $categories ) ) {
            foreach ( $categories as $key => $cat ) {
                $items[ $cat->cat_ID ] = $cat->cat_name;
                $childrens             = get_term_children( $cat->term_id, $cat->taxonomy );
                if ( $childrens ) {
                    foreach ( $childrens as $key => $children ) {
                        $child                    = get_term_by( 'id', $children, $cat->taxonomy );
                        $items[ $child->term_id ] = '--' . $child->name;

                    }
                }
            }
        }

        return $items;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => __( 'Carousel Posts', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Heading', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => false
			]
		);

		$this->add_control(
			'cat_id',
			[
				'label'   => esc_html__( 'Select Category', 'coaching' ),
				'type'    => Controls_Manager::SELECT2,
				'options' => $this->thim_get_post_categories(),
				'default' => 'all'
			]
		);

		$this->add_control(
			'visible_post',
			[
				'label'   => esc_html__( 'Posts Visible', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 3,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control(
			'number_posts',
			[
				'label'   => esc_html__( 'Number Posts', 'coaching' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 6,
				'min'     => 1,
				'step'    => 1
			]
		);

		$this->add_control(
			'show_nav',
			[
				'label'        => esc_html__( 'Show Navigation?', 'coaching' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'coaching' ),
				'label_off'    => esc_html__( 'No', 'coaching' ),
				'return_value' => 'yes',
				'default'      => 'yes'
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label'        => esc_html__( 'Show Pagination?', 'coaching' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'coaching' ),
				'label_off'    => esc_html__( 'No', 'coaching' ),
				'return_value' => 'yes',
				'default'      => ''
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Order by', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'popular' => esc_html__( 'Popular', 'coaching' ),
					'recent'  => esc_html__( 'Date', 'coaching' ),
					'title'   => esc_html__( 'Title', 'coaching' ),
					'random'  => esc_html__( 'Random', 'coaching' )
				],
				'default' => 'recent'
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => esc_html__( 'Order', 'coaching' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'asc'  => esc_html__( 'ASC', 'coaching' ),
					'desc' => esc_html__( 'DESC', 'coaching' )
				],
				'default' => 'desc' 
			]
		);


		$this->end_controls_section();
		$this->start_controls_section(
			'carousel_post_title_style',
			[
				'label'     => esc_html__( 'Widget Title', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				
			] 
		);
      
		$this->add_control(
			'carousel_post_style_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post-header .widget-title' => 'color: {{VALUE}} !important;',
				],
			]
		);
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'carousel_post_style_title_typography',
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post-header .widget-title',
			]
		);
		$this->add_responsive_control(
			'carousaitem_alignment',
			[
				'label'     => esc_html__( 'Alignment', 'coaching' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'coaching' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'coaching' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'coaching' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'left',
				'toggle'    => true,
				'selectors' => [
                    '{{WRAPPER}} .thim-owl-carousel-post-header .widget-title' => 'text-align: {{VALUE}};', 
                ],
			]
		);
		$this->add_responsive_control(
			'content_space',
			[
				'label'      => esc_html__( 'Space', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post-header .widget-title'      => 'margin-bottom: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();
		$this->carousel_tabs_style_sc();
		$this->carousel_tabs_nav_style();

	}
	protected function carousel_tabs_style_sc(){
		$this->start_controls_section(
			'carousel_post_content_style',
			[
				'label'     => esc_html__( 'Content', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				
			] 
		);
		$this->add_control(
			'carousel_post_date_haeding',
			[
				'label' => esc_html__( 'Date', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
	
		$this->add_control(
			'carousel_post_style_box_date_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .info .date' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'carousel_post_style_box_date_typography',
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .info .date',
			]
		);
		$this->add_control(
			'carousel_post_author_haeding',
			[
				'label' => esc_html__( 'Author', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'carousel_post_style_box_author_color',
			[
				'label'     => esc_html__( 'Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .info a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'carousel_post_style_box_author_typography',
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .info a',
			]
		);
		$this->add_control(
			'carousel_post_style_box_bg_color',
			[
				'label'     => esc_html__( 'Background Color For Box Info', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-item .info' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}
	protected function carousel_tabs_nav_style(){
		$this->start_controls_section(
			'carousel_post__nav_style_tab',
			[
				'label'     => esc_html__( 'Nav', 'coaching' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_nav' => 'yes'
				]
			]
		);
		   // start tab for item
		   $this->start_controls_tabs(
            'carousel_post_item_tabs'
        );

        // start normal tab
        $this->start_controls_tab(
            'carousel_post_style_normal',
            [
                'label' => esc_html__( 'Normal', 'coaching' ),
            ]
        );
		$this->add_responsive_control(
			'carousel_post__nav_vertical_offset',
			array(
				'label'       => esc_html__( 'Vertical align', 'coaching' ),
				'type'        => Controls_Manager::NUMBER,
				'label_block' => false,
				'min'         => - 500,
				'max'         => 500,
				'step'        => 1,
				'selectors'   => array(
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div' => '-webkit-transform: translateY({{VALUE}}px); -ms-transform: translateY({{SIZE}}px); transform: translateY({{SIZE}}px);',
				),
			)
		);
		$this->add_responsive_control(
			'carousel_post__nav_color_normal',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div i' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_normal',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_font_size',
			[
				'label'      => esc_html__( 'Font Size', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 200,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		

		$this->add_responsive_control(
			'carousel_post__nav_width',
			[
				'label'      => esc_html__( 'Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);

		$this->add_responsive_control(
			'carousel_post__nav_height',
			[
				'label'      => esc_html__( 'Height', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div' => 'height: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_normal',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name'     => 'carousel_post__nav_border_normal',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div',
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_tab();
		// end normal tab
		// start hover tab
		$this->start_controls_tab(
			'carousel_post_style_hover',
			[
				'label' => esc_html__( 'Hover', 'coaching' ), 
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_color_hover',
			[
				'label'     => esc_html__( 'Color', 'coaching' ), 
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div i:hover' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_bg_color_hover',
			[
				'label'     => esc_html__( 'Background Color', 'coaching' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div:hover' => 'background-color: {{VALUE}}'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'carousel_post__nav_box_shadow_hover',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div:hover',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(), 
			[
				'name'     => 'carousel_post__nav_border_hover',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div:hover',
			]
		);
		$this->add_responsive_control(
			'carousel_post__nav_border_radius_hover',
			[
				'label'      => esc_html__( 'Border Radius', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .thim-owl-carousel-post .owl-nav > div:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_tab();
		// end hover tab
		$this->end_controls_tabs();
		$this->end_controls_section();

	}
	protected function render() {
		$settings = $this->get_settings_for_display(); 
 		$args                 = array();
		$args['before_title'] = '<div class="thim-owl-carousel-post-header"><h3 class="widget-title">';
		$args['after_title']  = '</h3></div>';

		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings,
			'args'     => $args
		) );
	}

}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_Carousel_Post_El() );
