<?php

namespace Elementor;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography; 
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

class Thim_About_Me_El extends Widget_Base {

	public function get_name() {
		return 'thim-about-me';
	}

	public function get_title() {
		return esc_html__( 'Thim: About Me', 'coaching' );
	}

	public function get_icon() {
		return 'thim-widget-icon thim-widget-icon-accordion';
	}

	public function get_categories() {
		return [ 'thim_ekit' ];
	}

	public function get_base() {
		return basename( __FILE__, '.php' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content',
			[
				'label' => esc_html__( 'About Me', 'coaching' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control( 
			'info_me',
			[
				'label'       => esc_html__( 'Biographical Info', 'coaching' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'avt_img',
			[
				'label' => esc_html__( 'Upload Avatar Image', 'coaching' ),
				'type'  => Controls_Manager::MEDIA,

			]
		);

		$this->add_control(
			'phone',
			[
				'label'       => esc_html__( 'Phone Number', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'email',
			[
				'label'       => esc_html__( 'Email', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'address',
			[
				'label'       => esc_html__( 'Address', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'link',
			[
				'label'       => esc_html__( 'Link', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'text_link',
			[
				'label'       => esc_html__( 'Text Link', 'coaching' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Add your text here', 'coaching' ),
				'label_block' => true
			]
		);

		$this->end_controls_section();
		$this->about_me_tabs_style_sc();
		$this->about_me_list_contact_sc();

	}
 	protected function about_me_tabs_style_sc(){
		$this->start_controls_section(
			'style_menu_section',
			[
				'label' => esc_html__( 'Title', 'coaching' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'title_menu_color', 
            [
                'label' => esc_html__( 'Title Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title-info' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control( 
			\Elementor\Group_Control_Typography::get_type(), 
			[
				'name' => 'title_menu_typography',
				'selector' => '{{WRAPPER}} .title-info',
			]
		);
		$this->add_responsive_control(
			'ab_me_title_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .title-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
			]
		);
		$this->end_controls_section();
        $this->start_controls_section( 
			'ab_content_section',
			[
				'label' => esc_html__( 'Content', 'coaching' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'ab_content_color',
            [
                'label' => esc_html__( 'Content Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .about-info' => 'color: {{VALUE}};', 
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ab_content_typography',
				'selector' => '{{WRAPPER}} .about-info',
			]
		);
		$this->add_responsive_control(
			'ab_me_content_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .about-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
  				],
			]
		);

        $this->end_controls_section();
		
	}
	protected  function about_me_list_contact_sc(){
		$this->start_controls_section(
			'ab_list_ct_section',
			[
				'label' => esc_html__( 'List contact', 'coaching' ), 
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'list_post_title_h',
			[
				'label' => esc_html__( ' Title', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
            'ab_list_ct__color',
            [
                'label' => esc_html__( 'Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li.title' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ab_list_ct_typography',
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li.title',
			]
		);
		$this->add_responsive_control(
			'about_title_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-about-me .avatar .info-contact ul li.title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
  				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'about_title_item_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li.title',
			]
		);

		$this->add_group_control( 
			Group_Control_Border::get_type(),
			[
				'name'     => 'about_title_item__border',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li.title',
			]
		);
		$this->add_control(
			'ab_me_list_h',
			[
				'label' => esc_html__( ' Item', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        $this->add_control(
            'ab_me_list_color',
            [
                'label' => esc_html__( 'Text Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .thim-about-me .avatar .info-contact ul li p' => 'color: {{VALUE}};',
                ],
            ]
        );
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'ab_me_list_typography',
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li',
			]
		);
		$this->add_control(
            'ab_me_list_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'coaching' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li i' => 'background-image: linear-gradient(to left,{{VALUE}},{{VALUE}})!important;',
                ],
            ]
        );
		$this->add_responsive_control(
			'ab_me_list_max__width',
			[
				'label'      => esc_html__( 'Max Width', 'coaching' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .info-contact ul li' => 'max-width: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->add_responsive_control(
			'ab_me_list_item_padding',
			[
				'label'      => esc_html__( 'Padding', 'coaching' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'default' => [
                ],
				'selectors'  => [
					'{{WRAPPER}} .thim-about-me .avatar .info-contact ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};overflow: hidden;',
					'{{WRAPPER}} .thim-about-me .avatar .info-contact ul li i' => 'margin-left: 0px;',
  				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'ab_me_list__box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'ab_me_list__border',
				'label'    => esc_html__( 'Border', 'coaching' ),
				'selector' => '{{WRAPPER}} .thim-about-me .avatar .info-contact ul li',
			]
		);
		$this->about_me_bt_tab_style();

        $this->end_controls_section();
	}
	protected  function about_me_bt_tab_style(){
		$this->add_control(
			'ab_me_list_bt_h',
			[
				'label' => esc_html__( 'Button', 'coaching' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
			// start tab for item
			$this->start_controls_tabs(
				'ab_me__btitem_tabs',
			);
	
			// start normal tab
			$this->start_controls_tab(
				'ab_me__btstyle_normal2',
				[
					'label' => esc_html__( 'Normal', 'coaching' ),
				]
			);
			$this->add_control(
				'ab_me__bt_color', 
				[
					'label'     => esc_html__( 'Color', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .thim-about-me .right .content-info a' => 'color: {{VALUE}}!important;',
					],
				]
			);
			$this->add_control(
				'ab_me__bt_bgcolor', 
				[
					'label'     => esc_html__( 'Background', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .thim-about-me .right .content-info a' => 'background: linear-gradient(to left,{{VALUE}},{{VALUE}})!important;overflow: hidden;',
						'{{WRAPPER}} .thim-about-me .right .content-info a:after' => 'display: none;',
					],
				]
			);
			$this->add_group_control( 
				Group_Control_Typography::get_type(),
				[
					'name'     => 'ab_me__bt_typography',
					'label'    => esc_html__( 'Typography', 'coaching' ),
					'selector' =>'{{WRAPPER}} .thim-about-me .right .content-info a',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'item_border',
					'label' => esc_html__( 'Border', 'coaching' ),
					'selector' => '{{WRAPPER}} .thim-about-me .right .content-info a',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'item_box_shadow',
					'label'    => esc_html__( 'Box Shadow', 'coaching' ),
					'selector' =>'{{WRAPPER}} .thim-about-me .right .content-info a',
				]
			);
			$this->end_controls_tab();
			// end normal tab
			// start hover tab
			$this->start_controls_tab(
				'ab_me__bt_style_hover2',
				[
					'label' => esc_html__( 'Hover', 'coaching' ),
				] 
			);
			$this->add_control(
				'ab_me__bt_color_hover', 
				[
					'label'     => esc_html__( 'Color', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .thim-about-me .right .content-info a:hover' => 'color: {{VALUE}}!important;',
					],
				]
			);
			$this->add_control(
				'ab_me__bt_bgcolor_hover', 
				[
					'label'     => esc_html__( 'Background', 'coaching' ),
					'type'      => Controls_Manager::COLOR,
					'default'   => '',
					'selectors' => [
						'{{WRAPPER}} .thim-about-me .right .content-info a:hover' => 'background: {{VALUE}}!important;',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'item_box_shadow_hover',
					'label'    => esc_html__( 'Box Shadow', 'coaching' ),
					'selector' => '{{WRAPPER}} .thim-about-me .right .content-info a:hover',
				]
			);
			$this->end_controls_tab();
			// end hover tab
			$this->end_controls_tabs();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();

		// Map variables between Elementor and SiteOrigin
 		$settings['avt_img'] = isset($settings['avt_img']) ?  $settings['avt_img']['id'] : '';
		thim_get_widget_template( $this->get_base(), array(
			'instance' => $settings
		) );
	}
}

//Plugin::instance()->widgets_manager->register_widget_type( new Thim_About_Me_El() );
